/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.license.pro;

import java.math.BigInteger;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.license.VersionPrinter;

public enum LicenseType {
    TRIAL(0, VersionPrinter.EDITION, "trial"),
    PRO10(1, Edition.PRO, "10 schemas"),
    PRO20(2, Edition.PRO, "20 schemas"),
    PRO30(3, Edition.PRO, "30 schemas"),
    PRO40(4, Edition.PRO, "40 schemas"),
    PRO50(5, Edition.PRO, "50 schemas"),
    PRO60(6, Edition.PRO, "60 schemas"),
    PRO70(7, Edition.PRO, "70 schemas"),
    PRO80(8, Edition.PRO, "80 schemas"),
    PRO90(9, Edition.PRO, "90 schemas"),
    PRO100(10, Edition.PRO, "100 schemas"),
    PROSITE(15, Edition.PRO, "unlimited schemas"),
    ENTERPRISE10(17, Edition.ENTERPRISE, "10 schemas"),
    ENTERPRISE20(18, Edition.ENTERPRISE, "20 schemas"),
    ENTERPRISE30(19, Edition.ENTERPRISE, "30 schemas"),
    ENTERPRISE40(20, Edition.ENTERPRISE, "40 schemas"),
    ENTERPRISE50(21, Edition.ENTERPRISE, "50 schemas"),
    ENTERPRISE60(22, Edition.ENTERPRISE, "60 schemas"),
    ENTERPRISE70(23, Edition.ENTERPRISE, "70 schemas"),
    ENTERPRISE80(24, Edition.ENTERPRISE, "80 schemas"),
    ENTERPRISE90(25, Edition.ENTERPRISE, "90 schemas"),
    ENTERPRISE100(26, Edition.ENTERPRISE, "100 schemas"),
    ENTERPRISESITE(31, Edition.ENTERPRISE, "unlimited schemas"),
    PRO10_REDISTRIBUTABLE(33, Edition.PRO, "10 schemas, redistributable"),
    PRO20_REDISTRIBUTABLE(34, Edition.PRO, "20 schemas, redistributable"),
    PRO30_REDISTRIBUTABLE(35, Edition.PRO, "30 schemas, redistributable"),
    PRO40_REDISTRIBUTABLE(36, Edition.PRO, "40 schemas, redistributable"),
    PRO50_REDISTRIBUTABLE(37, Edition.PRO, "50 schemas, redistributable"),
    PRO60_REDISTRIBUTABLE(38, Edition.PRO, "60 schemas, redistributable"),
    PRO70_REDISTRIBUTABLE(39, Edition.PRO, "70 schemas, redistributable"),
    PRO80_REDISTRIBUTABLE(40, Edition.PRO, "80 schemas, redistributable"),
    PRO90_REDISTRIBUTABLE(41, Edition.PRO, "90 schemas, redistributable"),
    PRO100_REDISTRIBUTABLE(42, Edition.PRO, "100 schemas, redistributable"),
    PROSITE_REDISTRIBUTABLE(47, Edition.PRO, "unlimited schemas, redistributable"),
    ENTERPRISE10_REDISTRIBUTABLE(49, Edition.ENTERPRISE, "10 schemas, redistributable"),
    ENTERPRISE20_REDISTRIBUTABLE(50, Edition.ENTERPRISE, "20 schemas, redistributable"),
    ENTERPRISE30_REDISTRIBUTABLE(51, Edition.ENTERPRISE, "30 schemas, redistributable"),
    ENTERPRISE40_REDISTRIBUTABLE(52, Edition.ENTERPRISE, "40 schemas, redistributable"),
    ENTERPRISE50_REDISTRIBUTABLE(53, Edition.ENTERPRISE, "50 schemas, redistributable"),
    ENTERPRISE60_REDISTRIBUTABLE(54, Edition.ENTERPRISE, "60 schemas, redistributable"),
    ENTERPRISE70_REDISTRIBUTABLE(55, Edition.ENTERPRISE, "70 schemas, redistributable"),
    ENTERPRISE80_REDISTRIBUTABLE(56, Edition.ENTERPRISE, "80 schemas, redistributable"),
    ENTERPRISE90_REDISTRIBUTABLE(57, Edition.ENTERPRISE, "90 schemas, redistributable"),
    ENTERPRISE100_REDISTRIBUTABLE(58, Edition.ENTERPRISE, "100 schemas, redistributable"),
    ENTERPRISESITE_REDISTRIBUTABLE(63, Edition.ENTERPRISE, "unlimited schemas, redistributable");

    private final byte code;
    private final Edition edition;
    private final String details;

    private LicenseType(byte code, Edition edition, String details) {
        this.code = code;
        this.edition = edition;
        this.details = details;
    }

    public byte getCode() {
        return this.code;
    }

    public Edition getEdition() {
        return this.edition;
    }

    public String getDetails() {
        return this.details;
    }

    public static LicenseType fromCode(byte code) {
        for (LicenseType licenseType : LicenseType.values()) {
            if (licenseType.code != code) continue;
            return licenseType;
        }
        throw new IllegalArgumentException("Unknown license code: 0x" + LicenseType.toHex(code));
    }

    private static String toHex(byte ... array) {
        BigInteger bi = new BigInteger(1, array);
        String hex = bi.toString(16);
        int paddingLength = array.length * 2 - hex.length();
        if (paddingLength > 0) {
            return String.format("%0" + paddingLength + "d", 0) + hex;
        }
        return hex;
    }

    public String toString() {
        return (Object)((Object)this.edition) + " (" + this.details + ")";
    }
}

