/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.jdbc.pro;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flywaydb.core.api.FlywayException;

public class ErrorOverride {
    private static final Pattern ERROR_OVERRIDE_REGEX = Pattern.compile("^([A-Za-z0-9]{5,7}|\\*):(-?[0-9]{1,5}|\\*):([DIWE]-?)$");
    private final String state;
    private final boolean stateWildcard;
    private final int code;
    private final boolean codeWildcard;
    private final ErrorOverrideBehavior behavior;

    public ErrorOverride(String descriptor) {
        Matcher matcher = ERROR_OVERRIDE_REGEX.matcher(descriptor);
        if (!matcher.matches()) {
            throw new FlywayException("Invalid error override (should look like STATE:12345:W ): " + descriptor);
        }
        this.state = matcher.group(1);
        this.stateWildcard = "*".equals(this.state);
        String codeRaw = matcher.group(2);
        this.codeWildcard = "*".equals(codeRaw);
        this.code = this.codeWildcard ? Integer.MIN_VALUE : Integer.parseInt(codeRaw);
        this.behavior = ErrorOverrideBehavior.fromDescription(matcher.group(3));
    }

    public boolean appliesTo(String state, int code) {
        return !(!this.stateWildcard && !this.state.equals(state) || !this.codeWildcard && this.code != code);
    }

    String getState() {
        return this.state;
    }

    int getCode() {
        return this.code;
    }

    public ErrorOverrideBehavior getBehavior() {
        return this.behavior;
    }

    public static enum ErrorOverrideBehavior {
        DEBUG("D"),
        DEBUG_NO_DETAILS("D-"),
        INFO("I"),
        INFO_NO_DETAILS("I-"),
        WARNING("W"),
        WARNING_NO_DETAILS("W-"),
        ERROR("E"),
        ERROR_NO_DETAILS("E-");

        private final String descriptor;

        private ErrorOverrideBehavior(String descriptor) {
            this.descriptor = descriptor;
        }

        public static ErrorOverrideBehavior fromDescription(String descriptor) {
            for (ErrorOverrideBehavior errorOverrideBehavior : ErrorOverrideBehavior.values()) {
                if (!errorOverrideBehavior.descriptor.equals(descriptor)) continue;
                return errorOverrideBehavior;
            }
            throw new FlywayException("Invalid behavior descriptor: " + descriptor);
        }
    }
}

