/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.h2;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.h2.H2Connection;
import org.flywaydb.core.internal.database.h2.H2Database;
import org.flywaydb.core.internal.database.h2.H2Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.util.StringUtils;

public class H2Schema
extends Schema<H2Database, H2Table> {
    private static final Log LOG = LogFactory.getLog(H2Schema.class);

    H2Schema(JdbcTemplate jdbcTemplate, H2Database database, String name) {
        super(jdbcTemplate, database, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME=?", this.name) > 0;
    }

    @Override
    protected boolean doEmpty() {
        return ((H2Table[])this.allTables()).length == 0;
    }

    @Override
    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + ((H2Database)this.database).quote(this.name), new Object[0]);
    }

    @Override
    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP SCHEMA " + ((H2Database)this.database).quote(this.name) + (((H2Database)this.database).supportsDropSchemaCascade ? " CASCADE" : ""), new Object[0]);
    }

    @Override
    protected void doClean() throws SQLException {
        for (H2Table h2Table : (H2Table[])this.allTables()) {
            h2Table.drop();
        }
        List<String> sequenceNames = this.listObjectNames("SEQUENCE", "IS_GENERATED = false");
        for (String statement : this.generateDropStatements("SEQUENCE", sequenceNames)) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        List<String> constantNames = this.listObjectNames("CONSTANT", "");
        for (String string : this.generateDropStatements("CONSTANT", constantNames)) {
            this.jdbcTemplate.execute(string, new Object[0]);
        }
        List<String> aliasNames = this.jdbcTemplate.queryForStringList("SELECT ALIAS_NAME FROM INFORMATION_SCHEMA.FUNCTION_ALIASES WHERE ALIAS_SCHEMA = ?", this.name);
        for (String statement : this.generateDropStatements("ALIAS", aliasNames)) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        List<String> list = this.listObjectNames("DOMAIN", "");
        if (!list.isEmpty()) {
            if (this.name.equals(((H2Connection)((H2Database)this.database).getMainConnection()).getCurrentSchema().getName())) {
                for (String statement : this.generateDropStatementsForCurrentSchema("DOMAIN", list)) {
                    this.jdbcTemplate.execute(statement, new Object[0]);
                }
            } else {
                LOG.error("Unable to drop DOMAIN objects in schema " + ((H2Database)this.database).quote(this.name) + " due to H2 bug! (More info: http://code.google.com/p/h2database/issues/detail?id=306)");
            }
        }
    }

    private List<String> generateDropStatements(String objectType, List<String> objectNames) {
        ArrayList<String> statements = new ArrayList<String>();
        for (String objectName : objectNames) {
            String dropStatement = "DROP " + objectType + ((H2Database)this.database).quote(this.name, objectName);
            statements.add(dropStatement);
        }
        return statements;
    }

    private List<String> generateDropStatementsForCurrentSchema(String objectType, List<String> objectNames) {
        ArrayList<String> statements = new ArrayList<String>();
        for (String objectName : objectNames) {
            String dropStatement = "DROP " + objectType + ((H2Database)this.database).quote(objectName);
            statements.add(dropStatement);
        }
        return statements;
    }

    protected H2Table[] doAllTables() throws SQLException {
        List<String> tableNames = this.listObjectNames("TABLE", "TABLE_TYPE = 'TABLE'");
        H2Table[] tables = new H2Table[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = new H2Table(this.jdbcTemplate, (H2Database)this.database, this, tableNames.get(i));
        }
        return tables;
    }

    private List<String> listObjectNames(String objectType, String querySuffix) throws SQLException {
        String query = "SELECT " + objectType + "_NAME FROM INFORMATION_SCHEMA." + objectType + "S WHERE " + objectType + "_SCHEMA = ?";
        if (StringUtils.hasLength(querySuffix)) {
            query = query + " AND " + querySuffix;
        }
        return this.jdbcTemplate.queryForStringList(query, this.name);
    }

    @Override
    public Table getTable(String tableName) {
        return new H2Table(this.jdbcTemplate, (H2Database)this.database, this, tableName);
    }
}

