/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.firebirdsql.encodings.EncodingDefinition;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.jdbc.field.TypeConversionException;
import org.firebirdsql.util.IOUtils;

class FBStringField
extends FBField {
    static final String SHORT_TRUE = "Y";
    static final String SHORT_FALSE = "N";
    static final String LONG_TRUE = "true";
    static final String LONG_FALSE = "false";
    static final String SHORT_TRUE_2 = "T";
    static final String SHORT_TRUE_3 = "1";
    protected final int possibleCharLength;
    protected final EncodingDefinition encodingDefinition;

    FBStringField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
        this.encodingDefinition = FBStringField.getEncodingDefinition(fieldDescriptor);
        this.possibleCharLength = fieldDescriptor.getLength() / this.encodingDefinition.getMaxBytesPerChar();
    }

    protected static EncodingDefinition getEncodingDefinition(FieldDescriptor fieldDescriptor) throws SQLException {
        int characterSetId;
        switch (fieldDescriptor.getType() & 0xFFFFFFFE) {
            case 448: 
            case 452: {
                characterSetId = fieldDescriptor.getSubType();
                break;
            }
            case 520: {
                if (fieldDescriptor.getSubType() == 1) {
                    characterSetId = fieldDescriptor.getScale();
                    break;
                }
                characterSetId = 0;
                break;
            }
            default: {
                throw new SQLException("Unexpected Firebird data type: " + fieldDescriptor);
            }
        }
        return fieldDescriptor.getDatatypeCoder().getEncodingFactory().getEncodingDefinitionByCharacterSetId(characterSetId);
    }

    @Override
    public byte getByte() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        try {
            return Byte.parseByte(this.getString().trim());
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException("Error converting to byte. " + this.getString().trim());
        }
    }

    @Override
    public short getShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        try {
            return Short.parseShort(this.getString().trim());
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException("Error converting to short. " + this.getString().trim());
        }
    }

    @Override
    public int getInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        try {
            return Integer.parseInt(this.getString().trim());
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException("Error converting to int. " + this.getString().trim());
        }
    }

    @Override
    public long getLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        try {
            return Long.parseLong(this.getString().trim());
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException("Error converting to long. " + this.getString().trim());
        }
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        try {
            return new BigDecimal(this.getString().trim());
        }
        catch (NumberFormatException e) {
            throw new TypeConversionException("Error converting to big decimal. " + this.getString().trim());
        }
    }

    @Override
    public float getFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(this.getString().trim());
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException("Error converting to float. " + this.getString().trim());
        }
    }

    @Override
    public double getDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(this.getString().trim());
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException("Error converting to double. " + this.getString().trim());
        }
    }

    @Override
    public boolean getBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        String trimmedValue = this.getString().trim();
        return trimmedValue.equalsIgnoreCase(LONG_TRUE) || trimmedValue.equalsIgnoreCase(SHORT_TRUE) || trimmedValue.equalsIgnoreCase(SHORT_TRUE_2) || trimmedValue.equalsIgnoreCase(SHORT_TRUE_3);
    }

    @Override
    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeString(this.getFieldData(), this.encodingDefinition.getEncoding(), this.mappingPath);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new ByteArrayInputStream(this.getFieldData());
    }

    @Override
    public byte[] getBytes() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return (byte[])this.getFieldData().clone();
    }

    @Override
    public Date getDate(Calendar cal) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeDate(this.getDate(), cal);
    }

    @Override
    public Date getDate() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return Date.valueOf(this.getString().trim());
    }

    @Override
    public Time getTime(Calendar cal) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeTime(this.getTime(), cal, this.isInvertTimeZone());
    }

    @Override
    public Time getTime() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return Time.valueOf(this.getString().trim());
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeTimestamp(this.getTimestamp(), cal, this.isInvertTimeZone());
    }

    @Override
    public Timestamp getTimestamp() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return Timestamp.valueOf(this.getString().trim());
    }

    @Override
    public BigInteger getBigInteger() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        try {
            return new BigInteger(this.getString().trim());
        }
        catch (NumberFormatException e) {
            throw new TypeConversionException("Error converting to BigInteger. " + this.getString().trim());
        }
    }

    @Override
    public void setByte(byte value) throws SQLException {
        this.setString(Byte.toString(value));
    }

    @Override
    public void setShort(short value) throws SQLException {
        this.setString(Short.toString(value));
    }

    @Override
    public void setInteger(int value) throws SQLException {
        this.setString(Integer.toString(value));
    }

    @Override
    public void setLong(long value) throws SQLException {
        this.setString(Long.toString(value));
    }

    @Override
    public void setFloat(float value) throws SQLException {
        this.setString(Float.toString(value));
    }

    @Override
    public void setDouble(double value) throws SQLException {
        this.setString(Double.toString(value));
    }

    @Override
    public void setBigDecimal(BigDecimal value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setString(value.toString());
    }

    @Override
    public void setBoolean(boolean value) throws SQLException {
        if (this.possibleCharLength > 4) {
            this.setString(value ? LONG_TRUE : LONG_FALSE);
        } else if (this.possibleCharLength >= 1) {
            this.setString(value ? SHORT_TRUE : SHORT_FALSE);
        }
    }

    @Override
    public void setString(String value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setFieldData(this.getDatatypeCoder().encodeString(value, this.encodingDefinition.getEncoding(), this.mappingPath));
    }

    @Override
    protected void setBinaryStreamInternal(InputStream in, long length) throws SQLException {
        if (in == null) {
            this.setNull();
            return;
        }
        if (length > Integer.MAX_VALUE) {
            throw new FBDriverNotCapableException("Only length <= Integer.MAX_VALUE supported");
        }
        try {
            this.setBytes(IOUtils.toBytes(in, (int)length));
        }
        catch (IOException ioex) {
            throw new TypeConversionException("Error converting to binary stream.");
        }
    }

    @Override
    protected void setCharacterStreamInternal(Reader in, long length) throws SQLException {
        if (in == null) {
            this.setNull();
            return;
        }
        if (length > Integer.MAX_VALUE) {
            throw new FBDriverNotCapableException("Only length <= Integer.MAX_VALUE supported");
        }
        try {
            this.setString(IOUtils.toString(in, (int)length));
        }
        catch (IOException ioex) {
            throw new TypeConversionException("Error converting to character stream.");
        }
    }

    @Override
    public void setBytes(byte[] value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        if (value.length > this.fieldDescriptor.getLength()) {
            throw new DataTruncation(this.fieldDescriptor.getPosition() + 1, true, false, value.length, this.fieldDescriptor.getLength());
        }
        this.setFieldData(value);
    }

    @Override
    public void setDate(Date value, Calendar cal) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setDate(this.getDatatypeCoder().encodeDate(value, cal));
    }

    @Override
    public void setDate(Date value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setString(value.toString());
    }

    @Override
    public void setTime(Time value, Calendar cal) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setTime(this.getDatatypeCoder().encodeTime(value, cal, this.isInvertTimeZone()));
    }

    @Override
    public void setTime(Time value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setString(value.toString());
    }

    @Override
    public void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setTimestamp(this.getDatatypeCoder().encodeTimestamp(value, cal, this.isInvertTimeZone()));
    }

    @Override
    public void setTimestamp(Timestamp value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setString(value.toString());
    }

    @Override
    public void setBigInteger(BigInteger value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setString(value.toString());
    }
}

