/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import org.firebirdsql.jdbc.FBDatabaseMetaData;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.parser.JaybirdStatementModel;
import org.firebirdsql.jdbc.parser.StatementParser;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public abstract class AbstractGeneratedKeysQuery {
    private static final Logger logger = LoggerFactory.getLogger(AbstractGeneratedKeysQuery.class);
    private static final int QUERY_TYPE_KEEP_UNMODIFIED = 1;
    private static final int QUERY_TYPE_ADD_ALL_COLUMNS = 2;
    private static final int QUERY_TYPE_ADD_INDEXED = 3;
    private static final int QUERY_TYPE_ADD_COLUMNS = 4;
    private static final int QUERY_TYPE_ALREADY_HAS_RETURNING = 5;
    private static final int IDX_COLUMN_NAME = 4;
    private static final int IDX_ORDINAL_POSITION = 17;
    private static final String GENERATED_KEYS_FUNCTIONALITY_NOT_AVAILABLE = "Generated keys functionality not available, most likely cause: antlr-runtime not available on classpath";
    private static final StatementParser parser;
    private final String originalSQL;
    private String modifiedSQL;
    private int queryType = 1;
    private int[] columnIndexes;
    private String[] columnNames;
    private boolean processed = false;
    private boolean generatesKeys = false;
    private JaybirdStatementModel statementModel;

    private AbstractGeneratedKeysQuery(String sql) {
        this.originalSQL = sql;
    }

    public AbstractGeneratedKeysQuery(String sql, int autoGeneratedKeys) throws SQLException {
        this(sql);
        switch (autoGeneratedKeys) {
            case 1: {
                if (!AbstractGeneratedKeysQuery.isGeneratedKeysSupportLoaded()) {
                    throw new FBDriverNotCapableException(GENERATED_KEYS_FUNCTIONALITY_NOT_AVAILABLE);
                }
                this.queryType = 2;
                break;
            }
            case 2: {
                this.queryType = 1;
                break;
            }
            default: {
                throw new FBSQLException("Supplied value for autoGeneratedKeys is invalid", "HY092");
            }
        }
    }

    public AbstractGeneratedKeysQuery(String sql, int[] columnIndexes) throws SQLException {
        this(sql);
        if (!AbstractGeneratedKeysQuery.isGeneratedKeysSupportLoaded()) {
            throw new FBDriverNotCapableException(GENERATED_KEYS_FUNCTIONALITY_NOT_AVAILABLE);
        }
        if (columnIndexes != null && columnIndexes.length != 0) {
            this.columnIndexes = (int[])columnIndexes.clone();
            this.queryType = 3;
        } else {
            this.queryType = 1;
        }
    }

    public AbstractGeneratedKeysQuery(String sql, String[] columnNames) throws SQLException {
        this(sql);
        if (!AbstractGeneratedKeysQuery.isGeneratedKeysSupportLoaded()) {
            throw new FBDriverNotCapableException(GENERATED_KEYS_FUNCTIONALITY_NOT_AVAILABLE);
        }
        if (columnNames != null && columnNames.length != 0) {
            this.columnNames = (String[])columnNames.clone();
            this.queryType = 4;
        } else {
            this.queryType = 1;
        }
    }

    public boolean generatesKeys() throws SQLException {
        this.process();
        return this.generatesKeys;
    }

    public String getQueryString() throws SQLException {
        this.process();
        return this.modifiedSQL;
    }

    private void process() throws SQLException {
        if (this.processed) {
            return;
        }
        try {
            this.processStatementModel();
            this.updateQuery();
        }
        finally {
            this.processed = true;
        }
    }

    private void processStatementModel() throws SQLException {
        if (!AbstractGeneratedKeysQuery.isGeneratedKeysSupportLoaded()) {
            if (this.queryType == 1) {
                return;
            }
            throw new FBDriverNotCapableException(GENERATED_KEYS_FUNCTIONALITY_NOT_AVAILABLE);
        }
        try {
            this.statementModel = this.parseInsertStatement(this.originalSQL);
            if (this.statementModel.hasReturning()) {
                this.queryType = 5;
            }
        }
        catch (StatementParser.ParseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Exception parsing query: " + this.originalSQL, e);
            }
            this.queryType = 1;
        }
    }

    private void updateQuery() throws SQLException {
        switch (this.queryType) {
            case 2: {
                this.addAllColumns();
                break;
            }
            case 3: {
                this.addIndexedColumns();
                break;
            }
            case 4: {
                this.addReturningClause();
                break;
            }
            case 5: {
                this.generatesKeys = true;
                this.queryType = 1;
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported value for queryType: " + this.queryType);
            }
        }
        if (this.queryType == 1) {
            this.modifiedSQL = this.originalSQL;
        }
    }

    private void addAllColumns() throws SQLException {
        DatabaseMetaData metaData = this.getDatabaseMetaData();
        ArrayList<String> columns = new ArrayList<String>();
        try (ResultSet rs = metaData.getColumns(null, null, this.normalizeObjectName(this.statementModel.getTableName()), null);){
            while (rs.next()) {
                columns.add(this.quoteObjectName(rs.getString(4)));
            }
        }
        this.columnNames = columns.toArray(new String[0]);
        this.addReturningClause();
    }

    private void addIndexedColumns() throws SQLException {
        DatabaseMetaData metaData = this.getDatabaseMetaData();
        Arrays.sort(this.columnIndexes);
        ArrayList<String> columns = new ArrayList<String>();
        try (ResultSet rs = metaData.getColumns(null, null, this.normalizeObjectName(this.statementModel.getTableName()), null);){
            while (rs.next()) {
                if (Arrays.binarySearch(this.columnIndexes, rs.getInt(17)) < 0) continue;
                columns.add(this.quoteObjectName(rs.getString(4)));
            }
        }
        this.columnNames = columns.toArray(new String[0]);
        this.addReturningClause();
    }

    private String normalizeObjectName(String objectName) {
        if (objectName == null) {
            return null;
        }
        objectName = objectName.trim();
        if ((objectName = FBDatabaseMetaData.escapeWildcards(objectName)).length() > 2 && objectName.charAt(0) == '\"' && objectName.charAt(objectName.length() - 1) == '\"') {
            return objectName.substring(1, objectName.length() - 1).replaceAll("\"\"", "\"");
        }
        return objectName.toUpperCase();
    }

    private String quoteObjectName(String objectName) {
        if (objectName == null) {
            return null;
        }
        objectName = objectName.trim();
        return '\"' + objectName.replaceAll("\"", "\"\"") + '\"';
    }

    private void addReturningClause() {
        if (this.columnNames == null || this.columnNames.length == 0) {
            this.queryType = 1;
            return;
        }
        this.generatesKeys = true;
        StringBuilder query = new StringBuilder(this.originalSQL);
        if (query.charAt(query.length() - 1) == ';') {
            query.setLength(query.length() - 1);
        }
        query.append('\n');
        query.append("RETURNING ");
        for (int i = 0; i < this.columnNames.length; ++i) {
            query.append(this.columnNames[i]);
            if (i >= this.columnNames.length - 1) continue;
            query.append(',');
        }
        this.modifiedSQL = query.toString();
    }

    abstract DatabaseMetaData getDatabaseMetaData() throws SQLException;

    private JaybirdStatementModel parseInsertStatement(String sql) throws StatementParser.ParseException {
        return parser.parseInsertStatement(sql);
    }

    public static boolean isGeneratedKeysSupportLoaded() {
        return parser != null;
    }

    static {
        StatementParser temp = null;
        try {
            temp = (StatementParser)Class.forName("org.firebirdsql.jdbc.parser.StatementParserImpl").newInstance();
        }
        catch (Throwable ex) {
            Logger log = LoggerFactory.getLogger(AbstractGeneratedKeysQuery.class);
            log.error("Unable to load generated key parser. Generated keys functionality not available, most likely cause: antlr-runtime not available on classpath", ex);
        }
        finally {
            parser = temp;
        }
    }
}

