/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.encodings;

import java.nio.charset.Charset;
import org.firebirdsql.encodings.CharacterTranslator;
import org.firebirdsql.encodings.Encoding;

final class EncodingSingleByte
implements Encoding {
    private final char[] byteToChar;
    private final byte[] charToByte;
    private final Charset charset;

    public EncodingSingleByte(Charset charset) {
        this(charset, CharacterTranslator.IDENTITY_TRANSLATOR);
    }

    EncodingSingleByte(Charset charset, CharacterTranslator translator) {
        assert (charset != null) : "charset should not be null";
        assert (translator != null) : "translator should not be null";
        this.byteToChar = new char[256];
        this.charToByte = new byte[65536];
        this.charset = charset;
        byte[] val = new byte[1];
        for (int i = 0; i < 256; ++i) {
            val[0] = (byte)i;
            char ch = new String(val, 0, 1, charset).charAt(0);
            this.byteToChar[i] = translator.getMapping(ch);
            this.charToByte[this.byteToChar[i]] = (byte)i;
        }
    }

    @Override
    public byte[] encodeToCharset(String str) {
        int length = str.length();
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.charToByte[str.charAt(i)];
        }
        return result;
    }

    @Override
    public String decodeFromCharset(byte[] in) {
        return this.decodeFromCharset(in, 0, in.length);
    }

    @Override
    public String decodeFromCharset(byte[] in, int offset, int length) {
        StringBuilder sb = new StringBuilder(length);
        int limit = offset + length;
        for (int i = offset; i < limit; ++i) {
            sb.append(this.byteToChar[in[i] & 0xFF]);
        }
        return sb.toString();
    }

    @Override
    public Encoding withTranslation(CharacterTranslator translator) {
        if (translator != null) {
            return new EncodingSingleByte(this.charset, translator);
        }
        return this;
    }

    @Override
    public String getCharsetName() {
        return this.charset.name();
    }
}

