/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.jdbc.pro;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.schemahistory.AppliedMigration;
import org.flywaydb.core.internal.sqlscript.SqlStatement;
import org.flywaydb.core.internal.util.DateUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class DryRunStatementInterceptor
implements Closeable {
    private static final Log LOG = LogFactory.getLog(DryRunStatementInterceptor.class);
    private final Writer dryRunOutput;
    private Database database;
    private Table table;
    private String delimiterStr;

    public DryRunStatementInterceptor(OutputStream dryRunOutput, Charset encoding) {
        this.dryRunOutput = new BufferedWriter(new OutputStreamWriter(dryRunOutput, encoding));
        this.append("-- -====================================");
        this.append("-- Flyway Dry Run (" + DateUtils.formatDateAsIsoString(new Date()) + ")");
        this.append("-- -====================================");
        this.append("");
    }

    public void init(Database database, Table table) {
        this.database = database;
        this.table = table;
        this.delimiterStr = database.getDefaultDelimiter().toString();
    }

    public void schemaHistoryTableCreate(boolean baseline) {
        this.append(this.database.getRawCreateScript(this.table, baseline));
    }

    public void schemaHistoryTableInsert(AppliedMigration appliedMigration) {
        String success = appliedMigration.isSuccess() ? this.database.getBooleanTrue() : this.database.getBooleanFalse();
        this.appendStatement(DryRunStatementInterceptor.toInsertStatement(appliedMigration, this.database.getInsertStatement(this.table), success));
    }

    static String toInsertStatement(AppliedMigration appliedMigration, String rawInsertStatement, String success) {
        return String.format(rawInsertStatement.replace("?", "%s"), appliedMigration.getInstalledRank(), DryRunStatementInterceptor.toStringLiteral(appliedMigration.getVersion()), DryRunStatementInterceptor.toStringLiteral(appliedMigration.getDescription()), DryRunStatementInterceptor.toStringLiteral((Object)appliedMigration.getType()), DryRunStatementInterceptor.toStringLiteral(appliedMigration.getScript()), appliedMigration.getChecksum(), DryRunStatementInterceptor.toStringLiteral(appliedMigration.getInstalledBy()), appliedMigration.getExecutionTime(), success);
    }

    private static String toStringLiteral(Object value) {
        return value == null ? "null" : "'" + value + "'";
    }

    void interceptStatement(String sql) {
        this.appendStatement(sql);
    }

    void interceptPreparedStatement(String sql, Map<Integer, Object> params) {
        this.appendStatement(DryRunStatementInterceptor.prepareStatement(sql, params, this.database.getBooleanTrue(), this.database.getBooleanFalse()));
    }

    static String prepareStatement(String sql, Map<Integer, Object> params, String booleanTrue, String booleanFalse) {
        int expectedParameters;
        int highestIndexedParameter = params.keySet().isEmpty() ? 0 : Collections.max(params.keySet());
        if (highestIndexedParameter > (expectedParameters = DryRunStatementInterceptor.getExpectedParameterCount(sql))) {
            throw new FlywayException("Invalid prepared statement: parameter with index " + highestIndexedParameter + " when invoking '" + sql + "'");
        }
        Object[] args = new Object[expectedParameters];
        for (int i = 0; i < expectedParameters; ++i) {
            if (params.keySet().contains(i + 1)) {
                Object param = params.get(i + 1);
                if (param == null) {
                    args[i] = "NULL";
                    continue;
                }
                if (param instanceof Boolean) {
                    args[i] = (Boolean)param != false ? booleanTrue : booleanFalse;
                    continue;
                }
                if (param instanceof String) {
                    args[i] = "'" + ((String)param).replace("'", "''") + "'";
                    continue;
                }
                if (param instanceof URL) {
                    args[i] = "'" + ((URL)param).toString().replace("'", "''") + "'";
                    continue;
                }
                if (param instanceof Date || param instanceof Time || param instanceof Timestamp) {
                    args[i] = "'" + param.toString() + "'";
                    continue;
                }
                args[i] = param.toString();
                continue;
            }
            throw new FlywayException("Invalid prepared statement: missing parameter " + i + " when invoking '" + sql + "'");
        }
        return String.format(sql.replace("?", "%s"), args);
    }

    private static int getExpectedParameterCount(String sql) {
        int count = 0;
        for (int i = 0; i < sql.length(); ++i) {
            if ('?' != sql.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    void interceptCallableStatement(String sql) {
        this.appendStatement(sql);
    }

    private void appendStatement(String sql) {
        this.append(sql + this.delimiterStr);
    }

    private void append(String sql) {
        try {
            this.dryRunOutput.write(sql + "\n");
        }
        catch (IOException e) {
            throw new FlywayException("Unable to write to dry run output: " + e.getMessage(), e);
        }
    }

    @Override
    public void close() {
        try {
            this.dryRunOutput.close();
        }
        catch (IOException e) {
            LOG.warn("Unable to close dry run output: " + e.getMessage());
        }
    }

    void interceptCommand(String command) {
        this.append("");
        this.append("-- Executing: " + command + " (with callbacks)");
        this.append("-- ---------------------------------------------------------------------------------------");
    }

    public void sqlScript(LoadableResource resource) {
        this.append("");
        String location = resource.getAbsolutePath();
        this.append("-- Source: " + location);
        this.append("-- ---------" + StringUtils.trimOrPad("", location.length(), '-'));
    }

    public void sqlStatement(SqlStatement statement) {
        this.append(statement.getSql() + statement.getDelimiter());
    }
}

