/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.snowflake;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.snowflake.SnowflakeDatabase;
import org.flywaydb.core.internal.database.snowflake.SnowflakeSchema;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.RowMapper;

public class SnowflakeTable
extends Table<SnowflakeDatabase, SnowflakeSchema> {
    SnowflakeTable(JdbcTemplate jdbcTemplate, SnowflakeDatabase database, SnowflakeSchema schema, String name) {
        super(jdbcTemplate, database, schema, name);
    }

    @Override
    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP TABLE " + ((SnowflakeDatabase)this.database).quote(((SnowflakeSchema)this.schema).getName()) + "." + ((SnowflakeDatabase)this.database).quote(this.name), new Object[0]);
    }

    @Override
    protected boolean doExists() throws SQLException {
        if (!((SnowflakeSchema)this.schema).exists()) {
            return false;
        }
        String sql = "SHOW TABLES LIKE '" + this.name + "' IN SCHEMA " + ((SnowflakeDatabase)this.database).quote(((SnowflakeSchema)this.schema).getName());
        List<Boolean> results = this.jdbcTemplate.query(sql, new RowMapper<Boolean>(){

            @Override
            public Boolean mapRow(ResultSet rs) throws SQLException {
                return true;
            }
        }, new Object[0]);
        return !results.isEmpty();
    }

    @Override
    protected void doLock() throws SQLException {
    }
}

