/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.OracleClob;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableConnection;

@ProxyFor(value={OracleClob.class})
@ProxyAccess(value=ACProxyable.class)
@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public abstract class TxnReplayableClob
extends TxnReplayableBase
implements JDBCReplayable {
    private static final Method GETASCIISTREAM_METHOD = TxnReplayableClob.getGetAsciiStreamMethod();
    private static final Method GETASCIISTREAM_LONG_METHOD = TxnReplayableClob.getGetAsciiStreamLongMethod();
    private static final Method GETCHARSTREAM_METHOD = TxnReplayableClob.getGetCharacterStreamMethod();
    private static final Method GETCHARSTREAM_LONG_METHOD = TxnReplayableClob.getGetCharacterStreamLongMethod();
    private static final Method GETCHARSTREAM_LONG_LONG_METHOD = TxnReplayableClob.getGetCharacterStreamLongLongMethod();
    private static final Method SETASCIISTREAM_LONG_METHOD = TxnReplayableClob.getSetAsciiStreamLongMethod();
    private static final Method SETCHARSTREAM_LONG_METHOD = TxnReplayableClob.getSetCharacterStreamLongMethod();
    protected boolean isFreed = false;

    protected TxnReplayableClob() {
        this.thisProxyNameInLog = "CLOB" + this.thisProxyNameInLog;
    }

    private static final Method getGetAsciiStreamMethod() {
        try {
            return OracleClob.class.getMethod("getAsciiStream", new Class[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getGetAsciiStreamLongMethod() {
        try {
            return OracleClob.class.getMethod("getAsciiStream", Long.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getGetCharacterStreamMethod() {
        try {
            return OracleClob.class.getMethod("getCharacterStream", new Class[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getGetCharacterStreamLongMethod() {
        try {
            return OracleClob.class.getMethod("getCharacterStream", Long.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getGetCharacterStreamLongLongMethod() {
        try {
            return OracleClob.class.getMethod("getCharacterStream", Long.TYPE, Long.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getSetAsciiStreamLongMethod() {
        try {
            return OracleClob.class.getMethod("setAsciiStream", Long.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getSetCharacterStreamLongMethod() {
        try {
            return OracleClob.class.getMethod("setCharacterStream", Long.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        super.preForAll(method, object, objectArray);
    }

    @Override
    @Post
    protected void postForAll(Method method) {
        this.postForAll(method, null);
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        if (object instanceof TxnReplayableBase) {
            TxnReplayableBase txnReplayableBase = (TxnReplayableBase)object;
            txnReplayableBase.setFailoverManager(this.getFailoverManager());
        }
        return super.postForAll(method, object);
    }

    @Post
    @Methods(signatures={@Signature(name="close", args={})})
    protected void postForClose(Method method) {
        this.postForAll(method);
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            this.isLogicallyClosed = true;
            try {
                TxnReplayableConnection txnReplayableConnection = (TxnReplayableConnection)this.failoverMngr.getConnectionProxy();
                txnReplayableConnection.checkImplicitRequestBoundary();
            }
            catch (Throwable throwable) {
            }
        }
    }

    @Post
    @Methods(signatures={@Signature(name="free", args={})})
    protected void postForFree(Method method) {
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle;
        super.postForAll(method);
        if (!this.isFreed && (replayLifecycle = this.failoverMngr.getReplayLifecycle()) == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            try {
                TxnReplayableConnection txnReplayableConnection = (TxnReplayableConnection)this.failoverMngr.getConnectionProxy();
                txnReplayableConnection.checkImplicitRequestBoundary();
            }
            catch (Throwable throwable) {
            }
        }
        this.isFreed = true;
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        super.onErrorVoidForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public Object replayOneCall(TxnFailoverManagerImpl.CallHistoryEntry callHistoryEntry, SQLRecoverableException sQLRecoverableException) throws SQLException {
        if (callHistoryEntry == this.headSameProxy) {
            this.isFreed = false;
        }
        return super.replayOneCall(callHistoryEntry, sQLRecoverableException);
    }

    public InputStream getAsciiStream() throws SQLException {
        if (GETASCIISTREAM_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get ascii stream");
        }
        Method method = GETASCIISTREAM_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(method, this, new Object[0]);
        try {
            OracleClob oracleClob = (OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            InputStream inputStream = oracleClob.canReadBasicLobDataInLocator() ? oracleClob.getAsciiStream() : oracleClob.getDBAccess().newInputStream((OracleClob)((Object)this), oracleClob.getBufferSize(), 0L);
            return (InputStream)this.postForAll(method, inputStream);
        }
        catch (SQLException sQLException) {
            return (InputStream)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public InputStream getAsciiStream(long l2) throws SQLException {
        if (GETASCIISTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get ascii stream");
        }
        Method method = GETASCIISTREAM_LONG_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(method, this, l2);
        try {
            InputStream inputStream;
            OracleClob oracleClob = (OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (oracleClob.canReadBasicLobDataInLocator()) {
                inputStream = oracleClob.getAsciiStream(l2);
            } else {
                if (l2 < 1L) {
                    SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 68);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                inputStream = oracleClob.getDBAccess().newInputStream((OracleClob)((Object)this), oracleClob.getBufferSize(), l2);
            }
            return (InputStream)this.postForAll(method, inputStream);
        }
        catch (SQLException sQLException) {
            return (InputStream)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public Reader getCharacterStream() throws SQLException {
        if (GETCHARSTREAM_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get character stream");
        }
        Method method = GETCHARSTREAM_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(method, this, new Object[0]);
        try {
            OracleClob oracleClob = (OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Reader reader = oracleClob.canReadBasicLobDataInLocator() ? oracleClob.getCharacterStream() : oracleClob.getDBAccess().newReader((OracleClob)((Object)this), oracleClob.getBufferSize(), 0L);
            return (Reader)this.postForAll(method, reader);
        }
        catch (SQLException sQLException) {
            return (Reader)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public Reader getCharacterStream(long l2) throws SQLException {
        if (GETCHARSTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get character stream");
        }
        Method method = GETCHARSTREAM_LONG_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(method, this, l2);
        try {
            Reader reader;
            OracleClob oracleClob = (OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (oracleClob.canReadBasicLobDataInLocator()) {
                reader = oracleClob.getCharacterStream(l2);
            } else {
                if (l2 < 1L) {
                    SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 68);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                reader = oracleClob.getDBAccess().newReader((OracleClob)((Object)this), oracleClob.getBufferSize(), l2);
            }
            return (Reader)this.postForAll(method, reader);
        }
        catch (SQLException sQLException) {
            return (Reader)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public Reader getCharacterStream(long l2, long l3) throws SQLException {
        if (GETCHARSTREAM_LONG_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get character stream");
        }
        Method method = GETCHARSTREAM_LONG_LONG_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(method, this, l2, l3);
        try {
            Reader reader;
            OracleClob oracleClob = (OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (oracleClob.canReadBasicLobDataInLocator()) {
                reader = oracleClob.getCharacterStream(l2, l3);
            } else {
                long l4 = oracleClob.length();
                if (l2 < 1L || l3 < 0L || l2 > l4 || l2 - 1L + l3 > l4) {
                    SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 68);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                reader = oracleClob.getDBAccess().newReader((OracleClob)((Object)this), oracleClob.getBufferSize(), l2, l3);
            }
            return (Reader)this.postForAll(method, reader);
        }
        catch (SQLException sQLException) {
            return (Reader)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public OutputStream setAsciiStream(long l2) throws SQLException {
        if (SETASCIISTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot set ascii stream");
        }
        Method method = SETASCIISTREAM_LONG_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(method, this, l2);
        try {
            OracleClob oracleClob = (OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            OutputStream outputStream = oracleClob.getDBAccess().newOutputStream((OracleClob)((Object)this), oracleClob.getBufferSize(), l2, true);
            return (OutputStream)this.postForAll(method, outputStream);
        }
        catch (SQLException sQLException) {
            return (OutputStream)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public Writer setCharacterStream(long l2) throws SQLException {
        if (SETCHARSTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot set character stream");
        }
        Method method = SETCHARSTREAM_LONG_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(method, this, l2);
        try {
            OracleClob oracleClob = (OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Writer writer = oracleClob.getDBAccess().newWriter((OracleClob)((Object)this), oracleClob.getBufferSize(), l2, true);
            return (Writer)this.postForAll(method, writer);
        }
        catch (SQLException sQLException) {
            return (Writer)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public OutputStream getAsciiOutputStream() throws SQLException {
        return this.setAsciiStream(1L);
    }

    public OutputStream getAsciiOutputStream(long l2) throws SQLException {
        return this.setAsciiStream(l2);
    }

    public Writer getCharacterOutputStream() throws SQLException {
        return this.setCharacterStream(1L);
    }

    public Writer getCharacterOutputStream(long l2) throws SQLException {
        return this.setCharacterStream(l2);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public OracleConnection getInternalConnection() throws SQLException {
        OracleClob oracleClob = (OracleClob)this.getDelegate();
        return oracleClob.getInternalConnection();
    }
}

