/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.schemahistory;

import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.pro.DryRunStatementInterceptor;
import org.flywaydb.core.internal.schemahistory.JdbcTableSchemaHistory;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.schemahistory.pro.InMemorySchemaHistory;

public class SchemaHistoryFactory {
    private SchemaHistoryFactory() {
    }

    public static SchemaHistory getSchemaHistory(Configuration configuration, Database database, Schema schema, DryRunStatementInterceptor dryRunStatementInterceptor) {
        String installedBy = configuration.getInstalledBy() == null ? database.getCurrentUser() : configuration.getInstalledBy();
        Table table = schema.getTable(configuration.getTable());
        JdbcTableSchemaHistory jdbcTableSchemaHistory = new JdbcTableSchemaHistory(database, table, installedBy);
        if (configuration.getDryRunOutput() != null) {
            dryRunStatementInterceptor.init(database, table);
            return new InMemorySchemaHistory(jdbcTableSchemaHistory.exists(), jdbcTableSchemaHistory.allAppliedMigrations(), table, installedBy, dryRunStatementInterceptor);
        }
        return jdbcTableSchemaHistory;
    }
}

