/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.cloud.spanner.jdbc.JdbcPreconditions;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.concurrent.atomic.AtomicInteger;

class JdbcSavepoint
implements Savepoint {
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private final int id;
    private final String name;

    static JdbcSavepoint named(String name) {
        return new JdbcSavepoint(-1, name);
    }

    static JdbcSavepoint unnamed() {
        int id = COUNTER.incrementAndGet();
        return new JdbcSavepoint(id, String.format("s_%d", id));
    }

    private JdbcSavepoint(int id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public int getSavepointId() throws SQLException {
        JdbcPreconditions.checkState(this.id >= 0, "This is a named savepoint");
        return this.id;
    }

    @Override
    public String getSavepointName() throws SQLException {
        JdbcPreconditions.checkState(this.id < 0, "This is an unnamed savepoint");
        return this.name;
    }

    String internalGetSavepointName() {
        return this.name;
    }
}

