/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.secretsmanager.sql;

import com.amazonaws.secretsmanager.caching.SecretCache;
import com.amazonaws.secretsmanager.caching.SecretCacheConfiguration;
import com.amazonaws.secretsmanager.sql.AWSSecretsManagerDriver;
import com.amazonaws.secretsmanager.util.SQLExceptionUtils;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.utils.StringUtils;

public final class AWSSecretsManagerDb2Driver
extends AWSSecretsManagerDriver {
    public static final int ACCESS_DENIED_FOR_USER_USING_PASSWORD_TO_DATABASE = -1403;
    public static final String SUBPREFIX = "db2";

    public AWSSecretsManagerDb2Driver() {
    }

    public AWSSecretsManagerDb2Driver(SecretCache cache) {
        super(cache);
    }

    public AWSSecretsManagerDb2Driver(SecretsManagerClientBuilder builder) {
        super(builder);
    }

    public AWSSecretsManagerDb2Driver(SecretsManagerClient client) {
        super(client);
    }

    public AWSSecretsManagerDb2Driver(SecretCacheConfiguration cacheConfig) {
        super(cacheConfig);
    }

    @Override
    public String getPropertySubprefix() {
        return SUBPREFIX;
    }

    @Override
    public boolean isExceptionDueToAuthenticationError(Exception e) {
        return SQLExceptionUtils.unwrapAndCheckForCode(e, -1403);
    }

    @Override
    public String constructUrlFromEndpointPortDatabase(String endpoint, String port, String dbname) {
        String url = "jdbc:db2://" + endpoint;
        if (StringUtils.isNotBlank((CharSequence)port)) {
            url = url + ":" + port;
        }
        if (StringUtils.isNotBlank((CharSequence)dbname)) {
            url = url + "/" + dbname;
        }
        return url;
    }

    @Override
    public String getDefaultDriverClass() {
        try {
            Class.forName("com.ibm.db2.jcc.DB2Driver", false, this.getClass().getClassLoader());
            return "com.ibm.db2.jcc.DB2Driver";
        }
        catch (ClassNotFoundException e) {
            return "com.ibm.db2.jcc.DB2Driver";
        }
    }

    static {
        AWSSecretsManagerDriver.register(new AWSSecretsManagerDb2Driver());
    }
}

