/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class CRLNumberExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_cRLNumber;
    private BigInteger crlNumber = null;

    public CRLNumberExtension() {
        super(TYPE);
    }

    public CRLNumberExtension(BigInteger crlNumber) {
        this(crlNumber, false);
    }

    public CRLNumberExtension(BigInteger crlNumber, boolean critical) {
        super(TYPE, critical);
        this.crlNumber = crlNumber;
        this.setValue(this.toByteArray());
    }

    public CRLNumberExtension(InputStream is) throws IOException {
        super(is);
    }

    public BigInteger getCRLNumber() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.crlNumber;
    }

    private byte[] toByteArray() {
        byte[] b = Utils.toBytes((Streamable)new ASN1Integer(this.crlNumber));
        this.isDecoded = true;
        return b;
    }

    private void decodeValue() {
        try {
            this.crlNumber = ASN1Integer.inputValue((InputStream)new UnsyncByteArrayInputStream(this.getValue()));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return "CRLNumberExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = " + this.getCRLNumber() + "}";
    }
}

