/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.util.ArrayList;
import java.util.List;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.Attribute;
import oracle.security.crypto.cert.AttributeSet;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.cert.X509ExtensionSet;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.KeyPair;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SignatureException;
import oracle.security.crypto.provider.JCEUtil;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.OutputGenerationException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class CertificateRequest
implements ASN1Object,
Externalizable {
    private X500Name subject;
    private oracle.security.crypto.core.PublicKey pubKey;
    private AttributeSet attributes;
    private ASN1Sequence certReqInfo;
    private PrivateKey privKey;
    private AlgorithmIdentifier sigAlgID;
    private byte[] sigBytes;
    private boolean useWrongFormat;
    private ASN1Sequence contents = null;

    public CertificateRequest() {
    }

    public CertificateRequest(X500Name subject, PublicKey pubKey, PrivateKey privKey) {
        this(subject, pubKey, privKey, false);
    }

    public CertificateRequest(X500Name subject, PublicKey pubKey, PrivateKey privKey, boolean useWrongFormat) {
        this.subject = subject;
        this.pubKey = CryptoUtils.fromJCEPublicKey((PublicKey)pubKey);
        this.privKey = privKey;
        this.useWrongFormat = useWrongFormat;
    }

    public CertificateRequest(X500Name subject, KeyPair kp) {
        this(subject, kp, false);
    }

    public CertificateRequest(X500Name subject, KeyPair kp, boolean useWrongFormat) {
        this.subject = subject;
        this.pubKey = kp.getPublic();
        this.privKey = kp.getPrivate();
        this.useWrongFormat = useWrongFormat;
    }

    public CertificateRequest(InputStream is) throws IOException {
        this.input(is);
    }

    public CertificateRequest(byte[] data) throws IOException {
        this((InputStream)new UnsyncByteArrayInputStream(data));
    }

    public void sign() throws SignatureException {
        this.getCertReqInfo();
        try {
            if (this.sigAlgID == null) {
                if (this.privKey.getAlgorithm().equals("RSA")) {
                    this.sigAlgID = AlgID.sha256WithRSAEncryption;
                } else if (this.privKey.getAlgorithm().equals("DSA")) {
                    this.sigAlgID = AlgID.dsaWithSHA1;
                } else if (this.privKey.getAlgorithm().equals("EC")) {
                    int bit = ((ECPrivateKey)this.privKey).getParams().getCurve().getField().getFieldSize();
                    switch (bit) {
                        case 256: {
                            this.sigAlgID = AlgID.ecdsaWithSHA256;
                            break;
                        }
                        case 384: {
                            this.sigAlgID = AlgID.ecdsaWithSHA384;
                            break;
                        }
                        case 512: {
                            this.sigAlgID = AlgID.ecdsaWithSHA512;
                            break;
                        }
                        default: {
                            this.sigAlgID = AlgID.ecdsaWithSHA1;
                        }
                    }
                }
            }
            Signature sig = JCEUtil.getSignatureInstance((String)CryptoUtils.getSignatureAlg((AlgorithmIdentifier)this.sigAlgID));
            sig.initSign(this.privKey);
            sig.update(Utils.toBytes((Streamable)this.certReqInfo));
            this.sigBytes = sig.sign();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SignatureException((Throwable)ex);
        }
        catch (InvalidKeyException ex) {
            throw new SignatureException((Throwable)ex);
        }
        catch (java.security.SignatureException ex) {
            throw new SignatureException((Throwable)ex);
        }
        this.reset();
    }

    public void sign(RandomBitsSource rbs) throws SignatureException {
        this.sign();
    }

    public byte[] getSigBytes() throws SignatureException {
        if (this.sigBytes == null) {
            this.sign();
        }
        return this.sigBytes;
    }

    private ASN1Sequence getCertReqInfo() {
        if (this.certReqInfo == null) {
            this.certReqInfo = new ASN1Sequence();
            this.certReqInfo.addElement((ASN1Object)new ASN1Integer(0L));
            this.certReqInfo.addElement((ASN1Object)this.subject);
            this.certReqInfo.addElement((ASN1Object)CryptoUtils.subjectPublicKeyInfo((oracle.security.crypto.core.PublicKey)this.pubKey));
            if (this.attributes != null) {
                this.certReqInfo.addElement((ASN1Object)new ASN1GenericConstructed((List)this.attributes.toASN1Set().elementsAsList(), 0));
            } else if (!this.useWrongFormat) {
                this.certReqInfo.addElement((ASN1Object)new ASN1GenericConstructed(new ArrayList(), 0));
            }
        }
        return this.certReqInfo;
    }

    public void input(InputStream is) throws IOException {
        this.resetAll();
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
        this.certReqInfo = new ASN1Sequence((InputStream)sis);
        this.sigAlgID = new AlgorithmIdentifier((InputStream)sis);
        this.sigBytes = ASN1BitString.inputValue((InputStream)sis);
        sis.terminate();
        sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.certReqInfo));
        int version = ASN1Integer.inputValue((InputStream)sis).intValue();
        if (version != 0) {
            throw new ASN1FormatException("Expected version 0, got " + version);
        }
        this.subject = new X500Name((InputStream)sis);
        this.pubKey = CryptoUtils.inputSPKI((InputStream)sis);
        if (sis.hasMoreData()) {
            if (sis.getCurrentTag() == 0) {
                sis.setCurrentTag(17);
                this.attributes = new AttributeSet((InputStream)sis);
            } else {
                throw new ASN1FormatException("Expected tag 0, got " + sis.getCurrentTag());
            }
        }
        sis.terminate();
        try {
            this.verifySignature();
        }
        catch (AuthenticationException ex) {
            throw new IOException(ex);
        }
    }

    public boolean verifySignature() throws AuthenticationException {
        try {
            Signature sig = JCEUtil.getSignatureInstance((String)CryptoUtils.getSignatureAlg((AlgorithmIdentifier)this.sigAlgID));
            sig.initVerify((PublicKey)this.pubKey);
            sig.update(Utils.toBytes((Streamable)this.certReqInfo));
            return sig.verify(this.sigBytes);
        }
        catch (java.security.SignatureException ex) {
            throw new AuthenticationException((Throwable)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException((Throwable)ex);
        }
        catch (InvalidKeyException ex) {
            throw new AuthenticationException((Throwable)ex);
        }
    }

    public void output(OutputStream os) throws IOException {
        try {
            this.toASN1Sequence().output(os);
        }
        catch (SignatureException ex) {
            throw new OutputGenerationException((Exception)((Object)ex));
        }
    }

    public int length() {
        try {
            return this.toASN1Sequence().length();
        }
        catch (SignatureException ex) {
            return 0;
        }
    }

    ASN1Sequence toASN1Sequence() throws SignatureException {
        if (this.contents == null) {
            this.getSigBytes();
            ASN1Sequence seq = new ASN1Sequence();
            seq.addElement((ASN1Object)this.certReqInfo);
            seq.addElement((ASN1Object)this.sigAlgID);
            seq.addElement((ASN1Object)new ASN1BitString(this.sigBytes));
            this.contents = seq;
        }
        return this.contents;
    }

    private void reset() {
        this.contents = null;
    }

    private void resetAll() {
        this.reset();
        this.certReqInfo = null;
        this.sigBytes = null;
    }

    public void setSubject(X500Name subject) {
        this.subject = subject;
        this.resetAll();
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public void setPublicKey(oracle.security.crypto.core.PublicKey pk) {
        this.setPublicKey((PublicKey)pk);
    }

    public oracle.security.crypto.core.PublicKey getPublicKey() {
        return this.pubKey;
    }

    public void setPublicKey(PublicKey pk) {
        this.pubKey = CryptoUtils.fromJCEPublicKey((PublicKey)pk);
        this.resetAll();
    }

    public void setPrivateKey(oracle.security.crypto.core.PrivateKey privKey) {
        this.setPrivateKey(privKey, null);
    }

    public void setPrivateKey(oracle.security.crypto.core.PrivateKey privKey, AlgorithmIdentifier sigAlgID) {
        this.privKey = privKey;
        this.setSigAlgID(sigAlgID);
    }

    public void setPrivateKey(PrivateKey privKey, AlgorithmIdentifier sigAlgID) {
        this.privKey = privKey;
        this.setSigAlgID(sigAlgID);
    }

    public void setSigAlgID(AlgorithmIdentifier sigAlgID) {
        this.sigAlgID = sigAlgID;
        this.resetAll();
    }

    public AlgorithmIdentifier getSigAlgID() {
        return this.sigAlgID;
    }

    public Attribute addAttribute(ASN1ObjectID type, ASN1Object value) {
        return this.addAttribute(new Attribute(type, value));
    }

    public Attribute addAttribute(Attribute attr) {
        this.resetAll();
        if (this.attributes == null) {
            this.attributes = new AttributeSet();
        }
        return this.attributes.addAttribute(attr);
    }

    public Attribute getAttribute(ASN1ObjectID type) {
        return this.attributes != null ? this.attributes.getAttribute(type) : null;
    }

    public AttributeSet getAttributes() {
        return this.attributes;
    }

    public X509Extension addExtension(X509Extension ext) {
        X509ExtensionSet extSet = this.getExtensions();
        if (extSet == null) {
            extSet = new X509ExtensionSet();
        }
        X509Extension old = extSet.getExtension(ext.getType());
        extSet.addExtension(ext);
        this.setExtensions(extSet);
        return old;
    }

    public X509ExtensionSet setExtensions(X509ExtensionSet extSet) {
        Attribute a = this.addAttribute(PKIX.extensionRequest, extSet);
        if (a != null) {
            try {
                return new X509ExtensionSet(Utils.toStream((Streamable)((Streamable)a.getValuesAsList().get(0))));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    public X509ExtensionSet getExtensions() {
        Attribute a = this.getAttribute(PKIX.extensionRequest);
        if (a != null) {
            try {
                return new X509ExtensionSet(Utils.toStream((Streamable)((Streamable)a.getValuesAsList().get(0))));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    public void setUseWrongFormat(boolean useWrongFormat) {
        this.useWrongFormat = useWrongFormat;
        this.resetAll();
    }

    public boolean getUseWrongFormat() {
        return this.useWrongFormat;
    }

    public String toString() {
        return "subject = " + this.subject + ", pubKey = " + this.pubKey;
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes((Streamable)this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        this.input((InputStream)new UnsyncByteArrayInputStream(data));
    }
}

