/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.InternalApi;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.SavepointSupport;
import javax.annotation.Nonnull;

@InternalApi
interface UnitOfWork {
    public void cancel();

    public Type getType();

    public UnitOfWorkState getState();

    public boolean isActive();

    public ApiFuture<Void> commitAsync(CallType var1);

    public ApiFuture<Void> rollbackAsync(CallType var1);

    public void savepoint(@Nonnull String var1, @Nonnull Dialect var2);

    public void releaseSavepoint(@Nonnull String var1);

    public void rollbackToSavepoint(@Nonnull String var1, @Nonnull SavepointSupport var2);

    public ApiFuture<long[]> runBatchAsync(CallType var1);

    public void abortBatch();

    public boolean isReadOnly();

    public ApiFuture<ResultSet> executeQueryAsync(CallType var1, AbstractStatementParser.ParsedStatement var2, AnalyzeMode var3, Options.QueryOption ... var4);

    public Timestamp getReadTimestamp();

    public Timestamp getReadTimestampOrNull();

    public Timestamp getCommitTimestamp();

    public Timestamp getCommitTimestampOrNull();

    public CommitResponse getCommitResponse();

    public CommitResponse getCommitResponseOrNull();

    public ApiFuture<Void> executeDdlAsync(CallType var1, AbstractStatementParser.ParsedStatement var2);

    public ApiFuture<Long> executeUpdateAsync(CallType var1, AbstractStatementParser.ParsedStatement var2, Options.UpdateOption ... var3);

    public ApiFuture<ResultSet> analyzeUpdateAsync(CallType var1, AbstractStatementParser.ParsedStatement var2, AnalyzeMode var3, Options.UpdateOption ... var4);

    public ApiFuture<long[]> executeBatchUpdateAsync(CallType var1, Iterable<AbstractStatementParser.ParsedStatement> var2, Options.UpdateOption ... var3);

    public ApiFuture<Void> writeAsync(CallType var1, Iterable<Mutation> var2);

    public static enum UnitOfWorkState {
        STARTED,
        COMMITTING,
        COMMITTED,
        COMMIT_FAILED,
        ROLLED_BACK,
        RUNNING,
        RAN,
        RUN_FAILED,
        ABORTED;


        public boolean isActive() {
            return this == STARTED;
        }
    }

    public static enum Type {
        TRANSACTION,
        BATCH;

    }

    public static enum CallType {
        SYNC,
        ASYNC;

    }
}

