//
// Fluid Image management for the Fast Light Tool Kit (FLTK).
//
// Copyright 1998-2021 by Bill Spitzak and others.
//
// This library is free software. Distribution and use rights are outlined in
// the file "COPYING" which should have been included with this file.  If this
// file is missing or damaged, see the license at:
//
//     https://www.fltk.org/COPYING.php
//
// Please see the following page on how to report bugs and issues:
//
//     https://www.fltk.org/bugs.php
//

#ifndef _FLUID_PIXMAPS_H
#define _FLUID_PIXMAPS_H

class Fl_Pixmap;

extern Fl_Pixmap *lock_pixmap;
extern Fl_Pixmap *protected_pixmap;
extern Fl_Pixmap *invisible_pixmap;

extern Fl_Pixmap *window_pixmap;
extern Fl_Pixmap *button_pixmap;
extern Fl_Pixmap *checkbutton_pixmap;
extern Fl_Pixmap *roundbutton_pixmap;
extern Fl_Pixmap *box_pixmap;
extern Fl_Pixmap *group_pixmap;
extern Fl_Pixmap *function_pixmap;
extern Fl_Pixmap *code_pixmap;
extern Fl_Pixmap *codeblock_pixmap;
extern Fl_Pixmap *comment_pixmap;
extern Fl_Pixmap *declaration_pixmap;
extern Fl_Pixmap *declarationblock_pixmap;
extern Fl_Pixmap *class_pixmap;
extern Fl_Pixmap *tabs_pixmap;
extern Fl_Pixmap *input_pixmap;
extern Fl_Pixmap *choice_pixmap;
extern Fl_Pixmap *menuitem_pixmap;
extern Fl_Pixmap *menubar_pixmap;
extern Fl_Pixmap *submenu_pixmap;
extern Fl_Pixmap *scroll_pixmap;
extern Fl_Pixmap *tile_pixmap;
extern Fl_Pixmap *wizard_pixmap;
extern Fl_Pixmap *pack_pixmap;
extern Fl_Pixmap *returnbutton_pixmap;
extern Fl_Pixmap *lightbutton_pixmap;
extern Fl_Pixmap *repeatbutton_pixmap;
extern Fl_Pixmap *menubutton_pixmap;
extern Fl_Pixmap *output_pixmap;
extern Fl_Pixmap *textdisplay_pixmap;
extern Fl_Pixmap *textedit_pixmap;
extern Fl_Pixmap *fileinput_pixmap;
extern Fl_Pixmap *browser_pixmap;
extern Fl_Pixmap *checkbrowser_pixmap;
extern Fl_Pixmap *filebrowser_pixmap;
extern Fl_Pixmap *clock_pixmap;
extern Fl_Pixmap *help_pixmap;
extern Fl_Pixmap *progress_pixmap;
extern Fl_Pixmap *slider_pixmap;
extern Fl_Pixmap *scrollbar_pixmap;
extern Fl_Pixmap *valueslider_pixmap;
extern Fl_Pixmap *adjuster_pixmap;
extern Fl_Pixmap *counter_pixmap;
extern Fl_Pixmap *dial_pixmap;
extern Fl_Pixmap *roller_pixmap;
extern Fl_Pixmap *valueinput_pixmap;
extern Fl_Pixmap *valueoutput_pixmap;
extern Fl_Pixmap *spinner_pixmap;
extern Fl_Pixmap *widgetclass_pixmap;
extern Fl_Pixmap *data_pixmap;
extern Fl_Pixmap *tree_pixmap;
extern Fl_Pixmap *table_pixmap;
extern Fl_Pixmap *simple_terminal_pixmap;

extern Fl_Pixmap *pixmap[];

void loadPixmaps();

#endif // _FLUID_PIXMAPS_H
