//    SPDX-License-Identifier: LGPL-3.0-or-later
/*
    This file is part of FlexiBLAS, a BLAS/LAPACK interface wrapper library.
    Copyright (C) 2013-2024 Martin Koehler

    This program is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the Free
    Software Foundation, either version 3 of the License, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program. If not, see <https://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <complex.h>

#include "flexiblas_fortran_mangle.h"

#include "flexiblas.h"


#if __GNUC__ > 7
typedef size_t fortran_charlen_t;
#else
typedef int fortran_charlen_t;
#endif

#ifdef INTEGER8
#define blasint int64_t
#else
#define blasint int
#endif



static TLS_STORE uint8_t hook_pos_dsyswapr = 0;
#ifdef FLEXIBLAS_ABI_INTEL
void FC_GLOBAL(dsyswapr,DSYSWAPR)(char* uplo, blasint* n, double* a, blasint* lda, blasint* i1, blasint* i2)
#else
void FC_GLOBAL(dsyswapr,DSYSWAPR)(char* uplo, blasint* n, double* a, blasint* lda, blasint* i1, blasint* i2)
#endif
{
	void (*fn) (void* uplo, void* n, void* a, void* lda, void* i1, void* i2);
	void (*fn_hook) (void* uplo, void* n, void* a, void* lda, void* i1, void* i2);

    if ( current_backend->post_init != 0 ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }
	*(void **) & fn = current_backend->lapack.dsyswapr.f77_blas_function; 
	*(void **) & fn_hook = __flexiblas_hooks->dsyswapr.f77_hook_function[0]; 
	if ( fn_hook == NULL ) { 
		fn((void*) uplo, (void*) n, (void*) a, (void*) lda, (void*) i1, (void*) i2); 
		return;
	} else {
		hook_pos_dsyswapr = 0;
		fn_hook((void*) uplo, (void*) n, (void*) a, (void*) lda, (void*) i1, (void*) i2);
		return;
	}
}
#ifdef FLEXIBLAS_ABI_IBM
void dsyswapr_(char* uplo, blasint* n, double* a, blasint* lda, blasint* i1, blasint* i2) __attribute__((alias(MTS(FC_GLOBAL(dsyswapr,DSYSWAPR)))));
#else
#ifndef __APPLE__
void dsyswapr(char* uplo, blasint* n, double* a, blasint* lda, blasint* i1, blasint* i2) __attribute__((alias(MTS(FC_GLOBAL(dsyswapr,DSYSWAPR)))));
#else
void dsyswapr(char* uplo, blasint* n, double* a, blasint* lda, blasint* i1, blasint* i2){ FC_GLOBAL(dsyswapr,DSYSWAPR)((void*) uplo, (void*) n, (void*) a, (void*) lda, (void*) i1, (void*) i2); }
#endif
#endif




/* Real Implementation for Hooks */


void flexiblas_real_dsyswapr_(void* uplo, void* n, void* a, void* lda, void* i1, void* i2)
{
	void (*fn) (void* uplo, void* n, void* a, void* lda, void* i1, void* i2);

	*(void **) & fn = current_backend->lapack.dsyswapr.f77_blas_function; 

		fn((void*) uplo, (void*) n, (void*) a, (void*) lda, (void*) i1, (void*) i2); 

	return;
}
#ifndef __APPLE__
void flexiblas_real_dsyswapr(void* uplo, void* n, void* a, void* lda, void* i1, void* i2) __attribute__((alias("flexiblas_real_dsyswapr_")));
#else
void flexiblas_real_dsyswapr(void* uplo, void* n, void* a, void* lda, void* i1, void* i2){flexiblas_real_dsyswapr_((void*) uplo, (void*) n, (void*) a, (void*) lda, (void*) i1, (void*) i2);}
#endif




/* Chainloader for Hooks */


void flexiblas_chain_dsyswapr_(void* uplo, void* n, void* a, void* lda, void* i1, void* i2)
{
	void (*fn) (void* uplo, void* n, void* a, void* lda, void* i1, void* i2);
	void (*fn_hook) (void* uplo, void* n, void* a, void* lda, void* i1, void* i2);

	*(void **) &fn      = current_backend->lapack.dsyswapr.f77_blas_function; 

    hook_pos_dsyswapr ++;
    if( hook_pos_dsyswapr < __flexiblas_hooks->dsyswapr.nhook) {
        *(void **) &fn_hook = __flexiblas_hooks->dsyswapr.f77_hook_function[hook_pos_dsyswapr];
        fn_hook((void*) uplo, (void*) n, (void*) a, (void*) lda, (void*) i1, (void*) i2);
    } else {
        hook_pos_dsyswapr = 0;
		fn((void*) uplo, (void*) n, (void*) a, (void*) lda, (void*) i1, (void*) i2); 
	}
	return;
}
#ifndef __APPLE__
void flexiblas_chain_dsyswapr(void* uplo, void* n, void* a, void* lda, void* i1, void* i2) __attribute__((alias("flexiblas_chain_dsyswapr_")));
#else
void flexiblas_chain_dsyswapr(void* uplo, void* n, void* a, void* lda, void* i1, void* i2){flexiblas_chain_dsyswapr_((void*) uplo, (void*) n, (void*) a, (void*) lda, (void*) i1, (void*) i2);}
#endif



