//    SPDX-License-Identifier: LGPL-3.0-or-later
/*
    This file is part of FlexiBLAS, a BLAS/LAPACK interface wrapper library.
    Copyright (C) 2013-2024 Martin Koehler

    This program is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the Free
    Software Foundation, either version 3 of the License, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program. If not, see <https://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <complex.h>

#include "flexiblas_fortran_mangle.h"

#include "flexiblas.h"


#if __GNUC__ > 7
typedef size_t fortran_charlen_t;
#else
typedef int fortran_charlen_t;
#endif

#ifdef INTEGER8
#define blasint int64_t
#else
#define blasint int
#endif


HIDDEN int __flexiblas_load_flapack ( flexiblas_backend_t *handle, int *loaded, int *failed )  {
	int _ifailed = *failed;
	LOAD_FLAPACK(handle,lapack.cbbcsd,cbbcsd);
	LOAD_FLAPACK(handle,lapack.cbdsqr,cbdsqr);
	LOAD_FLAPACK(handle,lapack.cgbbrd,cgbbrd);
	LOAD_FLAPACK(handle,lapack.cgbcon,cgbcon);
	LOAD_FLAPACK(handle,lapack.cgbequ,cgbequ);
	LOAD_FLAPACK(handle,lapack.cgbequb,cgbequb);
	LOAD_FLAPACK(handle,lapack.cgbrfs,cgbrfs);
	LOAD_FLAPACK(handle,lapack.cgbsv,cgbsv);
	LOAD_FLAPACK(handle,lapack.cgbsvx,cgbsvx);
	LOAD_FLAPACK(handle,lapack.cgbtf2,cgbtf2);
	LOAD_FLAPACK(handle,lapack.cgbtrf,cgbtrf);
	LOAD_FLAPACK(handle,lapack.cgbtrs,cgbtrs);
	LOAD_FLAPACK(handle,lapack.cgebak,cgebak);
	LOAD_FLAPACK(handle,lapack.cgebal,cgebal);
	LOAD_FLAPACK(handle,lapack.cgebd2,cgebd2);
	LOAD_FLAPACK(handle,lapack.cgebrd,cgebrd);
	LOAD_FLAPACK(handle,lapack.cgecon,cgecon);
	LOAD_FLAPACK(handle,lapack.cgeequ,cgeequ);
	LOAD_FLAPACK(handle,lapack.cgeequb,cgeequb);
	LOAD_FLAPACK(handle,lapack.cgees,cgees);
	LOAD_FLAPACK(handle,lapack.cgeesx,cgeesx);
	LOAD_FLAPACK(handle,lapack.cgeev,cgeev);
	LOAD_FLAPACK(handle,lapack.cgeevx,cgeevx);
	LOAD_FLAPACK(handle,lapack.cgehd2,cgehd2);
	LOAD_FLAPACK(handle,lapack.cgehrd,cgehrd);
	LOAD_FLAPACK(handle,lapack.cgejsv,cgejsv);
	LOAD_FLAPACK(handle,lapack.cgelq,cgelq);
	LOAD_FLAPACK(handle,lapack.cgelq2,cgelq2);
	LOAD_FLAPACK(handle,lapack.cgelqf,cgelqf);
	LOAD_FLAPACK(handle,lapack.cgelqt,cgelqt);
	LOAD_FLAPACK(handle,lapack.cgelqt3,cgelqt3);
	LOAD_FLAPACK(handle,lapack.cgels,cgels);
	LOAD_FLAPACK(handle,lapack.cgelsd,cgelsd);
	LOAD_FLAPACK(handle,lapack.cgelss,cgelss);
	LOAD_FLAPACK(handle,lapack.cgelst,cgelst);
	LOAD_FLAPACK(handle,lapack.cgelsy,cgelsy);
	LOAD_FLAPACK(handle,lapack.cgemlq,cgemlq);
	LOAD_FLAPACK(handle,lapack.cgemlqt,cgemlqt);
	LOAD_FLAPACK(handle,lapack.cgemqr,cgemqr);
	LOAD_FLAPACK(handle,lapack.cgemqrt,cgemqrt);
	LOAD_FLAPACK(handle,lapack.cgeql2,cgeql2);
	LOAD_FLAPACK(handle,lapack.cgeqlf,cgeqlf);
	LOAD_FLAPACK(handle,lapack.cgeqp3,cgeqp3);
	LOAD_FLAPACK(handle,lapack.cgeqr,cgeqr);
	LOAD_FLAPACK(handle,lapack.cgeqr2,cgeqr2);
	LOAD_FLAPACK(handle,lapack.cgeqr2p,cgeqr2p);
	LOAD_FLAPACK(handle,lapack.cgeqrf,cgeqrf);
	LOAD_FLAPACK(handle,lapack.cgeqrfp,cgeqrfp);
	LOAD_FLAPACK(handle,lapack.cgeqrt,cgeqrt);
	LOAD_FLAPACK(handle,lapack.cgeqrt2,cgeqrt2);
	LOAD_FLAPACK(handle,lapack.cgeqrt3,cgeqrt3);
	LOAD_FLAPACK(handle,lapack.cgerfs,cgerfs);
	LOAD_FLAPACK(handle,lapack.cgerq2,cgerq2);
	LOAD_FLAPACK(handle,lapack.cgerqf,cgerqf);
	LOAD_FLAPACK(handle,lapack.cgesc2,cgesc2);
	LOAD_FLAPACK(handle,lapack.cgesdd,cgesdd);
	LOAD_FLAPACK(handle,lapack.cgesv,cgesv);
	LOAD_FLAPACK(handle,lapack.cgesvd,cgesvd);
	LOAD_FLAPACK(handle,lapack.cgesvdq,cgesvdq);
	LOAD_FLAPACK(handle,lapack.cgesvdx,cgesvdx);
	LOAD_FLAPACK(handle,lapack.cgesvj,cgesvj);
	LOAD_FLAPACK(handle,lapack.cgesvx,cgesvx);
	LOAD_FLAPACK(handle,lapack.cgetc2,cgetc2);
	LOAD_FLAPACK(handle,lapack.cgetf2,cgetf2);
	LOAD_FLAPACK(handle,lapack.cgetrf,cgetrf);
	LOAD_FLAPACK(handle,lapack.cgetrf2,cgetrf2);
	LOAD_FLAPACK(handle,lapack.cgetri,cgetri);
	LOAD_FLAPACK(handle,lapack.cgetrs,cgetrs);
	LOAD_FLAPACK(handle,lapack.cgetsls,cgetsls);
	LOAD_FLAPACK(handle,lapack.cgetsqrhrt,cgetsqrhrt);
	LOAD_FLAPACK(handle,lapack.cggbak,cggbak);
	LOAD_FLAPACK(handle,lapack.cggbal,cggbal);
	LOAD_FLAPACK(handle,lapack.cgges,cgges);
	LOAD_FLAPACK(handle,lapack.cgges3,cgges3);
	LOAD_FLAPACK(handle,lapack.cggesx,cggesx);
	LOAD_FLAPACK(handle,lapack.cggev,cggev);
	LOAD_FLAPACK(handle,lapack.cggev3,cggev3);
	LOAD_FLAPACK(handle,lapack.cggevx,cggevx);
	LOAD_FLAPACK(handle,lapack.cggglm,cggglm);
	LOAD_FLAPACK(handle,lapack.cgghd3,cgghd3);
	LOAD_FLAPACK(handle,lapack.cgghrd,cgghrd);
	LOAD_FLAPACK(handle,lapack.cgglse,cgglse);
	LOAD_FLAPACK(handle,lapack.cggqrf,cggqrf);
	LOAD_FLAPACK(handle,lapack.cggrqf,cggrqf);
	LOAD_FLAPACK(handle,lapack.cggsvd3,cggsvd3);
	LOAD_FLAPACK(handle,lapack.cggsvp3,cggsvp3);
	LOAD_FLAPACK(handle,lapack.cgsvj0,cgsvj0);
	LOAD_FLAPACK(handle,lapack.cgsvj1,cgsvj1);
	LOAD_FLAPACK(handle,lapack.cgtcon,cgtcon);
	LOAD_FLAPACK(handle,lapack.cgtrfs,cgtrfs);
	LOAD_FLAPACK(handle,lapack.cgtsv,cgtsv);
	LOAD_FLAPACK(handle,lapack.cgtsvx,cgtsvx);
	LOAD_FLAPACK(handle,lapack.cgttrf,cgttrf);
	LOAD_FLAPACK(handle,lapack.cgttrs,cgttrs);
	LOAD_FLAPACK(handle,lapack.cgtts2,cgtts2);
	LOAD_FLAPACK(handle,lapack.chb2st_kernels,chb2st_kernels);
	LOAD_FLAPACK(handle,lapack.chbev,chbev);
	LOAD_FLAPACK(handle,lapack.chbev_2stage,chbev_2stage);
	LOAD_FLAPACK(handle,lapack.chbevd,chbevd);
	LOAD_FLAPACK(handle,lapack.chbevd_2stage,chbevd_2stage);
	LOAD_FLAPACK(handle,lapack.chbevx,chbevx);
	LOAD_FLAPACK(handle,lapack.chbevx_2stage,chbevx_2stage);
	LOAD_FLAPACK(handle,lapack.chbgst,chbgst);
	LOAD_FLAPACK(handle,lapack.chbgv,chbgv);
	LOAD_FLAPACK(handle,lapack.chbgvd,chbgvd);
	LOAD_FLAPACK(handle,lapack.chbgvx,chbgvx);
	LOAD_FLAPACK(handle,lapack.chbtrd,chbtrd);
	LOAD_FLAPACK(handle,lapack.checon,checon);
	LOAD_FLAPACK(handle,lapack.checon_3,checon_3);
	LOAD_FLAPACK(handle,lapack.checon_rook,checon_rook);
	LOAD_FLAPACK(handle,lapack.cheequb,cheequb);
	LOAD_FLAPACK(handle,lapack.cheev,cheev);
	LOAD_FLAPACK(handle,lapack.cheev_2stage,cheev_2stage);
	LOAD_FLAPACK(handle,lapack.cheevd,cheevd);
	LOAD_FLAPACK(handle,lapack.cheevd_2stage,cheevd_2stage);
	LOAD_FLAPACK(handle,lapack.cheevr,cheevr);
	LOAD_FLAPACK(handle,lapack.cheevr_2stage,cheevr_2stage);
	LOAD_FLAPACK(handle,lapack.cheevx,cheevx);
	LOAD_FLAPACK(handle,lapack.cheevx_2stage,cheevx_2stage);
	LOAD_FLAPACK(handle,lapack.chegs2,chegs2);
	LOAD_FLAPACK(handle,lapack.chegst,chegst);
	LOAD_FLAPACK(handle,lapack.chegv,chegv);
	LOAD_FLAPACK(handle,lapack.chegv_2stage,chegv_2stage);
	LOAD_FLAPACK(handle,lapack.chegvd,chegvd);
	LOAD_FLAPACK(handle,lapack.chegvx,chegvx);
	LOAD_FLAPACK(handle,lapack.cherfs,cherfs);
	LOAD_FLAPACK(handle,lapack.chesv,chesv);
	LOAD_FLAPACK(handle,lapack.chesv_aa,chesv_aa);
	LOAD_FLAPACK(handle,lapack.chesv_aa_2stage,chesv_aa_2stage);
	LOAD_FLAPACK(handle,lapack.chesv_rk,chesv_rk);
	LOAD_FLAPACK(handle,lapack.chesv_rook,chesv_rook);
	LOAD_FLAPACK(handle,lapack.chesvx,chesvx);
	LOAD_FLAPACK(handle,lapack.cheswapr,cheswapr);
	LOAD_FLAPACK(handle,lapack.chetd2,chetd2);
	LOAD_FLAPACK(handle,lapack.chetf2,chetf2);
	LOAD_FLAPACK(handle,lapack.chetf2_rk,chetf2_rk);
	LOAD_FLAPACK(handle,lapack.chetf2_rook,chetf2_rook);
	LOAD_FLAPACK(handle,lapack.chetrd,chetrd);
	LOAD_FLAPACK(handle,lapack.chetrd_2stage,chetrd_2stage);
	LOAD_FLAPACK(handle,lapack.chetrd_hb2st,chetrd_hb2st);
	LOAD_FLAPACK(handle,lapack.chetrd_he2hb,chetrd_he2hb);
	LOAD_FLAPACK(handle,lapack.chetrf,chetrf);
	LOAD_FLAPACK(handle,lapack.chetrf_aa,chetrf_aa);
	LOAD_FLAPACK(handle,lapack.chetrf_aa_2stage,chetrf_aa_2stage);
	LOAD_FLAPACK(handle,lapack.chetrf_rk,chetrf_rk);
	LOAD_FLAPACK(handle,lapack.chetrf_rook,chetrf_rook);
	LOAD_FLAPACK(handle,lapack.chetri,chetri);
	LOAD_FLAPACK(handle,lapack.chetri2,chetri2);
	LOAD_FLAPACK(handle,lapack.chetri2x,chetri2x);
	LOAD_FLAPACK(handle,lapack.chetri_3,chetri_3);
	LOAD_FLAPACK(handle,lapack.chetri_3x,chetri_3x);
	LOAD_FLAPACK(handle,lapack.chetri_rook,chetri_rook);
	LOAD_FLAPACK(handle,lapack.chetrs,chetrs);
	LOAD_FLAPACK(handle,lapack.chetrs2,chetrs2);
	LOAD_FLAPACK(handle,lapack.chetrs_3,chetrs_3);
	LOAD_FLAPACK(handle,lapack.chetrs_aa,chetrs_aa);
	LOAD_FLAPACK(handle,lapack.chetrs_aa_2stage,chetrs_aa_2stage);
	LOAD_FLAPACK(handle,lapack.chetrs_rook,chetrs_rook);
	LOAD_FLAPACK(handle,lapack.chfrk,chfrk);
	LOAD_FLAPACK(handle,lapack.chgeqz,chgeqz);
	LOAD_FLAPACK(handle,lapack.chla_transtype,chla_transtype);
	LOAD_FLAPACK(handle,lapack.chpcon,chpcon);
	LOAD_FLAPACK(handle,lapack.chpev,chpev);
	LOAD_FLAPACK(handle,lapack.chpevd,chpevd);
	LOAD_FLAPACK(handle,lapack.chpevx,chpevx);
	LOAD_FLAPACK(handle,lapack.chpgst,chpgst);
	LOAD_FLAPACK(handle,lapack.chpgv,chpgv);
	LOAD_FLAPACK(handle,lapack.chpgvd,chpgvd);
	LOAD_FLAPACK(handle,lapack.chpgvx,chpgvx);
	LOAD_FLAPACK(handle,lapack.chprfs,chprfs);
	LOAD_FLAPACK(handle,lapack.chpsv,chpsv);
	LOAD_FLAPACK(handle,lapack.chpsvx,chpsvx);
	LOAD_FLAPACK(handle,lapack.chptrd,chptrd);
	LOAD_FLAPACK(handle,lapack.chptrf,chptrf);
	LOAD_FLAPACK(handle,lapack.chptri,chptri);
	LOAD_FLAPACK(handle,lapack.chptrs,chptrs);
	LOAD_FLAPACK(handle,lapack.chsein,chsein);
	LOAD_FLAPACK(handle,lapack.chseqr,chseqr);
	LOAD_FLAPACK(handle,lapack.clabrd,clabrd);
	LOAD_FLAPACK(handle,lapack.clacgv,clacgv);
	LOAD_FLAPACK(handle,lapack.clacn2,clacn2);
	LOAD_FLAPACK(handle,lapack.clacon,clacon);
	LOAD_FLAPACK(handle,lapack.clacp2,clacp2);
	LOAD_FLAPACK(handle,lapack.clacpy,clacpy);
	LOAD_FLAPACK(handle,lapack.clacrm,clacrm);
	LOAD_FLAPACK(handle,lapack.clacrt,clacrt);
	LOAD_FLAPACK(handle,lapack.cladiv,cladiv);
	LOAD_FLAPACK(handle,lapack.claed0,claed0);
	LOAD_FLAPACK(handle,lapack.claed7,claed7);
	LOAD_FLAPACK(handle,lapack.claed8,claed8);
	LOAD_FLAPACK(handle,lapack.claein,claein);
	LOAD_FLAPACK(handle,lapack.claesy,claesy);
	LOAD_FLAPACK(handle,lapack.claev2,claev2);
	LOAD_FLAPACK(handle,lapack.clag2z,clag2z);
	LOAD_FLAPACK(handle,lapack.clags2,clags2);
	LOAD_FLAPACK(handle,lapack.clagtm,clagtm);
	LOAD_FLAPACK(handle,lapack.clahef,clahef);
	LOAD_FLAPACK(handle,lapack.clahef_aa,clahef_aa);
	LOAD_FLAPACK(handle,lapack.clahef_rk,clahef_rk);
	LOAD_FLAPACK(handle,lapack.clahef_rook,clahef_rook);
	LOAD_FLAPACK(handle,lapack.clahqr,clahqr);
	LOAD_FLAPACK(handle,lapack.clahr2,clahr2);
	LOAD_FLAPACK(handle,lapack.claic1,claic1);
	LOAD_FLAPACK(handle,lapack.clals0,clals0);
	LOAD_FLAPACK(handle,lapack.clalsa,clalsa);
	LOAD_FLAPACK(handle,lapack.clalsd,clalsd);
	LOAD_FLAPACK(handle,lapack.clamswlq,clamswlq);
	LOAD_FLAPACK(handle,lapack.clamtsqr,clamtsqr);
	LOAD_FLAPACK(handle,lapack.clangb,clangb);
	LOAD_FLAPACK(handle,lapack.clange,clange);
	LOAD_FLAPACK(handle,lapack.clangt,clangt);
	LOAD_FLAPACK(handle,lapack.clanhb,clanhb);
	LOAD_FLAPACK(handle,lapack.clanhe,clanhe);
	LOAD_FLAPACK(handle,lapack.clanhf,clanhf);
	LOAD_FLAPACK(handle,lapack.clanhp,clanhp);
	LOAD_FLAPACK(handle,lapack.clanhs,clanhs);
	LOAD_FLAPACK(handle,lapack.clanht,clanht);
	LOAD_FLAPACK(handle,lapack.clansb,clansb);
	LOAD_FLAPACK(handle,lapack.clansp,clansp);
	LOAD_FLAPACK(handle,lapack.clansy,clansy);
	LOAD_FLAPACK(handle,lapack.clantb,clantb);
	LOAD_FLAPACK(handle,lapack.clantp,clantp);
	LOAD_FLAPACK(handle,lapack.clantr,clantr);
	LOAD_FLAPACK(handle,lapack.clapll,clapll);
	LOAD_FLAPACK(handle,lapack.clapmr,clapmr);
	LOAD_FLAPACK(handle,lapack.clapmt,clapmt);
	LOAD_FLAPACK(handle,lapack.claqgb,claqgb);
	LOAD_FLAPACK(handle,lapack.claqge,claqge);
	LOAD_FLAPACK(handle,lapack.claqhb,claqhb);
	LOAD_FLAPACK(handle,lapack.claqhe,claqhe);
	LOAD_FLAPACK(handle,lapack.claqhp,claqhp);
	LOAD_FLAPACK(handle,lapack.claqp2,claqp2);
	LOAD_FLAPACK(handle,lapack.claqps,claqps);
	LOAD_FLAPACK(handle,lapack.claqr0,claqr0);
	LOAD_FLAPACK(handle,lapack.claqr1,claqr1);
	LOAD_FLAPACK(handle,lapack.claqr2,claqr2);
	LOAD_FLAPACK(handle,lapack.claqr3,claqr3);
	LOAD_FLAPACK(handle,lapack.claqr4,claqr4);
	LOAD_FLAPACK(handle,lapack.claqr5,claqr5);
	LOAD_FLAPACK(handle,lapack.claqsb,claqsb);
	LOAD_FLAPACK(handle,lapack.claqsp,claqsp);
	LOAD_FLAPACK(handle,lapack.claqsy,claqsy);
	LOAD_FLAPACK(handle,lapack.claqz0,claqz0);
	LOAD_FLAPACK(handle,lapack.claqz1,claqz1);
	LOAD_FLAPACK(handle,lapack.claqz2,claqz2);
	LOAD_FLAPACK(handle,lapack.claqz3,claqz3);
	LOAD_FLAPACK(handle,lapack.clar1v,clar1v);
	LOAD_FLAPACK(handle,lapack.clar2v,clar2v);
	LOAD_FLAPACK(handle,lapack.clarcm,clarcm);
	LOAD_FLAPACK(handle,lapack.clarf,clarf);
	LOAD_FLAPACK(handle,lapack.clarfb,clarfb);
	LOAD_FLAPACK(handle,lapack.clarfb_gett,clarfb_gett);
	LOAD_FLAPACK(handle,lapack.clarfg,clarfg);
	LOAD_FLAPACK(handle,lapack.clarfgp,clarfgp);
	LOAD_FLAPACK(handle,lapack.clarft,clarft);
	LOAD_FLAPACK(handle,lapack.clarfx,clarfx);
	LOAD_FLAPACK(handle,lapack.clarfy,clarfy);
	LOAD_FLAPACK(handle,lapack.clargv,clargv);
	LOAD_FLAPACK(handle,lapack.clarnv,clarnv);
	LOAD_FLAPACK(handle,lapack.clarrv,clarrv);
	LOAD_FLAPACK(handle,lapack.clartg,clartg);
	LOAD_FLAPACK(handle,lapack.clartv,clartv);
	LOAD_FLAPACK(handle,lapack.clarz,clarz);
	LOAD_FLAPACK(handle,lapack.clarzb,clarzb);
	LOAD_FLAPACK(handle,lapack.clarzt,clarzt);
	LOAD_FLAPACK(handle,lapack.clascl,clascl);
	LOAD_FLAPACK(handle,lapack.claset,claset);
	LOAD_FLAPACK(handle,lapack.clasr,clasr);
	LOAD_FLAPACK(handle,lapack.classq,classq);
	LOAD_FLAPACK(handle,lapack.claswlq,claswlq);
	LOAD_FLAPACK(handle,lapack.claswp,claswp);
	LOAD_FLAPACK(handle,lapack.clasyf,clasyf);
	LOAD_FLAPACK(handle,lapack.clasyf_aa,clasyf_aa);
	LOAD_FLAPACK(handle,lapack.clasyf_rk,clasyf_rk);
	LOAD_FLAPACK(handle,lapack.clasyf_rook,clasyf_rook);
	LOAD_FLAPACK(handle,lapack.clatbs,clatbs);
	LOAD_FLAPACK(handle,lapack.clatdf,clatdf);
	LOAD_FLAPACK(handle,lapack.clatps,clatps);
	LOAD_FLAPACK(handle,lapack.clatrd,clatrd);
	LOAD_FLAPACK(handle,lapack.clatrs,clatrs);
	LOAD_FLAPACK(handle,lapack.clatrs3,clatrs3);
	LOAD_FLAPACK(handle,lapack.clatrz,clatrz);
	LOAD_FLAPACK(handle,lapack.clatsqr,clatsqr);
	LOAD_FLAPACK(handle,lapack.claunhr_col_getrfnp,claunhr_col_getrfnp);
	LOAD_FLAPACK(handle,lapack.claunhr_col_getrfnp2,claunhr_col_getrfnp2);
	LOAD_FLAPACK(handle,lapack.clauu2,clauu2);
	LOAD_FLAPACK(handle,lapack.clauum,clauum);
	LOAD_FLAPACK(handle,lapack.cpbcon,cpbcon);
	LOAD_FLAPACK(handle,lapack.cpbequ,cpbequ);
	LOAD_FLAPACK(handle,lapack.cpbrfs,cpbrfs);
	LOAD_FLAPACK(handle,lapack.cpbstf,cpbstf);
	LOAD_FLAPACK(handle,lapack.cpbsv,cpbsv);
	LOAD_FLAPACK(handle,lapack.cpbsvx,cpbsvx);
	LOAD_FLAPACK(handle,lapack.cpbtf2,cpbtf2);
	LOAD_FLAPACK(handle,lapack.cpbtrf,cpbtrf);
	LOAD_FLAPACK(handle,lapack.cpbtrs,cpbtrs);
	LOAD_FLAPACK(handle,lapack.cpftrf,cpftrf);
	LOAD_FLAPACK(handle,lapack.cpftri,cpftri);
	LOAD_FLAPACK(handle,lapack.cpftrs,cpftrs);
	LOAD_FLAPACK(handle,lapack.cpocon,cpocon);
	LOAD_FLAPACK(handle,lapack.cpoequ,cpoequ);
	LOAD_FLAPACK(handle,lapack.cpoequb,cpoequb);
	LOAD_FLAPACK(handle,lapack.cporfs,cporfs);
	LOAD_FLAPACK(handle,lapack.cposv,cposv);
	LOAD_FLAPACK(handle,lapack.cposvx,cposvx);
	LOAD_FLAPACK(handle,lapack.cpotf2,cpotf2);
	LOAD_FLAPACK(handle,lapack.cpotrf,cpotrf);
	LOAD_FLAPACK(handle,lapack.cpotrf2,cpotrf2);
	LOAD_FLAPACK(handle,lapack.cpotri,cpotri);
	LOAD_FLAPACK(handle,lapack.cpotrs,cpotrs);
	LOAD_FLAPACK(handle,lapack.cppcon,cppcon);
	LOAD_FLAPACK(handle,lapack.cppequ,cppequ);
	LOAD_FLAPACK(handle,lapack.cpprfs,cpprfs);
	LOAD_FLAPACK(handle,lapack.cppsv,cppsv);
	LOAD_FLAPACK(handle,lapack.cppsvx,cppsvx);
	LOAD_FLAPACK(handle,lapack.cpptrf,cpptrf);
	LOAD_FLAPACK(handle,lapack.cpptri,cpptri);
	LOAD_FLAPACK(handle,lapack.cpptrs,cpptrs);
	LOAD_FLAPACK(handle,lapack.cpstf2,cpstf2);
	LOAD_FLAPACK(handle,lapack.cpstrf,cpstrf);
	LOAD_FLAPACK(handle,lapack.cptcon,cptcon);
	LOAD_FLAPACK(handle,lapack.cpteqr,cpteqr);
	LOAD_FLAPACK(handle,lapack.cptrfs,cptrfs);
	LOAD_FLAPACK(handle,lapack.cptsv,cptsv);
	LOAD_FLAPACK(handle,lapack.cptsvx,cptsvx);
	LOAD_FLAPACK(handle,lapack.cpttrf,cpttrf);
	LOAD_FLAPACK(handle,lapack.cpttrs,cpttrs);
	LOAD_FLAPACK(handle,lapack.cptts2,cptts2);
	LOAD_FLAPACK(handle,lapack.crot,crot);
	LOAD_FLAPACK(handle,lapack.cspcon,cspcon);
	LOAD_FLAPACK(handle,lapack.cspmv,cspmv);
	LOAD_FLAPACK(handle,lapack.cspr,cspr);
	LOAD_FLAPACK(handle,lapack.csprfs,csprfs);
	LOAD_FLAPACK(handle,lapack.cspsv,cspsv);
	LOAD_FLAPACK(handle,lapack.cspsvx,cspsvx);
	LOAD_FLAPACK(handle,lapack.csptrf,csptrf);
	LOAD_FLAPACK(handle,lapack.csptri,csptri);
	LOAD_FLAPACK(handle,lapack.csptrs,csptrs);
	LOAD_FLAPACK(handle,lapack.csrscl,csrscl);
	LOAD_FLAPACK(handle,lapack.cstedc,cstedc);
	LOAD_FLAPACK(handle,lapack.cstegr,cstegr);
	LOAD_FLAPACK(handle,lapack.cstein,cstein);
	LOAD_FLAPACK(handle,lapack.cstemr,cstemr);
	LOAD_FLAPACK(handle,lapack.csteqr,csteqr);
	LOAD_FLAPACK(handle,lapack.csycon,csycon);
	LOAD_FLAPACK(handle,lapack.csycon_3,csycon_3);
	LOAD_FLAPACK(handle,lapack.csycon_rook,csycon_rook);
	LOAD_FLAPACK(handle,lapack.csyconv,csyconv);
	LOAD_FLAPACK(handle,lapack.csyconvf,csyconvf);
	LOAD_FLAPACK(handle,lapack.csyconvf_rook,csyconvf_rook);
	LOAD_FLAPACK(handle,lapack.csyequb,csyequb);
	LOAD_FLAPACK(handle,lapack.csymv,csymv);
	LOAD_FLAPACK(handle,lapack.csyr,csyr);
	LOAD_FLAPACK(handle,lapack.csyrfs,csyrfs);
	LOAD_FLAPACK(handle,lapack.csysv,csysv);
	LOAD_FLAPACK(handle,lapack.csysv_aa,csysv_aa);
	LOAD_FLAPACK(handle,lapack.csysv_aa_2stage,csysv_aa_2stage);
	LOAD_FLAPACK(handle,lapack.csysv_rk,csysv_rk);
	LOAD_FLAPACK(handle,lapack.csysv_rook,csysv_rook);
	LOAD_FLAPACK(handle,lapack.csysvx,csysvx);
	LOAD_FLAPACK(handle,lapack.csyswapr,csyswapr);
	LOAD_FLAPACK(handle,lapack.csytf2,csytf2);
	LOAD_FLAPACK(handle,lapack.csytf2_rk,csytf2_rk);
	LOAD_FLAPACK(handle,lapack.csytf2_rook,csytf2_rook);
	LOAD_FLAPACK(handle,lapack.csytrf,csytrf);
	LOAD_FLAPACK(handle,lapack.csytrf_aa,csytrf_aa);
	LOAD_FLAPACK(handle,lapack.csytrf_aa_2stage,csytrf_aa_2stage);
	LOAD_FLAPACK(handle,lapack.csytrf_rk,csytrf_rk);
	LOAD_FLAPACK(handle,lapack.csytrf_rook,csytrf_rook);
	LOAD_FLAPACK(handle,lapack.csytri,csytri);
	LOAD_FLAPACK(handle,lapack.csytri2,csytri2);
	LOAD_FLAPACK(handle,lapack.csytri2x,csytri2x);
	LOAD_FLAPACK(handle,lapack.csytri_3,csytri_3);
	LOAD_FLAPACK(handle,lapack.csytri_3x,csytri_3x);
	LOAD_FLAPACK(handle,lapack.csytri_rook,csytri_rook);
	LOAD_FLAPACK(handle,lapack.csytrs,csytrs);
	LOAD_FLAPACK(handle,lapack.csytrs2,csytrs2);
	LOAD_FLAPACK(handle,lapack.csytrs_3,csytrs_3);
	LOAD_FLAPACK(handle,lapack.csytrs_aa,csytrs_aa);
	LOAD_FLAPACK(handle,lapack.csytrs_aa_2stage,csytrs_aa_2stage);
	LOAD_FLAPACK(handle,lapack.csytrs_rook,csytrs_rook);
	LOAD_FLAPACK(handle,lapack.ctbcon,ctbcon);
	LOAD_FLAPACK(handle,lapack.ctbrfs,ctbrfs);
	LOAD_FLAPACK(handle,lapack.ctbtrs,ctbtrs);
	LOAD_FLAPACK(handle,lapack.ctfsm,ctfsm);
	LOAD_FLAPACK(handle,lapack.ctftri,ctftri);
	LOAD_FLAPACK(handle,lapack.ctfttp,ctfttp);
	LOAD_FLAPACK(handle,lapack.ctfttr,ctfttr);
	LOAD_FLAPACK(handle,lapack.ctgevc,ctgevc);
	LOAD_FLAPACK(handle,lapack.ctgex2,ctgex2);
	LOAD_FLAPACK(handle,lapack.ctgexc,ctgexc);
	LOAD_FLAPACK(handle,lapack.ctgsen,ctgsen);
	LOAD_FLAPACK(handle,lapack.ctgsja,ctgsja);
	LOAD_FLAPACK(handle,lapack.ctgsna,ctgsna);
	LOAD_FLAPACK(handle,lapack.ctgsy2,ctgsy2);
	LOAD_FLAPACK(handle,lapack.ctgsyl,ctgsyl);
	LOAD_FLAPACK(handle,lapack.ctpcon,ctpcon);
	LOAD_FLAPACK(handle,lapack.ctplqt,ctplqt);
	LOAD_FLAPACK(handle,lapack.ctplqt2,ctplqt2);
	LOAD_FLAPACK(handle,lapack.ctpmlqt,ctpmlqt);
	LOAD_FLAPACK(handle,lapack.ctpmqrt,ctpmqrt);
	LOAD_FLAPACK(handle,lapack.ctpqrt,ctpqrt);
	LOAD_FLAPACK(handle,lapack.ctpqrt2,ctpqrt2);
	LOAD_FLAPACK(handle,lapack.ctprfb,ctprfb);
	LOAD_FLAPACK(handle,lapack.ctprfs,ctprfs);
	LOAD_FLAPACK(handle,lapack.ctptri,ctptri);
	LOAD_FLAPACK(handle,lapack.ctptrs,ctptrs);
	LOAD_FLAPACK(handle,lapack.ctpttf,ctpttf);
	LOAD_FLAPACK(handle,lapack.ctpttr,ctpttr);
	LOAD_FLAPACK(handle,lapack.ctrcon,ctrcon);
	LOAD_FLAPACK(handle,lapack.ctrevc,ctrevc);
	LOAD_FLAPACK(handle,lapack.ctrevc3,ctrevc3);
	LOAD_FLAPACK(handle,lapack.ctrexc,ctrexc);
	LOAD_FLAPACK(handle,lapack.ctrrfs,ctrrfs);
	LOAD_FLAPACK(handle,lapack.ctrsen,ctrsen);
	LOAD_FLAPACK(handle,lapack.ctrsna,ctrsna);
	LOAD_FLAPACK(handle,lapack.ctrsyl,ctrsyl);
	LOAD_FLAPACK(handle,lapack.ctrsyl3,ctrsyl3);
	LOAD_FLAPACK(handle,lapack.ctrti2,ctrti2);
	LOAD_FLAPACK(handle,lapack.ctrtri,ctrtri);
	LOAD_FLAPACK(handle,lapack.ctrtrs,ctrtrs);
	LOAD_FLAPACK(handle,lapack.ctrttf,ctrttf);
	LOAD_FLAPACK(handle,lapack.ctrttp,ctrttp);
	LOAD_FLAPACK(handle,lapack.ctzrzf,ctzrzf);
	LOAD_FLAPACK(handle,lapack.cunbdb,cunbdb);
	LOAD_FLAPACK(handle,lapack.cunbdb1,cunbdb1);
	LOAD_FLAPACK(handle,lapack.cunbdb2,cunbdb2);
	LOAD_FLAPACK(handle,lapack.cunbdb3,cunbdb3);
	LOAD_FLAPACK(handle,lapack.cunbdb4,cunbdb4);
	LOAD_FLAPACK(handle,lapack.cunbdb5,cunbdb5);
	LOAD_FLAPACK(handle,lapack.cunbdb6,cunbdb6);
	LOAD_FLAPACK(handle,lapack.cuncsd,cuncsd);
	LOAD_FLAPACK(handle,lapack.cuncsd2by1,cuncsd2by1);
	LOAD_FLAPACK(handle,lapack.cung2l,cung2l);
	LOAD_FLAPACK(handle,lapack.cung2r,cung2r);
	LOAD_FLAPACK(handle,lapack.cungbr,cungbr);
	LOAD_FLAPACK(handle,lapack.cunghr,cunghr);
	LOAD_FLAPACK(handle,lapack.cungl2,cungl2);
	LOAD_FLAPACK(handle,lapack.cunglq,cunglq);
	LOAD_FLAPACK(handle,lapack.cungql,cungql);
	LOAD_FLAPACK(handle,lapack.cungqr,cungqr);
	LOAD_FLAPACK(handle,lapack.cungr2,cungr2);
	LOAD_FLAPACK(handle,lapack.cungrq,cungrq);
	LOAD_FLAPACK(handle,lapack.cungtr,cungtr);
	LOAD_FLAPACK(handle,lapack.cungtsqr,cungtsqr);
	LOAD_FLAPACK(handle,lapack.cungtsqr_row,cungtsqr_row);
	LOAD_FLAPACK(handle,lapack.cunhr_col,cunhr_col);
	LOAD_FLAPACK(handle,lapack.cunm22,cunm22);
	LOAD_FLAPACK(handle,lapack.cunm2l,cunm2l);
	LOAD_FLAPACK(handle,lapack.cunm2r,cunm2r);
	LOAD_FLAPACK(handle,lapack.cunmbr,cunmbr);
	LOAD_FLAPACK(handle,lapack.cunmhr,cunmhr);
	LOAD_FLAPACK(handle,lapack.cunml2,cunml2);
	LOAD_FLAPACK(handle,lapack.cunmlq,cunmlq);
	LOAD_FLAPACK(handle,lapack.cunmql,cunmql);
	LOAD_FLAPACK(handle,lapack.cunmqr,cunmqr);
	LOAD_FLAPACK(handle,lapack.cunmr2,cunmr2);
	LOAD_FLAPACK(handle,lapack.cunmr3,cunmr3);
	LOAD_FLAPACK(handle,lapack.cunmrq,cunmrq);
	LOAD_FLAPACK(handle,lapack.cunmrz,cunmrz);
	LOAD_FLAPACK(handle,lapack.cunmtr,cunmtr);
	LOAD_FLAPACK(handle,lapack.cupgtr,cupgtr);
	LOAD_FLAPACK(handle,lapack.cupmtr,cupmtr);
	LOAD_FLAPACK(handle,lapack.dbbcsd,dbbcsd);
	LOAD_FLAPACK(handle,lapack.dbdsdc,dbdsdc);
	LOAD_FLAPACK(handle,lapack.dbdsqr,dbdsqr);
	LOAD_FLAPACK(handle,lapack.dbdsvdx,dbdsvdx);
	LOAD_FLAPACK(handle,lapack.ddisna,ddisna);
	LOAD_FLAPACK(handle,lapack.dgbbrd,dgbbrd);
	LOAD_FLAPACK(handle,lapack.dgbcon,dgbcon);
	LOAD_FLAPACK(handle,lapack.dgbequ,dgbequ);
	LOAD_FLAPACK(handle,lapack.dgbequb,dgbequb);
	LOAD_FLAPACK(handle,lapack.dgbrfs,dgbrfs);
	LOAD_FLAPACK(handle,lapack.dgbsv,dgbsv);
	LOAD_FLAPACK(handle,lapack.dgbsvx,dgbsvx);
	LOAD_FLAPACK(handle,lapack.dgbtf2,dgbtf2);
	LOAD_FLAPACK(handle,lapack.dgbtrf,dgbtrf);
	LOAD_FLAPACK(handle,lapack.dgbtrs,dgbtrs);
	LOAD_FLAPACK(handle,lapack.dgebak,dgebak);
	LOAD_FLAPACK(handle,lapack.dgebal,dgebal);
	LOAD_FLAPACK(handle,lapack.dgebd2,dgebd2);
	LOAD_FLAPACK(handle,lapack.dgebrd,dgebrd);
	LOAD_FLAPACK(handle,lapack.dgecon,dgecon);
	LOAD_FLAPACK(handle,lapack.dgeequ,dgeequ);
	LOAD_FLAPACK(handle,lapack.dgeequb,dgeequb);
	LOAD_FLAPACK(handle,lapack.dgees,dgees);
	LOAD_FLAPACK(handle,lapack.dgeesx,dgeesx);
	LOAD_FLAPACK(handle,lapack.dgeev,dgeev);
	LOAD_FLAPACK(handle,lapack.dgeevx,dgeevx);
	LOAD_FLAPACK(handle,lapack.dgehd2,dgehd2);
	LOAD_FLAPACK(handle,lapack.dgehrd,dgehrd);
	LOAD_FLAPACK(handle,lapack.dgejsv,dgejsv);
	LOAD_FLAPACK(handle,lapack.dgelq,dgelq);
	LOAD_FLAPACK(handle,lapack.dgelq2,dgelq2);
	LOAD_FLAPACK(handle,lapack.dgelqf,dgelqf);
	LOAD_FLAPACK(handle,lapack.dgelqt,dgelqt);
	LOAD_FLAPACK(handle,lapack.dgelqt3,dgelqt3);
	LOAD_FLAPACK(handle,lapack.dgels,dgels);
	LOAD_FLAPACK(handle,lapack.dgelsd,dgelsd);
	LOAD_FLAPACK(handle,lapack.dgelss,dgelss);
	LOAD_FLAPACK(handle,lapack.dgelst,dgelst);
	LOAD_FLAPACK(handle,lapack.dgelsy,dgelsy);
	LOAD_FLAPACK(handle,lapack.dgemlq,dgemlq);
	LOAD_FLAPACK(handle,lapack.dgemlqt,dgemlqt);
	LOAD_FLAPACK(handle,lapack.dgemqr,dgemqr);
	LOAD_FLAPACK(handle,lapack.dgemqrt,dgemqrt);
	LOAD_FLAPACK(handle,lapack.dgeql2,dgeql2);
	LOAD_FLAPACK(handle,lapack.dgeqlf,dgeqlf);
	LOAD_FLAPACK(handle,lapack.dgeqp3,dgeqp3);
	LOAD_FLAPACK(handle,lapack.dgeqr,dgeqr);
	LOAD_FLAPACK(handle,lapack.dgeqr2,dgeqr2);
	LOAD_FLAPACK(handle,lapack.dgeqr2p,dgeqr2p);
	LOAD_FLAPACK(handle,lapack.dgeqrf,dgeqrf);
	LOAD_FLAPACK(handle,lapack.dgeqrfp,dgeqrfp);
	LOAD_FLAPACK(handle,lapack.dgeqrt,dgeqrt);
	LOAD_FLAPACK(handle,lapack.dgeqrt2,dgeqrt2);
	LOAD_FLAPACK(handle,lapack.dgeqrt3,dgeqrt3);
	LOAD_FLAPACK(handle,lapack.dgerfs,dgerfs);
	LOAD_FLAPACK(handle,lapack.dgerq2,dgerq2);
	LOAD_FLAPACK(handle,lapack.dgerqf,dgerqf);
	LOAD_FLAPACK(handle,lapack.dgesc2,dgesc2);
	LOAD_FLAPACK(handle,lapack.dgesdd,dgesdd);
	LOAD_FLAPACK(handle,lapack.dgesv,dgesv);
	LOAD_FLAPACK(handle,lapack.dgesvd,dgesvd);
	LOAD_FLAPACK(handle,lapack.dgesvdq,dgesvdq);
	LOAD_FLAPACK(handle,lapack.dgesvdx,dgesvdx);
	LOAD_FLAPACK(handle,lapack.dgesvj,dgesvj);
	LOAD_FLAPACK(handle,lapack.dgesvx,dgesvx);
	LOAD_FLAPACK(handle,lapack.dgetc2,dgetc2);
	LOAD_FLAPACK(handle,lapack.dgetf2,dgetf2);
	LOAD_FLAPACK(handle,lapack.dgetrf,dgetrf);
	LOAD_FLAPACK(handle,lapack.dgetrf2,dgetrf2);
	LOAD_FLAPACK(handle,lapack.dgetri,dgetri);
	LOAD_FLAPACK(handle,lapack.dgetrs,dgetrs);
	LOAD_FLAPACK(handle,lapack.dgetsls,dgetsls);
	LOAD_FLAPACK(handle,lapack.dgetsqrhrt,dgetsqrhrt);
	LOAD_FLAPACK(handle,lapack.dggbak,dggbak);
	LOAD_FLAPACK(handle,lapack.dggbal,dggbal);
	LOAD_FLAPACK(handle,lapack.dgges,dgges);
	LOAD_FLAPACK(handle,lapack.dgges3,dgges3);
	LOAD_FLAPACK(handle,lapack.dggesx,dggesx);
	LOAD_FLAPACK(handle,lapack.dggev,dggev);
	LOAD_FLAPACK(handle,lapack.dggev3,dggev3);
	LOAD_FLAPACK(handle,lapack.dggevx,dggevx);
	LOAD_FLAPACK(handle,lapack.dggglm,dggglm);
	LOAD_FLAPACK(handle,lapack.dgghd3,dgghd3);
	LOAD_FLAPACK(handle,lapack.dgghrd,dgghrd);
	LOAD_FLAPACK(handle,lapack.dgglse,dgglse);
	LOAD_FLAPACK(handle,lapack.dggqrf,dggqrf);
	LOAD_FLAPACK(handle,lapack.dggrqf,dggrqf);
	LOAD_FLAPACK(handle,lapack.dggsvd3,dggsvd3);
	LOAD_FLAPACK(handle,lapack.dggsvp3,dggsvp3);
	LOAD_FLAPACK(handle,lapack.dgsvj0,dgsvj0);
	LOAD_FLAPACK(handle,lapack.dgsvj1,dgsvj1);
	LOAD_FLAPACK(handle,lapack.dgtcon,dgtcon);
	LOAD_FLAPACK(handle,lapack.dgtrfs,dgtrfs);
	LOAD_FLAPACK(handle,lapack.dgtsv,dgtsv);
	LOAD_FLAPACK(handle,lapack.dgtsvx,dgtsvx);
	LOAD_FLAPACK(handle,lapack.dgttrf,dgttrf);
	LOAD_FLAPACK(handle,lapack.dgttrs,dgttrs);
	LOAD_FLAPACK(handle,lapack.dgtts2,dgtts2);
	LOAD_FLAPACK(handle,lapack.dhgeqz,dhgeqz);
	LOAD_FLAPACK(handle,lapack.dhsein,dhsein);
	LOAD_FLAPACK(handle,lapack.dhseqr,dhseqr);
	LOAD_FLAPACK(handle,lapack.disnan,disnan);
	LOAD_FLAPACK(handle,lapack.dlabad,dlabad);
	LOAD_FLAPACK(handle,lapack.dlabrd,dlabrd);
	LOAD_FLAPACK(handle,lapack.dlacn2,dlacn2);
	LOAD_FLAPACK(handle,lapack.dlacon,dlacon);
	LOAD_FLAPACK(handle,lapack.dlacpy,dlacpy);
	LOAD_FLAPACK(handle,lapack.dladiv,dladiv);
	LOAD_FLAPACK(handle,lapack.dladiv1,dladiv1);
	LOAD_FLAPACK(handle,lapack.dladiv2,dladiv2);
	LOAD_FLAPACK(handle,lapack.dlae2,dlae2);
	LOAD_FLAPACK(handle,lapack.dlaebz,dlaebz);
	LOAD_FLAPACK(handle,lapack.dlaed0,dlaed0);
	LOAD_FLAPACK(handle,lapack.dlaed1,dlaed1);
	LOAD_FLAPACK(handle,lapack.dlaed2,dlaed2);
	LOAD_FLAPACK(handle,lapack.dlaed3,dlaed3);
	LOAD_FLAPACK(handle,lapack.dlaed4,dlaed4);
	LOAD_FLAPACK(handle,lapack.dlaed5,dlaed5);
	LOAD_FLAPACK(handle,lapack.dlaed6,dlaed6);
	LOAD_FLAPACK(handle,lapack.dlaed7,dlaed7);
	LOAD_FLAPACK(handle,lapack.dlaed8,dlaed8);
	LOAD_FLAPACK(handle,lapack.dlaed9,dlaed9);
	LOAD_FLAPACK(handle,lapack.dlaeda,dlaeda);
	LOAD_FLAPACK(handle,lapack.dlaein,dlaein);
	LOAD_FLAPACK(handle,lapack.dlaev2,dlaev2);
	LOAD_FLAPACK(handle,lapack.dlaexc,dlaexc);
	LOAD_FLAPACK(handle,lapack.dlag2,dlag2);
	LOAD_FLAPACK(handle,lapack.dlag2s,dlag2s);
	LOAD_FLAPACK(handle,lapack.dlags2,dlags2);
	LOAD_FLAPACK(handle,lapack.dlagtf,dlagtf);
	LOAD_FLAPACK(handle,lapack.dlagtm,dlagtm);
	LOAD_FLAPACK(handle,lapack.dlagts,dlagts);
	LOAD_FLAPACK(handle,lapack.dlagv2,dlagv2);
	LOAD_FLAPACK(handle,lapack.dlahqr,dlahqr);
	LOAD_FLAPACK(handle,lapack.dlahr2,dlahr2);
	LOAD_FLAPACK(handle,lapack.dlaic1,dlaic1);
	LOAD_FLAPACK(handle,lapack.dlaisnan,dlaisnan);
	LOAD_FLAPACK(handle,lapack.dlaln2,dlaln2);
	LOAD_FLAPACK(handle,lapack.dlals0,dlals0);
	LOAD_FLAPACK(handle,lapack.dlalsa,dlalsa);
	LOAD_FLAPACK(handle,lapack.dlalsd,dlalsd);
	LOAD_FLAPACK(handle,lapack.dlamc3,dlamc3);
	LOAD_FLAPACK(handle,lapack.dlamch,dlamch);
	LOAD_FLAPACK(handle,lapack.dlamrg,dlamrg);
	LOAD_FLAPACK(handle,lapack.dlamswlq,dlamswlq);
	LOAD_FLAPACK(handle,lapack.dlamtsqr,dlamtsqr);
	LOAD_FLAPACK(handle,lapack.dlaneg,dlaneg);
	LOAD_FLAPACK(handle,lapack.dlangb,dlangb);
	LOAD_FLAPACK(handle,lapack.dlange,dlange);
	LOAD_FLAPACK(handle,lapack.dlangt,dlangt);
	LOAD_FLAPACK(handle,lapack.dlanhs,dlanhs);
	LOAD_FLAPACK(handle,lapack.dlansb,dlansb);
	LOAD_FLAPACK(handle,lapack.dlansf,dlansf);
	LOAD_FLAPACK(handle,lapack.dlansp,dlansp);
	LOAD_FLAPACK(handle,lapack.dlanst,dlanst);
	LOAD_FLAPACK(handle,lapack.dlansy,dlansy);
	LOAD_FLAPACK(handle,lapack.dlantb,dlantb);
	LOAD_FLAPACK(handle,lapack.dlantp,dlantp);
	LOAD_FLAPACK(handle,lapack.dlantr,dlantr);
	LOAD_FLAPACK(handle,lapack.dlanv2,dlanv2);
	LOAD_FLAPACK(handle,lapack.dlaorhr_col_getrfnp,dlaorhr_col_getrfnp);
	LOAD_FLAPACK(handle,lapack.dlaorhr_col_getrfnp2,dlaorhr_col_getrfnp2);
	LOAD_FLAPACK(handle,lapack.dlapll,dlapll);
	LOAD_FLAPACK(handle,lapack.dlapmr,dlapmr);
	LOAD_FLAPACK(handle,lapack.dlapmt,dlapmt);
	LOAD_FLAPACK(handle,lapack.dlapy2,dlapy2);
	LOAD_FLAPACK(handle,lapack.dlapy3,dlapy3);
	LOAD_FLAPACK(handle,lapack.dlaqgb,dlaqgb);
	LOAD_FLAPACK(handle,lapack.dlaqge,dlaqge);
	LOAD_FLAPACK(handle,lapack.dlaqp2,dlaqp2);
	LOAD_FLAPACK(handle,lapack.dlaqps,dlaqps);
	LOAD_FLAPACK(handle,lapack.dlaqr0,dlaqr0);
	LOAD_FLAPACK(handle,lapack.dlaqr1,dlaqr1);
	LOAD_FLAPACK(handle,lapack.dlaqr2,dlaqr2);
	LOAD_FLAPACK(handle,lapack.dlaqr3,dlaqr3);
	LOAD_FLAPACK(handle,lapack.dlaqr4,dlaqr4);
	LOAD_FLAPACK(handle,lapack.dlaqr5,dlaqr5);
	LOAD_FLAPACK(handle,lapack.dlaqsb,dlaqsb);
	LOAD_FLAPACK(handle,lapack.dlaqsp,dlaqsp);
	LOAD_FLAPACK(handle,lapack.dlaqsy,dlaqsy);
	LOAD_FLAPACK(handle,lapack.dlaqtr,dlaqtr);
	LOAD_FLAPACK(handle,lapack.dlaqz0,dlaqz0);
	LOAD_FLAPACK(handle,lapack.dlaqz1,dlaqz1);
	LOAD_FLAPACK(handle,lapack.dlaqz2,dlaqz2);
	LOAD_FLAPACK(handle,lapack.dlaqz3,dlaqz3);
	LOAD_FLAPACK(handle,lapack.dlaqz4,dlaqz4);
	LOAD_FLAPACK(handle,lapack.dlar1v,dlar1v);
	LOAD_FLAPACK(handle,lapack.dlar2v,dlar2v);
	LOAD_FLAPACK(handle,lapack.dlarf,dlarf);
	LOAD_FLAPACK(handle,lapack.dlarfb,dlarfb);
	LOAD_FLAPACK(handle,lapack.dlarfb_gett,dlarfb_gett);
	LOAD_FLAPACK(handle,lapack.dlarfg,dlarfg);
	LOAD_FLAPACK(handle,lapack.dlarfgp,dlarfgp);
	LOAD_FLAPACK(handle,lapack.dlarft,dlarft);
	LOAD_FLAPACK(handle,lapack.dlarfx,dlarfx);
	LOAD_FLAPACK(handle,lapack.dlarfy,dlarfy);
	LOAD_FLAPACK(handle,lapack.dlargv,dlargv);
	LOAD_FLAPACK(handle,lapack.dlarmm,dlarmm);
	LOAD_FLAPACK(handle,lapack.dlarnv,dlarnv);
	LOAD_FLAPACK(handle,lapack.dlarra,dlarra);
	LOAD_FLAPACK(handle,lapack.dlarrb,dlarrb);
	LOAD_FLAPACK(handle,lapack.dlarrc,dlarrc);
	LOAD_FLAPACK(handle,lapack.dlarrd,dlarrd);
	LOAD_FLAPACK(handle,lapack.dlarre,dlarre);
	LOAD_FLAPACK(handle,lapack.dlarrf,dlarrf);
	LOAD_FLAPACK(handle,lapack.dlarrj,dlarrj);
	LOAD_FLAPACK(handle,lapack.dlarrk,dlarrk);
	LOAD_FLAPACK(handle,lapack.dlarrr,dlarrr);
	LOAD_FLAPACK(handle,lapack.dlarrv,dlarrv);
	LOAD_FLAPACK(handle,lapack.dlartg,dlartg);
	LOAD_FLAPACK(handle,lapack.dlartgp,dlartgp);
	LOAD_FLAPACK(handle,lapack.dlartgs,dlartgs);
	LOAD_FLAPACK(handle,lapack.dlartv,dlartv);
	LOAD_FLAPACK(handle,lapack.dlaruv,dlaruv);
	LOAD_FLAPACK(handle,lapack.dlarz,dlarz);
	LOAD_FLAPACK(handle,lapack.dlarzb,dlarzb);
	LOAD_FLAPACK(handle,lapack.dlarzt,dlarzt);
	LOAD_FLAPACK(handle,lapack.dlas2,dlas2);
	LOAD_FLAPACK(handle,lapack.dlascl,dlascl);
	LOAD_FLAPACK(handle,lapack.dlasd0,dlasd0);
	LOAD_FLAPACK(handle,lapack.dlasd1,dlasd1);
	LOAD_FLAPACK(handle,lapack.dlasd2,dlasd2);
	LOAD_FLAPACK(handle,lapack.dlasd3,dlasd3);
	LOAD_FLAPACK(handle,lapack.dlasd4,dlasd4);
	LOAD_FLAPACK(handle,lapack.dlasd5,dlasd5);
	LOAD_FLAPACK(handle,lapack.dlasd6,dlasd6);
	LOAD_FLAPACK(handle,lapack.dlasd7,dlasd7);
	LOAD_FLAPACK(handle,lapack.dlasd8,dlasd8);
	LOAD_FLAPACK(handle,lapack.dlasda,dlasda);
	LOAD_FLAPACK(handle,lapack.dlasdq,dlasdq);
	LOAD_FLAPACK(handle,lapack.dlasdt,dlasdt);
	LOAD_FLAPACK(handle,lapack.dlaset,dlaset);
	LOAD_FLAPACK(handle,lapack.dlasq1,dlasq1);
	LOAD_FLAPACK(handle,lapack.dlasq2,dlasq2);
	LOAD_FLAPACK(handle,lapack.dlasq3,dlasq3);
	LOAD_FLAPACK(handle,lapack.dlasq4,dlasq4);
	LOAD_FLAPACK(handle,lapack.dlasq5,dlasq5);
	LOAD_FLAPACK(handle,lapack.dlasq6,dlasq6);
	LOAD_FLAPACK(handle,lapack.dlasr,dlasr);
	LOAD_FLAPACK(handle,lapack.dlasrt,dlasrt);
	LOAD_FLAPACK(handle,lapack.dlassq,dlassq);
	LOAD_FLAPACK(handle,lapack.dlasv2,dlasv2);
	LOAD_FLAPACK(handle,lapack.dlaswlq,dlaswlq);
	LOAD_FLAPACK(handle,lapack.dlaswp,dlaswp);
	LOAD_FLAPACK(handle,lapack.dlasy2,dlasy2);
	LOAD_FLAPACK(handle,lapack.dlasyf,dlasyf);
	LOAD_FLAPACK(handle,lapack.dlasyf_aa,dlasyf_aa);
	LOAD_FLAPACK(handle,lapack.dlasyf_rk,dlasyf_rk);
	LOAD_FLAPACK(handle,lapack.dlasyf_rook,dlasyf_rook);
	LOAD_FLAPACK(handle,lapack.dlat2s,dlat2s);
	LOAD_FLAPACK(handle,lapack.dlatbs,dlatbs);
	LOAD_FLAPACK(handle,lapack.dlatdf,dlatdf);
	LOAD_FLAPACK(handle,lapack.dlatps,dlatps);
	LOAD_FLAPACK(handle,lapack.dlatrd,dlatrd);
	LOAD_FLAPACK(handle,lapack.dlatrs,dlatrs);
	LOAD_FLAPACK(handle,lapack.dlatrs3,dlatrs3);
	LOAD_FLAPACK(handle,lapack.dlatrz,dlatrz);
	LOAD_FLAPACK(handle,lapack.dlatsqr,dlatsqr);
	LOAD_FLAPACK(handle,lapack.dlauu2,dlauu2);
	LOAD_FLAPACK(handle,lapack.dlauum,dlauum);
	LOAD_FLAPACK(handle,lapack.dopgtr,dopgtr);
	LOAD_FLAPACK(handle,lapack.dopmtr,dopmtr);
	LOAD_FLAPACK(handle,lapack.dorbdb,dorbdb);
	LOAD_FLAPACK(handle,lapack.dorbdb1,dorbdb1);
	LOAD_FLAPACK(handle,lapack.dorbdb2,dorbdb2);
	LOAD_FLAPACK(handle,lapack.dorbdb3,dorbdb3);
	LOAD_FLAPACK(handle,lapack.dorbdb4,dorbdb4);
	LOAD_FLAPACK(handle,lapack.dorbdb5,dorbdb5);
	LOAD_FLAPACK(handle,lapack.dorbdb6,dorbdb6);
	LOAD_FLAPACK(handle,lapack.dorcsd,dorcsd);
	LOAD_FLAPACK(handle,lapack.dorcsd2by1,dorcsd2by1);
	LOAD_FLAPACK(handle,lapack.dorg2l,dorg2l);
	LOAD_FLAPACK(handle,lapack.dorg2r,dorg2r);
	LOAD_FLAPACK(handle,lapack.dorgbr,dorgbr);
	LOAD_FLAPACK(handle,lapack.dorghr,dorghr);
	LOAD_FLAPACK(handle,lapack.dorgl2,dorgl2);
	LOAD_FLAPACK(handle,lapack.dorglq,dorglq);
	LOAD_FLAPACK(handle,lapack.dorgql,dorgql);
	LOAD_FLAPACK(handle,lapack.dorgqr,dorgqr);
	LOAD_FLAPACK(handle,lapack.dorgr2,dorgr2);
	LOAD_FLAPACK(handle,lapack.dorgrq,dorgrq);
	LOAD_FLAPACK(handle,lapack.dorgtr,dorgtr);
	LOAD_FLAPACK(handle,lapack.dorgtsqr,dorgtsqr);
	LOAD_FLAPACK(handle,lapack.dorgtsqr_row,dorgtsqr_row);
	LOAD_FLAPACK(handle,lapack.dorhr_col,dorhr_col);
	LOAD_FLAPACK(handle,lapack.dorm22,dorm22);
	LOAD_FLAPACK(handle,lapack.dorm2l,dorm2l);
	LOAD_FLAPACK(handle,lapack.dorm2r,dorm2r);
	LOAD_FLAPACK(handle,lapack.dormbr,dormbr);
	LOAD_FLAPACK(handle,lapack.dormhr,dormhr);
	LOAD_FLAPACK(handle,lapack.dorml2,dorml2);
	LOAD_FLAPACK(handle,lapack.dormlq,dormlq);
	LOAD_FLAPACK(handle,lapack.dormql,dormql);
	LOAD_FLAPACK(handle,lapack.dormqr,dormqr);
	LOAD_FLAPACK(handle,lapack.dormr2,dormr2);
	LOAD_FLAPACK(handle,lapack.dormr3,dormr3);
	LOAD_FLAPACK(handle,lapack.dormrq,dormrq);
	LOAD_FLAPACK(handle,lapack.dormrz,dormrz);
	LOAD_FLAPACK(handle,lapack.dormtr,dormtr);
	LOAD_FLAPACK(handle,lapack.dpbcon,dpbcon);
	LOAD_FLAPACK(handle,lapack.dpbequ,dpbequ);
	LOAD_FLAPACK(handle,lapack.dpbrfs,dpbrfs);
	LOAD_FLAPACK(handle,lapack.dpbstf,dpbstf);
	LOAD_FLAPACK(handle,lapack.dpbsv,dpbsv);
	LOAD_FLAPACK(handle,lapack.dpbsvx,dpbsvx);
	LOAD_FLAPACK(handle,lapack.dpbtf2,dpbtf2);
	LOAD_FLAPACK(handle,lapack.dpbtrf,dpbtrf);
	LOAD_FLAPACK(handle,lapack.dpbtrs,dpbtrs);
	LOAD_FLAPACK(handle,lapack.dpftrf,dpftrf);
	LOAD_FLAPACK(handle,lapack.dpftri,dpftri);
	LOAD_FLAPACK(handle,lapack.dpftrs,dpftrs);
	LOAD_FLAPACK(handle,lapack.dpocon,dpocon);
	LOAD_FLAPACK(handle,lapack.dpoequ,dpoequ);
	LOAD_FLAPACK(handle,lapack.dpoequb,dpoequb);
	LOAD_FLAPACK(handle,lapack.dporfs,dporfs);
	LOAD_FLAPACK(handle,lapack.dposv,dposv);
	LOAD_FLAPACK(handle,lapack.dposvx,dposvx);
	LOAD_FLAPACK(handle,lapack.dpotf2,dpotf2);
	LOAD_FLAPACK(handle,lapack.dpotrf,dpotrf);
	LOAD_FLAPACK(handle,lapack.dpotrf2,dpotrf2);
	LOAD_FLAPACK(handle,lapack.dpotri,dpotri);
	LOAD_FLAPACK(handle,lapack.dpotrs,dpotrs);
	LOAD_FLAPACK(handle,lapack.dppcon,dppcon);
	LOAD_FLAPACK(handle,lapack.dppequ,dppequ);
	LOAD_FLAPACK(handle,lapack.dpprfs,dpprfs);
	LOAD_FLAPACK(handle,lapack.dppsv,dppsv);
	LOAD_FLAPACK(handle,lapack.dppsvx,dppsvx);
	LOAD_FLAPACK(handle,lapack.dpptrf,dpptrf);
	LOAD_FLAPACK(handle,lapack.dpptri,dpptri);
	LOAD_FLAPACK(handle,lapack.dpptrs,dpptrs);
	LOAD_FLAPACK(handle,lapack.dpstf2,dpstf2);
	LOAD_FLAPACK(handle,lapack.dpstrf,dpstrf);
	LOAD_FLAPACK(handle,lapack.dptcon,dptcon);
	LOAD_FLAPACK(handle,lapack.dpteqr,dpteqr);
	LOAD_FLAPACK(handle,lapack.dptrfs,dptrfs);
	LOAD_FLAPACK(handle,lapack.dptsv,dptsv);
	LOAD_FLAPACK(handle,lapack.dptsvx,dptsvx);
	LOAD_FLAPACK(handle,lapack.dpttrf,dpttrf);
	LOAD_FLAPACK(handle,lapack.dpttrs,dpttrs);
	LOAD_FLAPACK(handle,lapack.dptts2,dptts2);
	LOAD_FLAPACK(handle,lapack.droundup_lwork,droundup_lwork);
	LOAD_FLAPACK(handle,lapack.drscl,drscl);
	LOAD_FLAPACK(handle,lapack.dsb2st_kernels,dsb2st_kernels);
	LOAD_FLAPACK(handle,lapack.dsbev,dsbev);
	LOAD_FLAPACK(handle,lapack.dsbev_2stage,dsbev_2stage);
	LOAD_FLAPACK(handle,lapack.dsbevd,dsbevd);
	LOAD_FLAPACK(handle,lapack.dsbevd_2stage,dsbevd_2stage);
	LOAD_FLAPACK(handle,lapack.dsbevx,dsbevx);
	LOAD_FLAPACK(handle,lapack.dsbevx_2stage,dsbevx_2stage);
	LOAD_FLAPACK(handle,lapack.dsbgst,dsbgst);
	LOAD_FLAPACK(handle,lapack.dsbgv,dsbgv);
	LOAD_FLAPACK(handle,lapack.dsbgvd,dsbgvd);
	LOAD_FLAPACK(handle,lapack.dsbgvx,dsbgvx);
	LOAD_FLAPACK(handle,lapack.dsbtrd,dsbtrd);
	LOAD_FLAPACK(handle,lapack.dsecnd,dsecnd);
	LOAD_FLAPACK(handle,lapack.dsfrk,dsfrk);
	LOAD_FLAPACK(handle,lapack.dsgesv,dsgesv);
	LOAD_FLAPACK(handle,lapack.dspcon,dspcon);
	LOAD_FLAPACK(handle,lapack.dspev,dspev);
	LOAD_FLAPACK(handle,lapack.dspevd,dspevd);
	LOAD_FLAPACK(handle,lapack.dspevx,dspevx);
	LOAD_FLAPACK(handle,lapack.dspgst,dspgst);
	LOAD_FLAPACK(handle,lapack.dspgv,dspgv);
	LOAD_FLAPACK(handle,lapack.dspgvd,dspgvd);
	LOAD_FLAPACK(handle,lapack.dspgvx,dspgvx);
	LOAD_FLAPACK(handle,lapack.dsposv,dsposv);
	LOAD_FLAPACK(handle,lapack.dsprfs,dsprfs);
	LOAD_FLAPACK(handle,lapack.dspsv,dspsv);
	LOAD_FLAPACK(handle,lapack.dspsvx,dspsvx);
	LOAD_FLAPACK(handle,lapack.dsptrd,dsptrd);
	LOAD_FLAPACK(handle,lapack.dsptrf,dsptrf);
	LOAD_FLAPACK(handle,lapack.dsptri,dsptri);
	LOAD_FLAPACK(handle,lapack.dsptrs,dsptrs);
	LOAD_FLAPACK(handle,lapack.dstebz,dstebz);
	LOAD_FLAPACK(handle,lapack.dstedc,dstedc);
	LOAD_FLAPACK(handle,lapack.dstegr,dstegr);
	LOAD_FLAPACK(handle,lapack.dstein,dstein);
	LOAD_FLAPACK(handle,lapack.dstemr,dstemr);
	LOAD_FLAPACK(handle,lapack.dsteqr,dsteqr);
	LOAD_FLAPACK(handle,lapack.dsterf,dsterf);
	LOAD_FLAPACK(handle,lapack.dstev,dstev);
	LOAD_FLAPACK(handle,lapack.dstevd,dstevd);
	LOAD_FLAPACK(handle,lapack.dstevr,dstevr);
	LOAD_FLAPACK(handle,lapack.dstevx,dstevx);
	LOAD_FLAPACK(handle,lapack.dsycon,dsycon);
	LOAD_FLAPACK(handle,lapack.dsycon_3,dsycon_3);
	LOAD_FLAPACK(handle,lapack.dsycon_rook,dsycon_rook);
	LOAD_FLAPACK(handle,lapack.dsyconv,dsyconv);
	LOAD_FLAPACK(handle,lapack.dsyconvf,dsyconvf);
	LOAD_FLAPACK(handle,lapack.dsyconvf_rook,dsyconvf_rook);
	LOAD_FLAPACK(handle,lapack.dsyequb,dsyequb);
	LOAD_FLAPACK(handle,lapack.dsyev,dsyev);
	LOAD_FLAPACK(handle,lapack.dsyev_2stage,dsyev_2stage);
	LOAD_FLAPACK(handle,lapack.dsyevd,dsyevd);
	LOAD_FLAPACK(handle,lapack.dsyevd_2stage,dsyevd_2stage);
	LOAD_FLAPACK(handle,lapack.dsyevr,dsyevr);
	LOAD_FLAPACK(handle,lapack.dsyevr_2stage,dsyevr_2stage);
	LOAD_FLAPACK(handle,lapack.dsyevx,dsyevx);
	LOAD_FLAPACK(handle,lapack.dsyevx_2stage,dsyevx_2stage);
	LOAD_FLAPACK(handle,lapack.dsygs2,dsygs2);
	LOAD_FLAPACK(handle,lapack.dsygst,dsygst);
	LOAD_FLAPACK(handle,lapack.dsygv,dsygv);
	LOAD_FLAPACK(handle,lapack.dsygv_2stage,dsygv_2stage);
	LOAD_FLAPACK(handle,lapack.dsygvd,dsygvd);
	LOAD_FLAPACK(handle,lapack.dsygvx,dsygvx);
	LOAD_FLAPACK(handle,lapack.dsyrfs,dsyrfs);
	LOAD_FLAPACK(handle,lapack.dsysv,dsysv);
	LOAD_FLAPACK(handle,lapack.dsysv_aa,dsysv_aa);
	LOAD_FLAPACK(handle,lapack.dsysv_aa_2stage,dsysv_aa_2stage);
	LOAD_FLAPACK(handle,lapack.dsysv_rk,dsysv_rk);
	LOAD_FLAPACK(handle,lapack.dsysv_rook,dsysv_rook);
	LOAD_FLAPACK(handle,lapack.dsysvx,dsysvx);
	LOAD_FLAPACK(handle,lapack.dsyswapr,dsyswapr);
	LOAD_FLAPACK(handle,lapack.dsytd2,dsytd2);
	LOAD_FLAPACK(handle,lapack.dsytf2,dsytf2);
	LOAD_FLAPACK(handle,lapack.dsytf2_rk,dsytf2_rk);
	LOAD_FLAPACK(handle,lapack.dsytf2_rook,dsytf2_rook);
	LOAD_FLAPACK(handle,lapack.dsytrd,dsytrd);
	LOAD_FLAPACK(handle,lapack.dsytrd_2stage,dsytrd_2stage);
	LOAD_FLAPACK(handle,lapack.dsytrd_sb2st,dsytrd_sb2st);
	LOAD_FLAPACK(handle,lapack.dsytrd_sy2sb,dsytrd_sy2sb);
	LOAD_FLAPACK(handle,lapack.dsytrf,dsytrf);
	LOAD_FLAPACK(handle,lapack.dsytrf_aa,dsytrf_aa);
	LOAD_FLAPACK(handle,lapack.dsytrf_aa_2stage,dsytrf_aa_2stage);
	LOAD_FLAPACK(handle,lapack.dsytrf_rk,dsytrf_rk);
	LOAD_FLAPACK(handle,lapack.dsytrf_rook,dsytrf_rook);
	LOAD_FLAPACK(handle,lapack.dsytri,dsytri);
	LOAD_FLAPACK(handle,lapack.dsytri2,dsytri2);
	LOAD_FLAPACK(handle,lapack.dsytri2x,dsytri2x);
	LOAD_FLAPACK(handle,lapack.dsytri_3,dsytri_3);
	LOAD_FLAPACK(handle,lapack.dsytri_3x,dsytri_3x);
	LOAD_FLAPACK(handle,lapack.dsytri_rook,dsytri_rook);
	LOAD_FLAPACK(handle,lapack.dsytrs,dsytrs);
	LOAD_FLAPACK(handle,lapack.dsytrs2,dsytrs2);
	LOAD_FLAPACK(handle,lapack.dsytrs_3,dsytrs_3);
	LOAD_FLAPACK(handle,lapack.dsytrs_aa,dsytrs_aa);
	LOAD_FLAPACK(handle,lapack.dsytrs_aa_2stage,dsytrs_aa_2stage);
	LOAD_FLAPACK(handle,lapack.dsytrs_rook,dsytrs_rook);
	LOAD_FLAPACK(handle,lapack.dtbcon,dtbcon);
	LOAD_FLAPACK(handle,lapack.dtbrfs,dtbrfs);
	LOAD_FLAPACK(handle,lapack.dtbtrs,dtbtrs);
	LOAD_FLAPACK(handle,lapack.dtfsm,dtfsm);
	LOAD_FLAPACK(handle,lapack.dtftri,dtftri);
	LOAD_FLAPACK(handle,lapack.dtfttp,dtfttp);
	LOAD_FLAPACK(handle,lapack.dtfttr,dtfttr);
	LOAD_FLAPACK(handle,lapack.dtgevc,dtgevc);
	LOAD_FLAPACK(handle,lapack.dtgex2,dtgex2);
	LOAD_FLAPACK(handle,lapack.dtgexc,dtgexc);
	LOAD_FLAPACK(handle,lapack.dtgsen,dtgsen);
	LOAD_FLAPACK(handle,lapack.dtgsja,dtgsja);
	LOAD_FLAPACK(handle,lapack.dtgsna,dtgsna);
	LOAD_FLAPACK(handle,lapack.dtgsy2,dtgsy2);
	LOAD_FLAPACK(handle,lapack.dtgsyl,dtgsyl);
	LOAD_FLAPACK(handle,lapack.dtpcon,dtpcon);
	LOAD_FLAPACK(handle,lapack.dtplqt,dtplqt);
	LOAD_FLAPACK(handle,lapack.dtplqt2,dtplqt2);
	LOAD_FLAPACK(handle,lapack.dtpmlqt,dtpmlqt);
	LOAD_FLAPACK(handle,lapack.dtpmqrt,dtpmqrt);
	LOAD_FLAPACK(handle,lapack.dtpqrt,dtpqrt);
	LOAD_FLAPACK(handle,lapack.dtpqrt2,dtpqrt2);
	LOAD_FLAPACK(handle,lapack.dtprfb,dtprfb);
	LOAD_FLAPACK(handle,lapack.dtprfs,dtprfs);
	LOAD_FLAPACK(handle,lapack.dtptri,dtptri);
	LOAD_FLAPACK(handle,lapack.dtptrs,dtptrs);
	LOAD_FLAPACK(handle,lapack.dtpttf,dtpttf);
	LOAD_FLAPACK(handle,lapack.dtpttr,dtpttr);
	LOAD_FLAPACK(handle,lapack.dtrcon,dtrcon);
	LOAD_FLAPACK(handle,lapack.dtrevc,dtrevc);
	LOAD_FLAPACK(handle,lapack.dtrevc3,dtrevc3);
	LOAD_FLAPACK(handle,lapack.dtrexc,dtrexc);
	LOAD_FLAPACK(handle,lapack.dtrrfs,dtrrfs);
	LOAD_FLAPACK(handle,lapack.dtrsen,dtrsen);
	LOAD_FLAPACK(handle,lapack.dtrsna,dtrsna);
	LOAD_FLAPACK(handle,lapack.dtrsyl,dtrsyl);
	LOAD_FLAPACK(handle,lapack.dtrsyl3,dtrsyl3);
	LOAD_FLAPACK(handle,lapack.dtrti2,dtrti2);
	LOAD_FLAPACK(handle,lapack.dtrtri,dtrtri);
	LOAD_FLAPACK(handle,lapack.dtrtrs,dtrtrs);
	LOAD_FLAPACK(handle,lapack.dtrttf,dtrttf);
	LOAD_FLAPACK(handle,lapack.dtrttp,dtrttp);
	LOAD_FLAPACK(handle,lapack.dtzrzf,dtzrzf);
	LOAD_FLAPACK(handle,lapack.dzsum1,dzsum1);
	LOAD_FLAPACK(handle,lapack.icmax1,icmax1);
	LOAD_FLAPACK(handle,lapack.ieeeck,ieeeck);
	LOAD_FLAPACK(handle,lapack.ilaclc,ilaclc);
	LOAD_FLAPACK(handle,lapack.ilaclr,ilaclr);
	LOAD_FLAPACK(handle,lapack.iladiag,iladiag);
	LOAD_FLAPACK(handle,lapack.iladlc,iladlc);
	LOAD_FLAPACK(handle,lapack.iladlr,iladlr);
	LOAD_FLAPACK(handle,lapack.ilaenv,ilaenv);
	LOAD_FLAPACK(handle,lapack.ilaenv2stage,ilaenv2stage);
	LOAD_FLAPACK(handle,lapack.ilaprec,ilaprec);
	LOAD_FLAPACK(handle,lapack.ilaslc,ilaslc);
	LOAD_FLAPACK(handle,lapack.ilaslr,ilaslr);
	LOAD_FLAPACK(handle,lapack.ilatrans,ilatrans);
	LOAD_FLAPACK(handle,lapack.ilauplo,ilauplo);
	LOAD_FLAPACK(handle,lapack.ilazlc,ilazlc);
	LOAD_FLAPACK(handle,lapack.ilazlr,ilazlr);
	LOAD_FLAPACK(handle,lapack.iparam2stage,iparam2stage);
	LOAD_FLAPACK(handle,lapack.iparmq,iparmq);
	LOAD_FLAPACK(handle,lapack.izmax1,izmax1);
	LOAD_FLAPACK(handle,lapack.sbbcsd,sbbcsd);
	LOAD_FLAPACK(handle,lapack.sbdsdc,sbdsdc);
	LOAD_FLAPACK(handle,lapack.sbdsqr,sbdsqr);
	LOAD_FLAPACK(handle,lapack.sbdsvdx,sbdsvdx);
	LOAD_FLAPACK(handle,lapack.scsum1,scsum1);
	LOAD_FLAPACK(handle,lapack.sdisna,sdisna);
	LOAD_FLAPACK(handle,lapack.second,second);
	LOAD_FLAPACK(handle,lapack.sgbbrd,sgbbrd);
	LOAD_FLAPACK(handle,lapack.sgbcon,sgbcon);
	LOAD_FLAPACK(handle,lapack.sgbequ,sgbequ);
	LOAD_FLAPACK(handle,lapack.sgbequb,sgbequb);
	LOAD_FLAPACK(handle,lapack.sgbrfs,sgbrfs);
	LOAD_FLAPACK(handle,lapack.sgbsv,sgbsv);
	LOAD_FLAPACK(handle,lapack.sgbsvx,sgbsvx);
	LOAD_FLAPACK(handle,lapack.sgbtf2,sgbtf2);
	LOAD_FLAPACK(handle,lapack.sgbtrf,sgbtrf);
	LOAD_FLAPACK(handle,lapack.sgbtrs,sgbtrs);
	LOAD_FLAPACK(handle,lapack.sgebak,sgebak);
	LOAD_FLAPACK(handle,lapack.sgebal,sgebal);
	LOAD_FLAPACK(handle,lapack.sgebd2,sgebd2);
	LOAD_FLAPACK(handle,lapack.sgebrd,sgebrd);
	LOAD_FLAPACK(handle,lapack.sgecon,sgecon);
	LOAD_FLAPACK(handle,lapack.sgeequ,sgeequ);
	LOAD_FLAPACK(handle,lapack.sgeequb,sgeequb);
	LOAD_FLAPACK(handle,lapack.sgees,sgees);
	LOAD_FLAPACK(handle,lapack.sgeesx,sgeesx);
	LOAD_FLAPACK(handle,lapack.sgeev,sgeev);
	LOAD_FLAPACK(handle,lapack.sgeevx,sgeevx);
	LOAD_FLAPACK(handle,lapack.sgehd2,sgehd2);
	LOAD_FLAPACK(handle,lapack.sgehrd,sgehrd);
	LOAD_FLAPACK(handle,lapack.sgejsv,sgejsv);
	LOAD_FLAPACK(handle,lapack.sgelq,sgelq);
	LOAD_FLAPACK(handle,lapack.sgelq2,sgelq2);
	LOAD_FLAPACK(handle,lapack.sgelqf,sgelqf);
	LOAD_FLAPACK(handle,lapack.sgelqt,sgelqt);
	LOAD_FLAPACK(handle,lapack.sgelqt3,sgelqt3);
	LOAD_FLAPACK(handle,lapack.sgels,sgels);
	LOAD_FLAPACK(handle,lapack.sgelsd,sgelsd);
	LOAD_FLAPACK(handle,lapack.sgelss,sgelss);
	LOAD_FLAPACK(handle,lapack.sgelst,sgelst);
	LOAD_FLAPACK(handle,lapack.sgelsy,sgelsy);
	LOAD_FLAPACK(handle,lapack.sgemlq,sgemlq);
	LOAD_FLAPACK(handle,lapack.sgemlqt,sgemlqt);
	LOAD_FLAPACK(handle,lapack.sgemqr,sgemqr);
	LOAD_FLAPACK(handle,lapack.sgemqrt,sgemqrt);
	LOAD_FLAPACK(handle,lapack.sgeql2,sgeql2);
	LOAD_FLAPACK(handle,lapack.sgeqlf,sgeqlf);
	LOAD_FLAPACK(handle,lapack.sgeqp3,sgeqp3);
	LOAD_FLAPACK(handle,lapack.sgeqr,sgeqr);
	LOAD_FLAPACK(handle,lapack.sgeqr2,sgeqr2);
	LOAD_FLAPACK(handle,lapack.sgeqr2p,sgeqr2p);
	LOAD_FLAPACK(handle,lapack.sgeqrf,sgeqrf);
	LOAD_FLAPACK(handle,lapack.sgeqrfp,sgeqrfp);
	LOAD_FLAPACK(handle,lapack.sgeqrt,sgeqrt);
	LOAD_FLAPACK(handle,lapack.sgeqrt2,sgeqrt2);
	LOAD_FLAPACK(handle,lapack.sgeqrt3,sgeqrt3);
	LOAD_FLAPACK(handle,lapack.sgerfs,sgerfs);
	LOAD_FLAPACK(handle,lapack.sgerq2,sgerq2);
	LOAD_FLAPACK(handle,lapack.sgerqf,sgerqf);
	LOAD_FLAPACK(handle,lapack.sgesc2,sgesc2);
	LOAD_FLAPACK(handle,lapack.sgesdd,sgesdd);
	LOAD_FLAPACK(handle,lapack.sgesv,sgesv);
	LOAD_FLAPACK(handle,lapack.sgesvd,sgesvd);
	LOAD_FLAPACK(handle,lapack.sgesvdq,sgesvdq);
	LOAD_FLAPACK(handle,lapack.sgesvdx,sgesvdx);
	LOAD_FLAPACK(handle,lapack.sgesvj,sgesvj);
	LOAD_FLAPACK(handle,lapack.sgesvx,sgesvx);
	LOAD_FLAPACK(handle,lapack.sgetc2,sgetc2);
	LOAD_FLAPACK(handle,lapack.sgetf2,sgetf2);
	LOAD_FLAPACK(handle,lapack.sgetrf,sgetrf);
	LOAD_FLAPACK(handle,lapack.sgetrf2,sgetrf2);
	LOAD_FLAPACK(handle,lapack.sgetri,sgetri);
	LOAD_FLAPACK(handle,lapack.sgetrs,sgetrs);
	LOAD_FLAPACK(handle,lapack.sgetsls,sgetsls);
	LOAD_FLAPACK(handle,lapack.sgetsqrhrt,sgetsqrhrt);
	LOAD_FLAPACK(handle,lapack.sggbak,sggbak);
	LOAD_FLAPACK(handle,lapack.sggbal,sggbal);
	LOAD_FLAPACK(handle,lapack.sgges,sgges);
	LOAD_FLAPACK(handle,lapack.sgges3,sgges3);
	LOAD_FLAPACK(handle,lapack.sggesx,sggesx);
	LOAD_FLAPACK(handle,lapack.sggev,sggev);
	LOAD_FLAPACK(handle,lapack.sggev3,sggev3);
	LOAD_FLAPACK(handle,lapack.sggevx,sggevx);
	LOAD_FLAPACK(handle,lapack.sggglm,sggglm);
	LOAD_FLAPACK(handle,lapack.sgghd3,sgghd3);
	LOAD_FLAPACK(handle,lapack.sgghrd,sgghrd);
	LOAD_FLAPACK(handle,lapack.sgglse,sgglse);
	LOAD_FLAPACK(handle,lapack.sggqrf,sggqrf);
	LOAD_FLAPACK(handle,lapack.sggrqf,sggrqf);
	LOAD_FLAPACK(handle,lapack.sggsvd3,sggsvd3);
	LOAD_FLAPACK(handle,lapack.sggsvp3,sggsvp3);
	LOAD_FLAPACK(handle,lapack.sgsvj0,sgsvj0);
	LOAD_FLAPACK(handle,lapack.sgsvj1,sgsvj1);
	LOAD_FLAPACK(handle,lapack.sgtcon,sgtcon);
	LOAD_FLAPACK(handle,lapack.sgtrfs,sgtrfs);
	LOAD_FLAPACK(handle,lapack.sgtsv,sgtsv);
	LOAD_FLAPACK(handle,lapack.sgtsvx,sgtsvx);
	LOAD_FLAPACK(handle,lapack.sgttrf,sgttrf);
	LOAD_FLAPACK(handle,lapack.sgttrs,sgttrs);
	LOAD_FLAPACK(handle,lapack.sgtts2,sgtts2);
	LOAD_FLAPACK(handle,lapack.shgeqz,shgeqz);
	LOAD_FLAPACK(handle,lapack.shsein,shsein);
	LOAD_FLAPACK(handle,lapack.shseqr,shseqr);
	LOAD_FLAPACK(handle,lapack.sisnan,sisnan);
	LOAD_FLAPACK(handle,lapack.slabad,slabad);
	LOAD_FLAPACK(handle,lapack.slabrd,slabrd);
	LOAD_FLAPACK(handle,lapack.slacn2,slacn2);
	LOAD_FLAPACK(handle,lapack.slacon,slacon);
	LOAD_FLAPACK(handle,lapack.slacpy,slacpy);
	LOAD_FLAPACK(handle,lapack.sladiv,sladiv);
	LOAD_FLAPACK(handle,lapack.sladiv1,sladiv1);
	LOAD_FLAPACK(handle,lapack.sladiv2,sladiv2);
	LOAD_FLAPACK(handle,lapack.slae2,slae2);
	LOAD_FLAPACK(handle,lapack.slaebz,slaebz);
	LOAD_FLAPACK(handle,lapack.slaed0,slaed0);
	LOAD_FLAPACK(handle,lapack.slaed1,slaed1);
	LOAD_FLAPACK(handle,lapack.slaed2,slaed2);
	LOAD_FLAPACK(handle,lapack.slaed3,slaed3);
	LOAD_FLAPACK(handle,lapack.slaed4,slaed4);
	LOAD_FLAPACK(handle,lapack.slaed5,slaed5);
	LOAD_FLAPACK(handle,lapack.slaed6,slaed6);
	LOAD_FLAPACK(handle,lapack.slaed7,slaed7);
	LOAD_FLAPACK(handle,lapack.slaed8,slaed8);
	LOAD_FLAPACK(handle,lapack.slaed9,slaed9);
	LOAD_FLAPACK(handle,lapack.slaeda,slaeda);
	LOAD_FLAPACK(handle,lapack.slaein,slaein);
	LOAD_FLAPACK(handle,lapack.slaev2,slaev2);
	LOAD_FLAPACK(handle,lapack.slaexc,slaexc);
	LOAD_FLAPACK(handle,lapack.slag2,slag2);
	LOAD_FLAPACK(handle,lapack.slag2d,slag2d);
	LOAD_FLAPACK(handle,lapack.slags2,slags2);
	LOAD_FLAPACK(handle,lapack.slagtf,slagtf);
	LOAD_FLAPACK(handle,lapack.slagtm,slagtm);
	LOAD_FLAPACK(handle,lapack.slagts,slagts);
	LOAD_FLAPACK(handle,lapack.slagv2,slagv2);
	LOAD_FLAPACK(handle,lapack.slahqr,slahqr);
	LOAD_FLAPACK(handle,lapack.slahr2,slahr2);
	LOAD_FLAPACK(handle,lapack.slaic1,slaic1);
	LOAD_FLAPACK(handle,lapack.slaisnan,slaisnan);
	LOAD_FLAPACK(handle,lapack.slaln2,slaln2);
	LOAD_FLAPACK(handle,lapack.slals0,slals0);
	LOAD_FLAPACK(handle,lapack.slalsa,slalsa);
	LOAD_FLAPACK(handle,lapack.slalsd,slalsd);
	LOAD_FLAPACK(handle,lapack.slamc3,slamc3);
	LOAD_FLAPACK(handle,lapack.slamch,slamch);
	LOAD_FLAPACK(handle,lapack.slamrg,slamrg);
	LOAD_FLAPACK(handle,lapack.slamswlq,slamswlq);
	LOAD_FLAPACK(handle,lapack.slamtsqr,slamtsqr);
	LOAD_FLAPACK(handle,lapack.slaneg,slaneg);
	LOAD_FLAPACK(handle,lapack.slangb,slangb);
	LOAD_FLAPACK(handle,lapack.slange,slange);
	LOAD_FLAPACK(handle,lapack.slangt,slangt);
	LOAD_FLAPACK(handle,lapack.slanhs,slanhs);
	LOAD_FLAPACK(handle,lapack.slansb,slansb);
	LOAD_FLAPACK(handle,lapack.slansf,slansf);
	LOAD_FLAPACK(handle,lapack.slansp,slansp);
	LOAD_FLAPACK(handle,lapack.slanst,slanst);
	LOAD_FLAPACK(handle,lapack.slansy,slansy);
	LOAD_FLAPACK(handle,lapack.slantb,slantb);
	LOAD_FLAPACK(handle,lapack.slantp,slantp);
	LOAD_FLAPACK(handle,lapack.slantr,slantr);
	LOAD_FLAPACK(handle,lapack.slanv2,slanv2);
	LOAD_FLAPACK(handle,lapack.slaorhr_col_getrfnp,slaorhr_col_getrfnp);
	LOAD_FLAPACK(handle,lapack.slaorhr_col_getrfnp2,slaorhr_col_getrfnp2);
	LOAD_FLAPACK(handle,lapack.slapll,slapll);
	LOAD_FLAPACK(handle,lapack.slapmr,slapmr);
	LOAD_FLAPACK(handle,lapack.slapmt,slapmt);
	LOAD_FLAPACK(handle,lapack.slapy2,slapy2);
	LOAD_FLAPACK(handle,lapack.slapy3,slapy3);
	LOAD_FLAPACK(handle,lapack.slaqgb,slaqgb);
	LOAD_FLAPACK(handle,lapack.slaqge,slaqge);
	LOAD_FLAPACK(handle,lapack.slaqp2,slaqp2);
	LOAD_FLAPACK(handle,lapack.slaqps,slaqps);
	LOAD_FLAPACK(handle,lapack.slaqr0,slaqr0);
	LOAD_FLAPACK(handle,lapack.slaqr1,slaqr1);
	LOAD_FLAPACK(handle,lapack.slaqr2,slaqr2);
	LOAD_FLAPACK(handle,lapack.slaqr3,slaqr3);
	LOAD_FLAPACK(handle,lapack.slaqr4,slaqr4);
	LOAD_FLAPACK(handle,lapack.slaqr5,slaqr5);
	LOAD_FLAPACK(handle,lapack.slaqsb,slaqsb);
	LOAD_FLAPACK(handle,lapack.slaqsp,slaqsp);
	LOAD_FLAPACK(handle,lapack.slaqsy,slaqsy);
	LOAD_FLAPACK(handle,lapack.slaqtr,slaqtr);
	LOAD_FLAPACK(handle,lapack.slaqz0,slaqz0);
	LOAD_FLAPACK(handle,lapack.slaqz1,slaqz1);
	LOAD_FLAPACK(handle,lapack.slaqz2,slaqz2);
	LOAD_FLAPACK(handle,lapack.slaqz3,slaqz3);
	LOAD_FLAPACK(handle,lapack.slaqz4,slaqz4);
	LOAD_FLAPACK(handle,lapack.slar1v,slar1v);
	LOAD_FLAPACK(handle,lapack.slar2v,slar2v);
	LOAD_FLAPACK(handle,lapack.slarf,slarf);
	LOAD_FLAPACK(handle,lapack.slarfb,slarfb);
	LOAD_FLAPACK(handle,lapack.slarfb_gett,slarfb_gett);
	LOAD_FLAPACK(handle,lapack.slarfg,slarfg);
	LOAD_FLAPACK(handle,lapack.slarfgp,slarfgp);
	LOAD_FLAPACK(handle,lapack.slarft,slarft);
	LOAD_FLAPACK(handle,lapack.slarfx,slarfx);
	LOAD_FLAPACK(handle,lapack.slarfy,slarfy);
	LOAD_FLAPACK(handle,lapack.slargv,slargv);
	LOAD_FLAPACK(handle,lapack.slarmm,slarmm);
	LOAD_FLAPACK(handle,lapack.slarnv,slarnv);
	LOAD_FLAPACK(handle,lapack.slarra,slarra);
	LOAD_FLAPACK(handle,lapack.slarrb,slarrb);
	LOAD_FLAPACK(handle,lapack.slarrc,slarrc);
	LOAD_FLAPACK(handle,lapack.slarrd,slarrd);
	LOAD_FLAPACK(handle,lapack.slarre,slarre);
	LOAD_FLAPACK(handle,lapack.slarrf,slarrf);
	LOAD_FLAPACK(handle,lapack.slarrj,slarrj);
	LOAD_FLAPACK(handle,lapack.slarrk,slarrk);
	LOAD_FLAPACK(handle,lapack.slarrr,slarrr);
	LOAD_FLAPACK(handle,lapack.slarrv,slarrv);
	LOAD_FLAPACK(handle,lapack.slartg,slartg);
	LOAD_FLAPACK(handle,lapack.slartgp,slartgp);
	LOAD_FLAPACK(handle,lapack.slartgs,slartgs);
	LOAD_FLAPACK(handle,lapack.slartv,slartv);
	LOAD_FLAPACK(handle,lapack.slaruv,slaruv);
	LOAD_FLAPACK(handle,lapack.slarz,slarz);
	LOAD_FLAPACK(handle,lapack.slarzb,slarzb);
	LOAD_FLAPACK(handle,lapack.slarzt,slarzt);
	LOAD_FLAPACK(handle,lapack.slas2,slas2);
	LOAD_FLAPACK(handle,lapack.slascl,slascl);
	LOAD_FLAPACK(handle,lapack.slasd0,slasd0);
	LOAD_FLAPACK(handle,lapack.slasd1,slasd1);
	LOAD_FLAPACK(handle,lapack.slasd2,slasd2);
	LOAD_FLAPACK(handle,lapack.slasd3,slasd3);
	LOAD_FLAPACK(handle,lapack.slasd4,slasd4);
	LOAD_FLAPACK(handle,lapack.slasd5,slasd5);
	LOAD_FLAPACK(handle,lapack.slasd6,slasd6);
	LOAD_FLAPACK(handle,lapack.slasd7,slasd7);
	LOAD_FLAPACK(handle,lapack.slasd8,slasd8);
	LOAD_FLAPACK(handle,lapack.slasda,slasda);
	LOAD_FLAPACK(handle,lapack.slasdq,slasdq);
	LOAD_FLAPACK(handle,lapack.slasdt,slasdt);
	LOAD_FLAPACK(handle,lapack.slaset,slaset);
	LOAD_FLAPACK(handle,lapack.slasq1,slasq1);
	LOAD_FLAPACK(handle,lapack.slasq2,slasq2);
	LOAD_FLAPACK(handle,lapack.slasq3,slasq3);
	LOAD_FLAPACK(handle,lapack.slasq4,slasq4);
	LOAD_FLAPACK(handle,lapack.slasq5,slasq5);
	LOAD_FLAPACK(handle,lapack.slasq6,slasq6);
	LOAD_FLAPACK(handle,lapack.slasr,slasr);
	LOAD_FLAPACK(handle,lapack.slasrt,slasrt);
	LOAD_FLAPACK(handle,lapack.slassq,slassq);
	LOAD_FLAPACK(handle,lapack.slasv2,slasv2);
	LOAD_FLAPACK(handle,lapack.slaswlq,slaswlq);
	LOAD_FLAPACK(handle,lapack.slaswp,slaswp);
	LOAD_FLAPACK(handle,lapack.slasy2,slasy2);
	LOAD_FLAPACK(handle,lapack.slasyf,slasyf);
	LOAD_FLAPACK(handle,lapack.slasyf_aa,slasyf_aa);
	LOAD_FLAPACK(handle,lapack.slasyf_rk,slasyf_rk);
	LOAD_FLAPACK(handle,lapack.slasyf_rook,slasyf_rook);
	LOAD_FLAPACK(handle,lapack.slatbs,slatbs);
	LOAD_FLAPACK(handle,lapack.slatdf,slatdf);
	LOAD_FLAPACK(handle,lapack.slatps,slatps);
	LOAD_FLAPACK(handle,lapack.slatrd,slatrd);
	LOAD_FLAPACK(handle,lapack.slatrs,slatrs);
	LOAD_FLAPACK(handle,lapack.slatrs3,slatrs3);
	LOAD_FLAPACK(handle,lapack.slatrz,slatrz);
	LOAD_FLAPACK(handle,lapack.slatsqr,slatsqr);
	LOAD_FLAPACK(handle,lapack.slauu2,slauu2);
	LOAD_FLAPACK(handle,lapack.slauum,slauum);
	LOAD_FLAPACK(handle,lapack.sopgtr,sopgtr);
	LOAD_FLAPACK(handle,lapack.sopmtr,sopmtr);
	LOAD_FLAPACK(handle,lapack.sorbdb,sorbdb);
	LOAD_FLAPACK(handle,lapack.sorbdb1,sorbdb1);
	LOAD_FLAPACK(handle,lapack.sorbdb2,sorbdb2);
	LOAD_FLAPACK(handle,lapack.sorbdb3,sorbdb3);
	LOAD_FLAPACK(handle,lapack.sorbdb4,sorbdb4);
	LOAD_FLAPACK(handle,lapack.sorbdb5,sorbdb5);
	LOAD_FLAPACK(handle,lapack.sorbdb6,sorbdb6);
	LOAD_FLAPACK(handle,lapack.sorcsd,sorcsd);
	LOAD_FLAPACK(handle,lapack.sorcsd2by1,sorcsd2by1);
	LOAD_FLAPACK(handle,lapack.sorg2l,sorg2l);
	LOAD_FLAPACK(handle,lapack.sorg2r,sorg2r);
	LOAD_FLAPACK(handle,lapack.sorgbr,sorgbr);
	LOAD_FLAPACK(handle,lapack.sorghr,sorghr);
	LOAD_FLAPACK(handle,lapack.sorgl2,sorgl2);
	LOAD_FLAPACK(handle,lapack.sorglq,sorglq);
	LOAD_FLAPACK(handle,lapack.sorgql,sorgql);
	LOAD_FLAPACK(handle,lapack.sorgqr,sorgqr);
	LOAD_FLAPACK(handle,lapack.sorgr2,sorgr2);
	LOAD_FLAPACK(handle,lapack.sorgrq,sorgrq);
	LOAD_FLAPACK(handle,lapack.sorgtr,sorgtr);
	LOAD_FLAPACK(handle,lapack.sorgtsqr,sorgtsqr);
	LOAD_FLAPACK(handle,lapack.sorgtsqr_row,sorgtsqr_row);
	LOAD_FLAPACK(handle,lapack.sorhr_col,sorhr_col);
	LOAD_FLAPACK(handle,lapack.sorm22,sorm22);
	LOAD_FLAPACK(handle,lapack.sorm2l,sorm2l);
	LOAD_FLAPACK(handle,lapack.sorm2r,sorm2r);
	LOAD_FLAPACK(handle,lapack.sormbr,sormbr);
	LOAD_FLAPACK(handle,lapack.sormhr,sormhr);
	LOAD_FLAPACK(handle,lapack.sorml2,sorml2);
	LOAD_FLAPACK(handle,lapack.sormlq,sormlq);
	LOAD_FLAPACK(handle,lapack.sormql,sormql);
	LOAD_FLAPACK(handle,lapack.sormqr,sormqr);
	LOAD_FLAPACK(handle,lapack.sormr2,sormr2);
	LOAD_FLAPACK(handle,lapack.sormr3,sormr3);
	LOAD_FLAPACK(handle,lapack.sormrq,sormrq);
	LOAD_FLAPACK(handle,lapack.sormrz,sormrz);
	LOAD_FLAPACK(handle,lapack.sormtr,sormtr);
	LOAD_FLAPACK(handle,lapack.spbcon,spbcon);
	LOAD_FLAPACK(handle,lapack.spbequ,spbequ);
	LOAD_FLAPACK(handle,lapack.spbrfs,spbrfs);
	LOAD_FLAPACK(handle,lapack.spbstf,spbstf);
	LOAD_FLAPACK(handle,lapack.spbsv,spbsv);
	LOAD_FLAPACK(handle,lapack.spbsvx,spbsvx);
	LOAD_FLAPACK(handle,lapack.spbtf2,spbtf2);
	LOAD_FLAPACK(handle,lapack.spbtrf,spbtrf);
	LOAD_FLAPACK(handle,lapack.spbtrs,spbtrs);
	LOAD_FLAPACK(handle,lapack.spftrf,spftrf);
	LOAD_FLAPACK(handle,lapack.spftri,spftri);
	LOAD_FLAPACK(handle,lapack.spftrs,spftrs);
	LOAD_FLAPACK(handle,lapack.spocon,spocon);
	LOAD_FLAPACK(handle,lapack.spoequ,spoequ);
	LOAD_FLAPACK(handle,lapack.spoequb,spoequb);
	LOAD_FLAPACK(handle,lapack.sporfs,sporfs);
	LOAD_FLAPACK(handle,lapack.sposv,sposv);
	LOAD_FLAPACK(handle,lapack.sposvx,sposvx);
	LOAD_FLAPACK(handle,lapack.spotf2,spotf2);
	LOAD_FLAPACK(handle,lapack.spotrf,spotrf);
	LOAD_FLAPACK(handle,lapack.spotrf2,spotrf2);
	LOAD_FLAPACK(handle,lapack.spotri,spotri);
	LOAD_FLAPACK(handle,lapack.spotrs,spotrs);
	LOAD_FLAPACK(handle,lapack.sppcon,sppcon);
	LOAD_FLAPACK(handle,lapack.sppequ,sppequ);
	LOAD_FLAPACK(handle,lapack.spprfs,spprfs);
	LOAD_FLAPACK(handle,lapack.sppsv,sppsv);
	LOAD_FLAPACK(handle,lapack.sppsvx,sppsvx);
	LOAD_FLAPACK(handle,lapack.spptrf,spptrf);
	LOAD_FLAPACK(handle,lapack.spptri,spptri);
	LOAD_FLAPACK(handle,lapack.spptrs,spptrs);
	LOAD_FLAPACK(handle,lapack.spstf2,spstf2);
	LOAD_FLAPACK(handle,lapack.spstrf,spstrf);
	LOAD_FLAPACK(handle,lapack.sptcon,sptcon);
	LOAD_FLAPACK(handle,lapack.spteqr,spteqr);
	LOAD_FLAPACK(handle,lapack.sptrfs,sptrfs);
	LOAD_FLAPACK(handle,lapack.sptsv,sptsv);
	LOAD_FLAPACK(handle,lapack.sptsvx,sptsvx);
	LOAD_FLAPACK(handle,lapack.spttrf,spttrf);
	LOAD_FLAPACK(handle,lapack.spttrs,spttrs);
	LOAD_FLAPACK(handle,lapack.sptts2,sptts2);
	LOAD_FLAPACK(handle,lapack.sroundup_lwork,sroundup_lwork);
	LOAD_FLAPACK(handle,lapack.srscl,srscl);
	LOAD_FLAPACK(handle,lapack.ssb2st_kernels,ssb2st_kernels);
	LOAD_FLAPACK(handle,lapack.ssbev,ssbev);
	LOAD_FLAPACK(handle,lapack.ssbev_2stage,ssbev_2stage);
	LOAD_FLAPACK(handle,lapack.ssbevd,ssbevd);
	LOAD_FLAPACK(handle,lapack.ssbevd_2stage,ssbevd_2stage);
	LOAD_FLAPACK(handle,lapack.ssbevx,ssbevx);
	LOAD_FLAPACK(handle,lapack.ssbevx_2stage,ssbevx_2stage);
	LOAD_FLAPACK(handle,lapack.ssbgst,ssbgst);
	LOAD_FLAPACK(handle,lapack.ssbgv,ssbgv);
	LOAD_FLAPACK(handle,lapack.ssbgvd,ssbgvd);
	LOAD_FLAPACK(handle,lapack.ssbgvx,ssbgvx);
	LOAD_FLAPACK(handle,lapack.ssbtrd,ssbtrd);
	LOAD_FLAPACK(handle,lapack.ssfrk,ssfrk);
	LOAD_FLAPACK(handle,lapack.sspcon,sspcon);
	LOAD_FLAPACK(handle,lapack.sspev,sspev);
	LOAD_FLAPACK(handle,lapack.sspevd,sspevd);
	LOAD_FLAPACK(handle,lapack.sspevx,sspevx);
	LOAD_FLAPACK(handle,lapack.sspgst,sspgst);
	LOAD_FLAPACK(handle,lapack.sspgv,sspgv);
	LOAD_FLAPACK(handle,lapack.sspgvd,sspgvd);
	LOAD_FLAPACK(handle,lapack.sspgvx,sspgvx);
	LOAD_FLAPACK(handle,lapack.ssprfs,ssprfs);
	LOAD_FLAPACK(handle,lapack.sspsv,sspsv);
	LOAD_FLAPACK(handle,lapack.sspsvx,sspsvx);
	LOAD_FLAPACK(handle,lapack.ssptrd,ssptrd);
	LOAD_FLAPACK(handle,lapack.ssptrf,ssptrf);
	LOAD_FLAPACK(handle,lapack.ssptri,ssptri);
	LOAD_FLAPACK(handle,lapack.ssptrs,ssptrs);
	LOAD_FLAPACK(handle,lapack.sstebz,sstebz);
	LOAD_FLAPACK(handle,lapack.sstedc,sstedc);
	LOAD_FLAPACK(handle,lapack.sstegr,sstegr);
	LOAD_FLAPACK(handle,lapack.sstein,sstein);
	LOAD_FLAPACK(handle,lapack.sstemr,sstemr);
	LOAD_FLAPACK(handle,lapack.ssteqr,ssteqr);
	LOAD_FLAPACK(handle,lapack.ssterf,ssterf);
	LOAD_FLAPACK(handle,lapack.sstev,sstev);
	LOAD_FLAPACK(handle,lapack.sstevd,sstevd);
	LOAD_FLAPACK(handle,lapack.sstevr,sstevr);
	LOAD_FLAPACK(handle,lapack.sstevx,sstevx);
	LOAD_FLAPACK(handle,lapack.ssycon,ssycon);
	LOAD_FLAPACK(handle,lapack.ssycon_3,ssycon_3);
	LOAD_FLAPACK(handle,lapack.ssycon_rook,ssycon_rook);
	LOAD_FLAPACK(handle,lapack.ssyconv,ssyconv);
	LOAD_FLAPACK(handle,lapack.ssyconvf,ssyconvf);
	LOAD_FLAPACK(handle,lapack.ssyconvf_rook,ssyconvf_rook);
	LOAD_FLAPACK(handle,lapack.ssyequb,ssyequb);
	LOAD_FLAPACK(handle,lapack.ssyev,ssyev);
	LOAD_FLAPACK(handle,lapack.ssyev_2stage,ssyev_2stage);
	LOAD_FLAPACK(handle,lapack.ssyevd,ssyevd);
	LOAD_FLAPACK(handle,lapack.ssyevd_2stage,ssyevd_2stage);
	LOAD_FLAPACK(handle,lapack.ssyevr,ssyevr);
	LOAD_FLAPACK(handle,lapack.ssyevr_2stage,ssyevr_2stage);
	LOAD_FLAPACK(handle,lapack.ssyevx,ssyevx);
	LOAD_FLAPACK(handle,lapack.ssyevx_2stage,ssyevx_2stage);
	LOAD_FLAPACK(handle,lapack.ssygs2,ssygs2);
	LOAD_FLAPACK(handle,lapack.ssygst,ssygst);
	LOAD_FLAPACK(handle,lapack.ssygv,ssygv);
	LOAD_FLAPACK(handle,lapack.ssygv_2stage,ssygv_2stage);
	LOAD_FLAPACK(handle,lapack.ssygvd,ssygvd);
	LOAD_FLAPACK(handle,lapack.ssygvx,ssygvx);
	LOAD_FLAPACK(handle,lapack.ssyrfs,ssyrfs);
	LOAD_FLAPACK(handle,lapack.ssysv,ssysv);
	LOAD_FLAPACK(handle,lapack.ssysv_aa,ssysv_aa);
	LOAD_FLAPACK(handle,lapack.ssysv_aa_2stage,ssysv_aa_2stage);
	LOAD_FLAPACK(handle,lapack.ssysv_rk,ssysv_rk);
	LOAD_FLAPACK(handle,lapack.ssysv_rook,ssysv_rook);
	LOAD_FLAPACK(handle,lapack.ssysvx,ssysvx);
	LOAD_FLAPACK(handle,lapack.ssyswapr,ssyswapr);
	LOAD_FLAPACK(handle,lapack.ssytd2,ssytd2);
	LOAD_FLAPACK(handle,lapack.ssytf2,ssytf2);
	LOAD_FLAPACK(handle,lapack.ssytf2_rk,ssytf2_rk);
	LOAD_FLAPACK(handle,lapack.ssytf2_rook,ssytf2_rook);
	LOAD_FLAPACK(handle,lapack.ssytrd,ssytrd);
	LOAD_FLAPACK(handle,lapack.ssytrd_2stage,ssytrd_2stage);
	LOAD_FLAPACK(handle,lapack.ssytrd_sb2st,ssytrd_sb2st);
	LOAD_FLAPACK(handle,lapack.ssytrd_sy2sb,ssytrd_sy2sb);
	LOAD_FLAPACK(handle,lapack.ssytrf,ssytrf);
	LOAD_FLAPACK(handle,lapack.ssytrf_aa,ssytrf_aa);
	LOAD_FLAPACK(handle,lapack.ssytrf_aa_2stage,ssytrf_aa_2stage);
	LOAD_FLAPACK(handle,lapack.ssytrf_rk,ssytrf_rk);
	LOAD_FLAPACK(handle,lapack.ssytrf_rook,ssytrf_rook);
	LOAD_FLAPACK(handle,lapack.ssytri,ssytri);
	LOAD_FLAPACK(handle,lapack.ssytri2,ssytri2);
	LOAD_FLAPACK(handle,lapack.ssytri2x,ssytri2x);
	LOAD_FLAPACK(handle,lapack.ssytri_3,ssytri_3);
	LOAD_FLAPACK(handle,lapack.ssytri_3x,ssytri_3x);
	LOAD_FLAPACK(handle,lapack.ssytri_rook,ssytri_rook);
	LOAD_FLAPACK(handle,lapack.ssytrs,ssytrs);
	LOAD_FLAPACK(handle,lapack.ssytrs2,ssytrs2);
	LOAD_FLAPACK(handle,lapack.ssytrs_3,ssytrs_3);
	LOAD_FLAPACK(handle,lapack.ssytrs_aa,ssytrs_aa);
	LOAD_FLAPACK(handle,lapack.ssytrs_aa_2stage,ssytrs_aa_2stage);
	LOAD_FLAPACK(handle,lapack.ssytrs_rook,ssytrs_rook);
	LOAD_FLAPACK(handle,lapack.stbcon,stbcon);
	LOAD_FLAPACK(handle,lapack.stbrfs,stbrfs);
	LOAD_FLAPACK(handle,lapack.stbtrs,stbtrs);
	LOAD_FLAPACK(handle,lapack.stfsm,stfsm);
	LOAD_FLAPACK(handle,lapack.stftri,stftri);
	LOAD_FLAPACK(handle,lapack.stfttp,stfttp);
	LOAD_FLAPACK(handle,lapack.stfttr,stfttr);
	LOAD_FLAPACK(handle,lapack.stgevc,stgevc);
	LOAD_FLAPACK(handle,lapack.stgex2,stgex2);
	LOAD_FLAPACK(handle,lapack.stgexc,stgexc);
	LOAD_FLAPACK(handle,lapack.stgsen,stgsen);
	LOAD_FLAPACK(handle,lapack.stgsja,stgsja);
	LOAD_FLAPACK(handle,lapack.stgsna,stgsna);
	LOAD_FLAPACK(handle,lapack.stgsy2,stgsy2);
	LOAD_FLAPACK(handle,lapack.stgsyl,stgsyl);
	LOAD_FLAPACK(handle,lapack.stpcon,stpcon);
	LOAD_FLAPACK(handle,lapack.stplqt,stplqt);
	LOAD_FLAPACK(handle,lapack.stplqt2,stplqt2);
	LOAD_FLAPACK(handle,lapack.stpmlqt,stpmlqt);
	LOAD_FLAPACK(handle,lapack.stpmqrt,stpmqrt);
	LOAD_FLAPACK(handle,lapack.stpqrt,stpqrt);
	LOAD_FLAPACK(handle,lapack.stpqrt2,stpqrt2);
	LOAD_FLAPACK(handle,lapack.stprfb,stprfb);
	LOAD_FLAPACK(handle,lapack.stprfs,stprfs);
	LOAD_FLAPACK(handle,lapack.stptri,stptri);
	LOAD_FLAPACK(handle,lapack.stptrs,stptrs);
	LOAD_FLAPACK(handle,lapack.stpttf,stpttf);
	LOAD_FLAPACK(handle,lapack.stpttr,stpttr);
	LOAD_FLAPACK(handle,lapack.strcon,strcon);
	LOAD_FLAPACK(handle,lapack.strevc,strevc);
	LOAD_FLAPACK(handle,lapack.strevc3,strevc3);
	LOAD_FLAPACK(handle,lapack.strexc,strexc);
	LOAD_FLAPACK(handle,lapack.strrfs,strrfs);
	LOAD_FLAPACK(handle,lapack.strsen,strsen);
	LOAD_FLAPACK(handle,lapack.strsna,strsna);
	LOAD_FLAPACK(handle,lapack.strsyl,strsyl);
	LOAD_FLAPACK(handle,lapack.strsyl3,strsyl3);
	LOAD_FLAPACK(handle,lapack.strti2,strti2);
	LOAD_FLAPACK(handle,lapack.strtri,strtri);
	LOAD_FLAPACK(handle,lapack.strtrs,strtrs);
	LOAD_FLAPACK(handle,lapack.strttf,strttf);
	LOAD_FLAPACK(handle,lapack.strttp,strttp);
	LOAD_FLAPACK(handle,lapack.stzrzf,stzrzf);
	LOAD_FLAPACK(handle,lapack.xerbla_array,xerbla_array);
	LOAD_FLAPACK(handle,lapack.zbbcsd,zbbcsd);
	LOAD_FLAPACK(handle,lapack.zbdsqr,zbdsqr);
	LOAD_FLAPACK(handle,lapack.zcgesv,zcgesv);
	LOAD_FLAPACK(handle,lapack.zcposv,zcposv);
	LOAD_FLAPACK(handle,lapack.zdrscl,zdrscl);
	LOAD_FLAPACK(handle,lapack.zgbbrd,zgbbrd);
	LOAD_FLAPACK(handle,lapack.zgbcon,zgbcon);
	LOAD_FLAPACK(handle,lapack.zgbequ,zgbequ);
	LOAD_FLAPACK(handle,lapack.zgbequb,zgbequb);
	LOAD_FLAPACK(handle,lapack.zgbrfs,zgbrfs);
	LOAD_FLAPACK(handle,lapack.zgbsv,zgbsv);
	LOAD_FLAPACK(handle,lapack.zgbsvx,zgbsvx);
	LOAD_FLAPACK(handle,lapack.zgbtf2,zgbtf2);
	LOAD_FLAPACK(handle,lapack.zgbtrf,zgbtrf);
	LOAD_FLAPACK(handle,lapack.zgbtrs,zgbtrs);
	LOAD_FLAPACK(handle,lapack.zgebak,zgebak);
	LOAD_FLAPACK(handle,lapack.zgebal,zgebal);
	LOAD_FLAPACK(handle,lapack.zgebd2,zgebd2);
	LOAD_FLAPACK(handle,lapack.zgebrd,zgebrd);
	LOAD_FLAPACK(handle,lapack.zgecon,zgecon);
	LOAD_FLAPACK(handle,lapack.zgeequ,zgeequ);
	LOAD_FLAPACK(handle,lapack.zgeequb,zgeequb);
	LOAD_FLAPACK(handle,lapack.zgees,zgees);
	LOAD_FLAPACK(handle,lapack.zgeesx,zgeesx);
	LOAD_FLAPACK(handle,lapack.zgeev,zgeev);
	LOAD_FLAPACK(handle,lapack.zgeevx,zgeevx);
	LOAD_FLAPACK(handle,lapack.zgehd2,zgehd2);
	LOAD_FLAPACK(handle,lapack.zgehrd,zgehrd);
	LOAD_FLAPACK(handle,lapack.zgejsv,zgejsv);
	LOAD_FLAPACK(handle,lapack.zgelq,zgelq);
	LOAD_FLAPACK(handle,lapack.zgelq2,zgelq2);
	LOAD_FLAPACK(handle,lapack.zgelqf,zgelqf);
	LOAD_FLAPACK(handle,lapack.zgelqt,zgelqt);
	LOAD_FLAPACK(handle,lapack.zgelqt3,zgelqt3);
	LOAD_FLAPACK(handle,lapack.zgels,zgels);
	LOAD_FLAPACK(handle,lapack.zgelsd,zgelsd);
	LOAD_FLAPACK(handle,lapack.zgelss,zgelss);
	LOAD_FLAPACK(handle,lapack.zgelst,zgelst);
	LOAD_FLAPACK(handle,lapack.zgelsy,zgelsy);
	LOAD_FLAPACK(handle,lapack.zgemlq,zgemlq);
	LOAD_FLAPACK(handle,lapack.zgemlqt,zgemlqt);
	LOAD_FLAPACK(handle,lapack.zgemqr,zgemqr);
	LOAD_FLAPACK(handle,lapack.zgemqrt,zgemqrt);
	LOAD_FLAPACK(handle,lapack.zgeql2,zgeql2);
	LOAD_FLAPACK(handle,lapack.zgeqlf,zgeqlf);
	LOAD_FLAPACK(handle,lapack.zgeqp3,zgeqp3);
	LOAD_FLAPACK(handle,lapack.zgeqr,zgeqr);
	LOAD_FLAPACK(handle,lapack.zgeqr2,zgeqr2);
	LOAD_FLAPACK(handle,lapack.zgeqr2p,zgeqr2p);
	LOAD_FLAPACK(handle,lapack.zgeqrf,zgeqrf);
	LOAD_FLAPACK(handle,lapack.zgeqrfp,zgeqrfp);
	LOAD_FLAPACK(handle,lapack.zgeqrt,zgeqrt);
	LOAD_FLAPACK(handle,lapack.zgeqrt2,zgeqrt2);
	LOAD_FLAPACK(handle,lapack.zgeqrt3,zgeqrt3);
	LOAD_FLAPACK(handle,lapack.zgerfs,zgerfs);
	LOAD_FLAPACK(handle,lapack.zgerq2,zgerq2);
	LOAD_FLAPACK(handle,lapack.zgerqf,zgerqf);
	LOAD_FLAPACK(handle,lapack.zgesc2,zgesc2);
	LOAD_FLAPACK(handle,lapack.zgesdd,zgesdd);
	LOAD_FLAPACK(handle,lapack.zgesv,zgesv);
	LOAD_FLAPACK(handle,lapack.zgesvd,zgesvd);
	LOAD_FLAPACK(handle,lapack.zgesvdq,zgesvdq);
	LOAD_FLAPACK(handle,lapack.zgesvdx,zgesvdx);
	LOAD_FLAPACK(handle,lapack.zgesvj,zgesvj);
	LOAD_FLAPACK(handle,lapack.zgesvx,zgesvx);
	LOAD_FLAPACK(handle,lapack.zgetc2,zgetc2);
	LOAD_FLAPACK(handle,lapack.zgetf2,zgetf2);
	LOAD_FLAPACK(handle,lapack.zgetrf,zgetrf);
	LOAD_FLAPACK(handle,lapack.zgetrf2,zgetrf2);
	LOAD_FLAPACK(handle,lapack.zgetri,zgetri);
	LOAD_FLAPACK(handle,lapack.zgetrs,zgetrs);
	LOAD_FLAPACK(handle,lapack.zgetsls,zgetsls);
	LOAD_FLAPACK(handle,lapack.zgetsqrhrt,zgetsqrhrt);
	LOAD_FLAPACK(handle,lapack.zggbak,zggbak);
	LOAD_FLAPACK(handle,lapack.zggbal,zggbal);
	LOAD_FLAPACK(handle,lapack.zgges,zgges);
	LOAD_FLAPACK(handle,lapack.zgges3,zgges3);
	LOAD_FLAPACK(handle,lapack.zggesx,zggesx);
	LOAD_FLAPACK(handle,lapack.zggev,zggev);
	LOAD_FLAPACK(handle,lapack.zggev3,zggev3);
	LOAD_FLAPACK(handle,lapack.zggevx,zggevx);
	LOAD_FLAPACK(handle,lapack.zggglm,zggglm);
	LOAD_FLAPACK(handle,lapack.zgghd3,zgghd3);
	LOAD_FLAPACK(handle,lapack.zgghrd,zgghrd);
	LOAD_FLAPACK(handle,lapack.zgglse,zgglse);
	LOAD_FLAPACK(handle,lapack.zggqrf,zggqrf);
	LOAD_FLAPACK(handle,lapack.zggrqf,zggrqf);
	LOAD_FLAPACK(handle,lapack.zggsvd3,zggsvd3);
	LOAD_FLAPACK(handle,lapack.zggsvp3,zggsvp3);
	LOAD_FLAPACK(handle,lapack.zgsvj0,zgsvj0);
	LOAD_FLAPACK(handle,lapack.zgsvj1,zgsvj1);
	LOAD_FLAPACK(handle,lapack.zgtcon,zgtcon);
	LOAD_FLAPACK(handle,lapack.zgtrfs,zgtrfs);
	LOAD_FLAPACK(handle,lapack.zgtsv,zgtsv);
	LOAD_FLAPACK(handle,lapack.zgtsvx,zgtsvx);
	LOAD_FLAPACK(handle,lapack.zgttrf,zgttrf);
	LOAD_FLAPACK(handle,lapack.zgttrs,zgttrs);
	LOAD_FLAPACK(handle,lapack.zgtts2,zgtts2);
	LOAD_FLAPACK(handle,lapack.zhb2st_kernels,zhb2st_kernels);
	LOAD_FLAPACK(handle,lapack.zhbev,zhbev);
	LOAD_FLAPACK(handle,lapack.zhbev_2stage,zhbev_2stage);
	LOAD_FLAPACK(handle,lapack.zhbevd,zhbevd);
	LOAD_FLAPACK(handle,lapack.zhbevd_2stage,zhbevd_2stage);
	LOAD_FLAPACK(handle,lapack.zhbevx,zhbevx);
	LOAD_FLAPACK(handle,lapack.zhbevx_2stage,zhbevx_2stage);
	LOAD_FLAPACK(handle,lapack.zhbgst,zhbgst);
	LOAD_FLAPACK(handle,lapack.zhbgv,zhbgv);
	LOAD_FLAPACK(handle,lapack.zhbgvd,zhbgvd);
	LOAD_FLAPACK(handle,lapack.zhbgvx,zhbgvx);
	LOAD_FLAPACK(handle,lapack.zhbtrd,zhbtrd);
	LOAD_FLAPACK(handle,lapack.zhecon,zhecon);
	LOAD_FLAPACK(handle,lapack.zhecon_3,zhecon_3);
	LOAD_FLAPACK(handle,lapack.zhecon_rook,zhecon_rook);
	LOAD_FLAPACK(handle,lapack.zheequb,zheequb);
	LOAD_FLAPACK(handle,lapack.zheev,zheev);
	LOAD_FLAPACK(handle,lapack.zheev_2stage,zheev_2stage);
	LOAD_FLAPACK(handle,lapack.zheevd,zheevd);
	LOAD_FLAPACK(handle,lapack.zheevd_2stage,zheevd_2stage);
	LOAD_FLAPACK(handle,lapack.zheevr,zheevr);
	LOAD_FLAPACK(handle,lapack.zheevr_2stage,zheevr_2stage);
	LOAD_FLAPACK(handle,lapack.zheevx,zheevx);
	LOAD_FLAPACK(handle,lapack.zheevx_2stage,zheevx_2stage);
	LOAD_FLAPACK(handle,lapack.zhegs2,zhegs2);
	LOAD_FLAPACK(handle,lapack.zhegst,zhegst);
	LOAD_FLAPACK(handle,lapack.zhegv,zhegv);
	LOAD_FLAPACK(handle,lapack.zhegv_2stage,zhegv_2stage);
	LOAD_FLAPACK(handle,lapack.zhegvd,zhegvd);
	LOAD_FLAPACK(handle,lapack.zhegvx,zhegvx);
	LOAD_FLAPACK(handle,lapack.zherfs,zherfs);
	LOAD_FLAPACK(handle,lapack.zhesv,zhesv);
	LOAD_FLAPACK(handle,lapack.zhesv_aa,zhesv_aa);
	LOAD_FLAPACK(handle,lapack.zhesv_aa_2stage,zhesv_aa_2stage);
	LOAD_FLAPACK(handle,lapack.zhesv_rk,zhesv_rk);
	LOAD_FLAPACK(handle,lapack.zhesv_rook,zhesv_rook);
	LOAD_FLAPACK(handle,lapack.zhesvx,zhesvx);
	LOAD_FLAPACK(handle,lapack.zheswapr,zheswapr);
	LOAD_FLAPACK(handle,lapack.zhetd2,zhetd2);
	LOAD_FLAPACK(handle,lapack.zhetf2,zhetf2);
	LOAD_FLAPACK(handle,lapack.zhetf2_rk,zhetf2_rk);
	LOAD_FLAPACK(handle,lapack.zhetf2_rook,zhetf2_rook);
	LOAD_FLAPACK(handle,lapack.zhetrd,zhetrd);
	LOAD_FLAPACK(handle,lapack.zhetrd_2stage,zhetrd_2stage);
	LOAD_FLAPACK(handle,lapack.zhetrd_hb2st,zhetrd_hb2st);
	LOAD_FLAPACK(handle,lapack.zhetrd_he2hb,zhetrd_he2hb);
	LOAD_FLAPACK(handle,lapack.zhetrf,zhetrf);
	LOAD_FLAPACK(handle,lapack.zhetrf_aa,zhetrf_aa);
	LOAD_FLAPACK(handle,lapack.zhetrf_aa_2stage,zhetrf_aa_2stage);
	LOAD_FLAPACK(handle,lapack.zhetrf_rk,zhetrf_rk);
	LOAD_FLAPACK(handle,lapack.zhetrf_rook,zhetrf_rook);
	LOAD_FLAPACK(handle,lapack.zhetri,zhetri);
	LOAD_FLAPACK(handle,lapack.zhetri2,zhetri2);
	LOAD_FLAPACK(handle,lapack.zhetri2x,zhetri2x);
	LOAD_FLAPACK(handle,lapack.zhetri_3,zhetri_3);
	LOAD_FLAPACK(handle,lapack.zhetri_3x,zhetri_3x);
	LOAD_FLAPACK(handle,lapack.zhetri_rook,zhetri_rook);
	LOAD_FLAPACK(handle,lapack.zhetrs,zhetrs);
	LOAD_FLAPACK(handle,lapack.zhetrs2,zhetrs2);
	LOAD_FLAPACK(handle,lapack.zhetrs_3,zhetrs_3);
	LOAD_FLAPACK(handle,lapack.zhetrs_aa,zhetrs_aa);
	LOAD_FLAPACK(handle,lapack.zhetrs_aa_2stage,zhetrs_aa_2stage);
	LOAD_FLAPACK(handle,lapack.zhetrs_rook,zhetrs_rook);
	LOAD_FLAPACK(handle,lapack.zhfrk,zhfrk);
	LOAD_FLAPACK(handle,lapack.zhgeqz,zhgeqz);
	LOAD_FLAPACK(handle,lapack.zhpcon,zhpcon);
	LOAD_FLAPACK(handle,lapack.zhpev,zhpev);
	LOAD_FLAPACK(handle,lapack.zhpevd,zhpevd);
	LOAD_FLAPACK(handle,lapack.zhpevx,zhpevx);
	LOAD_FLAPACK(handle,lapack.zhpgst,zhpgst);
	LOAD_FLAPACK(handle,lapack.zhpgv,zhpgv);
	LOAD_FLAPACK(handle,lapack.zhpgvd,zhpgvd);
	LOAD_FLAPACK(handle,lapack.zhpgvx,zhpgvx);
	LOAD_FLAPACK(handle,lapack.zhprfs,zhprfs);
	LOAD_FLAPACK(handle,lapack.zhpsv,zhpsv);
	LOAD_FLAPACK(handle,lapack.zhpsvx,zhpsvx);
	LOAD_FLAPACK(handle,lapack.zhptrd,zhptrd);
	LOAD_FLAPACK(handle,lapack.zhptrf,zhptrf);
	LOAD_FLAPACK(handle,lapack.zhptri,zhptri);
	LOAD_FLAPACK(handle,lapack.zhptrs,zhptrs);
	LOAD_FLAPACK(handle,lapack.zhsein,zhsein);
	LOAD_FLAPACK(handle,lapack.zhseqr,zhseqr);
	LOAD_FLAPACK(handle,lapack.zlabrd,zlabrd);
	LOAD_FLAPACK(handle,lapack.zlacgv,zlacgv);
	LOAD_FLAPACK(handle,lapack.zlacn2,zlacn2);
	LOAD_FLAPACK(handle,lapack.zlacon,zlacon);
	LOAD_FLAPACK(handle,lapack.zlacp2,zlacp2);
	LOAD_FLAPACK(handle,lapack.zlacpy,zlacpy);
	LOAD_FLAPACK(handle,lapack.zlacrm,zlacrm);
	LOAD_FLAPACK(handle,lapack.zlacrt,zlacrt);
	LOAD_FLAPACK(handle,lapack.zladiv,zladiv);
	LOAD_FLAPACK(handle,lapack.zlaed0,zlaed0);
	LOAD_FLAPACK(handle,lapack.zlaed7,zlaed7);
	LOAD_FLAPACK(handle,lapack.zlaed8,zlaed8);
	LOAD_FLAPACK(handle,lapack.zlaein,zlaein);
	LOAD_FLAPACK(handle,lapack.zlaesy,zlaesy);
	LOAD_FLAPACK(handle,lapack.zlaev2,zlaev2);
	LOAD_FLAPACK(handle,lapack.zlag2c,zlag2c);
	LOAD_FLAPACK(handle,lapack.zlags2,zlags2);
	LOAD_FLAPACK(handle,lapack.zlagtm,zlagtm);
	LOAD_FLAPACK(handle,lapack.zlahef,zlahef);
	LOAD_FLAPACK(handle,lapack.zlahef_aa,zlahef_aa);
	LOAD_FLAPACK(handle,lapack.zlahef_rk,zlahef_rk);
	LOAD_FLAPACK(handle,lapack.zlahef_rook,zlahef_rook);
	LOAD_FLAPACK(handle,lapack.zlahqr,zlahqr);
	LOAD_FLAPACK(handle,lapack.zlahr2,zlahr2);
	LOAD_FLAPACK(handle,lapack.zlaic1,zlaic1);
	LOAD_FLAPACK(handle,lapack.zlals0,zlals0);
	LOAD_FLAPACK(handle,lapack.zlalsa,zlalsa);
	LOAD_FLAPACK(handle,lapack.zlalsd,zlalsd);
	LOAD_FLAPACK(handle,lapack.zlamswlq,zlamswlq);
	LOAD_FLAPACK(handle,lapack.zlamtsqr,zlamtsqr);
	LOAD_FLAPACK(handle,lapack.zlangb,zlangb);
	LOAD_FLAPACK(handle,lapack.zlange,zlange);
	LOAD_FLAPACK(handle,lapack.zlangt,zlangt);
	LOAD_FLAPACK(handle,lapack.zlanhb,zlanhb);
	LOAD_FLAPACK(handle,lapack.zlanhe,zlanhe);
	LOAD_FLAPACK(handle,lapack.zlanhf,zlanhf);
	LOAD_FLAPACK(handle,lapack.zlanhp,zlanhp);
	LOAD_FLAPACK(handle,lapack.zlanhs,zlanhs);
	LOAD_FLAPACK(handle,lapack.zlanht,zlanht);
	LOAD_FLAPACK(handle,lapack.zlansb,zlansb);
	LOAD_FLAPACK(handle,lapack.zlansp,zlansp);
	LOAD_FLAPACK(handle,lapack.zlansy,zlansy);
	LOAD_FLAPACK(handle,lapack.zlantb,zlantb);
	LOAD_FLAPACK(handle,lapack.zlantp,zlantp);
	LOAD_FLAPACK(handle,lapack.zlantr,zlantr);
	LOAD_FLAPACK(handle,lapack.zlapll,zlapll);
	LOAD_FLAPACK(handle,lapack.zlapmr,zlapmr);
	LOAD_FLAPACK(handle,lapack.zlapmt,zlapmt);
	LOAD_FLAPACK(handle,lapack.zlaqgb,zlaqgb);
	LOAD_FLAPACK(handle,lapack.zlaqge,zlaqge);
	LOAD_FLAPACK(handle,lapack.zlaqhb,zlaqhb);
	LOAD_FLAPACK(handle,lapack.zlaqhe,zlaqhe);
	LOAD_FLAPACK(handle,lapack.zlaqhp,zlaqhp);
	LOAD_FLAPACK(handle,lapack.zlaqp2,zlaqp2);
	LOAD_FLAPACK(handle,lapack.zlaqps,zlaqps);
	LOAD_FLAPACK(handle,lapack.zlaqr0,zlaqr0);
	LOAD_FLAPACK(handle,lapack.zlaqr1,zlaqr1);
	LOAD_FLAPACK(handle,lapack.zlaqr2,zlaqr2);
	LOAD_FLAPACK(handle,lapack.zlaqr3,zlaqr3);
	LOAD_FLAPACK(handle,lapack.zlaqr4,zlaqr4);
	LOAD_FLAPACK(handle,lapack.zlaqr5,zlaqr5);
	LOAD_FLAPACK(handle,lapack.zlaqsb,zlaqsb);
	LOAD_FLAPACK(handle,lapack.zlaqsp,zlaqsp);
	LOAD_FLAPACK(handle,lapack.zlaqsy,zlaqsy);
	LOAD_FLAPACK(handle,lapack.zlaqz0,zlaqz0);
	LOAD_FLAPACK(handle,lapack.zlaqz1,zlaqz1);
	LOAD_FLAPACK(handle,lapack.zlaqz2,zlaqz2);
	LOAD_FLAPACK(handle,lapack.zlaqz3,zlaqz3);
	LOAD_FLAPACK(handle,lapack.zlar1v,zlar1v);
	LOAD_FLAPACK(handle,lapack.zlar2v,zlar2v);
	LOAD_FLAPACK(handle,lapack.zlarcm,zlarcm);
	LOAD_FLAPACK(handle,lapack.zlarf,zlarf);
	LOAD_FLAPACK(handle,lapack.zlarfb,zlarfb);
	LOAD_FLAPACK(handle,lapack.zlarfb_gett,zlarfb_gett);
	LOAD_FLAPACK(handle,lapack.zlarfg,zlarfg);
	LOAD_FLAPACK(handle,lapack.zlarfgp,zlarfgp);
	LOAD_FLAPACK(handle,lapack.zlarft,zlarft);
	LOAD_FLAPACK(handle,lapack.zlarfx,zlarfx);
	LOAD_FLAPACK(handle,lapack.zlarfy,zlarfy);
	LOAD_FLAPACK(handle,lapack.zlargv,zlargv);
	LOAD_FLAPACK(handle,lapack.zlarnv,zlarnv);
	LOAD_FLAPACK(handle,lapack.zlarrv,zlarrv);
	LOAD_FLAPACK(handle,lapack.zlartg,zlartg);
	LOAD_FLAPACK(handle,lapack.zlartv,zlartv);
	LOAD_FLAPACK(handle,lapack.zlarz,zlarz);
	LOAD_FLAPACK(handle,lapack.zlarzb,zlarzb);
	LOAD_FLAPACK(handle,lapack.zlarzt,zlarzt);
	LOAD_FLAPACK(handle,lapack.zlascl,zlascl);
	LOAD_FLAPACK(handle,lapack.zlaset,zlaset);
	LOAD_FLAPACK(handle,lapack.zlasr,zlasr);
	LOAD_FLAPACK(handle,lapack.zlassq,zlassq);
	LOAD_FLAPACK(handle,lapack.zlaswlq,zlaswlq);
	LOAD_FLAPACK(handle,lapack.zlaswp,zlaswp);
	LOAD_FLAPACK(handle,lapack.zlasyf,zlasyf);
	LOAD_FLAPACK(handle,lapack.zlasyf_aa,zlasyf_aa);
	LOAD_FLAPACK(handle,lapack.zlasyf_rk,zlasyf_rk);
	LOAD_FLAPACK(handle,lapack.zlasyf_rook,zlasyf_rook);
	LOAD_FLAPACK(handle,lapack.zlat2c,zlat2c);
	LOAD_FLAPACK(handle,lapack.zlatbs,zlatbs);
	LOAD_FLAPACK(handle,lapack.zlatdf,zlatdf);
	LOAD_FLAPACK(handle,lapack.zlatps,zlatps);
	LOAD_FLAPACK(handle,lapack.zlatrd,zlatrd);
	LOAD_FLAPACK(handle,lapack.zlatrs,zlatrs);
	LOAD_FLAPACK(handle,lapack.zlatrs3,zlatrs3);
	LOAD_FLAPACK(handle,lapack.zlatrz,zlatrz);
	LOAD_FLAPACK(handle,lapack.zlatsqr,zlatsqr);
	LOAD_FLAPACK(handle,lapack.zlaunhr_col_getrfnp,zlaunhr_col_getrfnp);
	LOAD_FLAPACK(handle,lapack.zlaunhr_col_getrfnp2,zlaunhr_col_getrfnp2);
	LOAD_FLAPACK(handle,lapack.zlauu2,zlauu2);
	LOAD_FLAPACK(handle,lapack.zlauum,zlauum);
	LOAD_FLAPACK(handle,lapack.zpbcon,zpbcon);
	LOAD_FLAPACK(handle,lapack.zpbequ,zpbequ);
	LOAD_FLAPACK(handle,lapack.zpbrfs,zpbrfs);
	LOAD_FLAPACK(handle,lapack.zpbstf,zpbstf);
	LOAD_FLAPACK(handle,lapack.zpbsv,zpbsv);
	LOAD_FLAPACK(handle,lapack.zpbsvx,zpbsvx);
	LOAD_FLAPACK(handle,lapack.zpbtf2,zpbtf2);
	LOAD_FLAPACK(handle,lapack.zpbtrf,zpbtrf);
	LOAD_FLAPACK(handle,lapack.zpbtrs,zpbtrs);
	LOAD_FLAPACK(handle,lapack.zpftrf,zpftrf);
	LOAD_FLAPACK(handle,lapack.zpftri,zpftri);
	LOAD_FLAPACK(handle,lapack.zpftrs,zpftrs);
	LOAD_FLAPACK(handle,lapack.zpocon,zpocon);
	LOAD_FLAPACK(handle,lapack.zpoequ,zpoequ);
	LOAD_FLAPACK(handle,lapack.zpoequb,zpoequb);
	LOAD_FLAPACK(handle,lapack.zporfs,zporfs);
	LOAD_FLAPACK(handle,lapack.zposv,zposv);
	LOAD_FLAPACK(handle,lapack.zposvx,zposvx);
	LOAD_FLAPACK(handle,lapack.zpotf2,zpotf2);
	LOAD_FLAPACK(handle,lapack.zpotrf,zpotrf);
	LOAD_FLAPACK(handle,lapack.zpotrf2,zpotrf2);
	LOAD_FLAPACK(handle,lapack.zpotri,zpotri);
	LOAD_FLAPACK(handle,lapack.zpotrs,zpotrs);
	LOAD_FLAPACK(handle,lapack.zppcon,zppcon);
	LOAD_FLAPACK(handle,lapack.zppequ,zppequ);
	LOAD_FLAPACK(handle,lapack.zpprfs,zpprfs);
	LOAD_FLAPACK(handle,lapack.zppsv,zppsv);
	LOAD_FLAPACK(handle,lapack.zppsvx,zppsvx);
	LOAD_FLAPACK(handle,lapack.zpptrf,zpptrf);
	LOAD_FLAPACK(handle,lapack.zpptri,zpptri);
	LOAD_FLAPACK(handle,lapack.zpptrs,zpptrs);
	LOAD_FLAPACK(handle,lapack.zpstf2,zpstf2);
	LOAD_FLAPACK(handle,lapack.zpstrf,zpstrf);
	LOAD_FLAPACK(handle,lapack.zptcon,zptcon);
	LOAD_FLAPACK(handle,lapack.zpteqr,zpteqr);
	LOAD_FLAPACK(handle,lapack.zptrfs,zptrfs);
	LOAD_FLAPACK(handle,lapack.zptsv,zptsv);
	LOAD_FLAPACK(handle,lapack.zptsvx,zptsvx);
	LOAD_FLAPACK(handle,lapack.zpttrf,zpttrf);
	LOAD_FLAPACK(handle,lapack.zpttrs,zpttrs);
	LOAD_FLAPACK(handle,lapack.zptts2,zptts2);
	LOAD_FLAPACK(handle,lapack.zrot,zrot);
	LOAD_FLAPACK(handle,lapack.zspcon,zspcon);
	LOAD_FLAPACK(handle,lapack.zspmv,zspmv);
	LOAD_FLAPACK(handle,lapack.zspr,zspr);
	LOAD_FLAPACK(handle,lapack.zsprfs,zsprfs);
	LOAD_FLAPACK(handle,lapack.zspsv,zspsv);
	LOAD_FLAPACK(handle,lapack.zspsvx,zspsvx);
	LOAD_FLAPACK(handle,lapack.zsptrf,zsptrf);
	LOAD_FLAPACK(handle,lapack.zsptri,zsptri);
	LOAD_FLAPACK(handle,lapack.zsptrs,zsptrs);
	LOAD_FLAPACK(handle,lapack.zstedc,zstedc);
	LOAD_FLAPACK(handle,lapack.zstegr,zstegr);
	LOAD_FLAPACK(handle,lapack.zstein,zstein);
	LOAD_FLAPACK(handle,lapack.zstemr,zstemr);
	LOAD_FLAPACK(handle,lapack.zsteqr,zsteqr);
	LOAD_FLAPACK(handle,lapack.zsycon,zsycon);
	LOAD_FLAPACK(handle,lapack.zsycon_3,zsycon_3);
	LOAD_FLAPACK(handle,lapack.zsycon_rook,zsycon_rook);
	LOAD_FLAPACK(handle,lapack.zsyconv,zsyconv);
	LOAD_FLAPACK(handle,lapack.zsyconvf,zsyconvf);
	LOAD_FLAPACK(handle,lapack.zsyconvf_rook,zsyconvf_rook);
	LOAD_FLAPACK(handle,lapack.zsyequb,zsyequb);
	LOAD_FLAPACK(handle,lapack.zsymv,zsymv);
	LOAD_FLAPACK(handle,lapack.zsyr,zsyr);
	LOAD_FLAPACK(handle,lapack.zsyrfs,zsyrfs);
	LOAD_FLAPACK(handle,lapack.zsysv,zsysv);
	LOAD_FLAPACK(handle,lapack.zsysv_aa,zsysv_aa);
	LOAD_FLAPACK(handle,lapack.zsysv_aa_2stage,zsysv_aa_2stage);
	LOAD_FLAPACK(handle,lapack.zsysv_rk,zsysv_rk);
	LOAD_FLAPACK(handle,lapack.zsysv_rook,zsysv_rook);
	LOAD_FLAPACK(handle,lapack.zsysvx,zsysvx);
	LOAD_FLAPACK(handle,lapack.zsyswapr,zsyswapr);
	LOAD_FLAPACK(handle,lapack.zsytf2,zsytf2);
	LOAD_FLAPACK(handle,lapack.zsytf2_rk,zsytf2_rk);
	LOAD_FLAPACK(handle,lapack.zsytf2_rook,zsytf2_rook);
	LOAD_FLAPACK(handle,lapack.zsytrf,zsytrf);
	LOAD_FLAPACK(handle,lapack.zsytrf_aa,zsytrf_aa);
	LOAD_FLAPACK(handle,lapack.zsytrf_aa_2stage,zsytrf_aa_2stage);
	LOAD_FLAPACK(handle,lapack.zsytrf_rk,zsytrf_rk);
	LOAD_FLAPACK(handle,lapack.zsytrf_rook,zsytrf_rook);
	LOAD_FLAPACK(handle,lapack.zsytri,zsytri);
	LOAD_FLAPACK(handle,lapack.zsytri2,zsytri2);
	LOAD_FLAPACK(handle,lapack.zsytri2x,zsytri2x);
	LOAD_FLAPACK(handle,lapack.zsytri_3,zsytri_3);
	LOAD_FLAPACK(handle,lapack.zsytri_3x,zsytri_3x);
	LOAD_FLAPACK(handle,lapack.zsytri_rook,zsytri_rook);
	LOAD_FLAPACK(handle,lapack.zsytrs,zsytrs);
	LOAD_FLAPACK(handle,lapack.zsytrs2,zsytrs2);
	LOAD_FLAPACK(handle,lapack.zsytrs_3,zsytrs_3);
	LOAD_FLAPACK(handle,lapack.zsytrs_aa,zsytrs_aa);
	LOAD_FLAPACK(handle,lapack.zsytrs_aa_2stage,zsytrs_aa_2stage);
	LOAD_FLAPACK(handle,lapack.zsytrs_rook,zsytrs_rook);
	LOAD_FLAPACK(handle,lapack.ztbcon,ztbcon);
	LOAD_FLAPACK(handle,lapack.ztbrfs,ztbrfs);
	LOAD_FLAPACK(handle,lapack.ztbtrs,ztbtrs);
	LOAD_FLAPACK(handle,lapack.ztfsm,ztfsm);
	LOAD_FLAPACK(handle,lapack.ztftri,ztftri);
	LOAD_FLAPACK(handle,lapack.ztfttp,ztfttp);
	LOAD_FLAPACK(handle,lapack.ztfttr,ztfttr);
	LOAD_FLAPACK(handle,lapack.ztgevc,ztgevc);
	LOAD_FLAPACK(handle,lapack.ztgex2,ztgex2);
	LOAD_FLAPACK(handle,lapack.ztgexc,ztgexc);
	LOAD_FLAPACK(handle,lapack.ztgsen,ztgsen);
	LOAD_FLAPACK(handle,lapack.ztgsja,ztgsja);
	LOAD_FLAPACK(handle,lapack.ztgsna,ztgsna);
	LOAD_FLAPACK(handle,lapack.ztgsy2,ztgsy2);
	LOAD_FLAPACK(handle,lapack.ztgsyl,ztgsyl);
	LOAD_FLAPACK(handle,lapack.ztpcon,ztpcon);
	LOAD_FLAPACK(handle,lapack.ztplqt,ztplqt);
	LOAD_FLAPACK(handle,lapack.ztplqt2,ztplqt2);
	LOAD_FLAPACK(handle,lapack.ztpmlqt,ztpmlqt);
	LOAD_FLAPACK(handle,lapack.ztpmqrt,ztpmqrt);
	LOAD_FLAPACK(handle,lapack.ztpqrt,ztpqrt);
	LOAD_FLAPACK(handle,lapack.ztpqrt2,ztpqrt2);
	LOAD_FLAPACK(handle,lapack.ztprfb,ztprfb);
	LOAD_FLAPACK(handle,lapack.ztprfs,ztprfs);
	LOAD_FLAPACK(handle,lapack.ztptri,ztptri);
	LOAD_FLAPACK(handle,lapack.ztptrs,ztptrs);
	LOAD_FLAPACK(handle,lapack.ztpttf,ztpttf);
	LOAD_FLAPACK(handle,lapack.ztpttr,ztpttr);
	LOAD_FLAPACK(handle,lapack.ztrcon,ztrcon);
	LOAD_FLAPACK(handle,lapack.ztrevc,ztrevc);
	LOAD_FLAPACK(handle,lapack.ztrevc3,ztrevc3);
	LOAD_FLAPACK(handle,lapack.ztrexc,ztrexc);
	LOAD_FLAPACK(handle,lapack.ztrrfs,ztrrfs);
	LOAD_FLAPACK(handle,lapack.ztrsen,ztrsen);
	LOAD_FLAPACK(handle,lapack.ztrsna,ztrsna);
	LOAD_FLAPACK(handle,lapack.ztrsyl,ztrsyl);
	LOAD_FLAPACK(handle,lapack.ztrsyl3,ztrsyl3);
	LOAD_FLAPACK(handle,lapack.ztrti2,ztrti2);
	LOAD_FLAPACK(handle,lapack.ztrtri,ztrtri);
	LOAD_FLAPACK(handle,lapack.ztrtrs,ztrtrs);
	LOAD_FLAPACK(handle,lapack.ztrttf,ztrttf);
	LOAD_FLAPACK(handle,lapack.ztrttp,ztrttp);
	LOAD_FLAPACK(handle,lapack.ztzrzf,ztzrzf);
	LOAD_FLAPACK(handle,lapack.zunbdb,zunbdb);
	LOAD_FLAPACK(handle,lapack.zunbdb1,zunbdb1);
	LOAD_FLAPACK(handle,lapack.zunbdb2,zunbdb2);
	LOAD_FLAPACK(handle,lapack.zunbdb3,zunbdb3);
	LOAD_FLAPACK(handle,lapack.zunbdb4,zunbdb4);
	LOAD_FLAPACK(handle,lapack.zunbdb5,zunbdb5);
	LOAD_FLAPACK(handle,lapack.zunbdb6,zunbdb6);
	LOAD_FLAPACK(handle,lapack.zuncsd,zuncsd);
	LOAD_FLAPACK(handle,lapack.zuncsd2by1,zuncsd2by1);
	LOAD_FLAPACK(handle,lapack.zung2l,zung2l);
	LOAD_FLAPACK(handle,lapack.zung2r,zung2r);
	LOAD_FLAPACK(handle,lapack.zungbr,zungbr);
	LOAD_FLAPACK(handle,lapack.zunghr,zunghr);
	LOAD_FLAPACK(handle,lapack.zungl2,zungl2);
	LOAD_FLAPACK(handle,lapack.zunglq,zunglq);
	LOAD_FLAPACK(handle,lapack.zungql,zungql);
	LOAD_FLAPACK(handle,lapack.zungqr,zungqr);
	LOAD_FLAPACK(handle,lapack.zungr2,zungr2);
	LOAD_FLAPACK(handle,lapack.zungrq,zungrq);
	LOAD_FLAPACK(handle,lapack.zungtr,zungtr);
	LOAD_FLAPACK(handle,lapack.zungtsqr,zungtsqr);
	LOAD_FLAPACK(handle,lapack.zungtsqr_row,zungtsqr_row);
	LOAD_FLAPACK(handle,lapack.zunhr_col,zunhr_col);
	LOAD_FLAPACK(handle,lapack.zunm22,zunm22);
	LOAD_FLAPACK(handle,lapack.zunm2l,zunm2l);
	LOAD_FLAPACK(handle,lapack.zunm2r,zunm2r);
	LOAD_FLAPACK(handle,lapack.zunmbr,zunmbr);
	LOAD_FLAPACK(handle,lapack.zunmhr,zunmhr);
	LOAD_FLAPACK(handle,lapack.zunml2,zunml2);
	LOAD_FLAPACK(handle,lapack.zunmlq,zunmlq);
	LOAD_FLAPACK(handle,lapack.zunmql,zunmql);
	LOAD_FLAPACK(handle,lapack.zunmqr,zunmqr);
	LOAD_FLAPACK(handle,lapack.zunmr2,zunmr2);
	LOAD_FLAPACK(handle,lapack.zunmr3,zunmr3);
	LOAD_FLAPACK(handle,lapack.zunmrq,zunmrq);
	LOAD_FLAPACK(handle,lapack.zunmrz,zunmrz);
	LOAD_FLAPACK(handle,lapack.zunmtr,zunmtr);
	LOAD_FLAPACK(handle,lapack.zupgtr,zupgtr);
	LOAD_FLAPACK(handle,lapack.zupmtr,zupmtr);
	if (_ifailed != (*failed))
		return 1;
	else
		 return 0;
}

