IF(CMAKE_C_COMPILER_LOADED)

IF(NOT "${HOSTOPT}" STREQUAL "")
    IF(NOT (HOSTOPT STREQUAL OFF OR HOSTOPT STREQUAL ON))
        STRING(SUBSTRING "${HOSTOPT}" 0 1 FIRST_CHAR)
        IF( "${FIRST_CHAR}" STREQUAL "/" )
            MESSAGE(STATUS "Load user supplied Host Optimizations for C -- ${HOSTOPT}")
            INCLUDE(${HOSTOPT})
        ELSE()
            MESSAGE(STATUS  "Load user supplied Host Optimizations for C -- ${CMAKE_BINARY_DIR}/${HOSTOPT}")
            INCLUDE(${CMAKE_BINARY_DIR}/${HOSTOPT})
        ENDIF()
        SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} ${HOSTOPT_C}")
    ENDIF()
ENDIF()


ADD_DEFINITIONS(-D_FILE_OFFSET_BITS=64)
IF(CMAKE_C_COMPILER_ID STREQUAL "GNU")
    # GNU
    SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -fPIC")
    SET(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE} -O3")
    SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -Wall -Wunused -g -Wextra -Wshadow -Wstrict-aliasing")
    SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -Wundef -Wlogical-op -Wparentheses -Wcast-qual")

    IF(DEBUGOPT STREQUAL ON)
        SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -O3")
    ELSE()
        SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -O0")
    ENDIF()

    IF(INTEGER8 STREQUAL ON)
        ADD_DEFINITIONS(-DINTEGER8)
    ENDIF()

    IF(HOSTOPT STREQUAL ON)
        SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -march=native -mtune=native")
    ENDIF()

ELSEIF(CMAKE_C_COMPILER_ID STREQUAL "Clang")
    IF(CMAKE_C_COMPILER_FRONTEND_VARIANT STREQUAL "MSVC")
        # clang-cl
        # Note that there is no need for position independent code on Windows
        SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -D_CRT_SECURE_NO_WARNINGS -D_CRT_SECURE_NO_DEPRECATE")
        SET(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE} /O2")
        SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} /W4 /DEBUG")

        IF(DEBUGOPT STREQUAL ON)
            SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} /O2")
        ELSE()
            SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} /Od")
        ENDIF()

        IF(INTEGER8 STREQUAL ON)
            ADD_DEFINITIONS(-DINTEGER8)
        ENDIF()

        IF(HOSTOPT STREQUAL ON)
            IF(NOT CMAKE_C_COMPILER_VERSION VERSION_LESS 8)
                SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -march=native")
            ELSE()
                MESSAGE(WARNING "No automatic host optimization available for clang-cl 7 or earlier.")
            ENDIF()
        ENDIF()
    ELSEIF(CMAKE_C_COMPILER_FRONTEND_VARIANT STREQUAL "GNU")
        # clang
        SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -fPIC")
        SET(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE} -O3")
        SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -Wall -Wunused -g -Wextra -Wshadow -Wstrict-aliasing")
        SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -Wundef -Wparentheses -Wcast-qual")

        IF(DEBUGOPT STREQUAL ON)
            SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -O3")
        ELSE()
            SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -O0")
        ENDIF()

        IF(INTEGER8 STREQUAL ON)
            ADD_DEFINITIONS(-DINTEGER8)
        ENDIF()

        IF(HOSTOPT STREQUAL ON)
            SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -march=native -mtune=native")
        ENDIF()
    ENDIF()

ELSEIF(CMAKE_C_COMPILER_ID STREQUAL "MSVC")
    # MSVC
    # Note that there is no need for position independent code on Windows
    SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -D_CRT_SECURE_NO_WARNINGS -D_CRT_SECURE_NO_DEPRECATE")
    SET(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE} /O2")
    SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} /W4 /DEBUG")

    IF(DEBUGOPT STREQUAL ON)
        SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} /O2")
    ELSE()
        SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} /Od")
    ENDIF()

    IF(INTEGER8 STREQUAL ON)
        ADD_DEFINITIONS(-DINTEGER8)
    ENDIF()

    IF(HOSTOPT STREQUAL ON)
        MESSAGE(WARNING "No automatic host optimization available for MSVC C compiler.")
    ENDIF()

ELSEIF(CMAKE_C_COMPILER_ID STREQUAL "Intel")
    # Intel
    SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -fpic")
    SET(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE} -O3")
    SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -Wall -g")

    IF(DEBUGOPT STREQUAL ON)
        SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -O3")
    ELSE()
        SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -O0")
    ENDIF()

    IF(INTEGER8 STREQUAL ON)
        ADD_DEFINITIONS(-DINTEGER8)
    ENDIF()

    IF(HOSTOPT STREQUAL ON)
        SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -xHost")
    ENDIF()

ELSEIF(CMAKE_C_COMPILER_ID STREQUAL "NVHPC")
    # Nvidia HPC SDK (nvc)
    SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -fpic -Mnoipa")
    SET(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE} -O3")
    SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG}")

    IF(DEBUGOPT STREQUAL ON)
        SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -gopt -O3")
    ELSE()
        SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -g -O0")
    ENDIF()

    IF(INTEGER8 STREQUAL ON)
        ADD_DEFINITIONS(-DINTEGER8)
    ENDIF()

    IF(HOSTOPT STREQUAL ON)
        SET(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE} -fast -tp=native")
        IF (DEBUGOPT STREQUAL ON)
            SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -fast -tp=native")
        ENDIF()
    ENDIF()

ELSEIF(CMAKE_C_COMPILER_ID STREQUAL "XL")
    # IBM XLC
    SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -qpic -qmaxmem=32768")
    IF(HOSTOPT STREQUAL ON)
        SET(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE} -O5 -qtune=auto -qarch=auto")
    ELSE()
        SET(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE} -O3")
    ENDIF()
    SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -Wall -g9")

    IF(DEBUGOPT STREQUAL ON)
        SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -O2")
    ELSE()
        SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -O0")
    ENDIF()

    STRING(REPLACE "-qhalt=e" "" CMAKE_C_FLAGS "${CMAKE_C_FLAGS}")

    IF(INTEGER8 STREQUAL ON)
        ADD_DEFINITIONS(-DINTEGER8)
    ENDIF()

    IF(OPENMP_FOUND)
        SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} ${OpenMP_C_FLAGS}")
        LIST(REMOVE_ITEM CMAKE_C_IMPLICIT_LINK_LIBRARIES "xlomp_ser")
    ENDIF()
ELSEIF(CMAKE_C_COMPILER_ID STREQUAL "TinyCC")
    # Tiny CC
    # Note that as of version 0.9.27 there is no support for optimization or position independent code generation
    SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS}")
    SET(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE}")
    SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -g -Wall")

    IF(INTEGER8 STREQUAL ON)
        ADD_DEFINITIONS(-DINTEGER8)
    ENDIF()

    IF(HOSTOPT STREQUAL ON)
        MESSAGE(WARNING "No automatic host optimization available for Tiny C compiler.")
    ENDIF()
ENDIF()

ENDIF() # C Compiler loaded
