/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Thu Dec 10 07:05:25 EST 2020 */

#include "dft/codelet-dft.h"

#if defined(ARCH_PREFERS_FMA) || defined(ISA_EXTENSION_PREFERS_FMA)

/* Generated by: ../../../genfft/gen_twiddle_c.native -fma -simd -compact -variables 4 -pipeline-latency 8 -n 64 -name t2fv_64 -include dft/simd/t2f.h */

/*
 * This function contains 519 FP additions, 384 FP multiplications,
 * (or, 261 additions, 126 multiplications, 258 fused multiply/add),
 * 107 stack variables, 15 constants, and 128 memory accesses
 */
#include "dft/simd/t2f.h"

static void t2fv_64(R *ri, R *ii, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DVK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DVK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DVK(KP820678790, +0.820678790828660330972281985331011598767386482);
     DVK(KP098491403, +0.098491403357164253077197521291327432293052451);
     DVK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DVK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DVK(KP303346683, +0.303346683607342391675883946941299872384187453);
     DVK(KP534511135, +0.534511135950791641089685961295362908582039528);
     DVK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DVK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DVK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DVK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DVK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DVK(KP414213562, +0.414213562373095048801688724209698078569671875);
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  R *x;
	  x = ri;
	  for (m = mb, W = W + (mb * ((TWVL / VL) * 126)); m < me; m = m + VL, x = x + (VL * ms), W = W + (TWVL * 126), MAKE_VOLATILE_STRIDE(64, rs)) {
	       V Ta, T3U, T6l, T7B, T37, T3V, T58, T7a, T1v, T24, T43, T4F, T5F, T7l, T5Q;
	       V T7o, T2i, T2R, T4a, T4I, T60, T7s, T6b, T7v, T4h, T4i, T4C, T5x, T7g, T1i;
	       V T3a, T5u, T7h, T4k, T4l, T4B, T5o, T7d, TV, T3b, T5l, T7e, T3X, T3Y, Tx;
	       V T38, T5f, T7C, T6o, T7b, T1S, T25, T5T, T7m, T46, T4G, T5M, T7p, T2F, T2S;
	       V T6e, T7t, T4d, T4J, T67, T7w;
	       {
		    V T1, T3, T8, T6, T33, T35, T55, T2Y, T30, T56, T2, T7, T5;
		    T1 = LD(&(x[0]), ms, &(x[0]));
		    T2 = LD(&(x[WS(rs, 32)]), ms, &(x[0]));
		    T3 = BYTWJ(&(W[TWVL * 62]), T2);
		    T7 = LD(&(x[WS(rs, 48)]), ms, &(x[0]));
		    T8 = BYTWJ(&(W[TWVL * 94]), T7);
		    T5 = LD(&(x[WS(rs, 16)]), ms, &(x[0]));
		    T6 = BYTWJ(&(W[TWVL * 30]), T5);
		    {
			 V T32, T34, T2X, T2Z;
			 T32 = LD(&(x[WS(rs, 8)]), ms, &(x[0]));
			 T33 = BYTWJ(&(W[TWVL * 14]), T32);
			 T34 = LD(&(x[WS(rs, 40)]), ms, &(x[0]));
			 T35 = BYTWJ(&(W[TWVL * 78]), T34);
			 T55 = VSUB(T33, T35);
			 T2X = LD(&(x[WS(rs, 56)]), ms, &(x[0]));
			 T2Y = BYTWJ(&(W[TWVL * 110]), T2X);
			 T2Z = LD(&(x[WS(rs, 24)]), ms, &(x[0]));
			 T30 = BYTWJ(&(W[TWVL * 46]), T2Z);
			 T56 = VSUB(T2Y, T30);
		    }
		    {
			 V T4, T9, T6j, T6k;
			 T4 = VADD(T1, T3);
			 T9 = VADD(T6, T8);
			 Ta = VSUB(T4, T9);
			 T3U = VADD(T4, T9);
			 T6j = VSUB(T6, T8);
			 T6k = VSUB(T56, T55);
			 T6l = VFNMS(LDK(KP707106781), T6k, T6j);
			 T7B = VFMA(LDK(KP707106781), T6k, T6j);
		    }
		    {
			 V T31, T36, T54, T57;
			 T31 = VADD(T2Y, T30);
			 T36 = VADD(T33, T35);
			 T37 = VSUB(T31, T36);
			 T3V = VADD(T36, T31);
			 T54 = VSUB(T1, T3);
			 T57 = VADD(T55, T56);
			 T58 = VFMA(LDK(KP707106781), T57, T54);
			 T7a = VFNMS(LDK(KP707106781), T57, T54);
		    }
	       }
	       {
		    V T1m, T1o, T1p, T1r, T1t, T1u, T1Y, T5C, T23, T5D, T41, T42;
		    {
			 V T1l, T1n, T1q, T1s;
			 T1l = LD(&(x[WS(rs, 1)]), ms, &(x[WS(rs, 1)]));
			 T1m = BYTWJ(&(W[0]), T1l);
			 T1n = LD(&(x[WS(rs, 33)]), ms, &(x[WS(rs, 1)]));
			 T1o = BYTWJ(&(W[TWVL * 64]), T1n);
			 T1p = VADD(T1m, T1o);
			 T1q = LD(&(x[WS(rs, 17)]), ms, &(x[WS(rs, 1)]));
			 T1r = BYTWJ(&(W[TWVL * 32]), T1q);
			 T1s = LD(&(x[WS(rs, 49)]), ms, &(x[WS(rs, 1)]));
			 T1t = BYTWJ(&(W[TWVL * 96]), T1s);
			 T1u = VADD(T1r, T1t);
		    }
		    {
			 V T1V, T1X, T1U, T1W;
			 T1U = LD(&(x[WS(rs, 9)]), ms, &(x[WS(rs, 1)]));
			 T1V = BYTWJ(&(W[TWVL * 16]), T1U);
			 T1W = LD(&(x[WS(rs, 41)]), ms, &(x[WS(rs, 1)]));
			 T1X = BYTWJ(&(W[TWVL * 80]), T1W);
			 T1Y = VADD(T1V, T1X);
			 T5C = VSUB(T1V, T1X);
		    }
		    {
			 V T20, T22, T1Z, T21;
			 T1Z = LD(&(x[WS(rs, 57)]), ms, &(x[WS(rs, 1)]));
			 T20 = BYTWJ(&(W[TWVL * 112]), T1Z);
			 T21 = LD(&(x[WS(rs, 25)]), ms, &(x[WS(rs, 1)]));
			 T22 = BYTWJ(&(W[TWVL * 48]), T21);
			 T23 = VADD(T20, T22);
			 T5D = VSUB(T20, T22);
		    }
		    T1v = VSUB(T1p, T1u);
		    T24 = VSUB(T1Y, T23);
		    T41 = VADD(T1p, T1u);
		    T42 = VADD(T1Y, T23);
		    T43 = VADD(T41, T42);
		    T4F = VSUB(T41, T42);
		    {
			 V T5B, T5E, T5O, T5P;
			 T5B = VSUB(T1m, T1o);
			 T5E = VADD(T5C, T5D);
			 T5F = VFMA(LDK(KP707106781), T5E, T5B);
			 T7l = VFNMS(LDK(KP707106781), T5E, T5B);
			 T5O = VSUB(T1r, T1t);
			 T5P = VSUB(T5C, T5D);
			 T5Q = VFMA(LDK(KP707106781), T5P, T5O);
			 T7o = VFNMS(LDK(KP707106781), T5P, T5O);
		    }
	       }
	       {
		    V T29, T2b, T2c, T2e, T2g, T2h, T2L, T5Y, T2Q, T5X, T48, T49;
		    {
			 V T28, T2a, T2d, T2f;
			 T28 = LD(&(x[WS(rs, 63)]), ms, &(x[WS(rs, 1)]));
			 T29 = BYTWJ(&(W[TWVL * 124]), T28);
			 T2a = LD(&(x[WS(rs, 31)]), ms, &(x[WS(rs, 1)]));
			 T2b = BYTWJ(&(W[TWVL * 60]), T2a);
			 T2c = VADD(T29, T2b);
			 T2d = LD(&(x[WS(rs, 15)]), ms, &(x[WS(rs, 1)]));
			 T2e = BYTWJ(&(W[TWVL * 28]), T2d);
			 T2f = LD(&(x[WS(rs, 47)]), ms, &(x[WS(rs, 1)]));
			 T2g = BYTWJ(&(W[TWVL * 92]), T2f);
			 T2h = VADD(T2e, T2g);
		    }
		    {
			 V T2I, T2K, T2H, T2J;
			 T2H = LD(&(x[WS(rs, 55)]), ms, &(x[WS(rs, 1)]));
			 T2I = BYTWJ(&(W[TWVL * 108]), T2H);
			 T2J = LD(&(x[WS(rs, 23)]), ms, &(x[WS(rs, 1)]));
			 T2K = BYTWJ(&(W[TWVL * 44]), T2J);
			 T2L = VADD(T2I, T2K);
			 T5Y = VSUB(T2I, T2K);
		    }
		    {
			 V T2N, T2P, T2M, T2O;
			 T2M = LD(&(x[WS(rs, 7)]), ms, &(x[WS(rs, 1)]));
			 T2N = BYTWJ(&(W[TWVL * 12]), T2M);
			 T2O = LD(&(x[WS(rs, 39)]), ms, &(x[WS(rs, 1)]));
			 T2P = BYTWJ(&(W[TWVL * 76]), T2O);
			 T2Q = VADD(T2N, T2P);
			 T5X = VSUB(T2N, T2P);
		    }
		    T2i = VSUB(T2c, T2h);
		    T2R = VSUB(T2L, T2Q);
		    T48 = VADD(T2c, T2h);
		    T49 = VADD(T2Q, T2L);
		    T4a = VADD(T48, T49);
		    T4I = VSUB(T48, T49);
		    {
			 V T5W, T5Z, T69, T6a;
			 T5W = VSUB(T29, T2b);
			 T5Z = VADD(T5X, T5Y);
			 T60 = VFMA(LDK(KP707106781), T5Z, T5W);
			 T7s = VFNMS(LDK(KP707106781), T5Z, T5W);
			 T69 = VSUB(T2g, T2e);
			 T6a = VSUB(T5Y, T5X);
			 T6b = VFMA(LDK(KP707106781), T6a, T69);
			 T7v = VFNMS(LDK(KP707106781), T6a, T69);
		    }
	       }
	       {
		    V TX, TZ, T10, T12, T14, T15, T1b, T5s, T1g, T5r, T5v, T5w;
		    {
			 V TW, TY, T11, T13;
			 TW = LD(&(x[WS(rs, 62)]), ms, &(x[0]));
			 TX = BYTWJ(&(W[TWVL * 122]), TW);
			 TY = LD(&(x[WS(rs, 30)]), ms, &(x[0]));
			 TZ = BYTWJ(&(W[TWVL * 58]), TY);
			 T10 = VADD(TX, TZ);
			 T11 = LD(&(x[WS(rs, 14)]), ms, &(x[0]));
			 T12 = BYTWJ(&(W[TWVL * 26]), T11);
			 T13 = LD(&(x[WS(rs, 46)]), ms, &(x[0]));
			 T14 = BYTWJ(&(W[TWVL * 90]), T13);
			 T15 = VADD(T12, T14);
		    }
		    {
			 V T18, T1a, T17, T19;
			 T17 = LD(&(x[WS(rs, 54)]), ms, &(x[0]));
			 T18 = BYTWJ(&(W[TWVL * 106]), T17);
			 T19 = LD(&(x[WS(rs, 22)]), ms, &(x[0]));
			 T1a = BYTWJ(&(W[TWVL * 42]), T19);
			 T1b = VADD(T18, T1a);
			 T5s = VSUB(T18, T1a);
		    }
		    {
			 V T1d, T1f, T1c, T1e;
			 T1c = LD(&(x[WS(rs, 6)]), ms, &(x[0]));
			 T1d = BYTWJ(&(W[TWVL * 10]), T1c);
			 T1e = LD(&(x[WS(rs, 38)]), ms, &(x[0]));
			 T1f = BYTWJ(&(W[TWVL * 74]), T1e);
			 T1g = VADD(T1d, T1f);
			 T5r = VSUB(T1d, T1f);
		    }
		    T4h = VADD(T10, T15);
		    T4i = VADD(T1g, T1b);
		    T4C = VSUB(T4h, T4i);
		    T5v = VSUB(T14, T12);
		    T5w = VSUB(T5s, T5r);
		    T5x = VFMA(LDK(KP707106781), T5w, T5v);
		    T7g = VFNMS(LDK(KP707106781), T5w, T5v);
		    {
			 V T16, T1h, T5q, T5t;
			 T16 = VSUB(T10, T15);
			 T1h = VSUB(T1b, T1g);
			 T1i = VFNMS(LDK(KP414213562), T1h, T16);
			 T3a = VFMA(LDK(KP414213562), T16, T1h);
			 T5q = VSUB(TX, TZ);
			 T5t = VADD(T5r, T5s);
			 T5u = VFMA(LDK(KP707106781), T5t, T5q);
			 T7h = VFNMS(LDK(KP707106781), T5t, T5q);
		    }
	       }
	       {
		    V TA, TC, TD, TF, TH, TI, TO, T5i, TT, T5j, T5m, T5n;
		    {
			 V Tz, TB, TE, TG;
			 Tz = LD(&(x[WS(rs, 2)]), ms, &(x[0]));
			 TA = BYTWJ(&(W[TWVL * 2]), Tz);
			 TB = LD(&(x[WS(rs, 34)]), ms, &(x[0]));
			 TC = BYTWJ(&(W[TWVL * 66]), TB);
			 TD = VADD(TA, TC);
			 TE = LD(&(x[WS(rs, 18)]), ms, &(x[0]));
			 TF = BYTWJ(&(W[TWVL * 34]), TE);
			 TG = LD(&(x[WS(rs, 50)]), ms, &(x[0]));
			 TH = BYTWJ(&(W[TWVL * 98]), TG);
			 TI = VADD(TF, TH);
		    }
		    {
			 V TL, TN, TK, TM;
			 TK = LD(&(x[WS(rs, 10)]), ms, &(x[0]));
			 TL = BYTWJ(&(W[TWVL * 18]), TK);
			 TM = LD(&(x[WS(rs, 42)]), ms, &(x[0]));
			 TN = BYTWJ(&(W[TWVL * 82]), TM);
			 TO = VADD(TL, TN);
			 T5i = VSUB(TL, TN);
		    }
		    {
			 V TQ, TS, TP, TR;
			 TP = LD(&(x[WS(rs, 58)]), ms, &(x[0]));
			 TQ = BYTWJ(&(W[TWVL * 114]), TP);
			 TR = LD(&(x[WS(rs, 26)]), ms, &(x[0]));
			 TS = BYTWJ(&(W[TWVL * 50]), TR);
			 TT = VADD(TQ, TS);
			 T5j = VSUB(TQ, TS);
		    }
		    T4k = VADD(TD, TI);
		    T4l = VADD(TO, TT);
		    T4B = VSUB(T4k, T4l);
		    T5m = VSUB(TF, TH);
		    T5n = VSUB(T5i, T5j);
		    T5o = VFMA(LDK(KP707106781), T5n, T5m);
		    T7d = VFNMS(LDK(KP707106781), T5n, T5m);
		    {
			 V TJ, TU, T5h, T5k;
			 TJ = VSUB(TD, TI);
			 TU = VSUB(TO, TT);
			 TV = VFNMS(LDK(KP414213562), TU, TJ);
			 T3b = VFMA(LDK(KP414213562), TJ, TU);
			 T5h = VSUB(TA, TC);
			 T5k = VADD(T5i, T5j);
			 T5l = VFMA(LDK(KP707106781), T5k, T5h);
			 T7e = VFNMS(LDK(KP707106781), T5k, T5h);
		    }
	       }
	       {
		    V Tf, T59, Tv, T5d, Tk, T5a, Tq, T5c, Tl, Tw;
		    {
			 V Tc, Te, Tb, Td;
			 Tb = LD(&(x[WS(rs, 4)]), ms, &(x[0]));
			 Tc = BYTWJ(&(W[TWVL * 6]), Tb);
			 Td = LD(&(x[WS(rs, 36)]), ms, &(x[0]));
			 Te = BYTWJ(&(W[TWVL * 70]), Td);
			 Tf = VADD(Tc, Te);
			 T59 = VSUB(Tc, Te);
		    }
		    {
			 V Ts, Tu, Tr, Tt;
			 Tr = LD(&(x[WS(rs, 12)]), ms, &(x[0]));
			 Ts = BYTWJ(&(W[TWVL * 22]), Tr);
			 Tt = LD(&(x[WS(rs, 44)]), ms, &(x[0]));
			 Tu = BYTWJ(&(W[TWVL * 86]), Tt);
			 Tv = VADD(Ts, Tu);
			 T5d = VSUB(Tu, Ts);
		    }
		    {
			 V Th, Tj, Tg, Ti;
			 Tg = LD(&(x[WS(rs, 20)]), ms, &(x[0]));
			 Th = BYTWJ(&(W[TWVL * 38]), Tg);
			 Ti = LD(&(x[WS(rs, 52)]), ms, &(x[0]));
			 Tj = BYTWJ(&(W[TWVL * 102]), Ti);
			 Tk = VADD(Th, Tj);
			 T5a = VSUB(Th, Tj);
		    }
		    {
			 V Tn, Tp, Tm, To;
			 Tm = LD(&(x[WS(rs, 60)]), ms, &(x[0]));
			 Tn = BYTWJ(&(W[TWVL * 118]), Tm);
			 To = LD(&(x[WS(rs, 28)]), ms, &(x[0]));
			 Tp = BYTWJ(&(W[TWVL * 54]), To);
			 Tq = VADD(Tn, Tp);
			 T5c = VSUB(Tn, Tp);
		    }
		    T3X = VADD(Tf, Tk);
		    T3Y = VADD(Tq, Tv);
		    Tl = VSUB(Tf, Tk);
		    Tw = VSUB(Tq, Tv);
		    Tx = VADD(Tl, Tw);
		    T38 = VSUB(Tw, Tl);
		    {
			 V T5b, T5e, T6m, T6n;
			 T5b = VFNMS(LDK(KP414213562), T5a, T59);
			 T5e = VFNMS(LDK(KP414213562), T5d, T5c);
			 T5f = VADD(T5b, T5e);
			 T7C = VSUB(T5e, T5b);
			 T6m = VFMA(LDK(KP414213562), T59, T5a);
			 T6n = VFMA(LDK(KP414213562), T5c, T5d);
			 T6o = VSUB(T6m, T6n);
			 T7b = VADD(T6m, T6n);
		    }
	       }
	       {
		    V T1A, T5G, T1Q, T5K, T1F, T5H, T1L, T5J;
		    {
			 V T1x, T1z, T1w, T1y;
			 T1w = LD(&(x[WS(rs, 5)]), ms, &(x[WS(rs, 1)]));
			 T1x = BYTWJ(&(W[TWVL * 8]), T1w);
			 T1y = LD(&(x[WS(rs, 37)]), ms, &(x[WS(rs, 1)]));
			 T1z = BYTWJ(&(W[TWVL * 72]), T1y);
			 T1A = VADD(T1x, T1z);
			 T5G = VSUB(T1x, T1z);
		    }
		    {
			 V T1N, T1P, T1M, T1O;
			 T1M = LD(&(x[WS(rs, 13)]), ms, &(x[WS(rs, 1)]));
			 T1N = BYTWJ(&(W[TWVL * 24]), T1M);
			 T1O = LD(&(x[WS(rs, 45)]), ms, &(x[WS(rs, 1)]));
			 T1P = BYTWJ(&(W[TWVL * 88]), T1O);
			 T1Q = VADD(T1N, T1P);
			 T5K = VSUB(T1N, T1P);
		    }
		    {
			 V T1C, T1E, T1B, T1D;
			 T1B = LD(&(x[WS(rs, 21)]), ms, &(x[WS(rs, 1)]));
			 T1C = BYTWJ(&(W[TWVL * 40]), T1B);
			 T1D = LD(&(x[WS(rs, 53)]), ms, &(x[WS(rs, 1)]));
			 T1E = BYTWJ(&(W[TWVL * 104]), T1D);
			 T1F = VADD(T1C, T1E);
			 T5H = VSUB(T1C, T1E);
		    }
		    {
			 V T1I, T1K, T1H, T1J;
			 T1H = LD(&(x[WS(rs, 61)]), ms, &(x[WS(rs, 1)]));
			 T1I = BYTWJ(&(W[TWVL * 120]), T1H);
			 T1J = LD(&(x[WS(rs, 29)]), ms, &(x[WS(rs, 1)]));
			 T1K = BYTWJ(&(W[TWVL * 56]), T1J);
			 T1L = VADD(T1I, T1K);
			 T5J = VSUB(T1I, T1K);
		    }
		    {
			 V T1G, T1R, T5R, T5S;
			 T1G = VSUB(T1A, T1F);
			 T1R = VSUB(T1L, T1Q);
			 T1S = VADD(T1G, T1R);
			 T25 = VSUB(T1G, T1R);
			 T5R = VFMA(LDK(KP414213562), T5G, T5H);
			 T5S = VFNMS(LDK(KP414213562), T5J, T5K);
			 T5T = VADD(T5R, T5S);
			 T7m = VSUB(T5R, T5S);
		    }
		    {
			 V T44, T45, T5I, T5L;
			 T44 = VADD(T1A, T1F);
			 T45 = VADD(T1L, T1Q);
			 T46 = VADD(T44, T45);
			 T4G = VSUB(T44, T45);
			 T5I = VFNMS(LDK(KP414213562), T5H, T5G);
			 T5L = VFMA(LDK(KP414213562), T5K, T5J);
			 T5M = VADD(T5I, T5L);
			 T7p = VSUB(T5I, T5L);
		    }
	       }
	       {
		    V T2n, T61, T2D, T65, T2s, T62, T2y, T64;
		    {
			 V T2k, T2m, T2j, T2l;
			 T2j = LD(&(x[WS(rs, 3)]), ms, &(x[WS(rs, 1)]));
			 T2k = BYTWJ(&(W[TWVL * 4]), T2j);
			 T2l = LD(&(x[WS(rs, 35)]), ms, &(x[WS(rs, 1)]));
			 T2m = BYTWJ(&(W[TWVL * 68]), T2l);
			 T2n = VADD(T2k, T2m);
			 T61 = VSUB(T2k, T2m);
		    }
		    {
			 V T2A, T2C, T2z, T2B;
			 T2z = LD(&(x[WS(rs, 11)]), ms, &(x[WS(rs, 1)]));
			 T2A = BYTWJ(&(W[TWVL * 20]), T2z);
			 T2B = LD(&(x[WS(rs, 43)]), ms, &(x[WS(rs, 1)]));
			 T2C = BYTWJ(&(W[TWVL * 84]), T2B);
			 T2D = VADD(T2A, T2C);
			 T65 = VSUB(T2C, T2A);
		    }
		    {
			 V T2p, T2r, T2o, T2q;
			 T2o = LD(&(x[WS(rs, 19)]), ms, &(x[WS(rs, 1)]));
			 T2p = BYTWJ(&(W[TWVL * 36]), T2o);
			 T2q = LD(&(x[WS(rs, 51)]), ms, &(x[WS(rs, 1)]));
			 T2r = BYTWJ(&(W[TWVL * 100]), T2q);
			 T2s = VADD(T2p, T2r);
			 T62 = VSUB(T2r, T2p);
		    }
		    {
			 V T2v, T2x, T2u, T2w;
			 T2u = LD(&(x[WS(rs, 59)]), ms, &(x[WS(rs, 1)]));
			 T2v = BYTWJ(&(W[TWVL * 116]), T2u);
			 T2w = LD(&(x[WS(rs, 27)]), ms, &(x[WS(rs, 1)]));
			 T2x = BYTWJ(&(W[TWVL * 52]), T2w);
			 T2y = VADD(T2v, T2x);
			 T64 = VSUB(T2v, T2x);
		    }
		    {
			 V T2t, T2E, T6c, T6d;
			 T2t = VSUB(T2n, T2s);
			 T2E = VSUB(T2y, T2D);
			 T2F = VADD(T2t, T2E);
			 T2S = VSUB(T2E, T2t);
			 T6c = VFNMS(LDK(KP414213562), T61, T62);
			 T6d = VFMA(LDK(KP414213562), T64, T65);
			 T6e = VADD(T6c, T6d);
			 T7t = VSUB(T6d, T6c);
		    }
		    {
			 V T4b, T4c, T63, T66;
			 T4b = VADD(T2n, T2s);
			 T4c = VADD(T2y, T2D);
			 T4d = VADD(T4b, T4c);
			 T4J = VSUB(T4c, T4b);
			 T63 = VFMA(LDK(KP414213562), T62, T61);
			 T66 = VFNMS(LDK(KP414213562), T65, T64);
			 T67 = VADD(T63, T66);
			 T7w = VSUB(T66, T63);
		    }
	       }
	       {
		    V T40, T4s, T4x, T4z, T4f, T4o, T4n, T4t, T4u, T4y;
		    {
			 V T3W, T3Z, T4v, T4w;
			 T3W = VADD(T3U, T3V);
			 T3Z = VADD(T3X, T3Y);
			 T40 = VSUB(T3W, T3Z);
			 T4s = VADD(T3W, T3Z);
			 T4v = VADD(T43, T46);
			 T4w = VADD(T4a, T4d);
			 T4x = VADD(T4v, T4w);
			 T4z = VSUB(T4w, T4v);
		    }
		    {
			 V T47, T4e, T4j, T4m;
			 T47 = VSUB(T43, T46);
			 T4e = VSUB(T4a, T4d);
			 T4f = VADD(T47, T4e);
			 T4o = VSUB(T4e, T47);
			 T4j = VADD(T4h, T4i);
			 T4m = VADD(T4k, T4l);
			 T4n = VSUB(T4j, T4m);
			 T4t = VADD(T4m, T4j);
		    }
		    T4u = VADD(T4s, T4t);
		    ST(&(x[WS(rs, 32)]), VSUB(T4u, T4x), ms, &(x[0]));
		    ST(&(x[0]), VADD(T4u, T4x), ms, &(x[0]));
		    T4y = VSUB(T4s, T4t);
		    ST(&(x[WS(rs, 48)]), VFNMSI(T4z, T4y), ms, &(x[0]));
		    ST(&(x[WS(rs, 16)]), VFMAI(T4z, T4y), ms, &(x[0]));
		    {
			 V T4g, T4p, T4q, T4r;
			 T4g = VFNMS(LDK(KP707106781), T4f, T40);
			 T4p = VFNMS(LDK(KP707106781), T4o, T4n);
			 ST(&(x[WS(rs, 24)]), VFNMSI(T4p, T4g), ms, &(x[0]));
			 ST(&(x[WS(rs, 40)]), VFMAI(T4p, T4g), ms, &(x[0]));
			 T4q = VFMA(LDK(KP707106781), T4f, T40);
			 T4r = VFMA(LDK(KP707106781), T4o, T4n);
			 ST(&(x[WS(rs, 56)]), VFNMSI(T4r, T4q), ms, &(x[0]));
			 ST(&(x[WS(rs, 8)]), VFMAI(T4r, T4q), ms, &(x[0]));
		    }
	       }
	       {
		    V T4E, T4W, T4S, T4X, T4L, T50, T4P, T4Z;
		    {
			 V T4A, T4D, T4Q, T4R;
			 T4A = VSUB(T3U, T3V);
			 T4D = VADD(T4B, T4C);
			 T4E = VFMA(LDK(KP707106781), T4D, T4A);
			 T4W = VFNMS(LDK(KP707106781), T4D, T4A);
			 T4Q = VFMA(LDK(KP414213562), T4I, T4J);
			 T4R = VFMA(LDK(KP414213562), T4F, T4G);
			 T4S = VSUB(T4Q, T4R);
			 T4X = VADD(T4R, T4Q);
		    }
		    {
			 V T4H, T4K, T4N, T4O;
			 T4H = VFNMS(LDK(KP414213562), T4G, T4F);
			 T4K = VFNMS(LDK(KP414213562), T4J, T4I);
			 T4L = VADD(T4H, T4K);
			 T50 = VSUB(T4K, T4H);
			 T4N = VSUB(T3Y, T3X);
			 T4O = VSUB(T4C, T4B);
			 T4P = VFMA(LDK(KP707106781), T4O, T4N);
			 T4Z = VFNMS(LDK(KP707106781), T4O, T4N);
		    }
		    {
			 V T4M, T4T, T52, T53;
			 T4M = VFNMS(LDK(KP923879532), T4L, T4E);
			 T4T = VFNMS(LDK(KP923879532), T4S, T4P);
			 ST(&(x[WS(rs, 28)]), VFNMSI(T4T, T4M), ms, &(x[0]));
			 ST(&(x[WS(rs, 36)]), VFMAI(T4T, T4M), ms, &(x[0]));
			 T52 = VFMA(LDK(KP923879532), T4X, T4W);
			 T53 = VFNMS(LDK(KP923879532), T50, T4Z);
			 ST(&(x[WS(rs, 12)]), VFNMSI(T53, T52), ms, &(x[0]));
			 ST(&(x[WS(rs, 52)]), VFMAI(T53, T52), ms, &(x[0]));
		    }
		    {
			 V T4U, T4V, T4Y, T51;
			 T4U = VFMA(LDK(KP923879532), T4L, T4E);
			 T4V = VFMA(LDK(KP923879532), T4S, T4P);
			 ST(&(x[WS(rs, 60)]), VFNMSI(T4V, T4U), ms, &(x[0]));
			 ST(&(x[WS(rs, 4)]), VFMAI(T4V, T4U), ms, &(x[0]));
			 T4Y = VFNMS(LDK(KP923879532), T4X, T4W);
			 T51 = VFMA(LDK(KP923879532), T50, T4Z);
			 ST(&(x[WS(rs, 20)]), VFMAI(T51, T4Y), ms, &(x[0]));
			 ST(&(x[WS(rs, 44)]), VFNMSI(T51, T4Y), ms, &(x[0]));
		    }
	       }
	       {
		    V T1k, T3k, T3d, T3n, T2V, T3o, T3g, T3l;
		    {
			 V Ty, T1j, T39, T3c;
			 Ty = VFMA(LDK(KP707106781), Tx, Ta);
			 T1j = VADD(TV, T1i);
			 T1k = VFMA(LDK(KP923879532), T1j, Ty);
			 T3k = VFNMS(LDK(KP923879532), T1j, Ty);
			 T39 = VFMA(LDK(KP707106781), T38, T37);
			 T3c = VSUB(T3a, T3b);
			 T3d = VFMA(LDK(KP923879532), T3c, T39);
			 T3n = VFNMS(LDK(KP923879532), T3c, T39);
			 {
			      V T27, T3f, T2U, T3e;
			      {
				   V T1T, T26, T2G, T2T;
				   T1T = VFMA(LDK(KP707106781), T1S, T1v);
				   T26 = VFMA(LDK(KP707106781), T25, T24);
				   T27 = VFNMS(LDK(KP198912367), T26, T1T);
				   T3f = VFMA(LDK(KP198912367), T1T, T26);
				   T2G = VFMA(LDK(KP707106781), T2F, T2i);
				   T2T = VFMA(LDK(KP707106781), T2S, T2R);
				   T2U = VFNMS(LDK(KP198912367), T2T, T2G);
				   T3e = VFMA(LDK(KP198912367), T2G, T2T);
			      }
			      T2V = VADD(T27, T2U);
			      T3o = VSUB(T2U, T27);
			      T3g = VSUB(T3e, T3f);
			      T3l = VADD(T3f, T3e);
			 }
		    }
		    {
			 V T2W, T3h, T3q, T3r;
			 T2W = VFNMS(LDK(KP980785280), T2V, T1k);
			 T3h = VFNMS(LDK(KP980785280), T3g, T3d);
			 ST(&(x[WS(rs, 30)]), VFNMSI(T3h, T2W), ms, &(x[0]));
			 ST(&(x[WS(rs, 34)]), VFMAI(T3h, T2W), ms, &(x[0]));
			 T3q = VFMA(LDK(KP980785280), T3l, T3k);
			 T3r = VFNMS(LDK(KP980785280), T3o, T3n);
			 ST(&(x[WS(rs, 14)]), VFNMSI(T3r, T3q), ms, &(x[0]));
			 ST(&(x[WS(rs, 50)]), VFMAI(T3r, T3q), ms, &(x[0]));
		    }
		    {
			 V T3i, T3j, T3m, T3p;
			 T3i = VFMA(LDK(KP980785280), T2V, T1k);
			 T3j = VFMA(LDK(KP980785280), T3g, T3d);
			 ST(&(x[WS(rs, 62)]), VFNMSI(T3j, T3i), ms, &(x[0]));
			 ST(&(x[WS(rs, 2)]), VFMAI(T3j, T3i), ms, &(x[0]));
			 T3m = VFNMS(LDK(KP980785280), T3l, T3k);
			 T3p = VFMA(LDK(KP980785280), T3o, T3n);
			 ST(&(x[WS(rs, 18)]), VFMAI(T3p, T3m), ms, &(x[0]));
			 ST(&(x[WS(rs, 46)]), VFNMSI(T3p, T3m), ms, &(x[0]));
		    }
	       }
	       {
		    V T3u, T3M, T3F, T3P, T3B, T3Q, T3I, T3N;
		    {
			 V T3s, T3t, T3D, T3E;
			 T3s = VFNMS(LDK(KP707106781), Tx, Ta);
			 T3t = VADD(T3b, T3a);
			 T3u = VFMA(LDK(KP923879532), T3t, T3s);
			 T3M = VFNMS(LDK(KP923879532), T3t, T3s);
			 T3D = VFNMS(LDK(KP707106781), T38, T37);
			 T3E = VSUB(T1i, TV);
			 T3F = VFNMS(LDK(KP923879532), T3E, T3D);
			 T3P = VFMA(LDK(KP923879532), T3E, T3D);
			 {
			      V T3x, T3H, T3A, T3G;
			      {
				   V T3v, T3w, T3y, T3z;
				   T3v = VFNMS(LDK(KP707106781), T1S, T1v);
				   T3w = VFNMS(LDK(KP707106781), T25, T24);
				   T3x = VFMA(LDK(KP668178637), T3w, T3v);
				   T3H = VFNMS(LDK(KP668178637), T3v, T3w);
				   T3y = VFNMS(LDK(KP707106781), T2F, T2i);
				   T3z = VFNMS(LDK(KP707106781), T2S, T2R);
				   T3A = VFMA(LDK(KP668178637), T3z, T3y);
				   T3G = VFNMS(LDK(KP668178637), T3y, T3z);
			      }
			      T3B = VADD(T3x, T3A);
			      T3Q = VSUB(T3A, T3x);
			      T3I = VSUB(T3G, T3H);
			      T3N = VADD(T3H, T3G);
			 }
		    }
		    {
			 V T3C, T3J, T3S, T3T;
			 T3C = VFNMS(LDK(KP831469612), T3B, T3u);
			 T3J = VFNMS(LDK(KP831469612), T3I, T3F);
			 ST(&(x[WS(rs, 38)]), VFNMSI(T3J, T3C), ms, &(x[0]));
			 ST(&(x[WS(rs, 26)]), VFMAI(T3J, T3C), ms, &(x[0]));
			 T3S = VFNMS(LDK(KP831469612), T3N, T3M);
			 T3T = VFMA(LDK(KP831469612), T3Q, T3P);
			 ST(&(x[WS(rs, 10)]), VFMAI(T3T, T3S), ms, &(x[0]));
			 ST(&(x[WS(rs, 54)]), VFNMSI(T3T, T3S), ms, &(x[0]));
		    }
		    {
			 V T3K, T3L, T3O, T3R;
			 T3K = VFMA(LDK(KP831469612), T3B, T3u);
			 T3L = VFMA(LDK(KP831469612), T3I, T3F);
			 ST(&(x[WS(rs, 6)]), VFNMSI(T3L, T3K), ms, &(x[0]));
			 ST(&(x[WS(rs, 58)]), VFMAI(T3L, T3K), ms, &(x[0]));
			 T3O = VFMA(LDK(KP831469612), T3N, T3M);
			 T3R = VFNMS(LDK(KP831469612), T3Q, T3P);
			 ST(&(x[WS(rs, 22)]), VFNMSI(T3R, T3O), ms, &(x[0]));
			 ST(&(x[WS(rs, 42)]), VFMAI(T3R, T3O), ms, &(x[0]));
		    }
	       }
	       {
		    V T7k, T8j, T7O, T89, T7H, T8g, T7R, T7Y, T7z, T7S, T7K, T7P, T85, T8k, T8c;
		    V T8h;
		    {
			 V T7c, T87, T7j, T88, T7f, T7i;
			 T7c = VFNMS(LDK(KP923879532), T7b, T7a);
			 T87 = VFMA(LDK(KP923879532), T7C, T7B);
			 T7f = VFNMS(LDK(KP668178637), T7e, T7d);
			 T7i = VFNMS(LDK(KP668178637), T7h, T7g);
			 T7j = VADD(T7f, T7i);
			 T88 = VSUB(T7f, T7i);
			 T7k = VFNMS(LDK(KP831469612), T7j, T7c);
			 T8j = VFNMS(LDK(KP831469612), T88, T87);
			 T7O = VFMA(LDK(KP831469612), T7j, T7c);
			 T89 = VFMA(LDK(KP831469612), T88, T87);
		    }
		    {
			 V T7D, T7W, T7G, T7X, T7E, T7F;
			 T7D = VFNMS(LDK(KP923879532), T7C, T7B);
			 T7W = VFMA(LDK(KP923879532), T7b, T7a);
			 T7E = VFMA(LDK(KP668178637), T7g, T7h);
			 T7F = VFMA(LDK(KP668178637), T7d, T7e);
			 T7G = VSUB(T7E, T7F);
			 T7X = VADD(T7F, T7E);
			 T7H = VFNMS(LDK(KP831469612), T7G, T7D);
			 T8g = VFNMS(LDK(KP831469612), T7X, T7W);
			 T7R = VFMA(LDK(KP831469612), T7G, T7D);
			 T7Y = VFMA(LDK(KP831469612), T7X, T7W);
		    }
		    {
			 V T7r, T7I, T7y, T7J;
			 {
			      V T7n, T7q, T7u, T7x;
			      T7n = VFNMS(LDK(KP923879532), T7m, T7l);
			      T7q = VFMA(LDK(KP923879532), T7p, T7o);
			      T7r = VFNMS(LDK(KP534511135), T7q, T7n);
			      T7I = VFMA(LDK(KP534511135), T7n, T7q);
			      T7u = VFNMS(LDK(KP923879532), T7t, T7s);
			      T7x = VFMA(LDK(KP923879532), T7w, T7v);
			      T7y = VFNMS(LDK(KP534511135), T7x, T7u);
			      T7J = VFMA(LDK(KP534511135), T7u, T7x);
			 }
			 T7z = VADD(T7r, T7y);
			 T7S = VSUB(T7y, T7r);
			 T7K = VSUB(T7I, T7J);
			 T7P = VADD(T7I, T7J);
		    }
		    {
			 V T81, T8a, T84, T8b;
			 {
			      V T7Z, T80, T82, T83;
			      T7Z = VFMA(LDK(KP923879532), T7m, T7l);
			      T80 = VFNMS(LDK(KP923879532), T7p, T7o);
			      T81 = VFMA(LDK(KP303346683), T80, T7Z);
			      T8a = VFNMS(LDK(KP303346683), T7Z, T80);
			      T82 = VFMA(LDK(KP923879532), T7t, T7s);
			      T83 = VFNMS(LDK(KP923879532), T7w, T7v);
			      T84 = VFMA(LDK(KP303346683), T83, T82);
			      T8b = VFNMS(LDK(KP303346683), T82, T83);
			 }
			 T85 = VADD(T81, T84);
			 T8k = VSUB(T84, T81);
			 T8c = VSUB(T8a, T8b);
			 T8h = VADD(T8a, T8b);
		    }
		    {
			 V T7A, T7L, T8i, T8l;
			 T7A = VFNMS(LDK(KP881921264), T7z, T7k);
			 T7L = VFNMS(LDK(KP881921264), T7K, T7H);
			 ST(&(x[WS(rs, 37)]), VFNMSI(T7L, T7A), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 27)]), VFMAI(T7L, T7A), ms, &(x[WS(rs, 1)]));
			 T8i = VFMA(LDK(KP956940335), T8h, T8g);
			 T8l = VFMA(LDK(KP956940335), T8k, T8j);
			 ST(&(x[WS(rs, 19)]), VFMAI(T8l, T8i), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 45)]), VFNMSI(T8l, T8i), ms, &(x[WS(rs, 1)]));
		    }
		    {
			 V T8m, T8n, T7M, T7N;
			 T8m = VFNMS(LDK(KP956940335), T8h, T8g);
			 T8n = VFNMS(LDK(KP956940335), T8k, T8j);
			 ST(&(x[WS(rs, 13)]), VFNMSI(T8n, T8m), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 51)]), VFMAI(T8n, T8m), ms, &(x[WS(rs, 1)]));
			 T7M = VFMA(LDK(KP881921264), T7z, T7k);
			 T7N = VFMA(LDK(KP881921264), T7K, T7H);
			 ST(&(x[WS(rs, 5)]), VFNMSI(T7N, T7M), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 59)]), VFMAI(T7N, T7M), ms, &(x[WS(rs, 1)]));
		    }
		    {
			 V T7Q, T7T, T86, T8d;
			 T7Q = VFNMS(LDK(KP881921264), T7P, T7O);
			 T7T = VFNMS(LDK(KP881921264), T7S, T7R);
			 ST(&(x[WS(rs, 21)]), VFNMSI(T7T, T7Q), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 43)]), VFMAI(T7T, T7Q), ms, &(x[WS(rs, 1)]));
			 T86 = VFNMS(LDK(KP956940335), T85, T7Y);
			 T8d = VFNMS(LDK(KP956940335), T8c, T89);
			 ST(&(x[WS(rs, 29)]), VFNMSI(T8d, T86), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 35)]), VFMAI(T8d, T86), ms, &(x[WS(rs, 1)]));
		    }
		    {
			 V T8e, T8f, T7U, T7V;
			 T8e = VFMA(LDK(KP956940335), T85, T7Y);
			 T8f = VFMA(LDK(KP956940335), T8c, T89);
			 ST(&(x[WS(rs, 61)]), VFNMSI(T8f, T8e), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 3)]), VFMAI(T8f, T8e), ms, &(x[WS(rs, 1)]));
			 T7U = VFMA(LDK(KP881921264), T7P, T7O);
			 T7V = VFMA(LDK(KP881921264), T7S, T7R);
			 ST(&(x[WS(rs, 11)]), VFMAI(T7V, T7U), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 53)]), VFNMSI(T7V, T7U), ms, &(x[WS(rs, 1)]));
		    }
	       }
	       {
		    V T5A, T75, T6A, T6V, T6t, T72, T6D, T6K, T6h, T6E, T6w, T6B, T6R, T76, T6Y;
		    V T73;
		    {
			 V T5g, T6T, T5z, T6U, T5p, T5y;
			 T5g = VFMA(LDK(KP923879532), T5f, T58);
			 T6T = VFNMS(LDK(KP923879532), T6o, T6l);
			 T5p = VFNMS(LDK(KP198912367), T5o, T5l);
			 T5y = VFNMS(LDK(KP198912367), T5x, T5u);
			 T5z = VADD(T5p, T5y);
			 T6U = VSUB(T5y, T5p);
			 T5A = VFMA(LDK(KP980785280), T5z, T5g);
			 T75 = VFNMS(LDK(KP980785280), T6U, T6T);
			 T6A = VFNMS(LDK(KP980785280), T5z, T5g);
			 T6V = VFMA(LDK(KP980785280), T6U, T6T);
		    }
		    {
			 V T6p, T6I, T6s, T6J, T6q, T6r;
			 T6p = VFMA(LDK(KP923879532), T6o, T6l);
			 T6I = VFNMS(LDK(KP923879532), T5f, T58);
			 T6q = VFMA(LDK(KP198912367), T5l, T5o);
			 T6r = VFMA(LDK(KP198912367), T5u, T5x);
			 T6s = VSUB(T6q, T6r);
			 T6J = VADD(T6q, T6r);
			 T6t = VFMA(LDK(KP980785280), T6s, T6p);
			 T72 = VFNMS(LDK(KP980785280), T6J, T6I);
			 T6D = VFNMS(LDK(KP980785280), T6s, T6p);
			 T6K = VFMA(LDK(KP980785280), T6J, T6I);
		    }
		    {
			 V T5V, T6u, T6g, T6v;
			 {
			      V T5N, T5U, T68, T6f;
			      T5N = VFMA(LDK(KP923879532), T5M, T5F);
			      T5U = VFMA(LDK(KP923879532), T5T, T5Q);
			      T5V = VFNMS(LDK(KP098491403), T5U, T5N);
			      T6u = VFMA(LDK(KP098491403), T5N, T5U);
			      T68 = VFMA(LDK(KP923879532), T67, T60);
			      T6f = VFMA(LDK(KP923879532), T6e, T6b);
			      T6g = VFNMS(LDK(KP098491403), T6f, T68);
			      T6v = VFMA(LDK(KP098491403), T68, T6f);
			 }
			 T6h = VADD(T5V, T6g);
			 T6E = VSUB(T6g, T5V);
			 T6w = VSUB(T6u, T6v);
			 T6B = VADD(T6u, T6v);
		    }
		    {
			 V T6N, T6W, T6Q, T6X;
			 {
			      V T6L, T6M, T6O, T6P;
			      T6L = VFNMS(LDK(KP923879532), T5M, T5F);
			      T6M = VFNMS(LDK(KP923879532), T5T, T5Q);
			      T6N = VFMA(LDK(KP820678790), T6M, T6L);
			      T6W = VFNMS(LDK(KP820678790), T6L, T6M);
			      T6O = VFNMS(LDK(KP923879532), T67, T60);
			      T6P = VFNMS(LDK(KP923879532), T6e, T6b);
			      T6Q = VFMA(LDK(KP820678790), T6P, T6O);
			      T6X = VFNMS(LDK(KP820678790), T6O, T6P);
			 }
			 T6R = VADD(T6N, T6Q);
			 T76 = VSUB(T6Q, T6N);
			 T6Y = VSUB(T6W, T6X);
			 T73 = VADD(T6W, T6X);
		    }
		    {
			 V T6i, T6x, T74, T77;
			 T6i = VFNMS(LDK(KP995184726), T6h, T5A);
			 T6x = VFNMS(LDK(KP995184726), T6w, T6t);
			 ST(&(x[WS(rs, 33)]), VFNMSI(T6x, T6i), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 31)]), VFMAI(T6x, T6i), ms, &(x[WS(rs, 1)]));
			 T74 = VFMA(LDK(KP773010453), T73, T72);
			 T77 = VFMA(LDK(KP773010453), T76, T75);
			 ST(&(x[WS(rs, 23)]), VFMAI(T77, T74), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 41)]), VFNMSI(T77, T74), ms, &(x[WS(rs, 1)]));
		    }
		    {
			 V T78, T79, T6y, T6z;
			 T78 = VFNMS(LDK(KP773010453), T73, T72);
			 T79 = VFNMS(LDK(KP773010453), T76, T75);
			 ST(&(x[WS(rs, 9)]), VFNMSI(T79, T78), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 55)]), VFMAI(T79, T78), ms, &(x[WS(rs, 1)]));
			 T6y = VFMA(LDK(KP995184726), T6h, T5A);
			 T6z = VFMA(LDK(KP995184726), T6w, T6t);
			 ST(&(x[WS(rs, 1)]), VFNMSI(T6z, T6y), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 63)]), VFMAI(T6z, T6y), ms, &(x[WS(rs, 1)]));
		    }
		    {
			 V T6C, T6F, T6S, T6Z;
			 T6C = VFNMS(LDK(KP995184726), T6B, T6A);
			 T6F = VFNMS(LDK(KP995184726), T6E, T6D);
			 ST(&(x[WS(rs, 17)]), VFNMSI(T6F, T6C), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 47)]), VFMAI(T6F, T6C), ms, &(x[WS(rs, 1)]));
			 T6S = VFNMS(LDK(KP773010453), T6R, T6K);
			 T6Z = VFNMS(LDK(KP773010453), T6Y, T6V);
			 ST(&(x[WS(rs, 25)]), VFNMSI(T6Z, T6S), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 39)]), VFMAI(T6Z, T6S), ms, &(x[WS(rs, 1)]));
		    }
		    {
			 V T70, T71, T6G, T6H;
			 T70 = VFMA(LDK(KP773010453), T6R, T6K);
			 T71 = VFMA(LDK(KP773010453), T6Y, T6V);
			 ST(&(x[WS(rs, 57)]), VFNMSI(T71, T70), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 7)]), VFMAI(T71, T70), ms, &(x[WS(rs, 1)]));
			 T6G = VFMA(LDK(KP995184726), T6B, T6A);
			 T6H = VFMA(LDK(KP995184726), T6E, T6D);
			 ST(&(x[WS(rs, 15)]), VFMAI(T6H, T6G), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 49)]), VFNMSI(T6H, T6G), ms, &(x[WS(rs, 1)]));
		    }
	       }
	  }
     }
     VLEAVE();
}

static const tw_instr twinstr[] = {
     VTW(0, 1),
     VTW(0, 2),
     VTW(0, 3),
     VTW(0, 4),
     VTW(0, 5),
     VTW(0, 6),
     VTW(0, 7),
     VTW(0, 8),
     VTW(0, 9),
     VTW(0, 10),
     VTW(0, 11),
     VTW(0, 12),
     VTW(0, 13),
     VTW(0, 14),
     VTW(0, 15),
     VTW(0, 16),
     VTW(0, 17),
     VTW(0, 18),
     VTW(0, 19),
     VTW(0, 20),
     VTW(0, 21),
     VTW(0, 22),
     VTW(0, 23),
     VTW(0, 24),
     VTW(0, 25),
     VTW(0, 26),
     VTW(0, 27),
     VTW(0, 28),
     VTW(0, 29),
     VTW(0, 30),
     VTW(0, 31),
     VTW(0, 32),
     VTW(0, 33),
     VTW(0, 34),
     VTW(0, 35),
     VTW(0, 36),
     VTW(0, 37),
     VTW(0, 38),
     VTW(0, 39),
     VTW(0, 40),
     VTW(0, 41),
     VTW(0, 42),
     VTW(0, 43),
     VTW(0, 44),
     VTW(0, 45),
     VTW(0, 46),
     VTW(0, 47),
     VTW(0, 48),
     VTW(0, 49),
     VTW(0, 50),
     VTW(0, 51),
     VTW(0, 52),
     VTW(0, 53),
     VTW(0, 54),
     VTW(0, 55),
     VTW(0, 56),
     VTW(0, 57),
     VTW(0, 58),
     VTW(0, 59),
     VTW(0, 60),
     VTW(0, 61),
     VTW(0, 62),
     VTW(0, 63),
     { TW_NEXT, VL, 0 }
};

static const ct_desc desc = { 64, XSIMD_STRING("t2fv_64"), twinstr, &GENUS, { 261, 126, 258, 0 }, 0, 0, 0 };

void XSIMD(codelet_t2fv_64) (planner *p) {
     X(kdft_dit_register) (p, t2fv_64, &desc);
}
#else

/* Generated by: ../../../genfft/gen_twiddle_c.native -simd -compact -variables 4 -pipeline-latency 8 -n 64 -name t2fv_64 -include dft/simd/t2f.h */

/*
 * This function contains 519 FP additions, 250 FP multiplications,
 * (or, 467 additions, 198 multiplications, 52 fused multiply/add),
 * 107 stack variables, 15 constants, and 128 memory accesses
 */
#include "dft/simd/t2f.h"

static void t2fv_64(R *ri, R *ii, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DVK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DVK(KP098017140, +0.098017140329560601994195563888641845861136673);
     DVK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DVK(KP634393284, +0.634393284163645498215171613225493370675687095);
     DVK(KP471396736, +0.471396736825997648556387625905254377657460319);
     DVK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DVK(KP290284677, +0.290284677254462367636192375817395274691476278);
     DVK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DVK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DVK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DVK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DVK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DVK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DVK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  R *x;
	  x = ri;
	  for (m = mb, W = W + (mb * ((TWVL / VL) * 126)); m < me; m = m + VL, x = x + (VL * ms), W = W + (TWVL * 126), MAKE_VOLATILE_STRIDE(64, rs)) {
	       V Tg, T4a, T6r, T7f, T3o, T4B, T5q, T7e, T5R, T62, T28, T4o, T2g, T4l, T7n;
	       V T7Z, T68, T6j, T2C, T4s, T3a, T4v, T7u, T82, T7E, T7F, T7V, T5F, T6u, T1k;
	       V T4e, T1r, T4d, T7B, T7C, T7W, T5M, T6v, TV, T4g, T12, T4h, T7h, T7i, TD;
	       V T4C, T3h, T4b, T5x, T6s, T1R, T4m, T7q, T80, T2j, T4p, T5Y, T63, T2Z, T4w;
	       V T7x, T83, T33, T4t, T6f, T6k;
	       {
		    V T1, T3, T3m, T3k, Tb, Td, Te, T6, T8, T9, T2, T3l, T3j;
		    T1 = LD(&(x[0]), ms, &(x[0]));
		    T2 = LD(&(x[WS(rs, 32)]), ms, &(x[0]));
		    T3 = BYTWJ(&(W[TWVL * 62]), T2);
		    T3l = LD(&(x[WS(rs, 48)]), ms, &(x[0]));
		    T3m = BYTWJ(&(W[TWVL * 94]), T3l);
		    T3j = LD(&(x[WS(rs, 16)]), ms, &(x[0]));
		    T3k = BYTWJ(&(W[TWVL * 30]), T3j);
		    {
			 V Ta, Tc, T5, T7;
			 Ta = LD(&(x[WS(rs, 56)]), ms, &(x[0]));
			 Tb = BYTWJ(&(W[TWVL * 110]), Ta);
			 Tc = LD(&(x[WS(rs, 24)]), ms, &(x[0]));
			 Td = BYTWJ(&(W[TWVL * 46]), Tc);
			 Te = VSUB(Tb, Td);
			 T5 = LD(&(x[WS(rs, 8)]), ms, &(x[0]));
			 T6 = BYTWJ(&(W[TWVL * 14]), T5);
			 T7 = LD(&(x[WS(rs, 40)]), ms, &(x[0]));
			 T8 = BYTWJ(&(W[TWVL * 78]), T7);
			 T9 = VSUB(T6, T8);
		    }
		    {
			 V T4, Tf, T6p, T6q;
			 T4 = VSUB(T1, T3);
			 Tf = VMUL(LDK(KP707106781), VADD(T9, Te));
			 Tg = VADD(T4, Tf);
			 T4a = VSUB(T4, Tf);
			 T6p = VADD(Tb, Td);
			 T6q = VADD(T6, T8);
			 T6r = VSUB(T6p, T6q);
			 T7f = VADD(T6q, T6p);
		    }
		    {
			 V T3i, T3n, T5o, T5p;
			 T3i = VMUL(LDK(KP707106781), VSUB(Te, T9));
			 T3n = VSUB(T3k, T3m);
			 T3o = VSUB(T3i, T3n);
			 T4B = VADD(T3n, T3i);
			 T5o = VADD(T1, T3);
			 T5p = VADD(T3k, T3m);
			 T5q = VSUB(T5o, T5p);
			 T7e = VADD(T5o, T5p);
		    }
	       }
	       {
		    V T24, T26, T5Q, T2b, T2d, T5P, T1W, T60, T21, T61, T22, T27;
		    {
			 V T23, T25, T2a, T2c;
			 T23 = LD(&(x[WS(rs, 17)]), ms, &(x[WS(rs, 1)]));
			 T24 = BYTWJ(&(W[TWVL * 32]), T23);
			 T25 = LD(&(x[WS(rs, 49)]), ms, &(x[WS(rs, 1)]));
			 T26 = BYTWJ(&(W[TWVL * 96]), T25);
			 T5Q = VADD(T24, T26);
			 T2a = LD(&(x[WS(rs, 1)]), ms, &(x[WS(rs, 1)]));
			 T2b = BYTWJ(&(W[0]), T2a);
			 T2c = LD(&(x[WS(rs, 33)]), ms, &(x[WS(rs, 1)]));
			 T2d = BYTWJ(&(W[TWVL * 64]), T2c);
			 T5P = VADD(T2b, T2d);
		    }
		    {
			 V T1T, T1V, T1S, T1U;
			 T1S = LD(&(x[WS(rs, 57)]), ms, &(x[WS(rs, 1)]));
			 T1T = BYTWJ(&(W[TWVL * 112]), T1S);
			 T1U = LD(&(x[WS(rs, 25)]), ms, &(x[WS(rs, 1)]));
			 T1V = BYTWJ(&(W[TWVL * 48]), T1U);
			 T1W = VSUB(T1T, T1V);
			 T60 = VADD(T1T, T1V);
		    }
		    {
			 V T1Y, T20, T1X, T1Z;
			 T1X = LD(&(x[WS(rs, 9)]), ms, &(x[WS(rs, 1)]));
			 T1Y = BYTWJ(&(W[TWVL * 16]), T1X);
			 T1Z = LD(&(x[WS(rs, 41)]), ms, &(x[WS(rs, 1)]));
			 T20 = BYTWJ(&(W[TWVL * 80]), T1Z);
			 T21 = VSUB(T1Y, T20);
			 T61 = VADD(T1Y, T20);
		    }
		    T5R = VSUB(T5P, T5Q);
		    T62 = VSUB(T60, T61);
		    T22 = VMUL(LDK(KP707106781), VSUB(T1W, T21));
		    T27 = VSUB(T24, T26);
		    T28 = VSUB(T22, T27);
		    T4o = VADD(T27, T22);
		    {
			 V T2e, T2f, T7l, T7m;
			 T2e = VSUB(T2b, T2d);
			 T2f = VMUL(LDK(KP707106781), VADD(T21, T1W));
			 T2g = VADD(T2e, T2f);
			 T4l = VSUB(T2e, T2f);
			 T7l = VADD(T5P, T5Q);
			 T7m = VADD(T61, T60);
			 T7n = VADD(T7l, T7m);
			 T7Z = VSUB(T7l, T7m);
		    }
	       }
	       {
		    V T2n, T2p, T66, T36, T38, T67, T2v, T6i, T2A, T6h, T2q, T2B;
		    {
			 V T2m, T2o, T35, T37;
			 T2m = LD(&(x[WS(rs, 63)]), ms, &(x[WS(rs, 1)]));
			 T2n = BYTWJ(&(W[TWVL * 124]), T2m);
			 T2o = LD(&(x[WS(rs, 31)]), ms, &(x[WS(rs, 1)]));
			 T2p = BYTWJ(&(W[TWVL * 60]), T2o);
			 T66 = VADD(T2n, T2p);
			 T35 = LD(&(x[WS(rs, 15)]), ms, &(x[WS(rs, 1)]));
			 T36 = BYTWJ(&(W[TWVL * 28]), T35);
			 T37 = LD(&(x[WS(rs, 47)]), ms, &(x[WS(rs, 1)]));
			 T38 = BYTWJ(&(W[TWVL * 92]), T37);
			 T67 = VADD(T36, T38);
		    }
		    {
			 V T2s, T2u, T2r, T2t;
			 T2r = LD(&(x[WS(rs, 7)]), ms, &(x[WS(rs, 1)]));
			 T2s = BYTWJ(&(W[TWVL * 12]), T2r);
			 T2t = LD(&(x[WS(rs, 39)]), ms, &(x[WS(rs, 1)]));
			 T2u = BYTWJ(&(W[TWVL * 76]), T2t);
			 T2v = VSUB(T2s, T2u);
			 T6i = VADD(T2s, T2u);
		    }
		    {
			 V T2x, T2z, T2w, T2y;
			 T2w = LD(&(x[WS(rs, 55)]), ms, &(x[WS(rs, 1)]));
			 T2x = BYTWJ(&(W[TWVL * 108]), T2w);
			 T2y = LD(&(x[WS(rs, 23)]), ms, &(x[WS(rs, 1)]));
			 T2z = BYTWJ(&(W[TWVL * 44]), T2y);
			 T2A = VSUB(T2x, T2z);
			 T6h = VADD(T2x, T2z);
		    }
		    T68 = VSUB(T66, T67);
		    T6j = VSUB(T6h, T6i);
		    T2q = VSUB(T2n, T2p);
		    T2B = VMUL(LDK(KP707106781), VADD(T2v, T2A));
		    T2C = VADD(T2q, T2B);
		    T4s = VSUB(T2q, T2B);
		    {
			 V T34, T39, T7s, T7t;
			 T34 = VMUL(LDK(KP707106781), VSUB(T2A, T2v));
			 T39 = VSUB(T36, T38);
			 T3a = VSUB(T34, T39);
			 T4v = VADD(T39, T34);
			 T7s = VADD(T66, T67);
			 T7t = VADD(T6i, T6h);
			 T7u = VADD(T7s, T7t);
			 T82 = VSUB(T7s, T7t);
		    }
	       }
	       {
		    V T1g, T1i, T5A, T1m, T1o, T5z, T18, T5C, T1d, T5D, T5B, T5E;
		    {
			 V T1f, T1h, T1l, T1n;
			 T1f = LD(&(x[WS(rs, 18)]), ms, &(x[0]));
			 T1g = BYTWJ(&(W[TWVL * 34]), T1f);
			 T1h = LD(&(x[WS(rs, 50)]), ms, &(x[0]));
			 T1i = BYTWJ(&(W[TWVL * 98]), T1h);
			 T5A = VADD(T1g, T1i);
			 T1l = LD(&(x[WS(rs, 2)]), ms, &(x[0]));
			 T1m = BYTWJ(&(W[TWVL * 2]), T1l);
			 T1n = LD(&(x[WS(rs, 34)]), ms, &(x[0]));
			 T1o = BYTWJ(&(W[TWVL * 66]), T1n);
			 T5z = VADD(T1m, T1o);
		    }
		    {
			 V T15, T17, T14, T16;
			 T14 = LD(&(x[WS(rs, 58)]), ms, &(x[0]));
			 T15 = BYTWJ(&(W[TWVL * 114]), T14);
			 T16 = LD(&(x[WS(rs, 26)]), ms, &(x[0]));
			 T17 = BYTWJ(&(W[TWVL * 50]), T16);
			 T18 = VSUB(T15, T17);
			 T5C = VADD(T15, T17);
		    }
		    {
			 V T1a, T1c, T19, T1b;
			 T19 = LD(&(x[WS(rs, 10)]), ms, &(x[0]));
			 T1a = BYTWJ(&(W[TWVL * 18]), T19);
			 T1b = LD(&(x[WS(rs, 42)]), ms, &(x[0]));
			 T1c = BYTWJ(&(W[TWVL * 82]), T1b);
			 T1d = VSUB(T1a, T1c);
			 T5D = VADD(T1a, T1c);
		    }
		    T7E = VADD(T5z, T5A);
		    T7F = VADD(T5D, T5C);
		    T7V = VSUB(T7E, T7F);
		    T5B = VSUB(T5z, T5A);
		    T5E = VSUB(T5C, T5D);
		    T5F = VFMA(LDK(KP923879532), T5B, VMUL(LDK(KP382683432), T5E));
		    T6u = VFNMS(LDK(KP382683432), T5B, VMUL(LDK(KP923879532), T5E));
		    {
			 V T1e, T1j, T1p, T1q;
			 T1e = VMUL(LDK(KP707106781), VSUB(T18, T1d));
			 T1j = VSUB(T1g, T1i);
			 T1k = VSUB(T1e, T1j);
			 T4e = VADD(T1j, T1e);
			 T1p = VSUB(T1m, T1o);
			 T1q = VMUL(LDK(KP707106781), VADD(T1d, T18));
			 T1r = VADD(T1p, T1q);
			 T4d = VSUB(T1p, T1q);
		    }
	       }
	       {
		    V TG, TI, T5G, TY, T10, T5H, TO, T5K, TT, T5J, T5I, T5L;
		    {
			 V TF, TH, TX, TZ;
			 TF = LD(&(x[WS(rs, 62)]), ms, &(x[0]));
			 TG = BYTWJ(&(W[TWVL * 122]), TF);
			 TH = LD(&(x[WS(rs, 30)]), ms, &(x[0]));
			 TI = BYTWJ(&(W[TWVL * 58]), TH);
			 T5G = VADD(TG, TI);
			 TX = LD(&(x[WS(rs, 14)]), ms, &(x[0]));
			 TY = BYTWJ(&(W[TWVL * 26]), TX);
			 TZ = LD(&(x[WS(rs, 46)]), ms, &(x[0]));
			 T10 = BYTWJ(&(W[TWVL * 90]), TZ);
			 T5H = VADD(TY, T10);
		    }
		    {
			 V TL, TN, TK, TM;
			 TK = LD(&(x[WS(rs, 6)]), ms, &(x[0]));
			 TL = BYTWJ(&(W[TWVL * 10]), TK);
			 TM = LD(&(x[WS(rs, 38)]), ms, &(x[0]));
			 TN = BYTWJ(&(W[TWVL * 74]), TM);
			 TO = VSUB(TL, TN);
			 T5K = VADD(TL, TN);
		    }
		    {
			 V TQ, TS, TP, TR;
			 TP = LD(&(x[WS(rs, 54)]), ms, &(x[0]));
			 TQ = BYTWJ(&(W[TWVL * 106]), TP);
			 TR = LD(&(x[WS(rs, 22)]), ms, &(x[0]));
			 TS = BYTWJ(&(W[TWVL * 42]), TR);
			 TT = VSUB(TQ, TS);
			 T5J = VADD(TQ, TS);
		    }
		    T7B = VADD(T5G, T5H);
		    T7C = VADD(T5K, T5J);
		    T7W = VSUB(T7B, T7C);
		    T5I = VSUB(T5G, T5H);
		    T5L = VSUB(T5J, T5K);
		    T5M = VFNMS(LDK(KP382683432), T5L, VMUL(LDK(KP923879532), T5I));
		    T6v = VFMA(LDK(KP382683432), T5I, VMUL(LDK(KP923879532), T5L));
		    {
			 V TJ, TU, TW, T11;
			 TJ = VSUB(TG, TI);
			 TU = VMUL(LDK(KP707106781), VADD(TO, TT));
			 TV = VADD(TJ, TU);
			 T4g = VSUB(TJ, TU);
			 TW = VMUL(LDK(KP707106781), VSUB(TT, TO));
			 T11 = VSUB(TY, T10);
			 T12 = VSUB(TW, T11);
			 T4h = VADD(T11, TW);
		    }
	       }
	       {
		    V Tl, T5r, TB, T5v, Tq, T5s, Tw, T5u, Tr, TC;
		    {
			 V Ti, Tk, Th, Tj;
			 Th = LD(&(x[WS(rs, 4)]), ms, &(x[0]));
			 Ti = BYTWJ(&(W[TWVL * 6]), Th);
			 Tj = LD(&(x[WS(rs, 36)]), ms, &(x[0]));
			 Tk = BYTWJ(&(W[TWVL * 70]), Tj);
			 Tl = VSUB(Ti, Tk);
			 T5r = VADD(Ti, Tk);
		    }
		    {
			 V Ty, TA, Tx, Tz;
			 Tx = LD(&(x[WS(rs, 12)]), ms, &(x[0]));
			 Ty = BYTWJ(&(W[TWVL * 22]), Tx);
			 Tz = LD(&(x[WS(rs, 44)]), ms, &(x[0]));
			 TA = BYTWJ(&(W[TWVL * 86]), Tz);
			 TB = VSUB(Ty, TA);
			 T5v = VADD(Ty, TA);
		    }
		    {
			 V Tn, Tp, Tm, To;
			 Tm = LD(&(x[WS(rs, 20)]), ms, &(x[0]));
			 Tn = BYTWJ(&(W[TWVL * 38]), Tm);
			 To = LD(&(x[WS(rs, 52)]), ms, &(x[0]));
			 Tp = BYTWJ(&(W[TWVL * 102]), To);
			 Tq = VSUB(Tn, Tp);
			 T5s = VADD(Tn, Tp);
		    }
		    {
			 V Tt, Tv, Ts, Tu;
			 Ts = LD(&(x[WS(rs, 60)]), ms, &(x[0]));
			 Tt = BYTWJ(&(W[TWVL * 118]), Ts);
			 Tu = LD(&(x[WS(rs, 28)]), ms, &(x[0]));
			 Tv = BYTWJ(&(W[TWVL * 54]), Tu);
			 Tw = VSUB(Tt, Tv);
			 T5u = VADD(Tt, Tv);
		    }
		    T7h = VADD(T5r, T5s);
		    T7i = VADD(T5u, T5v);
		    Tr = VFNMS(LDK(KP382683432), Tq, VMUL(LDK(KP923879532), Tl));
		    TC = VFMA(LDK(KP923879532), Tw, VMUL(LDK(KP382683432), TB));
		    TD = VADD(Tr, TC);
		    T4C = VSUB(TC, Tr);
		    {
			 V T3f, T3g, T5t, T5w;
			 T3f = VFNMS(LDK(KP923879532), TB, VMUL(LDK(KP382683432), Tw));
			 T3g = VFMA(LDK(KP382683432), Tl, VMUL(LDK(KP923879532), Tq));
			 T3h = VSUB(T3f, T3g);
			 T4b = VADD(T3g, T3f);
			 T5t = VSUB(T5r, T5s);
			 T5w = VSUB(T5u, T5v);
			 T5x = VMUL(LDK(KP707106781), VADD(T5t, T5w));
			 T6s = VMUL(LDK(KP707106781), VSUB(T5w, T5t));
		    }
	       }
	       {
		    V T1z, T5V, T1P, T5T, T1E, T5W, T1K, T5S;
		    {
			 V T1w, T1y, T1v, T1x;
			 T1v = LD(&(x[WS(rs, 61)]), ms, &(x[WS(rs, 1)]));
			 T1w = BYTWJ(&(W[TWVL * 120]), T1v);
			 T1x = LD(&(x[WS(rs, 29)]), ms, &(x[WS(rs, 1)]));
			 T1y = BYTWJ(&(W[TWVL * 56]), T1x);
			 T1z = VSUB(T1w, T1y);
			 T5V = VADD(T1w, T1y);
		    }
		    {
			 V T1M, T1O, T1L, T1N;
			 T1L = LD(&(x[WS(rs, 21)]), ms, &(x[WS(rs, 1)]));
			 T1M = BYTWJ(&(W[TWVL * 40]), T1L);
			 T1N = LD(&(x[WS(rs, 53)]), ms, &(x[WS(rs, 1)]));
			 T1O = BYTWJ(&(W[TWVL * 104]), T1N);
			 T1P = VSUB(T1M, T1O);
			 T5T = VADD(T1M, T1O);
		    }
		    {
			 V T1B, T1D, T1A, T1C;
			 T1A = LD(&(x[WS(rs, 13)]), ms, &(x[WS(rs, 1)]));
			 T1B = BYTWJ(&(W[TWVL * 24]), T1A);
			 T1C = LD(&(x[WS(rs, 45)]), ms, &(x[WS(rs, 1)]));
			 T1D = BYTWJ(&(W[TWVL * 88]), T1C);
			 T1E = VSUB(T1B, T1D);
			 T5W = VADD(T1B, T1D);
		    }
		    {
			 V T1H, T1J, T1G, T1I;
			 T1G = LD(&(x[WS(rs, 5)]), ms, &(x[WS(rs, 1)]));
			 T1H = BYTWJ(&(W[TWVL * 8]), T1G);
			 T1I = LD(&(x[WS(rs, 37)]), ms, &(x[WS(rs, 1)]));
			 T1J = BYTWJ(&(W[TWVL * 72]), T1I);
			 T1K = VSUB(T1H, T1J);
			 T5S = VADD(T1H, T1J);
		    }
		    {
			 V T1F, T1Q, T7o, T7p;
			 T1F = VFNMS(LDK(KP923879532), T1E, VMUL(LDK(KP382683432), T1z));
			 T1Q = VFMA(LDK(KP382683432), T1K, VMUL(LDK(KP923879532), T1P));
			 T1R = VSUB(T1F, T1Q);
			 T4m = VADD(T1Q, T1F);
			 T7o = VADD(T5S, T5T);
			 T7p = VADD(T5V, T5W);
			 T7q = VADD(T7o, T7p);
			 T80 = VSUB(T7p, T7o);
		    }
		    {
			 V T2h, T2i, T5U, T5X;
			 T2h = VFNMS(LDK(KP382683432), T1P, VMUL(LDK(KP923879532), T1K));
			 T2i = VFMA(LDK(KP923879532), T1z, VMUL(LDK(KP382683432), T1E));
			 T2j = VADD(T2h, T2i);
			 T4p = VSUB(T2i, T2h);
			 T5U = VSUB(T5S, T5T);
			 T5X = VSUB(T5V, T5W);
			 T5Y = VMUL(LDK(KP707106781), VADD(T5U, T5X));
			 T63 = VMUL(LDK(KP707106781), VSUB(T5X, T5U));
		    }
	       }
	       {
		    V T2H, T69, T2X, T6d, T2M, T6a, T2S, T6c;
		    {
			 V T2E, T2G, T2D, T2F;
			 T2D = LD(&(x[WS(rs, 3)]), ms, &(x[WS(rs, 1)]));
			 T2E = BYTWJ(&(W[TWVL * 4]), T2D);
			 T2F = LD(&(x[WS(rs, 35)]), ms, &(x[WS(rs, 1)]));
			 T2G = BYTWJ(&(W[TWVL * 68]), T2F);
			 T2H = VSUB(T2E, T2G);
			 T69 = VADD(T2E, T2G);
		    }
		    {
			 V T2U, T2W, T2T, T2V;
			 T2T = LD(&(x[WS(rs, 11)]), ms, &(x[WS(rs, 1)]));
			 T2U = BYTWJ(&(W[TWVL * 20]), T2T);
			 T2V = LD(&(x[WS(rs, 43)]), ms, &(x[WS(rs, 1)]));
			 T2W = BYTWJ(&(W[TWVL * 84]), T2V);
			 T2X = VSUB(T2U, T2W);
			 T6d = VADD(T2U, T2W);
		    }
		    {
			 V T2J, T2L, T2I, T2K;
			 T2I = LD(&(x[WS(rs, 19)]), ms, &(x[WS(rs, 1)]));
			 T2J = BYTWJ(&(W[TWVL * 36]), T2I);
			 T2K = LD(&(x[WS(rs, 51)]), ms, &(x[WS(rs, 1)]));
			 T2L = BYTWJ(&(W[TWVL * 100]), T2K);
			 T2M = VSUB(T2J, T2L);
			 T6a = VADD(T2J, T2L);
		    }
		    {
			 V T2P, T2R, T2O, T2Q;
			 T2O = LD(&(x[WS(rs, 59)]), ms, &(x[WS(rs, 1)]));
			 T2P = BYTWJ(&(W[TWVL * 116]), T2O);
			 T2Q = LD(&(x[WS(rs, 27)]), ms, &(x[WS(rs, 1)]));
			 T2R = BYTWJ(&(W[TWVL * 52]), T2Q);
			 T2S = VSUB(T2P, T2R);
			 T6c = VADD(T2P, T2R);
		    }
		    {
			 V T2N, T2Y, T7v, T7w;
			 T2N = VFNMS(LDK(KP382683432), T2M, VMUL(LDK(KP923879532), T2H));
			 T2Y = VFMA(LDK(KP923879532), T2S, VMUL(LDK(KP382683432), T2X));
			 T2Z = VADD(T2N, T2Y);
			 T4w = VSUB(T2Y, T2N);
			 T7v = VADD(T69, T6a);
			 T7w = VADD(T6c, T6d);
			 T7x = VADD(T7v, T7w);
			 T83 = VSUB(T7w, T7v);
		    }
		    {
			 V T31, T32, T6b, T6e;
			 T31 = VFNMS(LDK(KP923879532), T2X, VMUL(LDK(KP382683432), T2S));
			 T32 = VFMA(LDK(KP382683432), T2H, VMUL(LDK(KP923879532), T2M));
			 T33 = VSUB(T31, T32);
			 T4t = VADD(T32, T31);
			 T6b = VSUB(T69, T6a);
			 T6e = VSUB(T6c, T6d);
			 T6f = VMUL(LDK(KP707106781), VADD(T6b, T6e));
			 T6k = VMUL(LDK(KP707106781), VSUB(T6e, T6b));
		    }
	       }
	       {
		    V T7k, T7M, T7R, T7T, T7z, T7I, T7H, T7N, T7O, T7S;
		    {
			 V T7g, T7j, T7P, T7Q;
			 T7g = VADD(T7e, T7f);
			 T7j = VADD(T7h, T7i);
			 T7k = VSUB(T7g, T7j);
			 T7M = VADD(T7g, T7j);
			 T7P = VADD(T7n, T7q);
			 T7Q = VADD(T7u, T7x);
			 T7R = VADD(T7P, T7Q);
			 T7T = VBYI(VSUB(T7Q, T7P));
		    }
		    {
			 V T7r, T7y, T7D, T7G;
			 T7r = VSUB(T7n, T7q);
			 T7y = VSUB(T7u, T7x);
			 T7z = VMUL(LDK(KP707106781), VADD(T7r, T7y));
			 T7I = VMUL(LDK(KP707106781), VSUB(T7y, T7r));
			 T7D = VADD(T7B, T7C);
			 T7G = VADD(T7E, T7F);
			 T7H = VSUB(T7D, T7G);
			 T7N = VADD(T7G, T7D);
		    }
		    T7O = VADD(T7M, T7N);
		    ST(&(x[WS(rs, 32)]), VSUB(T7O, T7R), ms, &(x[0]));
		    ST(&(x[0]), VADD(T7O, T7R), ms, &(x[0]));
		    T7S = VSUB(T7M, T7N);
		    ST(&(x[WS(rs, 48)]), VSUB(T7S, T7T), ms, &(x[0]));
		    ST(&(x[WS(rs, 16)]), VADD(T7S, T7T), ms, &(x[0]));
		    {
			 V T7A, T7J, T7K, T7L;
			 T7A = VADD(T7k, T7z);
			 T7J = VBYI(VADD(T7H, T7I));
			 ST(&(x[WS(rs, 56)]), VSUB(T7A, T7J), ms, &(x[0]));
			 ST(&(x[WS(rs, 8)]), VADD(T7A, T7J), ms, &(x[0]));
			 T7K = VSUB(T7k, T7z);
			 T7L = VBYI(VSUB(T7I, T7H));
			 ST(&(x[WS(rs, 40)]), VSUB(T7K, T7L), ms, &(x[0]));
			 ST(&(x[WS(rs, 24)]), VADD(T7K, T7L), ms, &(x[0]));
		    }
	       }
	       {
		    V T7Y, T8j, T8c, T8k, T85, T8g, T89, T8h;
		    {
			 V T7U, T7X, T8a, T8b;
			 T7U = VSUB(T7e, T7f);
			 T7X = VMUL(LDK(KP707106781), VADD(T7V, T7W));
			 T7Y = VADD(T7U, T7X);
			 T8j = VSUB(T7U, T7X);
			 T8a = VFNMS(LDK(KP382683432), T7Z, VMUL(LDK(KP923879532), T80));
			 T8b = VFMA(LDK(KP382683432), T82, VMUL(LDK(KP923879532), T83));
			 T8c = VADD(T8a, T8b);
			 T8k = VSUB(T8b, T8a);
		    }
		    {
			 V T81, T84, T87, T88;
			 T81 = VFMA(LDK(KP923879532), T7Z, VMUL(LDK(KP382683432), T80));
			 T84 = VFNMS(LDK(KP382683432), T83, VMUL(LDK(KP923879532), T82));
			 T85 = VADD(T81, T84);
			 T8g = VSUB(T84, T81);
			 T87 = VSUB(T7i, T7h);
			 T88 = VMUL(LDK(KP707106781), VSUB(T7W, T7V));
			 T89 = VADD(T87, T88);
			 T8h = VSUB(T88, T87);
		    }
		    {
			 V T86, T8d, T8m, T8n;
			 T86 = VADD(T7Y, T85);
			 T8d = VBYI(VADD(T89, T8c));
			 ST(&(x[WS(rs, 60)]), VSUB(T86, T8d), ms, &(x[0]));
			 ST(&(x[WS(rs, 4)]), VADD(T86, T8d), ms, &(x[0]));
			 T8m = VBYI(VADD(T8h, T8g));
			 T8n = VADD(T8j, T8k);
			 ST(&(x[WS(rs, 12)]), VADD(T8m, T8n), ms, &(x[0]));
			 ST(&(x[WS(rs, 52)]), VSUB(T8n, T8m), ms, &(x[0]));
		    }
		    {
			 V T8e, T8f, T8i, T8l;
			 T8e = VSUB(T7Y, T85);
			 T8f = VBYI(VSUB(T8c, T89));
			 ST(&(x[WS(rs, 36)]), VSUB(T8e, T8f), ms, &(x[0]));
			 ST(&(x[WS(rs, 28)]), VADD(T8e, T8f), ms, &(x[0]));
			 T8i = VBYI(VSUB(T8g, T8h));
			 T8l = VSUB(T8j, T8k);
			 ST(&(x[WS(rs, 20)]), VADD(T8i, T8l), ms, &(x[0]));
			 ST(&(x[WS(rs, 44)]), VSUB(T8l, T8i), ms, &(x[0]));
		    }
	       }
	       {
		    V T5O, T6H, T6x, T6F, T6n, T6I, T6A, T6E;
		    {
			 V T5y, T5N, T6t, T6w;
			 T5y = VADD(T5q, T5x);
			 T5N = VADD(T5F, T5M);
			 T5O = VADD(T5y, T5N);
			 T6H = VSUB(T5y, T5N);
			 T6t = VADD(T6r, T6s);
			 T6w = VADD(T6u, T6v);
			 T6x = VADD(T6t, T6w);
			 T6F = VSUB(T6w, T6t);
			 {
			      V T65, T6y, T6m, T6z;
			      {
				   V T5Z, T64, T6g, T6l;
				   T5Z = VADD(T5R, T5Y);
				   T64 = VADD(T62, T63);
				   T65 = VFMA(LDK(KP980785280), T5Z, VMUL(LDK(KP195090322), T64));
				   T6y = VFNMS(LDK(KP195090322), T5Z, VMUL(LDK(KP980785280), T64));
				   T6g = VADD(T68, T6f);
				   T6l = VADD(T6j, T6k);
				   T6m = VFNMS(LDK(KP195090322), T6l, VMUL(LDK(KP980785280), T6g));
				   T6z = VFMA(LDK(KP195090322), T6g, VMUL(LDK(KP980785280), T6l));
			      }
			      T6n = VADD(T65, T6m);
			      T6I = VSUB(T6z, T6y);
			      T6A = VADD(T6y, T6z);
			      T6E = VSUB(T6m, T65);
			 }
		    }
		    {
			 V T6o, T6B, T6K, T6L;
			 T6o = VADD(T5O, T6n);
			 T6B = VBYI(VADD(T6x, T6A));
			 ST(&(x[WS(rs, 62)]), VSUB(T6o, T6B), ms, &(x[0]));
			 ST(&(x[WS(rs, 2)]), VADD(T6o, T6B), ms, &(x[0]));
			 T6K = VBYI(VADD(T6F, T6E));
			 T6L = VADD(T6H, T6I);
			 ST(&(x[WS(rs, 14)]), VADD(T6K, T6L), ms, &(x[0]));
			 ST(&(x[WS(rs, 50)]), VSUB(T6L, T6K), ms, &(x[0]));
		    }
		    {
			 V T6C, T6D, T6G, T6J;
			 T6C = VSUB(T5O, T6n);
			 T6D = VBYI(VSUB(T6A, T6x));
			 ST(&(x[WS(rs, 34)]), VSUB(T6C, T6D), ms, &(x[0]));
			 ST(&(x[WS(rs, 30)]), VADD(T6C, T6D), ms, &(x[0]));
			 T6G = VBYI(VSUB(T6E, T6F));
			 T6J = VSUB(T6H, T6I);
			 ST(&(x[WS(rs, 18)]), VADD(T6G, T6J), ms, &(x[0]));
			 ST(&(x[WS(rs, 46)]), VSUB(T6J, T6G), ms, &(x[0]));
		    }
	       }
	       {
		    V T6O, T79, T6Z, T77, T6V, T7a, T72, T76;
		    {
			 V T6M, T6N, T6X, T6Y;
			 T6M = VSUB(T5q, T5x);
			 T6N = VSUB(T6v, T6u);
			 T6O = VADD(T6M, T6N);
			 T79 = VSUB(T6M, T6N);
			 T6X = VSUB(T6s, T6r);
			 T6Y = VSUB(T5M, T5F);
			 T6Z = VADD(T6X, T6Y);
			 T77 = VSUB(T6Y, T6X);
			 {
			      V T6R, T70, T6U, T71;
			      {
				   V T6P, T6Q, T6S, T6T;
				   T6P = VSUB(T5R, T5Y);
				   T6Q = VSUB(T63, T62);
				   T6R = VFMA(LDK(KP831469612), T6P, VMUL(LDK(KP555570233), T6Q));
				   T70 = VFNMS(LDK(KP555570233), T6P, VMUL(LDK(KP831469612), T6Q));
				   T6S = VSUB(T68, T6f);
				   T6T = VSUB(T6k, T6j);
				   T6U = VFNMS(LDK(KP555570233), T6T, VMUL(LDK(KP831469612), T6S));
				   T71 = VFMA(LDK(KP555570233), T6S, VMUL(LDK(KP831469612), T6T));
			      }
			      T6V = VADD(T6R, T6U);
			      T7a = VSUB(T71, T70);
			      T72 = VADD(T70, T71);
			      T76 = VSUB(T6U, T6R);
			 }
		    }
		    {
			 V T6W, T73, T7c, T7d;
			 T6W = VADD(T6O, T6V);
			 T73 = VBYI(VADD(T6Z, T72));
			 ST(&(x[WS(rs, 58)]), VSUB(T6W, T73), ms, &(x[0]));
			 ST(&(x[WS(rs, 6)]), VADD(T6W, T73), ms, &(x[0]));
			 T7c = VBYI(VADD(T77, T76));
			 T7d = VADD(T79, T7a);
			 ST(&(x[WS(rs, 10)]), VADD(T7c, T7d), ms, &(x[0]));
			 ST(&(x[WS(rs, 54)]), VSUB(T7d, T7c), ms, &(x[0]));
		    }
		    {
			 V T74, T75, T78, T7b;
			 T74 = VSUB(T6O, T6V);
			 T75 = VBYI(VSUB(T72, T6Z));
			 ST(&(x[WS(rs, 38)]), VSUB(T74, T75), ms, &(x[0]));
			 ST(&(x[WS(rs, 26)]), VADD(T74, T75), ms, &(x[0]));
			 T78 = VBYI(VSUB(T76, T77));
			 T7b = VSUB(T79, T7a);
			 ST(&(x[WS(rs, 22)]), VADD(T78, T7b), ms, &(x[0]));
			 ST(&(x[WS(rs, 42)]), VSUB(T7b, T78), ms, &(x[0]));
		    }
	       }
	       {
		    V T4k, T5h, T4R, T59, T4H, T5j, T4P, T4Y, T4z, T4S, T4K, T4O, T55, T5k, T5c;
		    V T5g;
		    {
			 V T4c, T57, T4j, T58, T4f, T4i;
			 T4c = VADD(T4a, T4b);
			 T57 = VSUB(T4C, T4B);
			 T4f = VFMA(LDK(KP831469612), T4d, VMUL(LDK(KP555570233), T4e));
			 T4i = VFNMS(LDK(KP555570233), T4h, VMUL(LDK(KP831469612), T4g));
			 T4j = VADD(T4f, T4i);
			 T58 = VSUB(T4i, T4f);
			 T4k = VADD(T4c, T4j);
			 T5h = VSUB(T58, T57);
			 T4R = VSUB(T4c, T4j);
			 T59 = VADD(T57, T58);
		    }
		    {
			 V T4D, T4W, T4G, T4X, T4E, T4F;
			 T4D = VADD(T4B, T4C);
			 T4W = VSUB(T4a, T4b);
			 T4E = VFNMS(LDK(KP555570233), T4d, VMUL(LDK(KP831469612), T4e));
			 T4F = VFMA(LDK(KP555570233), T4g, VMUL(LDK(KP831469612), T4h));
			 T4G = VADD(T4E, T4F);
			 T4X = VSUB(T4F, T4E);
			 T4H = VADD(T4D, T4G);
			 T5j = VSUB(T4W, T4X);
			 T4P = VSUB(T4G, T4D);
			 T4Y = VADD(T4W, T4X);
		    }
		    {
			 V T4r, T4I, T4y, T4J;
			 {
			      V T4n, T4q, T4u, T4x;
			      T4n = VADD(T4l, T4m);
			      T4q = VADD(T4o, T4p);
			      T4r = VFMA(LDK(KP956940335), T4n, VMUL(LDK(KP290284677), T4q));
			      T4I = VFNMS(LDK(KP290284677), T4n, VMUL(LDK(KP956940335), T4q));
			      T4u = VADD(T4s, T4t);
			      T4x = VADD(T4v, T4w);
			      T4y = VFNMS(LDK(KP290284677), T4x, VMUL(LDK(KP956940335), T4u));
			      T4J = VFMA(LDK(KP290284677), T4u, VMUL(LDK(KP956940335), T4x));
			 }
			 T4z = VADD(T4r, T4y);
			 T4S = VSUB(T4J, T4I);
			 T4K = VADD(T4I, T4J);
			 T4O = VSUB(T4y, T4r);
		    }
		    {
			 V T51, T5a, T54, T5b;
			 {
			      V T4Z, T50, T52, T53;
			      T4Z = VSUB(T4l, T4m);
			      T50 = VSUB(T4p, T4o);
			      T51 = VFMA(LDK(KP881921264), T4Z, VMUL(LDK(KP471396736), T50));
			      T5a = VFNMS(LDK(KP471396736), T4Z, VMUL(LDK(KP881921264), T50));
			      T52 = VSUB(T4s, T4t);
			      T53 = VSUB(T4w, T4v);
			      T54 = VFNMS(LDK(KP471396736), T53, VMUL(LDK(KP881921264), T52));
			      T5b = VFMA(LDK(KP471396736), T52, VMUL(LDK(KP881921264), T53));
			 }
			 T55 = VADD(T51, T54);
			 T5k = VSUB(T5b, T5a);
			 T5c = VADD(T5a, T5b);
			 T5g = VSUB(T54, T51);
		    }
		    {
			 V T4A, T4L, T5i, T5l;
			 T4A = VADD(T4k, T4z);
			 T4L = VBYI(VADD(T4H, T4K));
			 ST(&(x[WS(rs, 61)]), VSUB(T4A, T4L), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 3)]), VADD(T4A, T4L), ms, &(x[WS(rs, 1)]));
			 T5i = VBYI(VSUB(T5g, T5h));
			 T5l = VSUB(T5j, T5k);
			 ST(&(x[WS(rs, 21)]), VADD(T5i, T5l), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 43)]), VSUB(T5l, T5i), ms, &(x[WS(rs, 1)]));
		    }
		    {
			 V T5m, T5n, T4M, T4N;
			 T5m = VBYI(VADD(T5h, T5g));
			 T5n = VADD(T5j, T5k);
			 ST(&(x[WS(rs, 11)]), VADD(T5m, T5n), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 53)]), VSUB(T5n, T5m), ms, &(x[WS(rs, 1)]));
			 T4M = VSUB(T4k, T4z);
			 T4N = VBYI(VSUB(T4K, T4H));
			 ST(&(x[WS(rs, 35)]), VSUB(T4M, T4N), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 29)]), VADD(T4M, T4N), ms, &(x[WS(rs, 1)]));
		    }
		    {
			 V T4Q, T4T, T56, T5d;
			 T4Q = VBYI(VSUB(T4O, T4P));
			 T4T = VSUB(T4R, T4S);
			 ST(&(x[WS(rs, 19)]), VADD(T4Q, T4T), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 45)]), VSUB(T4T, T4Q), ms, &(x[WS(rs, 1)]));
			 T56 = VADD(T4Y, T55);
			 T5d = VBYI(VADD(T59, T5c));
			 ST(&(x[WS(rs, 59)]), VSUB(T56, T5d), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 5)]), VADD(T56, T5d), ms, &(x[WS(rs, 1)]));
		    }
		    {
			 V T5e, T5f, T4U, T4V;
			 T5e = VSUB(T4Y, T55);
			 T5f = VBYI(VSUB(T5c, T59));
			 ST(&(x[WS(rs, 37)]), VSUB(T5e, T5f), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 27)]), VADD(T5e, T5f), ms, &(x[WS(rs, 1)]));
			 T4U = VBYI(VADD(T4P, T4O));
			 T4V = VADD(T4R, T4S);
			 ST(&(x[WS(rs, 13)]), VADD(T4U, T4V), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 51)]), VSUB(T4V, T4U), ms, &(x[WS(rs, 1)]));
		    }
	       }
	       {
		    V T1u, T43, T3D, T3V, T3t, T45, T3B, T3K, T3d, T3E, T3w, T3A, T3R, T46, T3Y;
		    V T42;
		    {
			 V TE, T3T, T1t, T3U, T13, T1s;
			 TE = VSUB(Tg, TD);
			 T3T = VADD(T3o, T3h);
			 T13 = VFMA(LDK(KP195090322), TV, VMUL(LDK(KP980785280), T12));
			 T1s = VFNMS(LDK(KP195090322), T1r, VMUL(LDK(KP980785280), T1k));
			 T1t = VSUB(T13, T1s);
			 T3U = VADD(T1s, T13);
			 T1u = VADD(TE, T1t);
			 T43 = VSUB(T3U, T3T);
			 T3D = VSUB(TE, T1t);
			 T3V = VADD(T3T, T3U);
		    }
		    {
			 V T3p, T3I, T3s, T3J, T3q, T3r;
			 T3p = VSUB(T3h, T3o);
			 T3I = VADD(Tg, TD);
			 T3q = VFNMS(LDK(KP195090322), T12, VMUL(LDK(KP980785280), TV));
			 T3r = VFMA(LDK(KP980785280), T1r, VMUL(LDK(KP195090322), T1k));
			 T3s = VSUB(T3q, T3r);
			 T3J = VADD(T3r, T3q);
			 T3t = VADD(T3p, T3s);
			 T45 = VSUB(T3I, T3J);
			 T3B = VSUB(T3s, T3p);
			 T3K = VADD(T3I, T3J);
		    }
		    {
			 V T2l, T3u, T3c, T3v;
			 {
			      V T29, T2k, T30, T3b;
			      T29 = VSUB(T1R, T28);
			      T2k = VSUB(T2g, T2j);
			      T2l = VFMA(LDK(KP634393284), T29, VMUL(LDK(KP773010453), T2k));
			      T3u = VFNMS(LDK(KP634393284), T2k, VMUL(LDK(KP773010453), T29));
			      T30 = VSUB(T2C, T2Z);
			      T3b = VSUB(T33, T3a);
			      T3c = VFNMS(LDK(KP634393284), T3b, VMUL(LDK(KP773010453), T30));
			      T3v = VFMA(LDK(KP773010453), T3b, VMUL(LDK(KP634393284), T30));
			 }
			 T3d = VADD(T2l, T3c);
			 T3E = VSUB(T3v, T3u);
			 T3w = VADD(T3u, T3v);
			 T3A = VSUB(T3c, T2l);
		    }
		    {
			 V T3N, T3W, T3Q, T3X;
			 {
			      V T3L, T3M, T3O, T3P;
			      T3L = VADD(T28, T1R);
			      T3M = VADD(T2g, T2j);
			      T3N = VFMA(LDK(KP098017140), T3L, VMUL(LDK(KP995184726), T3M));
			      T3W = VFNMS(LDK(KP098017140), T3M, VMUL(LDK(KP995184726), T3L));
			      T3O = VADD(T2C, T2Z);
			      T3P = VADD(T3a, T33);
			      T3Q = VFNMS(LDK(KP098017140), T3P, VMUL(LDK(KP995184726), T3O));
			      T3X = VFMA(LDK(KP995184726), T3P, VMUL(LDK(KP098017140), T3O));
			 }
			 T3R = VADD(T3N, T3Q);
			 T46 = VSUB(T3X, T3W);
			 T3Y = VADD(T3W, T3X);
			 T42 = VSUB(T3Q, T3N);
		    }
		    {
			 V T3e, T3x, T44, T47;
			 T3e = VADD(T1u, T3d);
			 T3x = VBYI(VADD(T3t, T3w));
			 ST(&(x[WS(rs, 57)]), VSUB(T3e, T3x), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 7)]), VADD(T3e, T3x), ms, &(x[WS(rs, 1)]));
			 T44 = VBYI(VSUB(T42, T43));
			 T47 = VSUB(T45, T46);
			 ST(&(x[WS(rs, 17)]), VADD(T44, T47), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 47)]), VSUB(T47, T44), ms, &(x[WS(rs, 1)]));
		    }
		    {
			 V T48, T49, T3y, T3z;
			 T48 = VBYI(VADD(T43, T42));
			 T49 = VADD(T45, T46);
			 ST(&(x[WS(rs, 15)]), VADD(T48, T49), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 49)]), VSUB(T49, T48), ms, &(x[WS(rs, 1)]));
			 T3y = VSUB(T1u, T3d);
			 T3z = VBYI(VSUB(T3w, T3t));
			 ST(&(x[WS(rs, 39)]), VSUB(T3y, T3z), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 25)]), VADD(T3y, T3z), ms, &(x[WS(rs, 1)]));
		    }
		    {
			 V T3C, T3F, T3S, T3Z;
			 T3C = VBYI(VSUB(T3A, T3B));
			 T3F = VSUB(T3D, T3E);
			 ST(&(x[WS(rs, 23)]), VADD(T3C, T3F), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 41)]), VSUB(T3F, T3C), ms, &(x[WS(rs, 1)]));
			 T3S = VADD(T3K, T3R);
			 T3Z = VBYI(VADD(T3V, T3Y));
			 ST(&(x[WS(rs, 63)]), VSUB(T3S, T3Z), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 1)]), VADD(T3S, T3Z), ms, &(x[WS(rs, 1)]));
		    }
		    {
			 V T40, T41, T3G, T3H;
			 T40 = VSUB(T3K, T3R);
			 T41 = VBYI(VSUB(T3Y, T3V));
			 ST(&(x[WS(rs, 33)]), VSUB(T40, T41), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 31)]), VADD(T40, T41), ms, &(x[WS(rs, 1)]));
			 T3G = VBYI(VADD(T3B, T3A));
			 T3H = VADD(T3D, T3E);
			 ST(&(x[WS(rs, 9)]), VADD(T3G, T3H), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 55)]), VSUB(T3H, T3G), ms, &(x[WS(rs, 1)]));
		    }
	       }
	  }
     }
     VLEAVE();
}

static const tw_instr twinstr[] = {
     VTW(0, 1),
     VTW(0, 2),
     VTW(0, 3),
     VTW(0, 4),
     VTW(0, 5),
     VTW(0, 6),
     VTW(0, 7),
     VTW(0, 8),
     VTW(0, 9),
     VTW(0, 10),
     VTW(0, 11),
     VTW(0, 12),
     VTW(0, 13),
     VTW(0, 14),
     VTW(0, 15),
     VTW(0, 16),
     VTW(0, 17),
     VTW(0, 18),
     VTW(0, 19),
     VTW(0, 20),
     VTW(0, 21),
     VTW(0, 22),
     VTW(0, 23),
     VTW(0, 24),
     VTW(0, 25),
     VTW(0, 26),
     VTW(0, 27),
     VTW(0, 28),
     VTW(0, 29),
     VTW(0, 30),
     VTW(0, 31),
     VTW(0, 32),
     VTW(0, 33),
     VTW(0, 34),
     VTW(0, 35),
     VTW(0, 36),
     VTW(0, 37),
     VTW(0, 38),
     VTW(0, 39),
     VTW(0, 40),
     VTW(0, 41),
     VTW(0, 42),
     VTW(0, 43),
     VTW(0, 44),
     VTW(0, 45),
     VTW(0, 46),
     VTW(0, 47),
     VTW(0, 48),
     VTW(0, 49),
     VTW(0, 50),
     VTW(0, 51),
     VTW(0, 52),
     VTW(0, 53),
     VTW(0, 54),
     VTW(0, 55),
     VTW(0, 56),
     VTW(0, 57),
     VTW(0, 58),
     VTW(0, 59),
     VTW(0, 60),
     VTW(0, 61),
     VTW(0, 62),
     VTW(0, 63),
     { TW_NEXT, VL, 0 }
};

static const ct_desc desc = { 64, XSIMD_STRING("t2fv_64"), twinstr, &GENUS, { 467, 198, 52, 0 }, 0, 0, 0 };

void XSIMD(codelet_t2fv_64) (planner *p) {
     X(kdft_dit_register) (p, t2fv_64, &desc);
}
#endif
