/*
 * Decompiled with CFR 0.152.
 */
package javacli;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import javacli.CliError;
import javacli.ComBuffer;
import javacli.Rectangle;
import javacli.Reference;

class TableDescriptor {
    Field[] columns;
    int nColumns;
    int[] types;
    Class cls;
    Constructor constructor;
    boolean autoincrement;
    static final Object[] bypassFlag = new Object[]{new Boolean(true)};
    static Method setBypass;
    static Class stringType;
    static Class dateType;
    static final Class[] constructorProfile;
    static final Object[] constructorParameters;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    TableDescriptor(Class tableClass) {
        int i;
        Field[] classFields;
        Class c;
        int n = 0;
        for (c = tableClass; c != null; c = c.getSuperclass()) {
            classFields = c.getDeclaredFields();
            for (i = 0; i < classFields.length; ++i) {
                if ((classFields[i].getModifiers() & 0x88) != 0) continue;
                ++n;
            }
        }
        this.columns = new Field[n];
        this.types = new int[n];
        this.nColumns = n;
        this.cls = tableClass;
        try {
            this.constructor = tableClass.getDeclaredConstructor(constructorProfile);
        }
        catch (Exception x) {
            throw new CliError("Default constructor is not accessible in class " + tableClass.getName());
        }
        if (setBypass != null) {
            try {
                setBypass.invoke((Object)this.constructor, bypassFlag);
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        n = 0;
        for (c = tableClass; c != null; c = c.getSuperclass()) {
            classFields = c.getDeclaredFields();
            for (i = 0; i < classFields.length; ++i) {
                int cliType;
                Class<?> type;
                Field f = classFields[i];
                if ((f.getModifiers() & 0x88) != 0) continue;
                if (setBypass != null) {
                    try {
                        setBypass.invoke((Object)f, bypassFlag);
                    }
                    catch (Exception x) {
                        throw new CliError("Field '" + f.getName() + "' is not accessible in class " + tableClass.getName());
                    }
                }
                if ((type = f.getType()) == Byte.TYPE) {
                    cliType = 2;
                } else if (type == Short.TYPE) {
                    cliType = 3;
                } else if (type == Integer.TYPE) {
                    if ((f.getModifiers() & 0x40) != 0) {
                        cliType = 24;
                        this.autoincrement = true;
                    } else {
                        cliType = 4;
                    }
                } else if (type == Boolean.TYPE) {
                    cliType = 1;
                } else if (type == Long.TYPE) {
                    cliType = 5;
                } else if (type == Float.TYPE) {
                    cliType = 6;
                } else if (type == Double.TYPE) {
                    cliType = 7;
                } else if (type == Reference.TYPE) {
                    cliType = 0;
                } else if (type == Rectangle.TYPE) {
                    cliType = 25;
                } else if (type == stringType) {
                    cliType = 9;
                } else if (type == dateType) {
                    cliType = 23;
                } else {
                    if (!type.isArray()) throw new CliError("Unsupported field type " + type.getName());
                    if ((type = type.getComponentType()) == Byte.TYPE) {
                        cliType = 14;
                    } else if (type == Short.TYPE) {
                        cliType = 15;
                    } else if (type == Integer.TYPE) {
                        cliType = 16;
                    } else if (type == Boolean.TYPE) {
                        cliType = 13;
                    } else if (type == Long.TYPE) {
                        cliType = 17;
                    } else if (type == Float.TYPE) {
                        cliType = 18;
                    } else if (type == Double.TYPE) {
                        cliType = 19;
                    } else if (type == Reference.TYPE) {
                        cliType = 12;
                    } else {
                        if (type != stringType) throw new CliError("Unsupported array type " + type.getName());
                        cliType = 21;
                    }
                }
                this.columns[n] = f;
                this.types[n++] = cliType;
            }
        }
    }

    void writeColumnDefs(ComBuffer buf) {
        int n = this.nColumns;
        for (int i = 0; i < n; ++i) {
            buf.putByte(this.types[i]);
            buf.putAsciiz(this.columns[i].getName());
        }
    }

    void writeColumnValues(ComBuffer buf, Object obj) {
        try {
            int n = this.nColumns;
            block25: for (int i = 0; i < n; ++i) {
                switch (this.types[i]) {
                    case 2: {
                        buf.putByte(this.columns[i].getByte(obj));
                        continue block25;
                    }
                    case 3: {
                        buf.putShort(this.columns[i].getShort(obj));
                        continue block25;
                    }
                    case 4: {
                        buf.putInt(this.columns[i].getInt(obj));
                        continue block25;
                    }
                    case 5: {
                        buf.putLong(this.columns[i].getLong(obj));
                        continue block25;
                    }
                    case 6: {
                        buf.putFloat(this.columns[i].getFloat(obj));
                        continue block25;
                    }
                    case 7: {
                        buf.putDouble(this.columns[i].getDouble(obj));
                        continue block25;
                    }
                    case 1: {
                        buf.putByte(this.columns[i].getBoolean(obj) ? 1 : 0);
                        continue block25;
                    }
                    case 0: {
                        Reference ref = (Reference)this.columns[i].get(obj);
                        buf.putInt(ref != null ? ref.oid : 0);
                        continue block25;
                    }
                    case 25: {
                        Rectangle rect = (Rectangle)this.columns[i].get(obj);
                        if (rect == null) {
                            rect = new Rectangle();
                        }
                        buf.putRectangle(rect);
                        continue block25;
                    }
                    case 9: {
                        buf.putString((String)this.columns[i].get(obj));
                        continue block25;
                    }
                    case 23: {
                        buf.putInt((int)(((Date)this.columns[i].get(obj)).getTime() / 1000L));
                        continue block25;
                    }
                    case 14: {
                        buf.putByteArray((byte[])this.columns[i].get(obj));
                        continue block25;
                    }
                    case 15: {
                        int j;
                        Object[] arr = (short[])this.columns[i].get(obj);
                        int len = arr == null ? 0 : arr.length;
                        buf.putInt(len);
                        for (j = 0; j < len; ++j) {
                            buf.putShort(arr[j]);
                        }
                        continue block25;
                    }
                    case 16: {
                        int j;
                        Object[] arr = (int[])this.columns[i].get(obj);
                        int len = arr == null ? 0 : arr.length;
                        buf.putInt(len);
                        for (j = 0; j < len; ++j) {
                            buf.putInt(arr[j]);
                        }
                        continue block25;
                    }
                    case 17: {
                        int j;
                        Object[] arr = (long[])this.columns[i].get(obj);
                        int len = arr == null ? 0 : arr.length;
                        buf.putInt(len);
                        for (j = 0; j < len; ++j) {
                            buf.putLong(arr[j]);
                        }
                        continue block25;
                    }
                    case 18: {
                        int j;
                        Object[] arr = (float[])this.columns[i].get(obj);
                        int len = arr == null ? 0 : arr.length;
                        buf.putInt(len);
                        for (j = 0; j < len; ++j) {
                            buf.putFloat(arr[j]);
                        }
                        continue block25;
                    }
                    case 19: {
                        int j;
                        Object[] arr = (double[])this.columns[i].get(obj);
                        int len = arr == null ? 0 : arr.length;
                        buf.putInt(len);
                        for (j = 0; j < len; ++j) {
                            buf.putDouble(arr[j]);
                        }
                        continue block25;
                    }
                    case 13: {
                        int j;
                        Object[] arr = (boolean[])this.columns[i].get(obj);
                        int len = arr == null ? 0 : arr.length;
                        buf.putInt(len);
                        for (j = 0; j < len; ++j) {
                            buf.putByte(arr[j] != 0 ? 1 : 0);
                        }
                        continue block25;
                    }
                    case 12: {
                        int j;
                        Object[] arr = (Reference[])this.columns[i].get(obj);
                        int len = arr == null ? 0 : arr.length;
                        buf.putInt(len);
                        for (j = 0; j < len; ++j) {
                            buf.putInt(arr[j] != null ? arr[j].oid : 0);
                        }
                        continue block25;
                    }
                    case 21: {
                        int j;
                        Object[] arr = (String[])this.columns[i].get(obj);
                        int len = arr == null ? 0 : arr.length;
                        buf.putInt(len);
                        for (j = 0; j < len; ++j) {
                            buf.putAsciiz((String)arr[j]);
                        }
                        continue block25;
                    }
                    case 24: {
                        continue block25;
                    }
                    default: {
                        throw new CliError("Unsupported type " + this.types[i]);
                    }
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new CliError("Object access error: " + x);
        }
    }

    Object readObject(ComBuffer buf) {
        try {
            Object obj = this.constructor.newInstance(constructorParameters);
            int n = this.nColumns;
            block24: for (int i = 0; i < n; ++i) {
                byte type = buf.getByte();
                if (type != this.types[i]) {
                    throw new CliError("Unexpected type of column: " + type + " instead of " + this.types[i]);
                }
                switch (this.types[i]) {
                    case 2: {
                        this.columns[i].setByte(obj, buf.getByte());
                        continue block24;
                    }
                    case 3: {
                        this.columns[i].setShort(obj, buf.getShort());
                        continue block24;
                    }
                    case 4: 
                    case 24: {
                        this.columns[i].setInt(obj, buf.getInt());
                        continue block24;
                    }
                    case 5: {
                        this.columns[i].setLong(obj, buf.getLong());
                        continue block24;
                    }
                    case 6: {
                        this.columns[i].setFloat(obj, buf.getFloat());
                        continue block24;
                    }
                    case 7: {
                        this.columns[i].setDouble(obj, buf.getDouble());
                        continue block24;
                    }
                    case 1: {
                        this.columns[i].setBoolean(obj, buf.getByte() != 0);
                        continue block24;
                    }
                    case 0: {
                        int oid = buf.getInt();
                        this.columns[i].set(obj, oid != 0 ? new Reference(oid) : null);
                        continue block24;
                    }
                    case 25: {
                        this.columns[i].set(obj, buf.getRectangle());
                        continue block24;
                    }
                    case 9: {
                        this.columns[i].set(obj, buf.getString());
                        continue block24;
                    }
                    case 23: {
                        this.columns[i].set(obj, new Date(((long)buf.getInt() & 0xFFFFFFFFL) * 1000L));
                        continue block24;
                    }
                    case 14: {
                        int j;
                        int len = buf.getInt();
                        byte[] arr = new byte[len];
                        for (j = 0; j < len; ++j) {
                            arr[j] = buf.getByte();
                        }
                        this.columns[i].set(obj, arr);
                        continue block24;
                    }
                    case 15: {
                        int j;
                        int len = buf.getInt();
                        short[] arr = new short[len];
                        for (j = 0; j < len; ++j) {
                            arr[j] = buf.getShort();
                        }
                        this.columns[i].set(obj, arr);
                        continue block24;
                    }
                    case 16: {
                        int j;
                        int len = buf.getInt();
                        int[] arr = new int[len];
                        for (j = 0; j < len; ++j) {
                            arr[j] = buf.getInt();
                        }
                        this.columns[i].set(obj, arr);
                        continue block24;
                    }
                    case 17: {
                        int j;
                        int len = buf.getInt();
                        long[] arr = new long[len];
                        for (j = 0; j < len; ++j) {
                            arr[j] = buf.getLong();
                        }
                        this.columns[i].set(obj, arr);
                        continue block24;
                    }
                    case 18: {
                        int j;
                        int len = buf.getInt();
                        float[] arr = new float[len];
                        for (j = 0; j < len; ++j) {
                            arr[j] = buf.getFloat();
                        }
                        this.columns[i].set(obj, arr);
                        continue block24;
                    }
                    case 19: {
                        int j;
                        int len = buf.getInt();
                        double[] arr = new double[len];
                        for (j = 0; j < len; ++j) {
                            arr[j] = buf.getDouble();
                        }
                        this.columns[i].set(obj, arr);
                        continue block24;
                    }
                    case 13: {
                        int j;
                        int len = buf.getInt();
                        boolean[] arr = new boolean[len];
                        for (j = 0; j < len; ++j) {
                            arr[j] = buf.getByte() != 0;
                        }
                        this.columns[i].set(obj, arr);
                        continue block24;
                    }
                    case 12: {
                        int j;
                        int len = buf.getInt();
                        Reference[] arr = new Reference[len];
                        for (j = 0; j < len; ++j) {
                            int oid = buf.getInt();
                            arr[j] = oid != 0 ? new Reference(oid) : null;
                        }
                        this.columns[i].set(obj, arr);
                        continue block24;
                    }
                    case 21: {
                        int j;
                        int len = buf.getInt();
                        String[] arr = new String[len];
                        for (j = 0; j < len; ++j) {
                            arr[j] = buf.getAsciiz();
                        }
                        this.columns[i].set(obj, arr);
                        continue block24;
                    }
                    default: {
                        throw new CliError("Unsupported type " + this.types[i]);
                    }
                }
            }
            return obj;
        }
        catch (Exception x) {
            throw new CliError("Object access error: " + x);
        }
    }

    static {
        constructorProfile = new Class[0];
        constructorParameters = new Object[0];
        try {
            Class<?> c = Class.forName("java.lang.reflect.AccessibleObject");
            Class[] param = new Class[]{Boolean.TYPE};
            setBypass = c.getMethod("setAccessible", param);
        }
        catch (Exception x) {
            // empty catch block
        }
        try {
            stringType = Class.forName("java.lang.String");
            dateType = Class.forName("java.util.Date");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

