/*
 * Decompiled with CFR 0.152.
 */
package javacli;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;

public class LocalSocket
extends Socket {
    private long implObj;

    @Override
    public InputStream getInputStream() throws IOException {
        return new LocalInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new LocalOutputStream();
    }

    @Override
    public void setTcpNoDelay(boolean on) {
    }

    @Override
    public void setSoLinger(boolean on, int linger) {
    }

    public void open(String address, int port) {
        this.implObj = LocalSocket.openSocket(address, port);
    }

    @Override
    public void close() {
        LocalSocket.closeSocket(this.implObj);
        this.implObj = 0L;
    }

    public LocalSocket accept() throws SocketException {
        return new LocalSocket(LocalSocket.acceptSocket(this.implObj));
    }

    public void cancelAccept() {
        LocalSocket.cancelAcceptSocket(this.implObj);
    }

    public static LocalSocket create(int port) throws SocketException {
        return new LocalSocket(LocalSocket.createSocket(port));
    }

    public LocalSocket(long implObj) throws SocketException {
        super((SocketImpl)null);
        this.implObj = implObj;
    }

    public LocalSocket(String address, int port) throws SocketException {
        super((SocketImpl)null);
        this.open(address, port);
    }

    public LocalSocket() throws SocketException {
        super((SocketImpl)null);
    }

    private static native int readSocket(long var0, byte[] var2, int var3, int var4);

    private static native void writeSocket(long var0, byte[] var2, int var3, int var4);

    private static native void closeSocket(long var0);

    private static native long openSocket(String var0, int var1);

    private static native long createSocket(int var0);

    private static native long acceptSocket(long var0);

    private static native void cancelAcceptSocket(long var0);

    static {
        Runtime.getRuntime().loadLibrary("jnilocalsock");
    }

    class LocalOutputStream
    extends OutputStream {
        LocalOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            byte[] buf = new byte[]{(byte)b};
            this.write(buf, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (LocalSocket.this.implObj == 0L) {
                throw new SocketException("Socket is not connected");
            }
            LocalSocket.writeSocket(LocalSocket.this.implObj, b, off, len);
        }
    }

    class LocalInputStream
    extends InputStream {
        LocalInputStream() {
        }

        @Override
        public int read() throws IOException {
            byte[] buf = new byte[1];
            return this.read(buf, 0, 1) == 1 ? buf[0] & 0xFF : -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (LocalSocket.this.implObj == 0L) {
                throw new SocketException("Socket is not connected");
            }
            return LocalSocket.readSocket(LocalSocket.this.implObj, b, off, len);
        }
    }
}

