#include "fthread.h"
#include <stdio.h>

ft_event_t event;

DEFINE_AUTOMATON (autom)
{
  BEGIN_AUTOMATON
     STATE_AWAIT (0,event)
     {
         fprintf (stdout, "*");
         GOTO(0);
     }

  END_AUTOMATON
}

/*********************************/
void traceInstants (void *args)
{
   int i = 0;
   while (1) {
      fprintf(stdout,"\n>>>>>>>>>>> instant %d: ",i++);
      ft_thread_cooperate ();
   }
}

void generator (void *args)
{
   int i;
   for (i=0;i<2;i++) {
      ft_thread_cooperate_n (10);
      fprintf (stdout, "event generated! ");
      ft_thread_generate (event);
   }
   ft_thread_cooperate ();
   fprintf (stdout, "exit\n");   
   exit (0);
}

int main ()
{
   int i;
   ft_scheduler_t sched = ft_scheduler_create ();

   ft_thread_create (sched,traceInstants,NULL,NULL);  
   for (i=0;i<5000;i++) ft_automaton_create (sched,autom,NULL,NULL);
   ft_thread_create (sched,generator,NULL,NULL);   
   
   event = ft_event_create (sched);
   ft_scheduler_start (sched);
   ft_exit ();
   return 0;
}

/* result

>>>>>>>>>>> instant 0:
>>>>>>>>>>> instant 1:
>>>>>>>>>>> instant 2:
>>>>>>>>>>> instant 3:
>>>>>>>>>>> instant 4:
>>>>>>>>>>> instant 5:
>>>>>>>>>>> instant 6:
>>>>>>>>>>> instant 7:
>>>>>>>>>>> instant 8:
>>>>>>>>>>> instant 9:
>>>>>>>>>>> instant 10: event generated! ********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
>>>>>>>>>>> instant 11:
>>>>>>>>>>> instant 12:
>>>>>>>>>>> instant 13:
>>>>>>>>>>> instant 14:
>>>>>>>>>>> instant 15:
>>>>>>>>>>> instant 16:
>>>>>>>>>>> instant 17:
>>>>>>>>>>> instant 18:
>>>>>>>>>>> instant 19:
>>>>>>>>>>> instant 20: event generated! ********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
>>>>>>>>>>> instant 21: exit
end result */
