/*****************************************************************************/
/* EyeClock - A clock application for X. The eyes follow the mouse pointer.  */
/*                                                                           */
/* EyeClock Copyright (C) 1998-1999 Sakai Hiroaki.                           */
/* All Rights Reserved.                                                      */
/*                                                                           */
/* EyeClock is a simple clock application for X11. You can put your favorite */
/* picture on the face of the clock. And you can move the eyes of the        */
/* picture following the mouse pointer.                                      */
/*                                                                           */
/* This file is a part of EyeClock.                                          */
/* EyeClock is FREE SOFTWARE. You can use, copy, modify, and/or redistribute */
/* it freely under the terms in the COPYRIGHT.                               */
/* See the COPYRIGHT for more details.                                       */
/*****************************************************************************/

/*****************************************************************************/
/* ʴؿ                                                            */
/* ()                                                            */
/*===========================================================================*/
/* Υե                                                        */
/*---------------------------------------------------------------------------*/
/* Υեϡ󥯥롼ѤΥإåեǤ                  */
/* ѻˤϡΥե򥤥󥯥롼ɤƤ                      */
/*****************************************************************************/

/*****************************************************************************/
/*                                                                   */
/*****************************************************************************/

#ifndef _etc_h_INCLUDED_
#define _etc_h_INCLUDED_

/*****************************************************************************/
/* إåեΥ󥯥롼(ѥ֥åʤ)                            */
/*****************************************************************************/

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/xpm.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*****************************************************************************/
/* (ѥ֥åʤ)                                              */
/*****************************************************************************/

#ifndef EYECLOCK_LIB
#define EYECLOCK_LIB "/usr/X11R6/lib/X11/EyeClock"
#endif

/*****************************************************************************/
/* (ѥ֥åʤ)                                                */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/* ѿ(ѥ֥åʤ)                                          */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/* ؿ                                                                      */
/*****************************************************************************/

/*===========================================================================*/
/* ͡Ǿ                                                            */
/*===========================================================================*/

int Min(int a, int b);
int Max(int a, int b);

/*===========================================================================*/
/* ե¸ߤĴ٤                                                    */
/*===========================================================================*/

int IsFileExistent(char * filename);

/*===========================================================================*/
/* ǥ쥯ȥ̾ȥե̾礹                                      */
/*===========================================================================*/

void ConcatenateFilename(char * buffer, int size,
			 char * dirname, char * filename);

/*===========================================================================*/
/* ԥåޥåסեɤ߹                                        */
/*===========================================================================*/

Pixmap MakePixmapFromFile(Display * display, Window w, char * filename);

/*===========================================================================*/
/* ǡԥåޥåפ                                        */
/*===========================================================================*/

Pixmap MakePixmapFromPixmapData(Display * display, Window w, char ** string);

/*===========================================================================*/
/* Drawable Υ                                                   */
/*===========================================================================*/

int GetX(Display * display, Drawable d);
int GetY(Display * display, Drawable d);
unsigned int GetWidth(Display * display, Drawable d);
unsigned int GetHeight(Display * display, Drawable d);
unsigned int GetDepth(Display * display, Drawable d);

/*===========================================================================*/
/* ԥåޥåפ˾Υ˳̾ơԥåޥåפ֤  */
/*===========================================================================*/

Pixmap CreateResizedPixmap(Display * display, Drawable d, Pixmap src,
			   unsigned int dst_width, unsigned int dst_height);

/*===========================================================================*/
/* ԥåޥåפ˾Υ˳̾                                */
/*===========================================================================*/

Pixmap ResizePixmap(Display * display, Drawable d, Pixmap src,
		    unsigned int dst_width, unsigned int dst_height);

/*===========================================================================*/
/* Ψ֤                                                                */
/*===========================================================================*/

int ComputeRatio(int source_width, int source_height,
		 int pixmap_width, int pixmap_height);


/*===========================================================================*/
/* ɥФޥκɸ֤                                      */
/*===========================================================================*/

XPoint GetPointerPosition(Display * display, Window window);

/*===========================================================================*/
/* ޥưŪ˺                                              */
/*===========================================================================*/

Pixmap CreateMaskPixmap(Display * display, Drawable d, Pixmap src,
			GC figure_gc, GC mask_gc);
Pixmap CreateMaskBitmap(Display * display, Drawable d, Pixmap src);
Pixmap CreateInvertMaskBitmap(Display * display, Drawable d, Pixmap src);

/*****************************************************************************/
/* ޤ                                                                  */
/*****************************************************************************/

#endif

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
