/*****************************************************************************/
/* EyeClock - A clock application for X. The eyes follow the mouse pointer.  */
/*                                                                           */
/* EyeClock Copyright (C) 1998-1999 Sakai Hiroaki.                           */
/* All Rights Reserved.                                                      */
/*                                                                           */
/* EyeClock is a simple clock application for X11. You can put your favorite */
/* picture on the face of the clock. And you can move the eyes of the        */
/* picture following the mouse pointer.                                      */
/*                                                                           */
/* This file is a part of EyeClock.                                          */
/* EyeClock is FREE SOFTWARE. You can use, copy, modify, and/or redistribute */
/* it freely under the terms in the COPYRIGHT.                               */
/* See the COPYRIGHT for more details.                                       */
/*****************************************************************************/

/*****************************************************************************/
/* ꥽С                                                      */
/* ()                                                                    */
/*===========================================================================*/
/* Υե                                                        */
/*---------------------------------------------------------------------------*/
/* Υեϡ饤֥ΤǤ                                    */
/*****************************************************************************/

/*****************************************************************************/
/*                                                                   */
/*****************************************************************************/

#include "converter.h"

/*****************************************************************************/
/* إåեΥ󥯥롼                                              */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/*                                                                 */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/*                                                                   */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/* ѿ                                                            */
/*****************************************************************************/

/*===========================================================================*/
/* ǥեȤΥԥåޥå                                                */
/*===========================================================================*/

/*---------------------------------------------------------------------------*/
/* ǥեȤΥ                                                      */
/*---------------------------------------------------------------------------*/

#if defined(DEFAULT_ICON_IS_BSD_DAEMON)
#include "xpm/daemon_icon_face.xpm"
#else
#include "xpm/default_icon_face.xpm"
#endif

/*---------------------------------------------------------------------------*/
/* ǥեȤδ顤ܡܶ                                                  */
/*---------------------------------------------------------------------------*/

#if defined(DEFAULT_FACE_IS_BSD_DAEMON)
#include "xpm/daemon_face.xpm"
#include "xpm/default_left_core.xpm"
#include "xpm/default_right_core.xpm"
#include "xpm/daemon_left_eye.xpm"
#include "xpm/daemon_right_eye.xpm"
#elif defined(DEFAULT_FACE_IS_PENGUIN)
#include "xpm/penguin_face.xpm"
#include "xpm/default_left_core.xpm"
#include "xpm/default_right_core.xpm"
#include "xpm/penguin_left_eye.xpm"
#include "xpm/penguin_right_eye.xpm"
#else
#include "xpm/taro_face.xpm"
#include "xpm/taro_left_core.xpm"
#include "xpm/taro_right_core.xpm"
#include "xpm/taro_left_eye.xpm"
#include "xpm/taro_right_eye.xpm"
#endif

/*---------------------------------------------------------------------------*/
/* ǥեȤοʸ                                                        */
/*---------------------------------------------------------------------------*/

#include "xpm/number_01.xpm"
#include "xpm/number_02.xpm"
#include "xpm/number_03.xpm"
#include "xpm/number_04.xpm"
#include "xpm/number_05.xpm"
#include "xpm/number_06.xpm"
#include "xpm/number_07.xpm"
#include "xpm/number_08.xpm"
#include "xpm/number_09.xpm"
#include "xpm/number_10.xpm"
#include "xpm/number_11.xpm"
#include "xpm/number_12.xpm"
#include "xpm/number_r01.xpm"
#include "xpm/number_r02.xpm"
#include "xpm/number_r03.xpm"
#include "xpm/number_r04.xpm"
#include "xpm/number_r05.xpm"
#include "xpm/number_r06.xpm"
#include "xpm/number_r07.xpm"
#include "xpm/number_r08.xpm"
#include "xpm/number_r09.xpm"
#include "xpm/number_r10.xpm"
#include "xpm/number_r11.xpm"
#include "xpm/number_r12.xpm"
#include "xpm/number_big.xpm"
#include "xpm/number_small.xpm"
#include "xpm/number_needle_00.xpm"
#include "xpm/number_needle_01.xpm"
#include "xpm/number_needle_02.xpm"
#include "xpm/number_needle_03.xpm"
#include "xpm/number_needle_04.xpm"
#include "xpm/number_needle_05.xpm"

/*===========================================================================*/
/* ǥեȤΥԥåޥåפ̾Τ                                    */
/*===========================================================================*/

static struct {
  char * name;
  char ** data;
} default_pixmaps[] = {
  /* ǥեȤΥ */
  {"DefaultIconFace", icon_face_xpm},

  /* ǥեȤδ */
  {"DefaultFace", face_xpm},

  /* ǥեȤܶ */
  {"DefaultLeftCore" , left_core_xpm},
  {"DefaultRightCore", right_core_xpm},

  /* ǥեȤ */
  {"DefaultLeftEye"  , left_eye_xpm},
  {"DefaultRightEye" , right_eye_xpm},

  /* ǥեȤοʸ */
  {"DefaultNumber1"  , number_01_xpm},
  {"DefaultNumber2"  , number_02_xpm},
  {"DefaultNumber3"  , number_03_xpm},
  {"DefaultNumber4"  , number_04_xpm},
  {"DefaultNumber5"  , number_05_xpm},
  {"DefaultNumber6"  , number_06_xpm},
  {"DefaultNumber7"  , number_07_xpm},
  {"DefaultNumber8"  , number_08_xpm},
  {"DefaultNumber9"  , number_09_xpm},
  {"DefaultNumber10" , number_10_xpm},
  {"DefaultNumber11" , number_11_xpm},
  {"DefaultNumber12" , number_12_xpm},
  {"DefaultNumberR1" , number_r01_xpm},
  {"DefaultNumberR2" , number_r02_xpm},
  {"DefaultNumberR3" , number_r03_xpm},
  {"DefaultNumberR4" , number_r04_xpm},
  {"DefaultNumberR5" , number_r05_xpm},
  {"DefaultNumberR6" , number_r06_xpm},
  {"DefaultNumberR7" , number_r07_xpm},
  {"DefaultNumberR8" , number_r08_xpm},
  {"DefaultNumberR9" , number_r09_xpm},
  {"DefaultNumberR10", number_r10_xpm},
  {"DefaultNumberR11", number_r11_xpm},
  {"DefaultNumberR12", number_r12_xpm},
  {"DefaultNumberBig"  , number_big_xpm},
  {"DefaultNumberSmall", number_small_xpm},
  {"DefaultNumberNeedle0"  , number_needle_00_xpm},
  {"DefaultNumberNeedle1"  , number_needle_01_xpm},
  {"DefaultNumberNeedle2"  , number_needle_02_xpm},
  {"DefaultNumberNeedle3"  , number_needle_03_xpm},
  {"DefaultNumberNeedle4"  , number_needle_04_xpm},
  {"DefaultNumberNeedle5"  , number_needle_05_xpm},
  {NULL, NULL}
};

/*===========================================================================*/
/* ǥեȤΥӥåȥޥåפ̾Τ                                      */
/*===========================================================================*/

static struct {
  char * name;
  int width;
  int height;
  char * data;
} default_bitmaps[] = {
  /* ǥեȤΥ */
  /*
  {"DefaultIconMaskBitmap", icon_mask_width, icon_mask_height, icon_mask_bits},
  */
  {NULL, 0, 0, NULL}
};

/*****************************************************************************/
/* ؿ                                                                */
/*****************************************************************************/

/*===========================================================================*/
/* ꥽С                                                      */
/*===========================================================================*/

/*---------------------------------------------------------------------------*/
/* String  Pixmap                                                          */
/*---------------------------------------------------------------------------*/

Boolean ConvertStringToPixmap(Display * d,
			      XrmValue * args, Cardinal * num,
			      XrmValue * from, XrmValue * to,
			      XtPointer * converter_data)
{
  Window r;
  static char * str;    /* static ǤʤФʤ? */
  static Pixmap pixmap; /* static ǤʤФʤ? */
  int i;

  str = (char *)(from->addr);

  r = DefaultRootWindow(d);

  pixmap = 0;

  if (str == NULL)
    pixmap = 0;
  else if (!strcmp(str, ""    ) || !strcmp(str, "none") ||
	   !strcmp(str, "None") || !strcmp(str, "NONE"))
    pixmap = 0;
  else if (!strcmp(str, "auto") || !strcmp(str, "Auto") ||
	   !strcmp(str, "AUTO"))
    pixmap = 0;
  else {
    /* ǥեȤΥԥåޥåפθ */
    for (i = 0; default_pixmaps[i].name; i++) {
      if (!strcmp(str, default_pixmaps[i].name)) {
	pixmap = MakePixmapFromPixmapData(d, r, default_pixmaps[i].data);
	goto set_pixmap;
      }
    }
    /* ǥեȤΥӥåȥޥåפθ */
    for (i = 0; default_bitmaps[i].name; i++) {
      if (!strcmp(str, default_bitmaps[i].name)) {
	pixmap = XCreateBitmapFromData(d, r,
				       default_bitmaps[i].data,
				       default_bitmaps[i].width,
				       default_bitmaps[i].height);
	goto set_pixmap;
      }
    }
    /* ե뤫ɤ߹ */
    pixmap = MakePixmapFromFile(d, r, str);
  }

set_pixmap:

  to->size = sizeof(Pixmap);
  *(Pixmap *)(to->addr) = pixmap;

  return (True);
}

/*---------------------------------------------------------------------------*/
/* PixmapData  Pixmap                                                      */
/*---------------------------------------------------------------------------*/

Boolean ConvertPixmapDataToPixmap(Display * d,
				  XrmValue * args, Cardinal * num,
				  XrmValue * from, XrmValue * to,
				  XtPointer * converter_data)
{
  static char ** str;   /* static ǤʤФʤ */
  static Pixmap pixmap; /* static ǤʤФʤ */

  str = (char **)(from->addr);

  if (str == NULL)
    pixmap = 0;
  else
    pixmap = MakePixmapFromPixmapData(d, DefaultRootWindow(d), str);

  to->size = sizeof(Pixmap);
  *(Pixmap *)(to->addr) = pixmap;

  return (True);
}

/*---------------------------------------------------------------------------*/
/* String  XPoint                                                          */
/* ("100x100" Τ褦ʸ󤫤顤XPoint Υǡ)                   */
/*---------------------------------------------------------------------------*/

Boolean ConvertStringToPoint(Display * d,
			     XrmValue * args, Cardinal * num,
			     XrmValue * from, XrmValue * to,
			     XtPointer * converter_data)
{
  static int i, len;
  static char * s;     /* static ǤʤФʤ */
  static XPoint point; /* static ǤʤФʤ */

  s = (char *)(from->addr);

  point.x = 0;
  point.y = 0;

  if (!strcmp(s, ""    ) || !strcmp(s, "none") ||
      !strcmp(s, "None") || !strcmp(s, "NONE")) {
    point.x = 0;
    point.y = 0;
  } else if (!strcmp(s, "auto") || !strcmp(s, "Auto") || !strcmp(s, "AUTO")) {
    point.x = -1;
    point.y = -1;
  } else {
    len = strlen(s);
    for (i = 0; i < len; i++) {
      if (!isdigit(s[i])) {
	if ((s[i] == 'x') || (s[i] == 'X') || (s[i] == '*')) {
	  point.x = atoi(s);
	  point.y = atoi(s + i + 1);
	  break;
	} else {
	  point.x = atoi(s);
	  point.y = atoi(s);
	  break;
	}
      }
    }
  }

  /* ꥽ XtResource ǻꤵƤȤ˽񤭹Τǡ */
  /* γݤϤʤ */
  to->size = sizeof(XPoint);
  *(XPoint *)(to->addr) = point;

  return (True);
}

/*---------------------------------------------------------------------------*/
/* Geometry  ɸ⤵                                                */
/* ("100x100+0+0" Τ褦ʸ󤫤顤ɸ⤵롥                 */
/*---------------------------------------------------------------------------*/

Boolean ConvertGeometryStringToPoint(Display * d,
				     XrmValue * args, Cardinal * num,
				     XrmValue * from, XrmValue * to,
				     XtPointer * converter_data)
{
  static char * s;                /* static ǤʤФʤ */
  static char * p;                /* static ǤʤФʤ */
  static Position x, y;           /* static ǤʤФʤ */
  static Dimension width, height; /* static ǤʤФʤ */

  s = (char *)(from->addr);
  x = y = 0;
  width = height = 0;

  if (!strcmp(s, "auto") || !strcmp(s, "Auto") || !strcmp(s, "AUTO") ||
      !strcmp(s, "none") || !strcmp(s, "None") || !strcmp(s, "NONE")) {
    x = y = 0;
    width = height = 0;
  } else {
    p = s;
    if ((*s == '+') || (*s == '-')) s++;
    for (; isdigit(*s); s++) { /* None */ }
    if ((*s == '+') || (*s == '-')) {
      x = atoi(p);
      y = atoi(s);
    } else {
      width  = atoi(p);
      height = atoi(++s);
      for (; isdigit(*s); s++) { /* None */ }
      x = atoi(s++);
      for (; isdigit(*s); s++) { /* None */ }
      y = atoi(s);
    }
  }

  /* ꥽ XtResource ǻꤵƤȤ˽񤭹Τǡ */
  /* γݤϤʤ */
  to->size = sizeof(CorePart);
  ((CorePart *)(to->addr))->width  = width;
  ((CorePart *)(to->addr))->height = height;
  ((CorePart *)(to->addr))->x = x;
  ((CorePart *)(to->addr))->y = y;

  return (True);
}

/*****************************************************************************/
/* ޤ                                                                  */
/*****************************************************************************/

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
