/*****************************************************************************/
/* EyeClock - A clock application for X. The eyes follow the mouse pointer.  */
/*                                                                           */
/* EyeClock Copyright (C) 1998-1999 Sakai Hiroaki.                           */
/* All Rights Reserved.                                                      */
/*                                                                           */
/* EyeClock is a simple clock application for X11. You can put your favorite */
/* picture on the face of the clock. And you can move the eyes of the        */
/* picture following the mouse pointer.                                      */
/*                                                                           */
/* This file is a part of EyeClock.                                          */
/* EyeClock is FREE SOFTWARE. You can use, copy, modify, and/or redistribute */
/* it freely under the terms in the COPYRIGHT.                               */
/* See the COPYRIGHT for more details.                                       */
/*****************************************************************************/

/*****************************************************************************/
/* Number å                                                       */
/* (Τ)                                                            */
/*===========================================================================*/
/* Υե                                                        */
/*---------------------------------------------------------------------------*/
/* Υեϡץ饤١ȤʥإåեǤ                        */
/* ץ饤١ȤʥФ˥Ȥʳˤϡ                          */
/* 󥯥롼ɤƻѤʤǤ                                    */
/* Υե򥤥󥯥롼ɤСץ饤١ȤʥФ˥        */
/* ǽˤʤޤ                                                          */
/*****************************************************************************/

#ifndef _NumberP_h_INCLUDED_
#define _NumberP_h_INCLUDED_

/*****************************************************************************/
/*                                                                   */
/*****************************************************************************/

#include "Number.h"

/*****************************************************************************/
/* إåեΥ󥯥롼(ץ饤١Ȥʤ)                          */
/*****************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "converter.h"
#include "etc.h"

/*****************************************************************************/
/* (ץ饤١Ȥʤ)                                            */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/* (ץ饤١Ȥʤ)                                              */
/*****************************************************************************/

/* åȤΥ󥹥󥹤Υ쥳ɤ */
typedef struct _NumberPart {
  Boolean active; /* 褹뤫ʤΥե饰 */
  int number;    /* ʸֹ(112) */

  /* ƥå(Clock å)ΥΨ */
  int face_size; /* פʸĤΥ */
  int face_width; /* פʸĤ */
  int face_height; /* פʸĤι⤵ */
  int ratio, ratio_x, ratio_y; /* Ψ */

  Dimension length; /* ʸȾ */

  Pixmap figure; /* ʸΥԥåޥå */
  Pixmap mask;   /* ʸΥޥ */
  XPoint size;   /* ʸΥԥåޥåפΥ */

  /* ʸꥵ */
  Pixmap resized_figure;
  Pixmap resized_mask;
  int resized_figure_width, resized_figure_height;

  /*  GC */
  GC gc_black, gc_white;
  GC gc_copy_and, gc_copy_or, gc_copy_andinv;
} NumberPart;

typedef struct _NumberRec {
  CorePart core;
  NumberPart number;
} NumberRec;

typedef struct _NumberClassPart {
  int dummy; /* ߡ */
} NumberClassPart;

typedef struct _NumberClassRec {
  CoreClassPart core_class;
  NumberClassPart number_class;
} NumberClassRec;

/*****************************************************************************/
/* ѿ(ץ饤١Ȥʤ)                                        */
/*****************************************************************************/

extern NumberClassRec numberClassRec;

/*****************************************************************************/
/* ؿ                                                                      */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/* ޤ                                                                  */
/*****************************************************************************/

#endif

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
