/*****************************************************************************/
/* EyeClock - A clock application for X. The eyes follow the mouse pointer.  */
/*                                                                           */
/* EyeClock Copyright (C) 1998-1999 Sakai Hiroaki.                           */
/* All Rights Reserved.                                                      */
/*                                                                           */
/* EyeClock is a simple clock application for X11. You can put your favorite */
/* picture on the face of the clock. And you can move the eyes of the        */
/* picture following the mouse pointer.                                      */
/*                                                                           */
/* This file is a part of EyeClock.                                          */
/* EyeClock is FREE SOFTWARE. You can use, copy, modify, and/or redistribute */
/* it freely under the terms in the COPYRIGHT.                               */
/* See the COPYRIGHT for more details.                                       */
/*****************************************************************************/

/*****************************************************************************/
/* Number å                                                       */
/* ()                                                                    */
/*===========================================================================*/
/* Υե                                                        */
/*---------------------------------------------------------------------------*/
/* ΥեϡåȤΤǤ                                  */
/*****************************************************************************/

/*****************************************************************************/
/*                                                                   */
/*****************************************************************************/

#include "NumberP.h"

/*****************************************************************************/
/* إåեΥ󥯥롼                                              */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/*                                                                 */
/*****************************************************************************/

#ifndef M_PI
#define M_PI 3.1415926535
#endif

/*****************************************************************************/
/*                                                                   */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/* ѿ                                                            */
/*****************************************************************************/

/*===========================================================================*/
/* åȤΥ饹Τγ                                          */
/*===========================================================================*/

WidgetClass numberWidgetClass = (WidgetClass)(&numberClassRec);

/*===========================================================================*/
/* ꥽                                                            */
/*===========================================================================*/

static XtResource resources[] = {
  {XtNgeometry, XtCGeometry, XtRWidgetCorePart, sizeof(CorePart),
   XtOffsetOf(NumberRec, core), XtRString, "0x0+0+0"},
  {XtNactive, XtCActive, XtRBoolean, sizeof(Boolean),
   XtOffsetOf(NumberRec, number.active), XtRString, "True"},

  {XtNnumber, XtCNumber, XtRInt, sizeof(int),
   XtOffsetOf(NumberRec, number.number), XtRString, "0"},

  {XtNlength, XtCLength, XtRDimension, sizeof(Dimension),
   XtOffsetOf(NumberRec, number.length), XtRString, "85"},
  {XtNfigure, XtCFigure, XtRPixmap, sizeof(Pixmap),
   XtOffsetOf(NumberRec, number.figure), XtRString, "None"},
  {XtNmask, XtCMask, XtRPixmap, sizeof(Pixmap),
   XtOffsetOf(NumberRec, number.mask), XtRString, "None"},

  {XtNsize, XtCSize, XtRXPoint, sizeof(XPoint),
   XtOffsetOf(NumberRec, number.size), XtRString, "0x0"},

  {XtNfaceSize, XtCFaceSize, XtRInt, sizeof(int),
   XtOffsetOf(NumberRec, number.face_size), XtRString, "64"},
  {XtNfaceWidth, XtCFaceWidth, XtRInt, sizeof(int),
   XtOffsetOf(NumberRec, number.face_width), XtRString, "64"},
  {XtNfaceHeight, XtCFaceHeight, XtRInt, sizeof(int),
   XtOffsetOf(NumberRec, number.face_height), XtRString, "64"},
  {XtNratio, XtCRatio, XtRInt, sizeof(int),
   XtOffsetOf(NumberRec, number.ratio), XtRString, "100"},
  {XtNratioX, XtCRatioX, XtRInt, sizeof(int),
   XtOffsetOf(NumberRec, number.ratio_x), XtRString, "100"},
  {XtNratioY, XtCRatioY, XtRInt, sizeof(int),
   XtOffsetOf(NumberRec, number.ratio_y), XtRString, "100"}};

/*===========================================================================*/
/* åȤΥ饹                                                */
/*===========================================================================*/

static void ClassInitialize();
static void ClassPartInitialize(WidgetClass widgetClass);

static void Initialize();
static void Realize(Widget w, XtValueMask * value_mask,
		    XSetWindowAttributes * attrs);
static void Destroy(Widget w);
static void Resize(Widget w);
static void Redisplay(Widget w, XEvent * event, Region region);

NumberClassRec numberClassRec = {
  { /* core ե */
    &widgetClassRec,        /* ѡ饹 */
    "Number",               /* 饹̾ */
    sizeof(NumberRec),      /*  */
    ClassInitialize,        /* 饹ν */
    NULL,                   /* class part ν */
    FALSE,                  /* class_inited */
    Initialize,             /* 󥹥󥹤ν */
    NULL,                   /* initialize_hook */
    Realize,                /* realize */
    NULL,                   /* actions */
    0,                      /* actions ο */
    resources,              /* ꥽ */
    XtNumber(resources),    /* ꥽ο */
    NULLQUARK,              /* xrm_class */
    TRUE,                   /* motion  */
    TRUE,                   /* exposure  */
    TRUE,                   /* enterleave  */
    FALSE,                  /* visible_interest */
    Destroy,                /* 󥹥󥹤κ */
    Resize,                 /* ꥵ */
    Redisplay,              /* ݡ */
    NULL,                   /* set_values */
    NULL,                   /* set_values_hook */
    NULL,                   /* set_values_almost */
    NULL,                   /* get_values_hook */
    NULL,                   /* accept_focus */
    XtVersion,              /* С */
    NULL,                   /* callback_offsets */
    NULL,                   /* tm_table */
    XtInheritQueryGeometry, /* query_geometry */
    NULL,                   /* display_accelerator */
    NULL                    /* extension */
  },
  { /* number ե */
    0                       /* dummy */
  }
};

/*****************************************************************************/
/* ؿ                                                                */
/*****************************************************************************/

static void ClassInitialize()
{
  /* ꥽СϿ */
  XtSetTypeConverter(XtRString, XtRXPoint, ConvertStringToPoint,
		     NULL, 0, XtCacheNone, NULL);
  XtSetTypeConverter(XtRString, XtRBitmap, ConvertStringToPixmap,
                     NULL, 0, XtCacheNone, NULL);
  XtSetTypeConverter(XtRString, XtRPixmap, ConvertStringToPixmap,
		     NULL, 0, XtCacheNone, NULL);
  XtSetTypeConverter(XtRPixmapData, XtRPixmap, ConvertPixmapDataToPixmap,
		     NULL, 0, XtCacheNone, NULL);
  XtSetTypeConverter(XtRString, XtRWidgetCorePart, 
		     ConvertGeometryStringToPoint, NULL, 0,
		     XtCacheNone, NULL);
}

static void ClassPartInitialize(WidgetClass widgetClass) { /* None */ }

static void Initialize(Widget req, Widget new, ArgList args, Cardinal num)
{
  NumberWidget nw = (NumberWidget)new;
  Display * d;
  Window r;

  if (!nw->number.active) return;

  d = XtDisplay(new);
  r = DefaultRootWindow(d);

  if (!nw->number.figure) {
    nw->number.active = False;
    return;
  }

  if (nw->number.size.x <= 0)
    nw->number.size.x =
      new->core.width  ? new->core.width  : GetWidth( d, nw->number.figure);

  if (nw->number.size.y <= 0)
    nw->number.size.y =
      new->core.height ? new->core.height : GetHeight(d, nw->number.figure);

  new->core.width  = nw->number.size.x;
  new->core.height = nw->number.size.y;

  if ((nw->number.size.x != GetWidth( d, nw->number.figure)) ||
      (nw->number.size.y != GetHeight(d, nw->number.figure))) {
    nw->number.figure = ResizePixmap(d, r, nw->number.figure,
				     nw->number.size.x, nw->number.size.y);
  }

  /* GC κ */
  nw->number.gc_black = XCreateGC(d, DefaultRootWindow(d), 0, 0);
  nw->number.gc_white = XCreateGC(d, DefaultRootWindow(d), 0, 0);
  nw->number.gc_copy_and    = XCreateGC(d, DefaultRootWindow(d), 0, 0);
  nw->number.gc_copy_andinv = XCreateGC(d, DefaultRootWindow(d), 0, 0);
  nw->number.gc_copy_or     = XCreateGC(d, DefaultRootWindow(d), 0, 0);
  XSetForeground(d, nw->number.gc_black, BlackPixel(d, DefaultScreen(d)));
  XSetForeground(d, nw->number.gc_white, WhitePixel(d, DefaultScreen(d)));
  XSetFunction(d, nw->number.gc_copy_and,    GXand);
  XSetFunction(d, nw->number.gc_copy_andinv, GXandInverted);
  XSetFunction(d, nw->number.gc_copy_or,     GXor);

  /* ޥ̵ˤϡưŪ˺ */
  if (!nw->number.mask)
    nw->number.mask = CreateMaskPixmap(d, r, nw->number.figure,
				       nw->number.gc_black,
				       nw->number.gc_white);
  if (nw->number.mask) {
    if ((GetWidth( d, nw->number.mask) != nw->number.size.x) ||
	(GetHeight(d, nw->number.mask) != nw->number.size.y))
      nw->number.mask = ResizePixmap(d, r, nw->number.mask,
				     nw->number.size.x, nw->number.size.y);
    XCopyArea(d, nw->number.mask, nw->number.figure,
	      nw->number.gc_copy_andinv,
	      0, 0, nw->number.size.x, nw->number.size.y, 0, 0);
  }

  nw->number.resized_figure = 0;
  nw->number.resized_mask   = 0;
}

static void Realize(Widget w, XtValueMask * value_mask,
		    XSetWindowAttributes * attrs)
{
  NumberWidget nw = (NumberWidget)w;

  if (!nw->number.active) return;

  /* if (!nw->number.resized_figure) Resize(w); */
}

static void Destroy(Widget w)
{
  NumberWidget nw = (NumberWidget)w;
  Display * d;

  if (!nw->number.active) return;

  d = XtDisplay(w);

  if (nw->number.gc_black) {
    XFreeGC(d, nw->number.gc_black);
    nw->number.gc_black = 0;
  }
  if (nw->number.gc_white) {
    XFreeGC(d, nw->number.gc_white);
    nw->number.gc_white = 0;
  }
  if (nw->number.gc_copy_and) {
    XFreeGC(d, nw->number.gc_copy_and);
    nw->number.gc_copy_and = 0;
  }
  if (nw->number.gc_copy_andinv) {
    XFreeGC(d, nw->number.gc_copy_andinv);
    nw->number.gc_copy_andinv = 0;
  }
  if (nw->number.gc_copy_or) {
    XFreeGC(d, nw->number.gc_copy_or);
    nw->number.gc_copy_or = 0;
  }

  if (nw->number.figure) {
    XFreePixmap(d, nw->number.figure);
    nw->number.figure = 0;
  }
  if (nw->number.mask) {
    XFreePixmap(d, nw->number.mask);
    nw->number.mask = 0;
  }

  if (nw->number.resized_figure) {
    XFreePixmap(d, nw->number.resized_figure);
    nw->number.resized_figure = 0;
  }
  if (nw->number.resized_mask) {
    XFreePixmap(d, nw->number.resized_mask);
    nw->number.resized_mask = 0;
  }
}

static void Resize(Widget w)
{
  NumberWidget nw = (NumberWidget)w;
  Display * d;
  Window r;
  int width, height;

  if (!nw->number.active) return;

  d = XtDisplay(w);
  r = DefaultRootWindow(d);

  if (nw->number.resized_figure) {
    XFreePixmap(d, nw->number.resized_figure);
    nw->number.resized_figure = 0;
  }
  if (nw->number.resized_mask) {
    XFreePixmap(d, nw->number.resized_mask);
    nw->number.resized_mask = 0;
  }

  width  = (int)nw->number.size.x * nw->number.ratio / 100;
  height = (int)nw->number.size.y * nw->number.ratio / 100;

  nw->number.resized_figure = (width>0 && height>0 && nw->number.figure)
    ? CreateResizedPixmap(d, r, nw->number.figure, width, height) : 0;
  nw->number.resized_mask   = (width>0 && height>0 && nw->number.mask)
    ? CreateResizedPixmap(d, r, nw->number.mask  , width, height) : 0;
}

static void Redisplay(Widget w, XEvent * event, Region region)
{
  NumberWidget nw = (NumberWidget)w;

  if (!nw->number.active) return;

  /* None */
}

/*===========================================================================*/
/* 饹Υ᥽åɤ                                                    */
/*===========================================================================*/

/*---------------------------------------------------------------------------*/
/*                                                                       */
/*---------------------------------------------------------------------------*/

void NumberDraw(Widget w, Pixmap pixmap, XPoint center)
{
  NumberWidget nw = (NumberWidget)w;
  double c, s;
  int x0, y0, x, y;
  int width, height;

  if (!nw->number.active) return;

  if (!pixmap) return; /* 褬ʤ */

  c = cos((nw->number.number - 3) * (30.0 * M_PI / 180.0));
  s = sin((nw->number.number - 3) * (30.0 * M_PI / 180.0));

  width  = (int)nw->number.size.x * nw->number.ratio / 100;
  height = (int)nw->number.size.y * nw->number.ratio / 100;

  x0 = center.x +
    (nw->number.face_width /2 * (int)w->core.x/100 * nw->number.ratio_x/100);

  y0 = center.y +
    (nw->number.face_height/2 * (int)w->core.y/100 * nw->number.ratio_y/100);

  x = x0
    + (int)(nw->number.face_size/2 * (int)nw->number.length / 100 * c)
    * nw->number.ratio / 100 - (int)(width /2);
  y = y0
    + (int)(nw->number.face_size/2 * (int)nw->number.length / 100 * s)
    * nw->number.ratio / 100 - (int)(height/2);

  if (nw->number.resized_mask)
    XCopyArea(XtDisplay(w), nw->number.resized_mask  , pixmap,
	      nw->number.gc_copy_and, 0, 0, width, height, x, y);
  if (nw->number.resized_figure)
    XCopyArea(XtDisplay(w), nw->number.resized_figure, pixmap,
	      nw->number.gc_copy_or , 0, 0, width, height, x, y);
}

/*****************************************************************************/
/* ޤ                                                                  */
/*****************************************************************************/

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
