/*****************************************************************************/
/* EyeClock - A clock application for X. The eyes follow the mouse pointer.  */
/*                                                                           */
/* EyeClock Copyright (C) 1998-1999 Sakai Hiroaki.                           */
/* All Rights Reserved.                                                      */
/*                                                                           */
/* EyeClock is a simple clock application for X11. You can put your favorite */
/* picture on the face of the clock. And you can move the eyes of the        */
/* picture following the mouse pointer.                                      */
/*                                                                           */
/* This file is a part of EyeClock.                                          */
/* EyeClock is FREE SOFTWARE. You can use, copy, modify, and/or redistribute */
/* it freely under the terms in the COPYRIGHT.                               */
/* See the COPYRIGHT for more details.                                       */
/*****************************************************************************/

/*****************************************************************************/
/* Hand å                                                         */
/* ()                                                            */
/*===========================================================================*/
/* Υե                                                        */
/*---------------------------------------------------------------------------*/
/* Υեϡ󥯥롼ѤΥإåեǤ                  */
/* ѻˤϡΥե򥤥󥯥롼ɤƤ                      */
/*****************************************************************************/

#ifndef _Hand_h_INCLUDED_
#define _Hand_h_INCLUDED_

/*****************************************************************************/
/*                                                                   */
/*****************************************************************************/

/*****************************************************************************/
/* إåեΥ󥯥롼(ѥ֥åʤ)                            */
/*****************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Core.h>

/*****************************************************************************/
/* (ѥ֥åʤ)                                              */
/*****************************************************************************/

typedef enum {OTHER_TYPE, SECOND_HAND, MINUTE_HAND, HOUR_HAND} HandType;

#ifndef XtNgeometry
#define XtNgeometry "geometry"
#endif
#ifndef XtCGeometry
#define XtCGeometry "Geometry"
#endif

#ifndef XtNactive
#define XtNactive "active"
#endif
#ifndef XtCActive
#define XtCActive "Active"
#endif

#ifndef XtNtype
#define XtNtype "type"
#endif
#ifndef XtCType
#define XtCType "Type"
#endif

#ifndef XtNfaceSize
#define XtNfaceSize "faceSize"
#endif
#ifndef XtCFaceSize
#define XtCFaceSize "FaceSize"
#endif

#ifndef XtNfaceWidth
#define XtNfaceWidth "faceWidth"
#endif
#ifndef XtCFaceWidth
#define XtCFaceWidth "FaceWidth"
#endif

#ifndef XtNfaceHeight
#define XtNfaceHeight "faceHeight"
#endif
#ifndef XtCFaceHeight
#define XtCFaceHeight "FaceHeight"
#endif

#ifndef XtNforeground
#define XtNforeground "foreground"
#endif
#ifndef XtCForeground
#define XtCForeground "Foreground"
#endif

#ifndef XtNwidth
#define XtNwidth  "width"
#endif
#ifndef XtCWidth
#define XtCWidth  "Width"
#endif

#ifndef XtNlength
#define XtNlength "length"
#endif
#ifndef XtCLength
#define XtCLength "Length"
#endif

#ifndef XtNratio
#define XtNratio "ratio"
#endif
#ifndef XtCRatio
#define XtCRatio "Ratio"
#endif

#ifndef XtNratioX
#define XtNratioX "ratioX"
#endif
#ifndef XtCRatioX
#define XtCRatioX "RatioX"
#endif

#ifndef XtNratioY
#define XtNratioY "ratioY"
#endif
#ifndef XtCRatioY
#define XtCRatioY "RatioY"
#endif

/*****************************************************************************/
/* (ѥ֥åʤ)                                                */
/*****************************************************************************/

typedef struct _HandRec * HandWidget;
typedef struct _HandClassRec * HandWidgetClass;

/*****************************************************************************/
/* ѿ(ѥ֥åʤ)                                          */
/*****************************************************************************/

extern WidgetClass handWidgetClass;

/*****************************************************************************/
/* ؿ                                                                      */
/*****************************************************************************/

/*===========================================================================*/
/* 饹Υ᥽åɤ                                                    */
/*===========================================================================*/

/*---------------------------------------------------------------------------*/
/*                                                                       */
/*---------------------------------------------------------------------------*/

void HandDraw(Widget w, Pixmap pixmap, XPoint center, time_t t);

/*****************************************************************************/
/* ޤ                                                                  */
/*****************************************************************************/

#endif

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
