/*****************************************************************************/
/* EyeClock - A clock application for X. The eyes follow the mouse pointer.  */
/*                                                                           */
/* EyeClock Copyright (C) 1998-1999 Sakai Hiroaki.                           */
/* All Rights Reserved.                                                      */
/*                                                                           */
/* EyeClock is a simple clock application for X11. You can put your favorite */
/* picture on the face of the clock. And you can move the eyes of the        */
/* picture following the mouse pointer.                                      */
/*                                                                           */
/* This file is a part of EyeClock.                                          */
/* EyeClock is FREE SOFTWARE. You can use, copy, modify, and/or redistribute */
/* it freely under the terms in the COPYRIGHT.                               */
/* See the COPYRIGHT for more details.                                       */
/*****************************************************************************/

/*****************************************************************************/
/* Clock å                                                        */
/* ()                                                            */
/*===========================================================================*/
/* Υե                                                        */
/*---------------------------------------------------------------------------*/
/* Υեϡ󥯥롼ѤΥإåեǤ                  */
/* ѻˤϡΥե򥤥󥯥롼ɤƤ                      */
/*****************************************************************************/

#ifndef _Clock_h_INCLUDED_
#define _Clock_h_INCLUDED_

/*****************************************************************************/
/*                                                                   */
/*****************************************************************************/

/*****************************************************************************/
/* إåեΥ󥯥롼(ѥ֥åʤ)                            */
/*****************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Core.h>
#include <X11/Composite.h>
#include <X11/Constraint.h>

/*****************************************************************************/
/* (ѥ֥åʤ)                                              */
/*****************************************************************************/

#ifndef XtNgeometry
#define XtNgeometry    "geometry"
#endif
#ifndef XtCGeometry
#define XtCGeometry    "Geometry"
#endif

#ifndef XtNroot
#define XtNroot "root"
#endif
#ifndef XtCRoot
#define XtCRoot "Root"
#endif

#ifndef XtNface
#define XtNface    "face"
#endif
#ifndef XtCFace
#define XtCFace    "Face"
#endif

#ifndef XtNinterval
#define XtNinterval "interval"
#endif
#ifndef XtCInterval
#define XtCInterval "Interval"
#endif

#ifndef XtNdummy
#define XtNdummy  "dummy"
#endif
#ifndef XtCDummy
#define XtCDummy  "Dummy"
#endif

/*****************************************************************************/
/* (ѥ֥åʤ)                                                */
/*****************************************************************************/

typedef struct _ClockRec * ClockWidget;
typedef struct _ClockClassRec * ClockWidgetClass;
typedef struct _ClockConstraintsRec * ClockConstraints;

/*****************************************************************************/
/* ѿ(ѥ֥åʤ)                                          */
/*****************************************************************************/

extern WidgetClass clockWidgetClass;

/*****************************************************************************/
/* ؿ                                                                      */
/*****************************************************************************/

/*===========================================================================*/
/* 饹Υ᥽åɤ                                                    */
/*===========================================================================*/

/*---------------------------------------------------------------------------*/
/*                                                                       */
/*---------------------------------------------------------------------------*/

void ClockDraw(Widget w, time_t timer, XPoint pointer);

/*---------------------------------------------------------------------------*/
/* פΥ                                                            */
/*---------------------------------------------------------------------------*/

void ClockStart(XtAppContext app, Widget w);

/*---------------------------------------------------------------------------*/
/* פ                                                                */
/*---------------------------------------------------------------------------*/

void ClockStop(Widget w);

/*---------------------------------------------------------------------------*/
/* ʸפΥ                                                      */
/*---------------------------------------------------------------------------*/

unsigned int ClockGetFaceWidth(Widget w);
unsigned int ClockGetFaceHeight(Widget w);

/*****************************************************************************/
/* ޤ                                                                  */
/*****************************************************************************/

#endif

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
