#ifndef __ET_TERMINAL_CLIENT__
#define __ET_TERMINAL_CLIENT__

#include "ClientConnection.hpp"
#include "Console.hpp"
#include "CryptoHandler.hpp"
#include "ForwardSourceHandler.hpp"
#include "Headers.hpp"
#include "LogHandler.hpp"
#include "PortForwardHandler.hpp"
#include "RawSocketUtils.hpp"
#include "ServerConnection.hpp"
#include "SshSetupHandler.hpp"
#include "TcpSocketHandler.hpp"

#include <errno.h>
#include <pwd.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <termios.h>

#include "ETerminal.pb.h"

namespace et {
class TerminalClient {
 public:
  TerminalClient(std::shared_ptr<SocketHandler> _socketHandler,
                 std::shared_ptr<SocketHandler> _pipeSocketHandler,
                 const SocketEndpoint& _socketEndpoint, const string& id,
                 const string& passkey, shared_ptr<Console> _console,
                 bool jumphost, const string& tunnels,
                 const string& reverseTunnels, bool forwardSshAgent);
  virtual ~TerminalClient();
  void setUpTunnel(const string& tunnels);
  void setUpReverseTunnels(const string& reverseTunnels);
  void handleWindowChanged(winsize* win);
  // void handlePfwPacket(char packetType);
  void run(const string& command);
  void shutdown() {
    lock_guard<recursive_mutex> guard(shutdownMutex);
    shuttingDown = true;
  }

 protected:
  shared_ptr<Console> console;
  shared_ptr<ClientConnection> connection;
  shared_ptr<PortForwardHandler> portForwardHandler;
  bool shuttingDown;
  recursive_mutex shutdownMutex;
};

}  // namespace et
#endif  // __ET_TERMINAL_CLIENT__
