// $Id$
/*
 * Standard trace metadata used by all ESMF traces.
 *
 * Earth System Modeling Framework
 * Copyright 2002-2018, University Corporation for Atmospheric Research, 
 * Massachusetts Institute of Technology, Geophysical Fluid Dynamics 
 * Laboratory, University of Michigan, National Centers for Environmental 
 * Prediction, Los Alamos National Laboratory, Argonne National Laboratory, 
 * NASA Goddard Space Flight Center.
 * Licensed under the University of Illinois-NCSA License.
 */

#include <string.h>
#include "ESMCI_Trace.h"

namespace ESMCI {

  std::string TraceGetMetadataString() {
    
    //site to convert text to c++ string literal
    //http://tomeko.net/online_tools/cpp_text_escape.php?lang=en

    std::string metadata_string;
    metadata_string = "/* CTF 1.8 */\n"
"\n"
"trace {\n"
"\tmajor = 1;\n"
"\tminor = 8;\n"
"\tbyte_order = le;\n"
"\tuuid = \"0f3ce8ba-e1e6-11e7-b5ca-34f39aeaad30\";\n"
"\tpacket.header := struct {\n"
"\t\tinteger {\n"
"\t\t\tsize = 32;\n"
"\t\t\talign = 32;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} magic;\n"
"\t\tinteger {\n"
"\t\t\tsize = 8;\n"
"\t\t\talign = 8;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} uuid[16];\n"
"\t} align(1);\n"
"};\n"
"\n"
"env {\n"
"\tesmf_trace_version = \"0.4\";\n"
"\ttracer_name = \"barectf\";\n"
"\tdomain = \"bare\";\n"
"\ttracer_minor = 2;\n"
"\ttracer_patch = 1;\n"
"\tbarectf_gen_date = \"2017-12-15T15:19:47.248674\";\n"
"\ttracer_major = 2;\n"
"};\n"
"\n"
"clock {\n"
"\tname = sys_clock;\n"
"\tdescription = \"System clock\";\n"
"\tfreq = 1000000000;\n"
"\toffset_s = 0;\n"
"\toffset = 0;\n"
"\tprecision = 0;\n"
"\tabsolute = false;\n"
"};\n"
"\n"
"/* default */\n"
"stream {\n"
"\tpacket.context := struct {\n"
"\t\tinteger {\n"
"\t\t\tsize = 64;\n"
"\t\t\talign = 64;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t\tmap = clock.sys_clock.value;\n"
"\t\t} timestamp_begin;\n"
"\t\tinteger {\n"
"\t\t\tsize = 64;\n"
"\t\t\talign = 64;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t\tmap = clock.sys_clock.value;\n"
"\t\t} timestamp_end;\n"
"\t\tinteger {\n"
"\t\t\tsize = 32;\n"
"\t\t\talign = 32;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} packet_size;\n"
"\t\tinteger {\n"
"\t\t\tsize = 32;\n"
"\t\t\talign = 32;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} content_size;\n"
"\t\tstring {\n"
"\t\t\tencoding = UTF8;\n"
"\t\t} nodename;\n"
"\t\tinteger {\n"
"\t\t\tsize = 32;\n"
"\t\t\talign = 32;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} pet;\n"
"\t} align(1);\n"
"\tevent.header := struct {\n"
"\t\tinteger {\n"
"\t\t\tsize = 8;\n"
"\t\t\talign = 8;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} id;\n"
"\t\tinteger {\n"
"\t\t\tsize = 64;\n"
"\t\t\talign = 64;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t\tmap = clock.sys_clock.value;\n"
"\t\t} timestamp;\n"
"\t} align(1);\n"
"};\n"
"\n"
"event {\n"
"\tname = \"prologue_enter\";\n"
"\tid = 0; /* default */\n"
"\tfields := struct {\n"
"\t\tinteger {\n"
"\t\t\tsize = 16;\n"
"\t\t\talign = 16;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} vmid;\n"
"\t\tinteger {\n"
"\t\t\tsize = 16;\n"
"\t\t\talign = 16;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} baseid;\n"
"\t\tenum : integer {\n"
"\t\t\tsize = 8;\n"
"\t\t\talign = 8;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} {\n"
"\t\t\t\"initialize\" = 0,\n"
"\t\t\t\"run\" = 1,\n"
"\t\t\t\"finalize\" = 2,\n"
"\t\t} method;\n"
"\t\tinteger {\n"
"\t\t\tsize = 8;\n"
"\t\t\talign = 8;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} phase;\n"
"\t} align(1);\n"
"};\n"
"\n"
"event {\n"
"\tname = \"epilogue_exit\";\n"
"\tid = 1; /* default */\n"
"\tfields := struct {\n"
"\t\tinteger {\n"
"\t\t\tsize = 16;\n"
"\t\t\talign = 16;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} vmid;\n"
"\t\tinteger {\n"
"\t\t\tsize = 16;\n"
"\t\t\talign = 16;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} baseid;\n"
"\t\tenum : integer {\n"
"\t\t\tsize = 8;\n"
"\t\t\talign = 8;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} {\n"
"\t\t\t\"initialize\" = 0,\n"
"\t\t\t\"run\" = 1,\n"
"\t\t\t\"finalize\" = 2,\n"
"\t\t} method;\n"
"\t\tinteger {\n"
"\t\t\tsize = 8;\n"
"\t\t\talign = 8;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} phase;\n"
"\t} align(1);\n"
"};\n"
"\n"
"event {\n"
"\tname = \"phase_enter\";\n"
"\tid = 2; /* default */\n"
"\tfields := struct {\n"
"\t\tinteger {\n"
"\t\t\tsize = 16;\n"
"\t\t\talign = 16;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} vmid;\n"
"\t\tinteger {\n"
"\t\t\tsize = 16;\n"
"\t\t\talign = 16;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} baseid;\n"
"\t\tenum : integer {\n"
"\t\t\tsize = 8;\n"
"\t\t\talign = 8;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} {\n"
"\t\t\t\"initialize\" = 0,\n"
"\t\t\t\"run\" = 1,\n"
"\t\t\t\"finalize\" = 2,\n"
"\t\t} method;\n"
"\t\tinteger {\n"
"\t\t\tsize = 8;\n"
"\t\t\talign = 8;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} phase;\n"
"\t} align(1);\n"
"};\n"
"\n"
"event {\n"
"\tname = \"phase_exit\";\n"
"\tid = 3; /* default */\n"
"\tfields := struct {\n"
"\t\tinteger {\n"
"\t\t\tsize = 16;\n"
"\t\t\talign = 16;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} vmid;\n"
"\t\tinteger {\n"
"\t\t\tsize = 16;\n"
"\t\t\talign = 16;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} baseid;\n"
"\t\tenum : integer {\n"
"\t\t\tsize = 8;\n"
"\t\t\talign = 8;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} {\n"
"\t\t\t\"initialize\" = 0,\n"
"\t\t\t\"run\" = 1,\n"
"\t\t\t\"finalize\" = 2,\n"
"\t\t} method;\n"
"\t\tinteger {\n"
"\t\t\tsize = 8;\n"
"\t\t\talign = 8;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} phase;\n"
"\t} align(1);\n"
"};\n"
"\n"
"event {\n"
"\tname = \"region_enter\";\n"
"\tid = 4; /* default */\n"
"\tfields := struct {\n"
"\t\tstring {\n"
"\t\t\tencoding = UTF8;\n"
"\t\t} name;\n"
"\t} align(1);\n"
"};\n"
"\n"
"event {\n"
"\tname = \"region_exit\";\n"
"\tid = 5; /* default */\n"
"\tfields := struct {\n"
"\t\tstring {\n"
"\t\t\tencoding = UTF8;\n"
"\t\t} name;\n"
"\t} align(1);\n"
"};\n"
"\n"
"event {\n"
"\tname = \"define_region\";\n"
"\tid = 6; /* default */\n"
"\tfields := struct {\n"
"\t\tinteger {\n"
"\t\t\tsize = 16;\n"
"\t\t\talign = 16;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} id;\n"
"\t\tstring {\n"
"\t\t\tencoding = UTF8;\n"
"\t\t} name;\n"
"\t} align(1);\n"
"};\n"
"\n"
"event {\n"
"\tname = \"regionid_enter\";\n"
"\tid = 7; /* default */\n"
"\tfields := struct {\n"
"\t\tinteger {\n"
"\t\t\tsize = 16;\n"
"\t\t\talign = 16;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} regionid;\n"
"\t} align(1);\n"
"};\n"
"\n"
"event {\n"
"\tname = \"regionid_exit\";\n"
"\tid = 8; /* default */\n"
"\tfields := struct {\n"
"\t\tinteger {\n"
"\t\t\tsize = 16;\n"
"\t\t\talign = 16;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} regionid;\n"
"\t} align(1);\n"
"};\n"
"\n"
"event {\n"
"\tname = \"comp\";\n"
"\tid = 9; /* default */\n"
"\tfields := struct {\n"
"\t\tinteger {\n"
"\t\t\tsize = 16;\n"
"\t\t\talign = 16;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} vmid;\n"
"\t\tinteger {\n"
"\t\t\tsize = 16;\n"
"\t\t\talign = 16;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} baseid;\n"
"\t\tstring {\n"
"\t\t\tencoding = UTF8;\n"
"\t\t} name;\n"
"\t\tstring {\n"
"\t\t\tencoding = UTF8;\n"
"\t\t} IPM;\n"
"\t\tstring {\n"
"\t\t\tencoding = UTF8;\n"
"\t\t} RPM;\n"
"\t\tstring {\n"
"\t\t\tencoding = UTF8;\n"
"\t\t} FPM;\n"
"\t} align(1);\n"
"};\n"
"\n"
"event {\n"
"\tname = \"mem\";\n"
"\tid = 10; /* default */\n"
"\tfields := struct {\n"
"\t\tinteger {\n"
"\t\t\tsize = 32;\n"
"\t\t\talign = 32;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} virtMem;\n"
"\t\tinteger {\n"
"\t\t\tsize = 32;\n"
"\t\t\talign = 32;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} physMem;\n"
"\t} align(1);\n"
"};\n"
"\n"
"event {\n"
"\tname = \"clk\";\n"
"\tid = 11; /* default */\n"
"\tfields := struct {\n"
"\t\tinteger {\n"
"\t\t\tsize = 16;\n"
"\t\t\talign = 16;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} year;\n"
"\t\tinteger {\n"
"\t\t\tsize = 8;\n"
"\t\t\talign = 8;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} month;\n"
"\t\tinteger {\n"
"\t\t\tsize = 8;\n"
"\t\t\talign = 8;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} day;\n"
"\t\tinteger {\n"
"\t\t\tsize = 8;\n"
"\t\t\talign = 8;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} hour;\n"
"\t\tinteger {\n"
"\t\t\tsize = 8;\n"
"\t\t\talign = 8;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} minute;\n"
"\t\tinteger {\n"
"\t\t\tsize = 8;\n"
"\t\t\talign = 8;\n"
"\t\t\tsigned = false;\n"
"\t\t\tbyte_order = le;\n"
"\t\t\tbase = 10;\n"
"\t\t\tencoding = none;\n"
"\t\t} second;\n"
"\t} align(1);\n"
"};";
     
    return metadata_string;

  }


  

}
