{application, ssl,
   [{description, "Erlang/OTP SSL application"},
    {vsn, "11.0"},
    {modules, [
	       %% TLS/SSL
	       tls_connection,
               tls_client_connection_1_3,
               tls_server_connection_1_3,
               tls_gen_connection_1_3,
	       tls_handshake,
	       tls_handshake_1_3,
	       tls_record,
	       tls_record_1_3,
	       tls_socket,
	       tls_v1,
	       tls_connection_sup,
	       tls_gen_connection,
	       tls_sender,
               tls_server_sup,
               tls_server_session_ticket_sup,
               tls_server_session_ticket,
               tls_sup,
               tls_dyn_connection_sup,
	       ssl_dh_groups,
	       %% DTLS
	       dtls_connection,
	       dtls_handshake,
	       dtls_record,
	       dtls_socket,
	       dtls_v1,
	       dtls_connection_sup,
               dtls_gen_connection,
	       dtls_packet_demux,
	       dtls_listener_sup,
               dtls_sup,
               dtls_server_sup,
               dtls_server_session_cache_sup,
	       %% API
	       ssl,  %% Main API
	       ssl_session_cache_api,
	       %% Both TLS/SSL and DTLS
               tls_dtls_connection,
	       ssl_config,
               ssl_gen_statem,
	       ssl_handshake,
	       ssl_record,
	       ssl_cipher,
               ssl_cipher_format,
	       ssl_srp_primes,
	       ssl_alert,
	       ssl_listen_tracker_sup, %% may be used by DTLS over SCTP
	       tls_bloom_filter,
	       tls_client_ticket_store,
	       %% Erlang Distribution over SSL/TLS
	       inet_tls_dist,
	       inet6_tls_dist,
	       ssl_dist_sup,
               ssl_dist_connection_sup,
               ssl_dist_admin_sup,
               tls_dist_sup,
               tls_dist_server_sup,
	       %% SSL/TLS session and cert handling
	       ssl_session,
               ssl_client_session_cache_db,
               ssl_server_session_cache,
               ssl_server_session_cache_db,
               ssl_server_session_cache_sup,
               ssl_upgrade_server_session_cache_sup,
	       ssl_manager,
	       ssl_pem_cache,
	       ssl_pkix_db,
	       ssl_certificate,
	       %% CRL handling
	       ssl_crl,
	       ssl_crl_cache,
	       ssl_crl_cache_api,
	       ssl_crl_hash_dir,
	       %% Logging
	       ssl_logger,
	       ssl_trace,
	       %% App structure
	       ssl_app,
	       ssl_sup,
	       ssl_admin_sup,
	       ssl_connection_sup
	       ]},
    {registered, [ssl_sup, ssl_manager]},
    {applications, [crypto, public_key, kernel, stdlib]},
    {env, []},
    {mod, {ssl_app, []}},
    {runtime_dependencies, ["stdlib-4.1","public_key-1.11.3","kernel-9.0",
                            "erts-14.0","crypto-5.0", "inets-5.10.7",
                            "runtime_tools-1.15.1"]}]}.
