# -*- coding: utf-8 -*-

# Copyright (c) 2006 - 2013 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the base class for all configuration pages.
"""

from PyQt4.QtGui import QWidget, QIcon, QPixmap, QColor
from PyQt4.QtCore import QString

from KdeQt import KQColorDialog, KQFontDialog

class ConfigurationPageBase(QWidget):
    """
    Class implementing the base class for all configuration pages.
    """
    def __init__(self):
        """
        Constructor
        """
        QWidget.__init__(self)
        
    def polishPage(self):
        """
        Public slot to perform some polishing actions.
        """
        return
        
    def saveState(self):
        """
        Public method to save the current state of the widget.
        """
        return None
        
    def setState(self, state):
        """
        Public method to set the state of the widget.
        
        @param state state data generated by saveState
        """
        return
        
    def initColour(self, colourstr, button, prefMethod):
        """
        Public method to initialize a colour selection button.
        
        @param colourstr colour to be set (string)
        @param button reference to a QButton to show the colour on
        @param prefMethod preferences method to get the colour
        @return reference to the created colour (QColor)
        """
        colour = QColor(prefMethod(colourstr))
        size = button.size()
        pm = QPixmap(size.width()/2, size.height()/2)
        pm.fill(colour)
        button.setIconSize(pm.size())
        button.setIcon(QIcon(pm))
        return colour
        
    def selectColour(self, button, colourVar):
        """
        Public method used by the colour selection buttons.
        
        @param button reference to a QButton to show the colour on
        @param colourVar reference to the variable containing the colour (QColor)
        @return selected colour (QColor)
        """
        colour = KQColorDialog.getColor(colourVar)
        if colour.isValid():
            size = button.iconSize()
            pm = QPixmap(size.width(), size.height())
            pm.fill(colour)
            button.setIcon(QIcon(pm))
        else:
            colour = colourVar
        return colour
        
    def selectFont(self, fontSample, fontVar, showFontInfo = False):
        """
        Public method used by the font selection buttons.
        
        @param fontSample reference to the font sample widget (QLineEdit)
        @param fontVar reference to the variable containing the font (QFont)
        @param showFontInfo flag indicating to show some font info
            as the sample (boolean)
        @return selected font (QFont)
        """
        font, ok = KQFontDialog.getFont(fontVar)
        if ok:
            fontSample.setFont(font)
            if showFontInfo:
                fontSample.setText(
                    QString("%1 %2").arg(font.family()).arg(font.pointSize()))
        else:
            font = fontVar
        return font
