note
	description: "Objects that represent an EV_DIALOG.%
		%The original version of this class was generated by EiffelBuild."
	legal: "See notice at end of class."
	status: "See notice at end of class."
	date: "$Date$"
	revision: "$Revision$"

class
	RADIO_BUTTON_CREATION_DIALOG

inherit
	RADIO_BUTTON_CREATION_DIALOG_IMP

create
	make

feature {NONE} -- Initialization

	make
			-- Creation method
		do
			create_all_widgets
			create_all_actions

			create ok_actions
			create cancel_actions

			default_create
		end

	user_initialization
			-- Called by `initialize'.
			-- Any custom user initialization that
			-- could not be performed in `initialize',
			-- (due to regeneration of implementation class)
			-- can be added here.
		do
			close_request_actions.extend (agent destroy)
			normal_radio_button.enable_select
		end

	create_all_widgets
			-- Create all widgets
		do
			create l_ev_vertical_box_1
			create l_ev_horizontal_box_1
			create l_ev_vertical_box_2
			create normal_radio_button
			create font_radio_button
			create width_radio_button
			create l_ev_vertical_box_3
			create font_frame
			create l_ev_horizontal_box_2
			create font_field
			create choose_font_button
			create width_frame
			create width_spin_button
			create l_ev_horizontal_box_3
			create l_ev_cell_1
			create ok_button
			create cancel_button
		end

	create_all_actions
			-- Create all actions
		do
			create string_constant_set_procedures.make (10)
			create string_constant_retrieval_functions.make (10)
			create integer_constant_set_procedures.make (10)
			create integer_constant_retrieval_functions.make (10)
			create pixmap_constant_set_procedures.make (10)
			create pixmap_constant_retrieval_functions.make (10)
			create integer_interval_constant_retrieval_functions.make (10)
			create integer_interval_constant_set_procedures.make (10)
			create font_constant_set_procedures.make (10)
			create font_constant_retrieval_functions.make (10)
			create pixmap_constant_retrieval_functions.make (10)
			create color_constant_set_procedures.make (10)
			create color_constant_retrieval_functions.make (10)
		end

feature -- Access

	font: detachable EV_FONT
			-- Selected Font.

	max_width: INTEGER
			-- Max width
		do
			Result := width_spin_button.value
		end

	ok_actions: EV_NOTIFY_ACTION_SEQUENCE
			-- Call when OK button is selected.

	cancel_actions: EV_NOTIFY_ACTION_SEQUENCE
			-- Call when Cancel button is selected.

feature -- Status report

	is_font: BOOLEAN
		do
			Result := font_radio_button.is_selected
		end

	is_width: BOOLEAN
		do
			Result := width_radio_button.is_selected
		end

	is_normal: BOOLEAN
		do
			Result := normal_radio_button.is_selected
		end

feature {NONE} -- Implementation

	font_selected (a_dialog: EV_FONT_DIALOG)
			-- A font is selected.
		require
			a_dialog_not_void: a_dialog /= Void
		local
			l_font: EV_FONT
		do
			l_font := a_dialog.font
			font := l_font
			font_field.set_text (l_font.name)
			font_field.set_tooltip (l_font.name)
		end

feature {NONE} -- Implementation


	on_choose_font_button_selected
			-- Called by `select_actions' of `choose_font_button'.
		local
			l_dialog: EV_FONT_DIALOG
		do
			create l_dialog
			l_dialog.ok_actions.extend (agent font_selected (l_dialog))
			l_dialog.show_modal_to_window (Current)
		end


	on_ok_button_selected
			-- Called by `select_actions' of `ok_button'.
		do
			ok_actions.call (Void)
			destroy
		end


	on_cancel_button_selected
			-- Called by `select_actions' of `cancel_button'.
		do
			cancel_actions.call (Void)
			destroy
		end

	on_normal_radio_button_selected
			-- Called by `select_actions' of `normal_radio_button'.
		do
			font_frame.disable_sensitive
			width_frame.disable_sensitive
		end

	on_font_radio_button_selected
			-- Called by `select_actions' of `font_radio_button'.
		do
			font_frame.enable_sensitive
			width_frame.disable_sensitive
		end

	on_width_radio_button_selected
			-- Called by `select_actions' of `width_radio_button'.
		do
			font_frame.disable_sensitive
			width_frame.enable_sensitive
		end

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"


end
