note

	description: "General popup shell implementation"
	legal: "See notice at end of class.";
	status: "See notice at end of class.";
	date: "$Date$";
	revision: "$Revision$"

deferred class

	POPUP_SHELL_I 

inherit

	SHELL_I
	
feature -- Status report

	is_cascade_grab: BOOLEAN
			-- Is the shell popped up with cascade grab (allowing the other
			-- shells popped up with grab to receive events) ?
		deferred
		end;

	is_exclusive_grab: BOOLEAN
			-- Is the shell popped up with exclusive grab ?
		deferred
		end;

	is_no_grab: BOOLEAN
			-- Is the shell popped up with no grab ?
		deferred
		end;

	is_popped_up: BOOLEAN
			-- Is the popup widget popped up on screen ?
		deferred
		end;

feature -- Status setting 

	popdown
			-- Popdown popup shell.
		deferred
		ensure
			not_pupped_up: not is_popped_up
		end;

	popup
			-- Popup a popup shell with no grab on it.
		deferred
		end;

	set_cascade_grab
			-- Specifies that the shell would be popped up with cascade grab
			-- (allowing the other shells popped up with grab to receive events).
		deferred
		ensure
			is_cascade_grab: is_cascade_grab
		end;

	set_exclusive_grab
			-- Specifies that the shell would be popped up with exclusive grab.
		deferred
		ensure
			is_exclusive_grab: is_exclusive_grab
		end;

	set_no_grab
			-- Specifies that the shell would be popped up with no grab.
		deferred
		ensure
			is_no_grab: is_no_grab
		end

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class POPUP_SHELL_I

