note
	description: "Protection information"
	legal: "See notice at end of class."
	status: "See notice at end of class."
	date: "$Date: 2012-12-15 08:14:51 +0000 (Sat, 15 Dec 2012) $"
	revision: "$Revision: 96460 $"

deferred class
	KG_PRIVATE_INFO

inherit
	KG_CONSTANTS

feature -- Access

	is_consistent: BOOLEAN
			-- Is protection info consistent?
		deferred
		end

	remaining_executions: INTEGER
			-- Number of times system can be executed without registration
		require
			initialized: is_consistent
		deferred
		end

	activation_key: STRING
			-- Activation key
		require
			initialized: is_consistent
		deferred
		end

	registration_date: DATE
			-- Date when product was registered
		require
			initialized: is_consistent
		deferred
		end

	checksum (value: STRING): INTEGER
			-- Data integrity checksum
		require
			non_void_value: value /= Void
			valid_value: not value.is_empty
		deferred
		end

feature -- Basic Operation

	set_key (key: like activation_key; date: like registration_date)
			-- Set `activation_key' with `key'.
			-- Set `registration_date' with `date'.
			-- Reset checksum so that `is_consistent' is `True'.
		require
			non_void_key: key /= Void
			non_void_date: date /= Void
			valid_key: has_valid_activation_key_format (key)
		deferred
		ensure
			key_set: activation_key.is_equal (key)
			registration_date_set: registration_date.is_equal (date)
			is_consistent: is_consistent
		end

	set_remaining_executions (times: INTEGER)
			-- Set `remaining_executions' with `times'.
		require
			valid_times: times >= 0
		deferred
		ensure
			remaining_executions_set: remaining_executions = times
		end

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class KG_PRIVATE_INFO
