note
	description: "Summary description for {BRANDED_LICENSE_VALIDATOR_WINDOW}."
	author: ""
	date: "$Date: 2021-02-19 15:35:58 +0000 (Fri, 19 Feb 2021) $"
	revision: "$Revision: 96853 $"

class
	BRANDED_LICENSE_VALIDATOR_WINDOW

inherit
	EV_TITLED_WINDOW
		redefine
			create_interface_objects
		end

	EIFFEL_LAYOUT
		undefine
			default_create,
			copy
		end

	EV_LAYOUT_CONSTANTS
		undefine
			default_create,
			copy
		end

	BRANDED_LICENSE_CONSTANTS
		undefine
			default_create,
			copy
		end

create
	make

feature {NONE} -- Initialization

	make (a_lic_checker: BRANDED_LICENSE_CHECKER)
		do
			license_checker := a_lic_checker

			default_create
			build_interface
			set_title ("EiffelStudio - " + a_lic_checker.edition_name + " Edition Activation Wizard")
		end

	create_interface_objects
		do
			Precursor
			create activation_button
		end

	build_interface
		local
			main: EV_VERTICAL_BOX
			l_header, vb: EV_VERTICAL_BOX
			hb, f_hb, l_buttons_box: EV_HORIZONTAL_BOX
			sep: EV_HORIZONTAL_SEPARATOR
			lab: EV_LABEL
			but: EV_BUTTON
			ft, ft_err: EV_FONT
			l_file_field: EV_TEXT_FIELD
			l_browse_button: EV_BUTTON
		do
			create main
			extend (main)

			create l_header
			l_header.set_border_width (10)
			l_header.set_padding_width (10)

			create ft
			ft.set_family ({EV_FONT_CONSTANTS}.Family_sans)
			ft.set_weight ({EV_FONT_CONSTANTS}.Weight_bold)
			ft.set_shape ({EV_FONT_CONSTANTS}.Shape_regular)
			ft.set_height_in_points (12)
			ft.preferred_families.extend ("Arial")

			create ft_err
			ft_err.set_weight ({EV_FONT_CONSTANTS}.Weight_bold)

			create lab.make_with_text ("Welcome to the Activation Wizard")
			lab.align_text_left
			lab.set_font (ft)
			l_header.extend (lab)
			l_header.disable_item_expand (lab)

			create lab.make_with_text ("    You are using the %"" + license_checker.edition_name + "%" edition.")
			lab.align_text_left
			l_header.extend (lab)
			l_header.disable_item_expand (lab)

			l_header.set_foreground_color (colors.black)
			l_header.set_background_color (colors.white)
			l_header.propagate_foreground_color
			l_header.propagate_background_color

			main.extend (l_header)
			main.disable_item_expand (l_header)

			create sep; main.extend (sep); main.disable_item_expand (sep)

			create hb
			main.extend (hb)
			create vb -- left sidebar
			hb.extend (vb)
			hb.disable_item_expand (vb)

			vb.set_background_color (colors.color_read_only)
			vb.extend (Left_image_pixmap)
			vb.set_minimum_width (150)
			vb.set_minimum_height (300)
			vb.extend (create {EV_CELL})

			create vb -- main part
			vb.set_border_width (10)
			vb.set_padding_width (5)
			hb.extend (vb)

			if license_checker.has_license then
				add_label ("This copy of EiffelStudio is activated.", vb, Void)

				if license_checker.is_licensed then
					if attached license_checker.associated_license as lic and then lic.is_expired then
						add_label ("But the license is expired since " + lic.date_time_to_iso (lic.end_date) + "." , vb, [ft_err, colors.red, Void])
					end
				else
					add_label ("But the license is not valid anymore." , vb, [ft_err, colors.red, Void])
				end
			else
				add_label ("This copy of EiffelStudio is not yet activated.", vb, Void)
			end

			vb.extend (create {EV_CELL})
			add_label ("Application license file:", vb, [ft, Void, Void])
			add_label ("Please provide an application license file.", vb, Void)

			create f_hb
			f_hb.set_padding_width (5)
			create l_file_field
			f_hb.extend (l_file_field)
			create l_browse_button.make_with_text ("Select a file...")
			f_hb.extend (l_browse_button)
			f_hb.disable_item_expand (l_browse_button)
			vb.extend (f_hb)
			vb.disable_item_expand (f_hb)
			create lab
			lab.align_text_left
			lab.hide
			vb.extend (lab)
			vb.disable_item_expand (lab)
			l_browse_button.select_actions.extend (agent (i_file_field: EV_TEXT_FIELD; i_msg_lab: EV_LABEL)
					local
						l_file_dlg: EV_FILE_OPEN_DIALOG
					do
						create l_file_dlg.make_with_title ("Select an EiffelStudio Application License File")
						l_file_dlg.show_modal_to_window (Current)
						l_file_dlg.disable_multiple_selection
						if attached l_file_dlg.file_name as p then
							on_license_file_selected (p, i_file_field, i_msg_lab)
						end
					end(l_file_field, lab)
				)

			vb.extend (create {EV_CELL})

			add_label ("If you do not have a license key:", vb, Void)
			add_label ("- contact your system administrator", vb, Void)
			add_label ("- or contact Eiffel Software at https://www.eiffel.com/", vb, Void)

 			create sep; main.extend (sep); main.disable_item_expand (sep)

			create l_buttons_box
			l_buttons_box.set_border_width (10)
			l_buttons_box.set_padding (10)
			main.extend (l_buttons_box)
			main.disable_item_expand (l_buttons_box)

			l_buttons_box.extend (create {EV_CELL})

			create but.make_with_text_and_action ("Cancel", agent on_cancel_and_quit)
			l_buttons_box.extend (but); but.set_minimum_width (default_button_width)
			l_buttons_box.disable_item_expand (but)

			but := activation_button
			but.set_text ("Activate")
			but.select_actions.extend (agent on_activate (l_file_field))
			l_buttons_box.extend (but); but.set_minimum_width (default_button_width)
			l_buttons_box.disable_item_expand (but)
			but.disable_sensitive
		end

	on_license_file_selected (a_file_path: READABLE_STRING_GENERAL; a_file_field: EV_TEXT_FIELD; a_msg_label: EV_LABEL)
		local
			p: PATH
		do
			if attached license_checker.license_at (create {PATH}.make_from_string (a_file_path)) as lic then
				if lic.is_expired then
					a_file_field.set_text (a_file_path)
					a_file_field.set_foreground_color (colors.red)
					a_msg_label.set_text ("This license is expired since "+ lic.date_time_to_iso (lic.end_date) + ".")
					a_msg_label.set_foreground_color (colors.red)
					a_msg_label.show
					activation_button.disable_sensitive
				elseif not lic.is_valid_for_platform (license_checker.platform) then
					a_file_field.set_text (a_file_path)
					a_file_field.set_foreground_color (colors.red)
					a_msg_label.set_text ("This license is not for this platform %""+ license_checker.platform + "%".")
					a_msg_label.set_foreground_color (colors.red)
					a_msg_label.show
					activation_button.disable_sensitive
				elseif not lic.is_valid_for_version (license_checker.major_minor_version) then
					a_file_field.set_text (a_file_path)
					a_file_field.set_foreground_color (colors.red)
					a_msg_label.set_text ("This license is not for this version %""+ license_checker.major_minor_version + "%".")
					a_msg_label.set_foreground_color (colors.red)
					a_msg_label.show
					activation_button.disable_sensitive
				else
					a_file_field.set_foreground_color (colors.black)
					a_msg_label.remove_text
					a_msg_label.set_foreground_color (colors.black)
					a_msg_label.hide
					a_file_field.set_text (a_file_path)
					activation_button.enable_sensitive
				end
			else
				a_file_field.set_text (a_file_path)
				a_file_field.set_foreground_color (colors.red)
				a_msg_label.set_text ("This is not a valid EiffelStudio license file.")
				a_msg_label.set_foreground_color (colors.red)
				a_msg_label.show
				activation_button.disable_sensitive
			end
		end

feature -- Access

	license_checker: BRANDED_LICENSE_CHECKER

feature {NONE} -- Implementation

	add_label (a_text: READABLE_STRING_GENERAL; a_container: EV_BOX; a_data: detachable TUPLE [font: detachable EV_FONT; fg_color: detachable EV_COLOR; bg_color: detachable EV_COLOR])
		local
			lab: EV_LABEL
		do
			create lab.make_with_text (a_text)
			if a_data /= Void then
				if attached a_data.font as ft then
					lab.set_font (ft)
				end
				if attached a_data.fg_color as l_fg_color then
					lab.set_foreground_color (l_fg_color)
				end
				if attached a_data.bg_color as l_bg_color then
					lab.set_background_color (l_bg_color)
				end
			end
			lab.align_text_left
			a_container.extend (lab)
			a_container.disable_item_expand (lab)
		end

	colors: EV_STOCK_COLORS
		once
			create Result
		end

	Left_image_pixmap: EV_PIXMAP
		local
			fut: FILE_UTILITIES
		do
			create Result
			if fut.file_path_exists (left_image_path) then
				Result.set_with_named_path (Left_image_path)
				Result.set_minimum_size (Result.width, Result.height)
			else
				Result.set_size (100, 100)
			end
		end

	Left_image_path: PATH
			-- Activation image path
		once
			if is_eiffel_layout_defined then
				Result := eiffel_layout.bitmaps_path
			else
				create Result.make_current
			end
			Result := Result.extended ("png").extended ("activation.png")
		end

	Logo_path: PATH
			-- Logo image path
		once
			if is_eiffel_layout_defined then
				Result := eiffel_layout.bitmaps_path
			else
				create Result.make_current
			end
			Result := Result.extended ("png").extended ("logo.png")
		end

	activation_button: EV_BUTTON

feature -- Event

	on_activate (a_file_field: EV_TEXT_FIELD)
		local
			fn: PATH
			f,locf: RAW_FILE
			fut: FILE_UTILITIES
			err: BOOLEAN
		do
			create fn.make_from_string (a_file_field.text)
			if license_checker.is_valid_license_file (fn) then
				err := False
				fut.copy_file_path (fn, license_checker.location)
				if not fut.file_path_exists (license_checker.location) then
					fut.copy_file_path (fn, license_checker.user_location)
					if not fut.file_path_exists (license_checker.user_location) then
						on_error ({STRING_32} "could not save license file to %"" + license_checker.user_location.name + {STRING_32} "%",%Ncheck permissions")
						err := True
					end
				end
				if not err then
					license_checker.check_license
					if license_checker.can_run then
						on_continue
					else
						-- Could not activate ... ask administrator.
						on_error ({STRING_32} "error during activation, contact your administrator or the user support service.")
					end
				end
			end
		end

	is_access_writable (loc: PATH): BOOLEAN
			-- Is it possible to write to the `loc` location.
		local
			f: RAW_FILE
			d: DIRECTORY
		do
			create f.make_with_path (loc)
			if f.exists then
				Result := f.is_access_writable
			else
				create d.make_with_path (loc.parent)
				if d.exists and d.is_writable then
					Result := True
				end
			end
		end

	on_continue
		do
			hide
			if attached on_run as l_on_run then
				l_on_run.call (Void)
			end
			if attached on_close as l_on_close then
				l_on_close.call (Void)
			end
		end

	on_error (msg: READABLE_STRING_GENERAL)
		local
			dlg: EV_ERROR_DIALOG
		do
			activation_button.disable_sensitive
			create dlg.make_with_text ("Error with license activation")
			dlg.set_text (msg)
			dlg.show_modal_to_window (Current)
		end

	on_cancel_and_quit
		do
--			on_cancel
			ev_application.destroy
		end

	on_cancel
			-- Will register later
		do
			hide
			if attached on_run as l_on_run then
				l_on_run.call (Void)
			end
			if attached on_close as l_on_close then
				l_on_close.call (Void)
			end
		end

feature -- Settings

	set_actions (a_on_run, a_on_close: detachable PROCEDURE)
			-- Set `on_run' with `a_on_run', and `on_close' with `a_on_close'.
		do
			on_run := a_on_run
			on_close := a_on_close
		ensure
			on_run_set: on_run = a_on_run
			on_close_set: on_close = a_on_close
		end

feature {NONE} -- Event handlers

	on_run: detachable PROCEDURE
			-- Called after button "Activate" is clicked

	on_close: detachable PROCEDURE
			-- Called after processing.

end
