# Gobo Eiffel Compiler

This folder contains the source code of *Gobo Eiffel Compiler* (`gec`).
The code of `gec` is mainly based on the *Gobo Eiffel Tools Library*
(`$GOBO/library/tools`).

**Included in this folder:**

* `bootstrap`: the C code to bootstrap the Eiffel compiler.
* `config`: this folder contains config files necessary to run
  `gec`. For example, it contains information about the C compiler
  to be used to compile the C code generated by `gec`.
* `doc`: this folder contains the documentation for this tool,
  in HTML format. Start with `index.html`.
* `runtime`: this folder contains runtime files to be included in
  the programs compiled by `gec`.
* `src`: this folder contains the classes necessary to compile this tool.
* `test`: this folder contains tests to exercise this tool.

**To compile and run this tool:**

1. Go to folder `src`.

2. Use your favorite Eiffel compiler to compile the Eiffel system using
   the provided ECF file. Alternatively you can use `geant` to launch
   the compilation:
   
        geant compile_<compiler>
       
    where `<compiler>` is either `ise` or `ge`.

3. Run `gec` using:

        gec <ecf_file>

    where `<ecf_file>` is an ECF file describing the Eiffel system.

## Authors

Copyright (c) 2005-2019, Eric Bezault and others
