//===----------------------------------------------------------------------===//
//                         DuckDB
//
// core_functions/scalar/list_functions.hpp
//
//
//===----------------------------------------------------------------------===//
// This file is automatically generated by scripts/generate_functions.py
// Do not edit this file manually, your changes will be overwritten
//===----------------------------------------------------------------------===//

#pragma once

#include "duckdb/function/function_set.hpp"

namespace duckdb {

struct ListFlattenFun {
	static constexpr const char *Name = "flatten";
	static constexpr const char *Parameters = "nested_list";
	static constexpr const char *Description = "Flattens a nested list by one level.";
	static constexpr const char *Example = "flatten([[1, 2, 3], [4, 5]])";
	static constexpr const char *Categories = "list";

	static ScalarFunction GetFunction();
};

struct ListAggregateFun {
	static constexpr const char *Name = "list_aggregate";
	static constexpr const char *Parameters = "list,function_name";
	static constexpr const char *Description = "Executes the aggregate function `function_name` on the elements of `list`.";
	static constexpr const char *Example = "list_aggregate([1, 2, NULL], 'min')";
	static constexpr const char *Categories = "list";

	static ScalarFunction GetFunction();
};

struct ArrayAggregateFun {
	using ALIAS = ListAggregateFun;

	static constexpr const char *Name = "array_aggregate";
};

struct ListAggrFun {
	using ALIAS = ListAggregateFun;

	static constexpr const char *Name = "list_aggr";
};

struct ArrayAggrFun {
	using ALIAS = ListAggregateFun;

	static constexpr const char *Name = "array_aggr";
};

struct AggregateFun {
	using ALIAS = ListAggregateFun;

	static constexpr const char *Name = "aggregate";
};

struct ListDistinctFun {
	static constexpr const char *Name = "list_distinct";
	static constexpr const char *Parameters = "list";
	static constexpr const char *Description = "Removes all duplicates and `NULL` values from a list. Does not preserve the original order.";
	static constexpr const char *Example = "list_distinct([1, 1, NULL, -3, 1, 5])";
	static constexpr const char *Categories = "list";

	static ScalarFunction GetFunction();
};

struct ArrayDistinctFun {
	using ALIAS = ListDistinctFun;

	static constexpr const char *Name = "array_distinct";
};

struct ListUniqueFun {
	static constexpr const char *Name = "list_unique";
	static constexpr const char *Parameters = "list";
	static constexpr const char *Description = "Counts the unique elements of a `list`.";
	static constexpr const char *Example = "list_unique([1, 1, NULL, -3, 1, 5])";
	static constexpr const char *Categories = "list";

	static ScalarFunction GetFunction();
};

struct ArrayUniqueFun {
	using ALIAS = ListUniqueFun;

	static constexpr const char *Name = "array_unique";
};

struct ListValueFun {
	static constexpr const char *Name = "list_value";
	static constexpr const char *Parameters = "any,...";
	static constexpr const char *Description = "Creates a LIST containing the argument values.";
	static constexpr const char *Example = "list_value(4, 5, 6)";
	static constexpr const char *Categories = "list";

	static ScalarFunctionSet GetFunctions();
};

struct ListPackFun {
	using ALIAS = ListValueFun;

	static constexpr const char *Name = "list_pack";
};

struct ListSliceFun {
	static constexpr const char *Name = "list_slice";
	static constexpr const char *Parameters = "list,begin,end\001list,begin,end,step";
	static constexpr const char *Description = "Extracts a sublist or substring using slice conventions. Negative values are accepted.\001list_slice with added step feature.";
	static constexpr const char *Example = "list_slice([4, 5, 6], 2, 3)\002array_slice('DuckDB', 3, 4)\002array_slice('DuckDB', 3, NULL)\002array_slice('DuckDB', 0, -3)\001list_slice([4, 5, 6], 1, 3, 2)";
	static constexpr const char *Categories = "list,string\001list";

	static ScalarFunctionSet GetFunctions();
};

struct ArraySliceFun {
	using ALIAS = ListSliceFun;

	static constexpr const char *Name = "array_slice";
};

struct ListSortFun {
	static constexpr const char *Name = "list_sort";
	static constexpr const char *Parameters = "list";
	static constexpr const char *Description = "Sorts the elements of the list.";
	static constexpr const char *Example = "list_sort([3, 6, 1, 2])";
	static constexpr const char *Categories = "list";

	static ScalarFunctionSet GetFunctions();
};

struct ArraySortFun {
	using ALIAS = ListSortFun;

	static constexpr const char *Name = "array_sort";
};

struct ListGradeUpFun {
	static constexpr const char *Name = "list_grade_up";
	static constexpr const char *Parameters = "list";
	static constexpr const char *Description = "Works like list_sort, but the results are the indexes that correspond to the position in the original list instead of the actual values.";
	static constexpr const char *Example = "list_grade_up([3, 6, 1, 2])";
	static constexpr const char *Categories = "list";

	static ScalarFunctionSet GetFunctions();
};

struct ArrayGradeUpFun {
	using ALIAS = ListGradeUpFun;

	static constexpr const char *Name = "array_grade_up";
};

struct GradeUpFun {
	using ALIAS = ListGradeUpFun;

	static constexpr const char *Name = "grade_up";
};

struct ListReverseSortFun {
	static constexpr const char *Name = "list_reverse_sort";
	static constexpr const char *Parameters = "list";
	static constexpr const char *Description = "Sorts the elements of the list in reverse order.";
	static constexpr const char *Example = "list_reverse_sort([3, 6, 1, 2])";
	static constexpr const char *Categories = "list";

	static ScalarFunctionSet GetFunctions();
};

struct ArrayReverseSortFun {
	using ALIAS = ListReverseSortFun;

	static constexpr const char *Name = "array_reverse_sort";
};

struct ListTransformFun {
	static constexpr const char *Name = "list_transform";
	static constexpr const char *Parameters = "list,lambda(x)";
	static constexpr const char *Description = "Returns a list that is the result of applying the `lambda` function to each element of the input `list`. The return type is defined by the return type of the `lambda` function.";
	static constexpr const char *Example = "list_transform([1, 2, 3], lambda x : x + 1)";
	static constexpr const char *Categories = "list,lambda";

	static ScalarFunction GetFunction();
};

struct ArrayTransformFun {
	using ALIAS = ListTransformFun;

	static constexpr const char *Name = "array_transform";
};

struct ListApplyFun {
	using ALIAS = ListTransformFun;

	static constexpr const char *Name = "list_apply";
};

struct ArrayApplyFun {
	using ALIAS = ListTransformFun;

	static constexpr const char *Name = "array_apply";
};

struct ApplyFun {
	using ALIAS = ListTransformFun;

	static constexpr const char *Name = "apply";
};

struct ListFilterFun {
	static constexpr const char *Name = "list_filter";
	static constexpr const char *Parameters = "list,lambda(x)";
	static constexpr const char *Description = "Constructs a list from those elements of the input `list` for which the `lambda` function returns `true`. DuckDB must be able to cast the `lambda` function's return type to `BOOL`. The return type of `list_filter` is the same as the input list's.";
	static constexpr const char *Example = "list_filter([3, 4, 5], lambda x : x > 4)";
	static constexpr const char *Categories = "list,lambda";

	static ScalarFunction GetFunction();
};

struct ArrayFilterFun {
	using ALIAS = ListFilterFun;

	static constexpr const char *Name = "array_filter";
};

struct FilterFun {
	using ALIAS = ListFilterFun;

	static constexpr const char *Name = "filter";
};

struct ListReduceFun {
	static constexpr const char *Name = "list_reduce";
	static constexpr const char *Parameters = "list,lambda(x,y),initial_value";
	static constexpr const char *Description = "Reduces all elements of the input `list` into a single scalar value by executing the `lambda` function on a running result and the next list element. The `lambda` function has an optional `initial_value` argument.";
	static constexpr const char *Example = "list_reduce([1, 2, 3], lambda x, y : x + y)";
	static constexpr const char *Categories = "list,lambda";

	static ScalarFunctionSet GetFunctions();
};

struct ArrayReduceFun {
	using ALIAS = ListReduceFun;

	static constexpr const char *Name = "array_reduce";
};

struct ReduceFun {
	using ALIAS = ListReduceFun;

	static constexpr const char *Name = "reduce";
};

struct GenerateSeriesFun {
	static constexpr const char *Name = "generate_series";
	static constexpr const char *Parameters = "start,stop,step";
	static constexpr const char *Description = "Creates a list of values between `start` and `stop` - the stop parameter is inclusive.";
	static constexpr const char *Example = "generate_series(2, 5, 3)";
	static constexpr const char *Categories = "list";

	static ScalarFunctionSet GetFunctions();
};

struct ListRangeFun {
	static constexpr const char *Name = "range";
	static constexpr const char *Parameters = "start,stop,step";
	static constexpr const char *Description = "Creates a list of values between `start` and `stop` - the stop parameter is exclusive.";
	static constexpr const char *Example = "range(2, 5, 3)";
	static constexpr const char *Categories = "list";

	static ScalarFunctionSet GetFunctions();
};

struct ListCosineDistanceFun {
	static constexpr const char *Name = "list_cosine_distance";
	static constexpr const char *Parameters = "list1,list2";
	static constexpr const char *Description = "Computes the cosine distance between two same-sized lists.";
	static constexpr const char *Example = "list_cosine_distance([1, 2, 3], [1, 2, 3])";
	static constexpr const char *Categories = "list";

	static ScalarFunctionSet GetFunctions();
};

struct ListCosineDistanceFunAlias {
	using ALIAS = ListCosineDistanceFun;

	static constexpr const char *Name = "<=>";
};

struct ListCosineSimilarityFun {
	static constexpr const char *Name = "list_cosine_similarity";
	static constexpr const char *Parameters = "list1,list2";
	static constexpr const char *Description = "Computes the cosine similarity between two same-sized lists.";
	static constexpr const char *Example = "list_cosine_similarity([1, 2, 3], [1, 2, 3])";
	static constexpr const char *Categories = "list";

	static ScalarFunctionSet GetFunctions();
};

struct ListDistanceFun {
	static constexpr const char *Name = "list_distance";
	static constexpr const char *Parameters = "list1,list2";
	static constexpr const char *Description = "Calculates the Euclidean distance between two points with coordinates given in two inputs lists of equal length.";
	static constexpr const char *Example = "list_distance([1, 2, 3], [1, 2, 5])";
	static constexpr const char *Categories = "list";

	static ScalarFunctionSet GetFunctions();
};

struct ListDistanceFunAlias {
	using ALIAS = ListDistanceFun;

	static constexpr const char *Name = "<->";
};

struct ListInnerProductFun {
	static constexpr const char *Name = "list_inner_product";
	static constexpr const char *Parameters = "list1,list2";
	static constexpr const char *Description = "Computes the inner product between two same-sized lists.";
	static constexpr const char *Example = "list_inner_product([1, 2, 3], [1, 2, 3])";
	static constexpr const char *Categories = "list";

	static ScalarFunctionSet GetFunctions();
};

struct ListDotProductFun {
	using ALIAS = ListInnerProductFun;

	static constexpr const char *Name = "list_dot_product";
};

struct ListNegativeInnerProductFun {
	static constexpr const char *Name = "list_negative_inner_product";
	static constexpr const char *Parameters = "list1,list2";
	static constexpr const char *Description = "Computes the negative inner product between two same-sized lists.";
	static constexpr const char *Example = "list_negative_inner_product([1, 2, 3], [1, 2, 3])";
	static constexpr const char *Categories = "list";

	static ScalarFunctionSet GetFunctions();
};

struct ListNegativeDotProductFun {
	using ALIAS = ListNegativeInnerProductFun;

	static constexpr const char *Name = "list_negative_dot_product";
};

struct UnpivotListFun {
	static constexpr const char *Name = "unpivot_list";
	static constexpr const char *Parameters = "any,...";
	static constexpr const char *Description = "Identical to list_value, but generated as part of unpivot for better error messages.";
	static constexpr const char *Example = "unpivot_list(4, 5, 6)";
	static constexpr const char *Categories = "list";

	static ScalarFunction GetFunction();
};

struct ListHasAnyFun {
	static constexpr const char *Name = "list_has_any";
	static constexpr const char *Parameters = "list1,list2";
	static constexpr const char *Description = "Returns true if the lists have any element in common. NULLs are ignored.";
	static constexpr const char *Example = "list_has_any([1, 2, 3], [2, 3, 4])";
	static constexpr const char *Categories = "list";

	static ScalarFunction GetFunction();
};

struct ArrayHasAnyFun {
	using ALIAS = ListHasAnyFun;

	static constexpr const char *Name = "array_has_any";
};

struct ListHasAnyFunAlias {
	using ALIAS = ListHasAnyFun;

	static constexpr const char *Name = "&&";
};

struct ListHasAllFun {
	static constexpr const char *Name = "list_has_all";
	static constexpr const char *Parameters = "list1,list2";
	static constexpr const char *Description = "Returns true if all elements of list2 are in list1. NULLs are ignored.";
	static constexpr const char *Example = "list_has_all([1, 2, 3], [2, 3])";
	static constexpr const char *Categories = "list";

	static ScalarFunction GetFunction();
};

struct ArrayHasAllFun {
	using ALIAS = ListHasAllFun;

	static constexpr const char *Name = "array_has_all";
};

struct ListHasAllFunAlias {
	using ALIAS = ListHasAllFun;

	static constexpr const char *Name = "@>";
};

struct ListHasAllFunAlias2 {
	using ALIAS = ListHasAllFun;

	static constexpr const char *Name = "<@";
};

} // namespace duckdb
