/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.AuthorizationException;
import ch.iterate.openstack.swift.exception.ContainerNotFoundException;
import ch.iterate.openstack.swift.model.Region;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SwiftLocationFeature
implements Location {
    private static final Logger log = Logger.getLogger(SwiftLocationFeature.class);
    private final SwiftSession session;
    private final PathContainerService containerService = new PathContainerService();
    private final Map<Path, Location.Name> cache = new HashMap<Path, Location.Name>();

    public SwiftLocationFeature(SwiftSession session) {
        this.session = session;
    }

    public Set<Location.Name> getLocations() {
        LinkedHashSet<Location.Name> locations = new LinkedHashSet<Location.Name>();
        if (StringUtils.isNotBlank((CharSequence)this.session.getHost().getRegion())) {
            locations.add(new SwiftRegion(this.session.getHost().getRegion()));
        } else {
            ArrayList<Region> regions = new ArrayList<Region>(((Client)this.session.getClient()).getRegions());
            regions.sort(new Comparator<Region>(){

                @Override
                public int compare(Region r1, Region r2) {
                    if (r1.isDefault()) {
                        return -1;
                    }
                    if (r2.isDefault()) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (Region region : regions) {
                if (StringUtils.isBlank((CharSequence)region.getRegionId())) continue;
                locations.add(new SwiftRegion(region.getRegionId()));
            }
        }
        return locations;
    }

    public Location.Name getLocation(Path file) throws BackgroundException {
        Path container = this.containerService.getContainer(file);
        if (container.isRoot()) {
            return unknown;
        }
        if (this.cache.containsKey(container)) {
            return this.cache.get(container);
        }
        if (Location.unknown.equals((Object)new SwiftRegion(container.attributes().getRegion()))) {
            SwiftRegion region = new SwiftRegion(this.session.getHost().getRegion());
            if (Location.unknown.equals((Object)region)) {
                Client client = (Client)this.session.getClient();
                for (Region r : client.getRegions()) {
                    try {
                        this.cache.put(container, new SwiftRegion(client.getContainerInfo(r, container.getName()).getRegion().getRegionId()));
                    }
                    catch (AuthorizationException | ContainerNotFoundException e) {
                        log.warn((Object)String.format("Failure finding container %s in region %s", container, r.getRegionId()));
                    }
                    catch (IOException e) {
                        throw new DefaultIOExceptionMappingService().map(e);
                    }
                }
                if (!this.cache.containsKey(container)) {
                    throw new NotfoundException(container.getAbsolute());
                }
            } else {
                this.cache.put(container, region);
            }
        } else {
            SwiftRegion r = new SwiftRegion(container.attributes().getRegion());
            this.cache.put(container, r);
        }
        return this.cache.get(container);
    }

    public static final class SwiftRegion
    extends Location.Name {
        public SwiftRegion(String identifier) {
            super(identifier);
        }

        public String toString() {
            String identifier = this.getIdentifier();
            if (null == identifier) {
                return LocaleFactory.localizedString((String)"Unknown");
            }
            return LocaleFactory.localizedString((String)this.getIdentifier(), (String)"Mosso");
        }
    }
}

