/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.binding;

import ch.cyberduck.binding.AlertController;
import ch.cyberduck.binding.BundleController;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.NSButton;
import ch.cyberduck.binding.application.NSPrintInfo;
import ch.cyberduck.binding.application.NSPrintOperation;
import ch.cyberduck.binding.application.NSPrintPanel;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.binding.application.NSWindow;
import ch.cyberduck.binding.application.SheetCallback;
import ch.cyberduck.binding.application.WindowListener;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.ProviderHelpServiceFactory;
import ch.cyberduck.core.local.BrowserLauncherFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.cocoa.foundation.NSPoint;

public abstract class WindowController
extends BundleController
implements NSWindow.Delegate {
    private static final Logger log = Logger.getLogger(WindowController.class);
    protected static final String DEFAULT = LocaleFactory.localizedString((String)"Default");
    private final Set<WindowListener> listeners = Collections.synchronizedSet(new HashSet());
    protected NSWindow window;

    @Override
    public void invalidate() {
        this.listeners.clear();
        if (this.window != null) {
            this.window.setDelegate(null);
        }
        super.invalidate();
    }

    public void addListener(WindowListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(WindowListener listener) {
        this.listeners.remove(listener);
    }

    public void setWindow(NSWindow window) {
        this.window = window;
        this.window.recalculateKeyViewLoop();
        this.window.setReleasedWhenClosed(!this.isSingleton());
        this.window.setDelegate(this.id());
    }

    public NSWindow window() {
        return this.window;
    }

    public boolean isSingleton() {
        return false;
    }

    public boolean isVisible() {
        if (null == this.window) {
            return false;
        }
        return this.window.isVisible();
    }

    @Override
    public void windowDidBecomeKey(NSNotification notification) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Become key for window %s", new Object[]{this.window}));
        }
    }

    @Override
    public void windowDidResignKey(NSNotification notification) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Resign key for window %s", new Object[]{this.window}));
        }
    }

    @Override
    public void windowDidBecomeMain(NSNotification notification) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Become main for window %s", new Object[]{this.window}));
        }
    }

    @Override
    public void windowDidResignMain(NSNotification notification) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Resign main for window %s", new Object[]{this.window}));
        }
    }

    public void windowWillEnterFullScreen(NSNotification notification) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Enter full screen for window %s", new Object[]{this.window}));
        }
    }

    public void windowWillExitFullScreen(NSNotification notification) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Exit full screen for window %s", new Object[]{this.window}));
        }
    }

    public void windowDidFailToEnterFullScreen(NSWindow window) {
        log.error((Object)"Error entering full screen");
    }

    @Override
    public void windowWillBeginSheet(NSNotification notification) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Attach sheet for window %s", new Object[]{this.window}));
        }
    }

    @Override
    public boolean windowShouldClose(NSWindow sender) {
        return true;
    }

    @Override
    public void windowWillClose(NSNotification notification) {
        this.window.endEditingFor(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Window will close %s", notification));
        }
        for (WindowListener listener : this.listeners.toArray(new WindowListener[this.listeners.size()])) {
            listener.windowWillClose();
        }
        if (!this.isSingleton()) {
            this.invalidate();
        }
    }

    protected NSPoint cascade(NSPoint point) {
        return this.window.cascadeTopLeftFromPoint(point);
    }

    protected void setState(NSButton toggle, boolean select) {
        if (select && 0 == toggle.state() || !select && 1 == toggle.state()) {
            toggle.performClick(null);
        }
        toggle.setState(select ? 1 : 0);
    }

    public void alert(NSAlert alert, final SheetCallback callback) {
        AlertController c = new AlertController(alert){

            @Override
            public void callback(int returncode) {
                callback.callback(returncode);
            }
        };
        c.beginSheet(this);
    }

    public void helpButtonClicked(ID sender) {
        BrowserLauncherFactory.get().open(ProviderHelpServiceFactory.get().help());
    }

    protected void print(NSView view) {
        NSPrintInfo print = NSPrintInfo.sharedPrintInfo();
        print.setOrientation(1);
        NSPrintOperation op = NSPrintOperation.printOperationWithView_printInfo(view, print);
        op.setShowsPrintPanel(true);
        NSPrintPanel panel = op.printPanel();
        panel.setOptions(panel.options() | 8 | 4 | 0x10);
        op.runOperationModalForWindow_delegate_didRunSelector_contextInfo(this.window, this.id(), Foundation.selector((String)"printOperationDidRun:success:contextInfo:"), null);
    }

    public void printOperationDidRun_success_contextInfo(NSPrintOperation op, boolean success, ID contextInfo) {
        if (!success) {
            log.warn((Object)String.format("Printing failed for context %s", contextInfo));
        }
    }
}

