/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features.sharepoint;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.onedrive.AbstractListService;
import ch.cyberduck.core.onedrive.AbstractSharepointSession;
import java.net.URI;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.Sites;
import org.nuxeo.onedrive.client.types.Site;

public class SitesListService
extends AbstractListService<Site.Metadata> {
    private final AbstractSharepointSession session;

    public SitesListService(AbstractSharepointSession session) {
        this.session = session;
    }

    @Override
    protected Iterator<Site.Metadata> getIterator(Path directory) throws BackgroundException {
        if (!this.session.isSingleSite() && directory.getParent().isRoot()) {
            return Sites.getSites((OneDriveAPI)((OneDriveAPI)this.session.getClient()), (String)"*");
        }
        return Sites.getSites((Site)this.session.getSite(directory.getParent()));
    }

    @Override
    protected boolean isFiltering(Path directory) {
        return !this.session.isSingleSite() && directory.getParent().isRoot();
    }

    @Override
    protected boolean filter(Site.Metadata metadata) {
        return null != metadata.getRoot();
    }

    @Override
    protected Path toPath(Site.Metadata metadata, Path directory) {
        PathAttributes attributes = new PathAttributes();
        attributes.setVersionId(metadata.getId());
        attributes.setDisplayname(metadata.getDisplayName());
        attributes.setLink(new DescriptiveUrl(URI.create(metadata.webUrl)));
        return new Path(directory, metadata.getName(), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory, AbstractPath.Type.placeholder), attributes);
    }

    @Override
    protected void postList(AttributedList<Path> list) {
        HashMap<String, Set> duplicates = new HashMap<String, Set>();
        for (int i = 0; i < list.size(); ++i) {
            final Path file = (Path)list.get(i);
            AttributedList result = list.filter((Filter)new Filter<Path>(){

                public boolean accept(Path test) {
                    return file != test && file.getName().equals(test.getName());
                }

                public Pattern toPattern() {
                    return null;
                }
            });
            if (result.size() <= 0) continue;
            Set set = duplicates.getOrDefault(file.getName(), new HashSet());
            set.add(i);
            duplicates.put(file.getName(), set);
        }
        for (Set set : duplicates.values()) {
            for (Integer i : set) {
                Path file = (Path)list.get(i.intValue());
                URI webLink = URI.create(file.attributes().getLink().getUrl());
                String[] path = webLink.getPath().split(String.valueOf('/'));
                String suffix = path[path.length - 2];
                Path rename = new Path(file.getParent(), String.format("%s (%s)", file.getName(), suffix), file.getType(), file.attributes());
                list.set(i.intValue(), (Referenceable)rename);
            }
        }
    }
}

