/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.HostParserException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpSession;
import ch.cyberduck.core.oauth.OAuth2ErrorResponseInterceptor;
import ch.cyberduck.core.oauth.OAuth2RequestInterceptor;
import ch.cyberduck.core.onedrive.GraphCommonsHttpRequestExecutor;
import ch.cyberduck.core.onedrive.features.GraphAttributesFinderFeature;
import ch.cyberduck.core.onedrive.features.GraphBufferWriteFeature;
import ch.cyberduck.core.onedrive.features.GraphCopyFeature;
import ch.cyberduck.core.onedrive.features.GraphDeleteFeature;
import ch.cyberduck.core.onedrive.features.GraphDirectoryFeature;
import ch.cyberduck.core.onedrive.features.GraphFileIdProvider;
import ch.cyberduck.core.onedrive.features.GraphFindFeature;
import ch.cyberduck.core.onedrive.features.GraphMoveFeature;
import ch.cyberduck.core.onedrive.features.GraphPromptUrlProvider;
import ch.cyberduck.core.onedrive.features.GraphQuotaFeature;
import ch.cyberduck.core.onedrive.features.GraphReadFeature;
import ch.cyberduck.core.onedrive.features.GraphSearchFeature;
import ch.cyberduck.core.onedrive.features.GraphTimestampFeature;
import ch.cyberduck.core.onedrive.features.GraphTouchFeature;
import ch.cyberduck.core.onedrive.features.GraphWriteFeature;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.proxy.ProxyFactory;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.RequestExecutor;
import org.nuxeo.onedrive.client.RequestHeader;
import org.nuxeo.onedrive.client.Users;
import org.nuxeo.onedrive.client.types.DriveItem;
import org.nuxeo.onedrive.client.types.User;

public abstract class GraphSession
extends HttpSession<OneDriveAPI> {
    private static final String API_VERSION = "v1.0";
    private static final Logger log = Logger.getLogger(GraphSession.class);
    private OAuth2RequestInterceptor authorizationService;
    private User.Metadata user;
    protected final GraphFileIdProvider fileIdProvider = new GraphFileIdProvider(this);

    public User.Metadata getUser() {
        return this.user;
    }

    protected GraphSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
    }

    public DriveItem toItem(Path currentPath) throws BackgroundException {
        return this.toItem(currentPath, true);
    }

    public abstract DriveItem toItem(Path var1, boolean var2) throws BackgroundException;

    public boolean isAccessible(Path path) {
        return this.isAccessible(path, true);
    }

    public abstract boolean isAccessible(Path var1, boolean var2);

    public abstract ContainerItem getContainer(Path var1);

    public DriveItem toFile(Path file) throws BackgroundException {
        return this.toFile(file, true);
    }

    public DriveItem toFile(Path file, boolean resolveLastItem) throws BackgroundException {
        DriveItem item = this.toItem(file, resolveLastItem);
        if (!(item instanceof DriveItem)) {
            throw new NotfoundException(String.format("%s is not a file.", file.getAbsolute()));
        }
        return item;
    }

    public DriveItem toFolder(Path file) throws BackgroundException {
        return this.toFolder(file, true);
    }

    public DriveItem toFolder(Path file, boolean resolveLastItem) throws BackgroundException {
        DriveItem item = this.toItem(file, resolveLastItem);
        if (!(item instanceof DriveItem)) {
            throw new NotfoundException(String.format("%s is not a folder.", file.getAbsolute()));
        }
        return item;
    }

    protected OneDriveAPI connect(Proxy proxy, HostKeyCallback key, LoginCallback prompt) throws HostParserException {
        HttpClientBuilder configuration = this.builder.build(ProxyFactory.get().find(this.host.getProtocol().getOAuthAuthorizationUrl()), (TranscriptListener)this, prompt);
        this.authorizationService = new OAuth2RequestInterceptor((HttpClient)configuration.build(), this.host.getProtocol()){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                if (request.containsHeader("Authorization")) {
                    super.process(request, context);
                }
            }
        }.withRedirectUri(this.host.getProtocol().getOAuthRedirectUrl()).withParameter("prompt", "select_account");
        configuration.addInterceptorLast((HttpRequestInterceptor)this.authorizationService);
        configuration.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new OAuth2ErrorResponseInterceptor(this.host, this.authorizationService, prompt));
        final GraphCommonsHttpRequestExecutor executor = new GraphCommonsHttpRequestExecutor(configuration.build()){

            public void addAuthorizationHeader(Set<RequestHeader> headers) {
                headers.add(new RequestHeader("Authorization", "Bearer"));
            }
        };
        return new OneDriveAPI(){

            public RequestExecutor getExecutor() {
                return executor;
            }

            public boolean isBusinessConnection() {
                return false;
            }

            public boolean isGraphConnection() {
                String hostname = GraphSession.this.host.getProtocol().getDefaultHostname();
                switch (hostname.toLowerCase()) {
                    case "graph.microsoft.com": 
                    case "graph.microsoft.de": 
                    case "microsoftgraph.chinacloudapi.cn": {
                        return true;
                    }
                }
                return false;
            }

            public String getBaseURL() {
                return String.format("%s://%s/%s", GraphSession.this.host.getProtocol().getScheme(), GraphSession.this.host.getProtocol().getDefaultHostname(), GraphSession.API_VERSION);
            }

            public String getEmailURL() {
                return String.format("%s%s", this.getBaseURL(), "/me");
            }
        };
    }

    public void login(Proxy proxy, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        this.authorizationService.setTokens(this.authorizationService.authorize(this.host, prompt, cancel));
        try {
            this.user = Users.get((User)User.getCurrent((OneDriveAPI)((OneDriveAPI)this.client)), (User.Select[])new User.Select[]{User.Select.CreationType, User.Select.UserPrincipalName});
            String account = this.user.getUserPrincipalName();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Authenticated as user %s", account));
            }
            this.host.getCredentials().setUsername(account);
        }
        catch (OneDriveAPIException e) {
            log.warn((Object)String.format("Failure reading current user properties probably missing user.read scope. %s.", e.getMessage()));
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    protected void logout() throws BackgroundException {
        try {
            ((OneDriveAPI)this.client).getExecutor().close();
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == IdProvider.class) {
            return (T)this.fileIdProvider;
        }
        if (type == AttributesFinder.class) {
            return (T)new GraphAttributesFinderFeature(this);
        }
        if (type == Directory.class) {
            return (T)new GraphDirectoryFeature(this);
        }
        if (type == Read.class) {
            return (T)new GraphReadFeature(this);
        }
        if (type == Write.class) {
            return (T)new GraphWriteFeature(this);
        }
        if (type == MultipartWrite.class) {
            return (T)new GraphBufferWriteFeature(this);
        }
        if (type == Delete.class) {
            return (T)new GraphDeleteFeature(this);
        }
        if (type == Touch.class) {
            return (T)new GraphTouchFeature(this);
        }
        if (type == Move.class) {
            return (T)new GraphMoveFeature(this);
        }
        if (type == Copy.class) {
            return (T)new GraphCopyFeature(this);
        }
        if (type == Find.class) {
            return (T)new GraphFindFeature(this);
        }
        if (type == Search.class) {
            return (T)new GraphSearchFeature(this);
        }
        if (type == Timestamp.class) {
            return (T)((Object)new GraphTimestampFeature(this));
        }
        if (type == Quota.class) {
            return (T)new GraphQuotaFeature(this, (Home)this.getFeature(Home.class));
        }
        if (type == PromptUrlProvider.class) {
            return (T)new GraphPromptUrlProvider(this);
        }
        return (T)super._getFeature(type);
    }

    public static final class ContainerItem {
        public static final ContainerItem EMPTY = new ContainerItem(null, null, false);
        private final Path collectionPath;
        private final Path containerPath;
        private final boolean isDrive;

        public boolean isDrive() {
            return this.isDrive;
        }

        public Optional<Path> getCollectionPath() {
            return Optional.ofNullable(this.collectionPath);
        }

        public Optional<Path> getContainerPath() {
            return Optional.ofNullable(this.containerPath);
        }

        public boolean isDefined() {
            return this.collectionPath != null && this.containerPath != null;
        }

        public boolean isContainerInCollection() {
            if (!this.isDefined()) {
                return false;
            }
            return this.containerPath.isChild(this.collectionPath);
        }

        public boolean isCollectionInContainer() {
            if (!this.isDefined()) {
                return false;
            }
            return this.collectionPath.isChild(this.containerPath);
        }

        public ContainerItem(Path containerPath, Path collectionPath, boolean isDrive) {
            this.containerPath = containerPath;
            this.collectionPath = collectionPath;
            this.isDrive = isDrive;
        }
    }
}

