/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxRootListService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.shared.DefaultHomeFinderService;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.users.DbxUserUsersRequests;
import com.dropbox.core.v2.users.FullAccount;
import org.apache.log4j.Logger;

public class DropboxHomeFinderFeature
extends DefaultHomeFinderService {
    private static final Logger log = Logger.getLogger(DropboxRootListService.class);
    private final DropboxSession session;

    public DropboxHomeFinderFeature(DropboxSession session) {
        super((Session)session);
        this.session = session;
    }

    public Path find() throws BackgroundException {
        Path directory = super.find();
        if (directory.isRoot()) {
            try {
                FullAccount account = new DbxUserUsersRequests((DbxRawClientV2)this.session.getClient()).getCurrentAccount();
                switch (account.getAccountType()) {
                    case BUSINESS: {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Set root namespace %s", account.getRootInfo().getRootNamespaceId()));
                        }
                        return directory.withAttributes(new PathAttributes().withVersionId(account.getRootInfo().getRootNamespaceId()));
                    }
                }
            }
            catch (DbxException e) {
                throw new DropboxExceptionMappingService().map(e);
            }
        }
        return directory;
    }
}

