/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp.openssh;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostParser;
import ch.cyberduck.core.JumphostConfigurator;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.exception.HostParserException;
import ch.cyberduck.core.sftp.SFTPProtocol;
import ch.cyberduck.core.sftp.openssh.OpenSSHCredentialsConfigurator;
import ch.cyberduck.core.sftp.openssh.OpenSSHHostnameConfigurator;
import ch.cyberduck.core.sftp.openssh.config.transport.OpenSshConfig;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class OpenSSHJumpHostConfigurator
implements JumphostConfigurator {
    private static final Logger log = Logger.getLogger(OpenSSHJumpHostConfigurator.class);
    private final OpenSshConfig configuration;
    private final OpenSSHHostnameConfigurator hostname;
    private final OpenSSHCredentialsConfigurator credentials;

    public OpenSSHJumpHostConfigurator() {
        this(new OpenSshConfig(LocalFactory.get((Local)LocalFactory.get((Local)LocalFactory.get(), (String)".ssh"), (String)"config")));
    }

    public OpenSSHJumpHostConfigurator(OpenSshConfig configuration) {
        this.configuration = configuration;
        this.hostname = new OpenSSHHostnameConfigurator(configuration);
        this.credentials = new OpenSSHCredentialsConfigurator(configuration);
    }

    public Host getJumphost(String alias) {
        if (StringUtils.isBlank((CharSequence)alias)) {
            return null;
        }
        String proxyJump = this.configuration.lookup(alias).getProxyJump();
        if (StringUtils.isBlank((CharSequence)proxyJump)) {
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Found jump host configuration %s from %s", proxyJump, this.configuration));
        }
        try {
            Host host = new HostParser(new ProtocolFactory(Collections.singleton(new SFTPProtocol())), (Protocol)new SFTPProtocol()).get(proxyJump);
            host.setCredentials(this.credentials.configure(host));
            host.setPort(this.hostname.getPort(host.getHostname()));
            host.setHostname(this.hostname.getHostname(host.getHostname()));
            return host;
        }
        catch (HostParserException e) {
            log.warn((Object)String.format("Failure parsing JumpHost directive %s", proxyJump));
            return null;
        }
    }

    public JumphostConfigurator reload() {
        this.hostname.reload();
        this.credentials.reload();
        return this;
    }
}

