/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.FileDriverError;
import org.irods.jargon.core.exception.FileNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.DataObjInpForQuerySpecColl;
import org.irods.jargon.core.packinstr.SpecColInfo;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.pub.CollectionAndDataObjectListAndSearchAO;
import org.irods.jargon.core.pub.CollectionIteratorAOImpl;
import org.irods.jargon.core.pub.IRODSAccessObjectFactory;
import org.irods.jargon.core.pub.IRODSGenQueryExecutor;
import org.irods.jargon.core.pub.ZoneAO;
import org.irods.jargon.core.pub.aohelper.CollectionAOHelper;
import org.irods.jargon.core.pub.domain.ObjStat;
import org.irods.jargon.core.pub.domain.Zone;
import org.irods.jargon.core.pub.io.IRODSFileSystemAOHelper;
import org.irods.jargon.core.query.CollectionAndDataObjectListingEntry;
import org.irods.jargon.core.query.GenQueryBuilderException;
import org.irods.jargon.core.query.IRODSGenQueryBuilder;
import org.irods.jargon.core.query.IRODSGenQueryFromBuilder;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSet;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.QueryResultProcessingUtils;
import org.irods.jargon.core.utils.CollectionAndPath;
import org.irods.jargon.core.utils.IRODSDataConversionUtil;
import org.irods.jargon.core.utils.MiscIRODSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CollectionListingUtils {
    private final CollectionAndDataObjectListAndSearchAO collectionAndDataObjectListAndSearchAO;
    public static final String QUERY_EXCEPTION_FOR_QUERY = "query exception for  query:";
    public static final Logger log = LoggerFactory.getLogger(CollectionIteratorAOImpl.class);

    IRODSAccessObjectFactory getIrodsAccessObjectFactory() throws JargonException {
        return this.collectionAndDataObjectListAndSearchAO.getIRODSAccessObjectFactory();
    }

    IRODSAccount getIrodsAccount() throws JargonException {
        return this.collectionAndDataObjectListAndSearchAO.getIRODSAccount();
    }

    CollectionListingUtils(CollectionAndDataObjectListAndSearchAO collectionAndDataObjectListAndSearchAO) {
        if (collectionAndDataObjectListAndSearchAO == null) {
            throw new IllegalArgumentException("null collectionAndDataObjectListAndSearchAO");
        }
        this.collectionAndDataObjectListAndSearchAO = collectionAndDataObjectListAndSearchAO;
    }

    List<CollectionAndDataObjectListingEntry> handleNoListingUnderRootOrHomeByLookingForPublicAndHome(String absolutePathToParent) throws FileNotFoundException, JargonException {
        log.info("handleNoListingUnderRootOrHomeByLookingForPublicAndHome()");
        String path = absolutePathToParent;
        ArrayList<CollectionAndDataObjectListingEntry> collectionAndDataObjectListingEntries = new ArrayList<CollectionAndDataObjectListingEntry>();
        if (!this.collectionAndDataObjectListAndSearchAO.getJargonProperties().isDefaultToPublicIfNothingUnderRootWhenListing()) {
            log.info("not configured in jargon.properties to look for public and user home, throw the FileNotFoundException");
            throw new FileNotFoundException("the collection cannot be found");
        }
        if (path.equals("/")) {
            log.info("phase1 - under root, add zones");
            collectionAndDataObjectListingEntries.addAll(this.createStandInForZoneDir());
            return collectionAndDataObjectListingEntries;
        }
        List<String> components = MiscIRODSUtils.breakIRODSPathIntoComponents(path);
        if (components.size() == 2) {
            log.info("under zone, add a home");
            log.info("assume this is a zone name, look for a home dir under the zone name");
            collectionAndDataObjectListingEntries.add(this.createStandInForHomeDir(path));
            return collectionAndDataObjectListingEntries;
        }
        components = MiscIRODSUtils.breakIRODSPathIntoComponents(path);
        if (components.size() == 3 && components.get(2).equals("home")) {
            log.info("under home, see if same zone as login");
            if (this.collectionAndDataObjectListAndSearchAO.getIRODSAccount().getZone().equals(components.get(1))) {
                log.info("under logged in zone, add user and public dirs");
                collectionAndDataObjectListingEntries.addAll(this.createStandInsUnderHomeInLoggedInZone(path));
            } else {
                log.info("under federated zone, add federated user");
                collectionAndDataObjectListingEntries.addAll(this.createStandInsUnderHomeInFederatedZone(components.get(1)));
            }
            return collectionAndDataObjectListingEntries;
        }
        log.info("really is a not found for file:{}", (Object)path);
        throw new FileNotFoundException("unable to find file under path");
    }

    ObjStat handleNoObjStatUnderRootOrHomeByLookingForPublicAndHome(String irodsAbsolutePath) throws FileNotFoundException, JargonException {
        log.info("handleNoObjStatUnderRootOrHomeByLookingForPublicAndHome()");
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        ObjStat objStat = null;
        if (!this.collectionAndDataObjectListAndSearchAO.getJargonProperties().isDefaultToPublicIfNothingUnderRootWhenListing()) {
            log.info("not configured in jargon.properties to look for public and user home, throw the FileNotFoundException");
            throw new FileNotFoundException("the object cannot be found");
        }
        if (irodsAbsolutePath.equals("/")) {
            log.info("phase1 - under root");
            objStat = new ObjStat();
            objStat.setAbsolutePath(irodsAbsolutePath);
            objStat.setObjectType(CollectionAndDataObjectListingEntry.ObjectType.COLLECTION);
            objStat.setSpecColType(ObjStat.SpecColType.NORMAL);
            objStat.setStandInGeneratedObjStat(true);
            objStat.setModifiedAt(new Date());
            objStat.setCreatedAt(new Date());
            log.info("return a fake objStat for root:{}", (Object)objStat);
            return objStat;
        }
        List<String> components = MiscIRODSUtils.breakIRODSPathIntoComponents(irodsAbsolutePath);
        if (components.size() == 2) {
            ZoneAO zoneAO = this.getIrodsAccessObjectFactory().getZoneAO(this.getIrodsAccount());
            List<String> zones = zoneAO.listZoneNames();
            boolean found = false;
            for (String zone : zones) {
                if (!zone.equals(components.get(1))) continue;
                log.info("zone matches:{}", (Object)zone);
                found = true;
                break;
            }
            if (!found) {
                log.error("not a valid zone, cannot interpolate this path:{}", (Object)irodsAbsolutePath);
                throw new FileNotFoundException("path does not exist");
            }
            objStat = new ObjStat();
            objStat.setAbsolutePath(irodsAbsolutePath);
            objStat.setObjectType(CollectionAndDataObjectListingEntry.ObjectType.COLLECTION);
            objStat.setSpecColType(ObjStat.SpecColType.NORMAL);
            objStat.setStandInGeneratedObjStat(true);
            objStat.setModifiedAt(new Date());
            objStat.setCreatedAt(new Date());
            log.info("return a fake objStat for zone:{}", (Object)objStat);
            return objStat;
        }
        if (components.size() == 3) {
            log.info("under zone, add a home obj stat");
            if (components.get(2).equals("home")) {
                objStat = new ObjStat();
                objStat.setAbsolutePath(irodsAbsolutePath);
                objStat.setObjectType(CollectionAndDataObjectListingEntry.ObjectType.COLLECTION);
                objStat.setSpecColType(ObjStat.SpecColType.NORMAL);
                objStat.setStandInGeneratedObjStat(true);
                objStat.setModifiedAt(new Date());
                objStat.setCreatedAt(new Date());
                log.info("return a fake objStat for zone/home:{}", (Object)objStat);
                return objStat;
            }
        }
        log.info("really is a not found for file:{}", (Object)irodsAbsolutePath);
        throw new FileNotFoundException("unable to find file under path");
    }

    private List<CollectionAndDataObjectListingEntry> createStandInsUnderHomeInLoggedInZone(String path) throws FileNotFoundException, JargonException {
        ArrayList<CollectionAndDataObjectListingEntry> collectionAndDataObjectListingEntries = new ArrayList<CollectionAndDataObjectListingEntry>();
        log.info("under home, look for public and user dir");
        StringBuilder sb = new StringBuilder(path);
        sb.append("/public");
        try {
            ObjStat statForPublic = this.collectionAndDataObjectListAndSearchAO.retrieveObjectStatForPath(sb.toString());
            collectionAndDataObjectListingEntries.add(this.createStandInForPublicDir(statForPublic));
        }
        catch (FileNotFoundException fnf) {
            log.info("no public dir");
        }
        log.info("see if a user home dir applies");
        try {
            ObjStat statForUserHome = this.collectionAndDataObjectListAndSearchAO.retrieveObjectStatForPath(MiscIRODSUtils.computeHomeDirectoryForIRODSAccount(this.collectionAndDataObjectListAndSearchAO.getIRODSAccount()));
            collectionAndDataObjectListingEntries.add(this.createStandInForUserDir(statForUserHome));
        }
        catch (FileNotFoundException fnf) {
            log.info("no home dir");
        }
        return collectionAndDataObjectListingEntries;
    }

    private List<CollectionAndDataObjectListingEntry> createStandInsUnderHomeInFederatedZone(String zone) throws FileNotFoundException, JargonException {
        ArrayList<CollectionAndDataObjectListingEntry> collectionAndDataObjectListingEntries = new ArrayList<CollectionAndDataObjectListingEntry>();
        log.info("under home in federated zone, look for public and home dir");
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        sb.append(zone);
        sb.append("/home/public");
        try {
            ObjStat statForPublic = this.collectionAndDataObjectListAndSearchAO.retrieveObjectStatForPath(sb.toString());
            collectionAndDataObjectListingEntries.add(this.createStandInForPublicDir(statForPublic));
        }
        catch (FileNotFoundException fnf) {
            log.info("no public dir");
        }
        log.info("see if a user home dir applies");
        try {
            ObjStat homeStat = this.collectionAndDataObjectListAndSearchAO.retrieveObjectStatForPath(MiscIRODSUtils.computeHomeDirectoryForIRODSAccountInFederatedZone(this.collectionAndDataObjectListAndSearchAO.getIRODSAccount(), zone));
            collectionAndDataObjectListingEntries.add(this.createStandInForUserDir(homeStat));
        }
        catch (FileNotFoundException fnf) {
            log.info("no user dir");
        }
        return collectionAndDataObjectListingEntries;
    }

    private List<CollectionAndDataObjectListingEntry> createStandInForZoneDir() throws FileNotFoundException, JargonException {
        log.info("under root, put out zone as an entry");
        ArrayList<CollectionAndDataObjectListingEntry> entries = new ArrayList<CollectionAndDataObjectListingEntry>();
        ZoneAO zoneAO = this.collectionAndDataObjectListAndSearchAO.getIRODSAccessObjectFactory().getZoneAO(this.collectionAndDataObjectListAndSearchAO.getIRODSAccount());
        List<Zone> zones = zoneAO.listZones();
        int count = 1;
        for (Zone zone : zones) {
            CollectionAndDataObjectListingEntry entry = new CollectionAndDataObjectListingEntry();
            entry.setParentPath("/");
            StringBuilder sb = new StringBuilder();
            sb.append("/");
            sb.append(zone.getZoneName());
            entry.setPathOrName(sb.toString());
            entry.setObjectType(CollectionAndDataObjectListingEntry.ObjectType.COLLECTION);
            entry.setCount(count++);
            entry.setLastResult(true);
            entries.add(entry);
        }
        return entries;
    }

    private CollectionAndDataObjectListingEntry createStandInForHomeDir(String path) {
        log.info("under a zone, put out home as an entry");
        CollectionAndDataObjectListingEntry entry = new CollectionAndDataObjectListingEntry();
        entry.setCount(0);
        entry.setLastResult(true);
        entry.setObjectType(CollectionAndDataObjectListingEntry.ObjectType.COLLECTION);
        entry.setOwnerZone(this.collectionAndDataObjectListAndSearchAO.getIRODSAccount().getZone());
        entry.setParentPath(path);
        StringBuilder sb = new StringBuilder();
        sb.append(path);
        sb.append("/home");
        entry.setPathOrName(sb.toString());
        entry.setSpecColType(ObjStat.SpecColType.NORMAL);
        entry.setLastResult(true);
        return entry;
    }

    private CollectionAndDataObjectListingEntry createStandInForPublicDir(ObjStat objStat) {
        log.info("under root, put out home as an entry");
        CollectionAndDataObjectListingEntry entry = new CollectionAndDataObjectListingEntry();
        entry.setCount(0);
        entry.setLastResult(true);
        entry.setOwnerZone(this.collectionAndDataObjectListAndSearchAO.getIRODSAccount().getZone());
        entry.setOwnerName(objStat.getOwnerName());
        entry.setPathOrName(objStat.getAbsolutePath());
        entry.setSpecColType(objStat.getSpecColType());
        entry.setCreatedAt(objStat.getCreatedAt());
        entry.setId(objStat.getDataId());
        entry.setObjectType(objStat.getObjectType());
        return entry;
    }

    private CollectionAndDataObjectListingEntry createStandInForUserDir(ObjStat objStat) {
        log.info("put a user dir entry out there");
        CollectionAndDataObjectListingEntry entry = new CollectionAndDataObjectListingEntry();
        entry.setCount(0);
        entry.setLastResult(true);
        entry.setObjectType(CollectionAndDataObjectListingEntry.ObjectType.COLLECTION);
        entry.setOwnerZone(this.collectionAndDataObjectListAndSearchAO.getIRODSAccount().getZone());
        entry.setPathOrName(objStat.getAbsolutePath());
        entry.setSpecColType(objStat.getSpecColType());
        entry.setCreatedAt(objStat.getCreatedAt());
        entry.setId(objStat.getDataId());
        entry.setObjectType(objStat.getObjectType());
        entry.setOwnerZone(this.collectionAndDataObjectListAndSearchAO.getIRODSAccount().getZone());
        entry.setOwnerName(objStat.getOwnerName());
        return entry;
    }

    List<CollectionAndDataObjectListingEntry> listCollectionsUnderPath(ObjStat objStat, int partialStartIndex) throws FileNotFoundException, JargonException {
        log.info("listCollectionsUnderPath()");
        if (objStat == null) {
            throw new IllegalArgumentException("objStat is null");
        }
        MiscIRODSUtils.evaluateSpecCollSupport(objStat);
        String effectiveAbsolutePath = MiscIRODSUtils.determineAbsolutePathBasedOnCollTypeInObjectStat(objStat);
        if (objStat.getSpecColType() == ObjStat.SpecColType.STRUCT_FILE_COLL || objStat.getSpecColType() == ObjStat.SpecColType.MOUNTED_COLL) {
            return this.listUnderPathWhenSpecColl(objStat, effectiveAbsolutePath, true);
        }
        return this.listCollectionsUnderPathViaGenQuery(objStat, partialStartIndex, effectiveAbsolutePath);
    }

    private List<CollectionAndDataObjectListingEntry> listUnderPathWhenSpecColl(ObjStat objStat, String effectiveAbsolutePath, boolean isCollection) throws JargonException {
        log.info("listCollectionsUnderPathWhenSpecColl()");
        ArrayList<CollectionAndDataObjectListingEntry> entries = new ArrayList<CollectionAndDataObjectListingEntry>();
        SpecColInfo specColInfo = new SpecColInfo();
        specColInfo.setCacheDir(objStat.getCacheDir());
        if (objStat.isCacheDirty()) {
            specColInfo.setCacheDirty(1);
        }
        specColInfo.setCollClass(1);
        specColInfo.setCollection(objStat.getAbsolutePath());
        specColInfo.setObjPath(objStat.getObjectPath());
        specColInfo.setPhyPath(objStat.getObjectPath());
        specColInfo.setReplNum(objStat.getReplNumber());
        specColInfo.setType(2);
        if (this.collectionAndDataObjectListAndSearchAO.getIRODSServerProperties().isAtLeastIrods410()) {
            specColInfo.setUseResourceHierarchy(true);
        }
        DataObjInpForQuerySpecColl dataObjInp = null;
        dataObjInp = isCollection ? DataObjInpForQuerySpecColl.instanceQueryCollections(effectiveAbsolutePath, specColInfo) : DataObjInpForQuerySpecColl.instanceQueryDataObj(effectiveAbsolutePath, specColInfo);
        try {
            Tag response = this.collectionAndDataObjectListAndSearchAO.getIRODSProtocol().irodsFunction(dataObjInp);
            log.debug("response from function: {}", (Object)response.parseTag());
            int totalRecords = response.getTag("totalRowCount").getIntValue();
            log.info("total records:{}", (Object)totalRecords);
            int continueInx = response.getTag("continueInx").getIntValue();
            List<IRODSQueryResultRow> results = QueryResultProcessingUtils.translateResponseIntoResultSet(response, new ArrayList<String>(), 0, 0);
            int ctr = 1;
            CollectionAndDataObjectListingEntry entry = null;
            for (IRODSQueryResultRow row : results) {
                entry = this.createListingEntryFromResultRow(objStat, row, isCollection);
                entry.setCount(ctr++);
                entry.setLastResult(continueInx <= 0);
                entries.add(entry);
            }
            while (continueInx > 0) {
                dataObjInp = DataObjInpForQuerySpecColl.instanceQueryCollections(effectiveAbsolutePath, specColInfo, continueInx);
                dataObjInp = isCollection ? DataObjInpForQuerySpecColl.instanceQueryCollections(effectiveAbsolutePath, specColInfo, continueInx) : DataObjInpForQuerySpecColl.instanceQueryDataObj(effectiveAbsolutePath, specColInfo, continueInx);
                response = this.collectionAndDataObjectListAndSearchAO.getIRODSProtocol().irodsFunction(dataObjInp);
                log.debug("response from function: {}", (Object)response.parseTag());
                totalRecords = response.getTag("totalRowCount").getIntValue();
                log.info("total records:{}", (Object)totalRecords);
                continueInx = response.getTag("continueInx").getIntValue();
                results = QueryResultProcessingUtils.translateResponseIntoResultSet(response, new ArrayList<String>(), 0, entries.size());
                for (IRODSQueryResultRow row : results) {
                    entry = this.createListingEntryFromResultRow(objStat, row, isCollection);
                    entry.setCount(ctr++);
                    entry.setLastResult(continueInx <= 0);
                    entries.add(entry);
                }
            }
            return entries;
        }
        catch (FileDriverError fde) {
            log.warn("file driver error listing empty spec coll is ignored, just act as no data found");
            return new ArrayList<CollectionAndDataObjectListingEntry>();
        }
        catch (DataNotFoundException dnf) {
            log.info("end of data");
            return entries;
        }
    }

    private CollectionAndDataObjectListingEntry createListingEntryFromResultRow(ObjStat objStat, IRODSQueryResultRow row, boolean isCollection) throws JargonException {
        CollectionAndDataObjectListingEntry listingEntry = new CollectionAndDataObjectListingEntry();
        listingEntry.setCreatedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(2)));
        listingEntry.setDataSize(IRODSDataConversionUtil.getLongOrZeroFromIRODSValue(row.getColumn(4)));
        listingEntry.setModifiedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(3)));
        row.getColumn(1);
        if (isCollection) {
            listingEntry.setObjectType(CollectionAndDataObjectListingEntry.ObjectType.COLLECTION);
        } else {
            listingEntry.setObjectType(CollectionAndDataObjectListingEntry.ObjectType.DATA_OBJECT);
        }
        listingEntry.setOwnerName(objStat.getOwnerName());
        listingEntry.setOwnerZone(objStat.getOwnerZone());
        if (isCollection) {
            CollectionAndPath collectionAndPath = MiscIRODSUtils.separateCollectionAndPathFromGivenAbsolutePath(row.getColumn(0));
            listingEntry.setParentPath(collectionAndPath.getCollectionParent());
            listingEntry.setPathOrName(row.getColumn(0));
        } else {
            listingEntry.setParentPath(row.getColumn(0));
            listingEntry.setPathOrName(row.getColumn(1));
        }
        listingEntry.setSpecColType(objStat.getSpecColType());
        return listingEntry;
    }

    private List<CollectionAndDataObjectListingEntry> listCollectionsUnderPathViaGenQuery(ObjStat objStat, int partialStartIndex, String effectiveAbsolutePath) throws JargonException {
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, false, true, null);
        try {
            IRODSFileSystemAOHelper.buildQueryListAllCollections(effectiveAbsolutePath, builder);
        }
        catch (GenQueryBuilderException e) {
            log.error("query builder exception", (Throwable)e);
            throw new JargonException("error building query", e);
        }
        IRODSQueryResultSet resultSet = this.queryForPathAndReturnResultSet(objStat.getAbsolutePath(), builder, partialStartIndex, objStat);
        ArrayList<CollectionAndDataObjectListingEntry> subdirs = new ArrayList<CollectionAndDataObjectListingEntry>(resultSet.getResults().size());
        CollectionAndDataObjectListingEntry collectionAndDataObjectListingEntry = null;
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            collectionAndDataObjectListingEntry = CollectionAOHelper.buildCollectionListEntryFromResultSetRowForCollectionQuery(row, resultSet.getTotalRecords());
            this.adjustEntryFromRowInCaseOfSpecialCollection(objStat, effectiveAbsolutePath, collectionAndDataObjectListingEntry);
            if (collectionAndDataObjectListingEntry.getPathOrName().equals("/")) continue;
            subdirs.add(collectionAndDataObjectListingEntry);
        }
        return subdirs;
    }

    IRODSQueryResultSet queryForPathAndReturnResultSet(String absolutePath, IRODSGenQueryBuilder builder, int partialStartIndex, ObjStat objStat) throws JargonException {
        IRODSQueryResultSet resultSet;
        log.info("queryForPathAndReturnResultSet for: {}", (Object)absolutePath);
        IRODSGenQueryExecutor irodsGenQueryExecutor = this.collectionAndDataObjectListAndSearchAO.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(this.collectionAndDataObjectListAndSearchAO.getIRODSAccount());
        try {
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(this.collectionAndDataObjectListAndSearchAO.getJargonProperties().getMaxFilesAndDirsQueryMax());
            resultSet = irodsGenQueryExecutor.executeIRODSQueryWithPagingInZone(irodsQuery, partialStartIndex, MiscIRODSUtils.getZoneInPath(absolutePath));
        }
        catch (JargonQueryException e) {
            log.error(QUERY_EXCEPTION_FOR_QUERY, (Throwable)e);
            throw new JargonException(e);
        }
        catch (GenQueryBuilderException e) {
            log.error(QUERY_EXCEPTION_FOR_QUERY, (Throwable)e);
            throw new JargonException(e);
        }
        return resultSet;
    }

    private void adjustEntryFromRowInCaseOfSpecialCollection(ObjStat objStat, String effectiveAbsolutePath, CollectionAndDataObjectListingEntry collectionAndDataObjectListingEntry) {
        if (objStat.getSpecColType() == ObjStat.SpecColType.LINKED_COLL) {
            log.info("adjusting paths in entry to reflect linked collection info");
            StringBuilder sb = new StringBuilder();
            sb.append(objStat.getObjectPath());
            sb.append('/');
            sb.append(MiscIRODSUtils.getLastPathComponentForGiveAbsolutePath(collectionAndDataObjectListingEntry.getPathOrName()));
            collectionAndDataObjectListingEntry.setSpecialObjectPath(sb.toString());
            sb = new StringBuilder();
            sb.append(objStat.getAbsolutePath());
            sb.append('/');
            sb.append(MiscIRODSUtils.getLastPathComponentForGiveAbsolutePath(collectionAndDataObjectListingEntry.getPathOrName()));
            collectionAndDataObjectListingEntry.setPathOrName(sb.toString());
            collectionAndDataObjectListingEntry.setParentPath(objStat.getAbsolutePath());
            collectionAndDataObjectListingEntry.setSpecColType(ObjStat.SpecColType.LINKED_COLL);
        }
    }

    List<CollectionAndDataObjectListingEntry> listDataObjectsUnderPath(ObjStat objStat, int partialStartIndex) throws JargonException {
        log.info("listDataObjectsUnderPath(objStat, partialStartIndex)");
        if (objStat == null) {
            throw new IllegalArgumentException("collectionAndDataObjectListingEntry is null");
        }
        String effectiveAbsolutePath = MiscIRODSUtils.determineAbsolutePathBasedOnCollTypeInObjectStat(objStat);
        log.info("determined effectiveAbsolutePathToBe:{}", (Object)effectiveAbsolutePath);
        log.info("listDataObjectsUnderPath for: {}", (Object)objStat);
        List<CollectionAndDataObjectListingEntry> files = objStat.getSpecColType() == ObjStat.SpecColType.STRUCT_FILE_COLL || objStat.getSpecColType() == ObjStat.SpecColType.MOUNTED_COLL ? this.listUnderPathWhenSpecColl(objStat, effectiveAbsolutePath, false) : this.listDataObjectsUnderPathViaGenQuery(objStat, partialStartIndex, effectiveAbsolutePath);
        return files;
    }

    private List<CollectionAndDataObjectListingEntry> listDataObjectsUnderPathViaGenQuery(ObjStat objStat, int partialStartIndex, String effectiveAbsolutePath) throws JargonException {
        IRODSQueryResultSet resultSet;
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, false, true, null);
        IRODSFileSystemAOHelper.buildQueryListAllDataObjectsWithSizeAndDateInfo(effectiveAbsolutePath, builder);
        try {
            resultSet = this.queryForPathAndReturnResultSet(effectiveAbsolutePath, builder, partialStartIndex, objStat);
        }
        catch (JargonException e) {
            log.error("exception querying for data objects:{}", (Object)builder, (Object)e);
            throw new JargonException("error in query", e);
        }
        ArrayList<CollectionAndDataObjectListingEntry> files = new ArrayList<CollectionAndDataObjectListingEntry>(resultSet.getResults().size());
        String lastPath = "";
        String currentPath = "";
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            CollectionAndDataObjectListingEntry entry = CollectionAOHelper.buildCollectionListEntryFromResultSetRowForDataObjectQuery(row, resultSet.getTotalRecords());
            this.augmentCollectionEntryForSpecialCollections(objStat, effectiveAbsolutePath, entry);
            StringBuilder sb = new StringBuilder();
            sb.append(entry.getParentPath());
            sb.append('/');
            sb.append(entry.getPathOrName());
            currentPath = sb.toString();
            if (currentPath.equals(lastPath)) continue;
            lastPath = currentPath;
            files.add(entry);
        }
        return files;
    }

    void augmentCollectionEntryForSpecialCollections(ObjStat objStat, String effectiveAbsolutePath, CollectionAndDataObjectListingEntry entry) {
        if (objStat.getSpecColType() == ObjStat.SpecColType.LINKED_COLL) {
            log.info("adjusting paths in entry to reflect linked collection info");
            entry.setSpecialObjectPath(objStat.getObjectPath());
            CollectionAndPath collectionAndPathForAbsPath = MiscIRODSUtils.separateCollectionAndPathFromGivenAbsolutePath(entry.getPathOrName());
            if (entry.isCollection()) {
                entry.setPathOrName(objStat.getAbsolutePath() + "/" + collectionAndPathForAbsPath.getChildName());
                entry.setParentPath(objStat.getAbsolutePath());
            } else {
                entry.setParentPath(objStat.getAbsolutePath());
            }
        }
    }
}

