/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.azure;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DisabledHostKeyCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.azure.AzureAclPermissionFeature;
import ch.cyberduck.core.azure.AzureAttributesFinderFeature;
import ch.cyberduck.core.azure.AzureCopyFeature;
import ch.cyberduck.core.azure.AzureDeleteFeature;
import ch.cyberduck.core.azure.AzureDirectoryFeature;
import ch.cyberduck.core.azure.AzureFindFeature;
import ch.cyberduck.core.azure.AzureHomeFinderService;
import ch.cyberduck.core.azure.AzureListService;
import ch.cyberduck.core.azure.AzureLoggingFeature;
import ch.cyberduck.core.azure.AzureMetadataFeature;
import ch.cyberduck.core.azure.AzureMoveFeature;
import ch.cyberduck.core.azure.AzureReadFeature;
import ch.cyberduck.core.azure.AzureTouchFeature;
import ch.cyberduck.core.azure.AzureUrlProvider;
import ch.cyberduck.core.azure.AzureWriteFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ListCanceledException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.Logging;
import ch.cyberduck.core.features.Metadata;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.DisabledX509HostnameVerifier;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.ssl.CustomTrustSSLProtocolSocketFactory;
import ch.cyberduck.core.ssl.DefaultX509KeyManager;
import ch.cyberduck.core.ssl.DisabledX509TrustManager;
import ch.cyberduck.core.ssl.SSLSession;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RetryNoRetry;
import com.microsoft.azure.storage.RetryPolicyFactory;
import com.microsoft.azure.storage.SendingRequestEvent;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageCredentialsAccountAndKey;
import com.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.azure.storage.StorageEvent;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureSession
extends SSLSession<CloudBlobClient> {
    private static final Logger log = Logger.getLogger(AzureSession.class);
    private final OperationContext context = new OperationContext();
    private StorageEvent<SendingRequestEvent> listener;

    public AzureSession(Host h) {
        super(h, (X509TrustManager)new DisabledX509TrustManager(), (X509KeyManager)new DefaultX509KeyManager());
    }

    public AzureSession(Host h, X509TrustManager trust, X509KeyManager key) {
        super(h, trust, key);
    }

    public CloudBlobClient connect(Proxy proxy, HostKeyCallback callback, LoginCallback prompt) throws BackgroundException {
        try {
            Object credentials = this.host.getCredentials().isTokenAuthentication() ? new StorageCredentialsSharedAccessSignature(this.host.getCredentials().getToken()) : new StorageCredentialsAccountAndKey(this.host.getCredentials().getUsername(), "null");
            URI uri = new URI(String.format("%s://%s", Scheme.https, this.host.getHostname()));
            CloudBlobClient client = new CloudBlobClient(uri, (StorageCredentials)credentials);
            client.setDirectoryDelimiter(String.valueOf('/'));
            BlobRequestOptions options = new BlobRequestOptions();
            options.setRetryPolicyFactory((RetryPolicyFactory)new RetryNoRetry());
            this.context.setLoggingEnabled(true);
            this.context.setLogger(LoggerFactory.getLogger((String)log.getName()));
            this.context.setUserHeaders(new HashMap<String, String>(Collections.singletonMap("User-Agent", new PreferencesUseragentProvider().get())));
            this.listener = new StorageEvent<SendingRequestEvent>(){

                public void eventOccurred(SendingRequestEvent event) {
                    if (event.getConnectionObject() instanceof HttpsURLConnection) {
                        HttpsURLConnection connection = (HttpsURLConnection)event.getConnectionObject();
                        connection.setSSLSocketFactory((SSLSocketFactory)new CustomTrustSSLProtocolSocketFactory(AzureSession.this.trust, AzureSession.this.key));
                        connection.setHostnameVerifier((HostnameVerifier)new DisabledX509HostnameVerifier());
                    }
                }
            };
            this.context.getSendingRequestEventHandler().addListener((StorageEvent)this.listener);
            switch (proxy.getType()) {
                case SOCKS: {
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Configured to use SOCKS proxy %s", proxy));
                    }
                    java.net.Proxy socksProxy = new java.net.Proxy(Proxy.Type.SOCKS, new InetSocketAddress(proxy.getHostname(), proxy.getPort()));
                    this.context.setProxy(socksProxy);
                    break;
                }
                case HTTP: 
                case HTTPS: {
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Configured to use HTTP proxy %s", proxy));
                    }
                    java.net.Proxy httpProxy = new java.net.Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy.getHostname(), proxy.getPort()));
                    this.context.setProxy(httpProxy);
                    break;
                }
            }
            return client;
        }
        catch (URISyntaxException e) {
            throw new LoginFailureException(e.getMessage(), (Throwable)e);
        }
    }

    public void login(Proxy proxy, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        StorageCredentials credentials = ((CloudBlobClient)this.client).getCredentials();
        if (this.host.getCredentials().isPasswordAuthentication()) {
            ((StorageCredentialsAccountAndKey)credentials).updateKey(this.host.getCredentials().getPassword());
        } else if (this.host.getCredentials().isTokenAuthentication() && !StringUtils.equals((CharSequence)this.host.getCredentials().getToken(), (CharSequence)((StorageCredentialsSharedAccessSignature)credentials).getToken())) {
            this.interrupt();
            this.open(proxy, (HostKeyCallback)new DisabledHostKeyCallback(), prompt);
        }
        try {
            ((ListService)this.getFeature(ListService.class)).list(new AzureHomeFinderService(this).find(), (ListProgressListener)new DisabledListProgressListener(){

                public void chunk(Path parent, AttributedList<Path> list) throws ListCanceledException {
                    throw new ListCanceledException(list);
                }
            });
        }
        catch (ListCanceledException listCanceledException) {
            // empty catch block
        }
    }

    protected void logout() {
        this.context.getSendingRequestEventHandler().removeListener(this.listener);
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == ListService.class) {
            return (T)new AzureListService(this, this.context);
        }
        if (type == Read.class) {
            return (T)new AzureReadFeature(this, this.context);
        }
        if (type == Write.class) {
            return (T)((Object)new AzureWriteFeature(this, this.context));
        }
        if (type == Directory.class) {
            return (T)new AzureDirectoryFeature(this, this.context);
        }
        if (type == Delete.class) {
            return (T)new AzureDeleteFeature(this, this.context);
        }
        if (type == Headers.class) {
            return (T)new AzureMetadataFeature(this, this.context);
        }
        if (type == Metadata.class) {
            return (T)new AzureMetadataFeature(this, this.context);
        }
        if (type == Find.class) {
            return (T)new AzureFindFeature(this, this.context);
        }
        if (type == AttributesFinder.class) {
            return (T)new AzureAttributesFinderFeature(this, this.context);
        }
        if (type == Logging.class) {
            return (T)new AzureLoggingFeature(this, this.context);
        }
        if (type == Home.class) {
            return (T)((Object)new AzureHomeFinderService(this));
        }
        if (type == Move.class) {
            return (T)new AzureMoveFeature(this, this.context);
        }
        if (type == Copy.class) {
            return (T)new AzureCopyFeature(this, this.context);
        }
        if (type == Touch.class) {
            return (T)new AzureTouchFeature(this, this.context);
        }
        if (type == PromptUrlProvider.class) {
            return (T)new AzureUrlProvider(this);
        }
        if (type == AclPermission.class) {
            return (T)((Object)new AzureAclPermissionFeature(this, this.context));
        }
        return (T)super._getFeature(type);
    }

    static {
        HttpsURLConnection.setDefaultSSLSocketFactory((SSLSocketFactory)new CustomTrustSSLProtocolSocketFactory((X509TrustManager)new DisabledX509TrustManager(), (X509KeyManager)new DefaultX509KeyManager()));
        HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)new DisabledX509HostnameVerifier());
        HttpsURLConnection.setFollowRedirects(true);
    }
}

