/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.RandomStringService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.UUIDRandomStringService;
import ch.cyberduck.core.cryptomator.ContentWriter;
import ch.cyberduck.core.cryptomator.CryptoVault;
import ch.cyberduck.core.cryptomator.features.CryptoWriteFeature;
import ch.cyberduck.core.cryptomator.impl.CryptoDirectoryV7Provider;
import ch.cyberduck.core.cryptomator.random.RandomNonceGenerator;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.random.NonceGenerator;
import ch.cyberduck.core.transfer.TransferStatus;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.apache.log4j.Logger;
import org.cryptomator.cryptolib.api.FileHeader;

public class CryptoDirectoryV7Feature<Reply>
implements Directory<Reply> {
    private static final Logger log = Logger.getLogger(CryptoDirectoryV7Feature.class);
    private final Session<?> session;
    private final Directory<Reply> proxy;
    private final CryptoVault vault;
    private final RandomStringService random = new UUIDRandomStringService();

    public CryptoDirectoryV7Feature(Session<?> session, Directory<Reply> delegate, Write<Reply> writer, CryptoVault cryptomator) {
        this.session = session;
        this.proxy = delegate.withWriter(new CryptoWriteFeature<Reply>(session, writer, cryptomator));
        this.vault = cryptomator;
    }

    public Path mkdir(Path folder, String region, TransferStatus status) throws BackgroundException {
        String directoryId = this.random.random();
        Path encrypt = this.vault.encrypt(this.session, folder, directoryId, false);
        Path metadataFolder = this.vault.encrypt(this.session, folder, true);
        Path metadataPath = new Path(((Directory)this.session._getFeature(Directory.class)).mkdir(metadataFolder, region, new TransferStatus()), CryptoDirectoryV7Provider.DIRECTORY_METADATAFILE, EnumSet.of(AbstractPath.Type.file));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Write metadata %s for folder %s", metadataPath, folder));
        }
        new ContentWriter(this.session).write(metadataPath, directoryId.getBytes(StandardCharsets.UTF_8));
        Path intermediate = encrypt.getParent();
        if (!((Find)this.session._getFeature(Find.class)).find(intermediate)) {
            ((Directory)this.session._getFeature(Directory.class)).mkdir(intermediate, region, new TransferStatus());
        }
        FileHeader header = this.vault.getFileHeaderCryptor().create();
        status.setHeader(this.vault.getFileHeaderCryptor().encryptHeader(header));
        status.setNonces((NonceGenerator)new RandomNonceGenerator());
        Path target = this.proxy.mkdir(encrypt, region, status);
        target.attributes().setDirectoryId(directoryId);
        target.attributes().setDecrypted(encrypt.attributes().getDecrypted());
        Path decrypt = this.vault.decrypt(this.session, this.vault.encrypt(this.session, target, true));
        decrypt.attributes().setVersionId(target.attributes().getVersionId());
        return decrypt;
    }

    public boolean isSupported(Path workdir, String name) {
        return this.proxy.isSupported(workdir, name);
    }

    public CryptoDirectoryV7Feature<Reply> withWriter(Write<Reply> writer) {
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoDirectoryFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

