/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.googledrive.DriveAttributesFinderFeature;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileidProvider;
import ch.cyberduck.core.googledrive.DriveHomeFinderService;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import java.io.IOException;
import java.util.Collections;

public class DriveTouchFeature
implements Touch<VersionId> {
    private final DriveSession session;
    private final DriveFileidProvider fileid;

    public DriveTouchFeature(DriveSession session, DriveFileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        try {
            Drive.Files.Create insert = ((Drive)this.session.getClient()).files().create(new File().setName(file.getName()).setMimeType(status.getMime()).setParents(Collections.singletonList(this.fileid.getFileid(file.getParent(), (ListProgressListener)new DisabledListProgressListener()))));
            File execute = (File)insert.setSupportsTeamDrives(Boolean.valueOf(PreferencesFactory.get().getBoolean("googledrive.teamdrive.enable"))).execute();
            return new Path(file.getParent(), file.getName(), file.getType(), new DriveAttributesFinderFeature(this.session, this.fileid).toAttributes(execute));
        }
        catch (IOException e) {
            throw new DriveExceptionMappingService().map("Cannot create file {0}", e, file);
        }
    }

    public DriveTouchFeature withWriter(Write<VersionId> writer) {
        return this;
    }

    public boolean isSupported(Path workdir, String filename) {
        if (workdir.isRoot()) {
            return false;
        }
        return !DriveHomeFinderService.TEAM_DRIVES_NAME.equals((Object)workdir);
    }
}

