/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.googledrive.DriveAttributesFinderFeature;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileidProvider;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.webloc.UrlFileWriter;
import ch.cyberduck.core.webloc.UrlFileWriterFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.FileList;
import java.io.IOException;
import java.util.EnumSet;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractDriveListService
implements ListService {
    private static final Logger log = Logger.getLogger(AbstractDriveListService.class);
    protected static final String GOOGLE_APPS_PREFIX = "application/vnd.google-apps";
    protected static final String DRIVE_FOLDER = String.format("%s.folder", "application/vnd.google-apps");
    protected static final String DRIVE_SHORTCUT = String.format("%s.shortcut", "application/vnd.google-apps");
    protected static final String DEFAULT_FIELDS = String.format("files(%s),nextPageToken", "createdTime,explicitlyTrashed,id,md5Checksum,mimeType,modifiedTime,name,size,webViewLink,shortcutDetails");
    private final DriveSession session;
    private final int pagesize;
    private final UrlFileWriter urlFileWriter = UrlFileWriterFactory.get();
    private final String fields;
    private final DriveAttributesFinderFeature attributes;
    private final DriveFileidProvider fileid;

    public AbstractDriveListService(DriveSession session, DriveFileidProvider fileid) {
        this(session, fileid, PreferencesFactory.get().getInteger("googledrive.list.limit"));
    }

    public AbstractDriveListService(DriveSession session, DriveFileidProvider fileid, int pagesize) {
        this(session, fileid, pagesize, DEFAULT_FIELDS);
    }

    public AbstractDriveListService(DriveSession session, DriveFileidProvider fileid, int pagesize, String fields) {
        this.session = session;
        this.fileid = fileid;
        this.pagesize = pagesize;
        this.fields = fields;
        this.attributes = new DriveAttributesFinderFeature(session, fileid);
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        try {
            AttributedList children = new AttributedList();
            String page = null;
            String query = this.query(directory, listener);
            do {
                FileList list = (FileList)((Drive)this.session.getClient()).files().list().setIncludeTeamDriveItems(Boolean.valueOf(true)).setSupportsTeamDrives(Boolean.valueOf(PreferencesFactory.get().getBoolean("googledrive.teamdrive.enable"))).setQ(query).setOrderBy("name").setPageToken(page).setFields(this.fields).setPageSize(Integer.valueOf(this.pagesize)).execute();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Chunk of %d retrieved", list.getFiles().size()));
                }
                for (File f : list.getFiles()) {
                    PathAttributes properties = this.attributes.toAttributes(f);
                    String filename = !DRIVE_FOLDER.equals(f.getMimeType()) && !DRIVE_SHORTCUT.equals(f.getMimeType()) && StringUtils.startsWith((CharSequence)f.getMimeType(), (CharSequence)GOOGLE_APPS_PREFIX) ? String.format("%s.%s", f.getName(), this.urlFileWriter.getExtension()) : f.getName();
                    if (StringUtils.equals((CharSequence)filename, (CharSequence)String.valueOf('/'))) continue;
                    EnumSet<AbstractPath.Type> type = this.toType(f);
                    Path child = new Path(directory, filename, type, properties);
                    if (children.find((Predicate)((Object)new DriveFileidProvider.IgnoreTrashedPathPredicate(child))) != null) {
                        properties.setDuplicate(true);
                    }
                    children.add((Referenceable)child);
                }
                listener.chunk(directory, children);
                page = list.getNextPageToken();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("Continue with next page token %s", page));
            } while (page != null);
            return children;
        }
        catch (IOException e) {
            throw new DriveExceptionMappingService().map("Listing directory failed", e, directory);
        }
    }

    protected EnumSet<AbstractPath.Type> toType(File f) {
        File.ShortcutDetails shortcutDetails;
        EnumSet<AbstractPath.Type> type = DRIVE_SHORTCUT.equals(f.getMimeType()) ? (DRIVE_FOLDER.equals((shortcutDetails = f.getShortcutDetails()).getTargetMimeType()) ? EnumSet.of(AbstractPath.Type.directory) : (StringUtils.startsWith((CharSequence)shortcutDetails.getTargetMimeType(), (CharSequence)GOOGLE_APPS_PREFIX) ? EnumSet.of(AbstractPath.Type.file, AbstractPath.Type.placeholder) : EnumSet.of(AbstractPath.Type.file))) : (DRIVE_FOLDER.equals(f.getMimeType()) ? EnumSet.of(AbstractPath.Type.directory) : (StringUtils.startsWith((CharSequence)f.getMimeType(), (CharSequence)GOOGLE_APPS_PREFIX) ? EnumSet.of(AbstractPath.Type.file, AbstractPath.Type.placeholder) : EnumSet.of(AbstractPath.Type.file)));
        return type;
    }

    protected abstract String query(Path var1, ListProgressListener var2) throws BackgroundException;

    public ListService withCache(Cache<Path> cache) {
        this.fileid.withCache((Cache)cache);
        return this;
    }
}

